/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ucar.grib.GribResourceReader;
import ucar.grib.Parameter;
import ucar.grib.grib2.Category;
import ucar.grib.grib2.Discipline;

public final class ParameterTable {
    protected static final String dir = "tables";
    protected static final String filename = "grib2StdQuantities.xml";
    private static final ArrayList<Discipline> discipline = new ArrayList();

    public static String getDisciplineName(int aDis) {
        Discipline dis = ParameterTable.getDiscipline(aDis);
        if (dis != null) {
            return dis.getName();
        }
        return "UnknownDiscipline_" + Integer.toString(aDis);
    }

    private static Discipline getDiscipline(int aDis) {
        for (int i = 0; i < discipline.size(); ++i) {
            Discipline dis = discipline.get(i);
            if (dis.getNumber() != aDis) continue;
            return dis;
        }
        return null;
    }

    public static String getCategoryName(int d, int c) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            return "UnknownDiscipline_" + Integer.toString(d);
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            return "UnknownCategory_" + Integer.toString(c);
        }
        return category.getName();
    }

    public static String getParameterName(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            return "UnknownDiscipline_" + Integer.toString(d);
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            return "UnknownCategory_" + Integer.toString(c);
        }
        return category.getParameter(p).getName();
    }

    public static String getParameterUnit(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            return "UnknownDiscipline_" + Integer.toString(d);
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            return "UnknownCategory_" + Integer.toString(c);
        }
        return category.getParameter(p).getUnit();
    }

    public static String getParameterDescription(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            return "UnknownDiscipline_" + Integer.toString(d);
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            return "UnknownCategory_" + Integer.toString(c);
        }
        return category.getParameter(p).getDescription();
    }

    public static Parameter getParameter(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            return new Parameter(p, "UnknownDiscipline_" + Integer.toString(d), "UnknownDiscipline_" + Integer.toString(d), "Unknown");
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            return new Parameter(p, "UnknownCategory_" + Integer.toString(c), "UnknownCategory_" + Integer.toString(c), "Unknown");
        }
        return category.getParameter(p);
    }

    public static void addParametersUser(String UserGribTable) throws IOException {
        ParameterTable.addParametersUser(ParameterTable.getInputStream(UserGribTable));
    }

    public static void addParametersUser(InputStream is) throws IOException {
        String line;
        if (is == null) {
            return;
        }
        Pattern p_comment = Pattern.compile("^#");
        Pattern p_parameter = Pattern.compile("(.*)\t(.*)\t(.*)\t(.*)\t(.*)\t(.*)");
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            Matcher m;
            if (p_comment.matcher(line).find() || !(m = p_parameter.matcher(line)).find() || m.groupCount() != 6) continue;
            Parameter p = new Parameter(Integer.parseInt(m.group(3)), m.group(4), m.group(6), m.group(5));
            ParameterTable.getDiscipline(Integer.parseInt(m.group(1))).getCategory(Integer.parseInt(m.group(2))).setParameter(p);
        }
        is.close();
    }

    private static InputStream getInputStream(String filename) {
        return ParameterTable.getInputStream(filename, null);
    }

    private static InputStream getInputStream(String filename, Class origin) {
        return GribResourceReader.getInputStream(filename, origin);
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            ClassLoader cl = ParameterTable.class.getClassLoader();
            InputStream is = cl.getResourceAsStream("resources/grib/tables/grib2StdQuantities.xml");
            Document doc = parser.parse(is);
            NodeList d = doc.getElementsByTagName("discipline");
            for (int i = 0; i < d.getLength(); ++i) {
                Discipline dis = new Discipline();
                NamedNodeMap da = d.item(i).getAttributes();
                for (int j = 0; j < da.getLength(); ++j) {
                    if (da.item(j).getNodeName().equals("id")) {
                        dis.setName(da.item(j).getNodeValue());
                        continue;
                    }
                    if (!da.item(j).getNodeName().equals("number")) continue;
                    dis.setNumber(Integer.parseInt(da.item(j).getNodeValue()));
                }
                NodeList c = d.item(i).getChildNodes();
                for (int j = 0; j < c.getLength(); ++j) {
                    if (!c.item(j).getNodeName().equals("category")) continue;
                    Category cat = new Category();
                    NamedNodeMap ca = c.item(j).getAttributes();
                    for (int k = 0; k < ca.getLength(); ++k) {
                        if (ca.item(k).getNodeName().equals("id")) {
                            cat.setName(ca.item(k).getNodeValue());
                            continue;
                        }
                        if (!ca.item(k).getNodeName().equals("number")) continue;
                        cat.setNumber(Integer.parseInt(ca.item(k).getNodeValue()));
                    }
                    NodeList p = c.item(j).getChildNodes();
                    for (int m = 0; m < p.getLength(); ++m) {
                        if (!p.item(m).getNodeName().equals("quantity")) continue;
                        Parameter par = null;
                        String pName = "";
                        int pNumber = -1;
                        String pUnit = "";
                        String pDesc = "";
                        NamedNodeMap pa = p.item(m).getAttributes();
                        for (int n = 0; n < pa.getLength(); ++n) {
                            Node attr = pa.item(n);
                            if (attr.getNodeName().equals("id")) {
                                pName = attr.getNodeValue();
                                continue;
                            }
                            if (attr.getNodeName().equals("number")) {
                                pNumber = Integer.parseInt(attr.getNodeValue());
                                continue;
                            }
                            if (attr.getNodeName().equals("unit")) {
                                pUnit = attr.getNodeValue();
                                continue;
                            }
                            if (!attr.getNodeName().equals("description")) continue;
                            pDesc = attr.getNodeValue();
                        }
                        if (pName.startsWith("Reserved") || pName.startsWith("Missing")) continue;
                        par = new Parameter();
                        par.setName(pName);
                        par.setNumber(pNumber);
                        par.setUnit(pUnit);
                        par.setDescription(pDesc);
                        cat.setParameter(par);
                    }
                    dis.setCategory(cat);
                }
                discipline.add(dis);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

