/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.IteratorFast;
import ucar.ma2.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
implements Cloneable {
    public static final Index0D scalarIndex = new Index0D();
    protected int[] shape;
    protected int[] stride;
    protected int rank;
    protected long size;
    protected int offset;
    protected boolean fastIterator = true;
    protected int[] current;

    public static Index factory(int[] shape) {
        int rank = shape.length;
        switch (rank) {
            case 0: {
                return scalarIndex;
            }
            case 1: {
                return new Index1D(shape);
            }
            case 2: {
                return new Index2D(shape);
            }
            case 3: {
                return new Index3D(shape);
            }
            case 4: {
                return new Index4D(shape);
            }
            case 5: {
                return new Index5D(shape);
            }
            case 6: {
                return new Index6D(shape);
            }
            case 7: {
                return new Index7D(shape);
            }
        }
        return new Index(shape);
    }

    private static Index factory(int rank) {
        switch (rank) {
            case 0: {
                return scalarIndex;
            }
            case 1: {
                return new Index1D();
            }
            case 2: {
                return new Index2D();
            }
            case 3: {
                return new Index3D();
            }
            case 4: {
                return new Index4D();
            }
            case 5: {
                return new Index5D();
            }
            case 6: {
                return new Index6D();
            }
            case 7: {
                return new Index7D();
            }
        }
        return new Index(rank);
    }

    public static long computeSize(int[] shape) {
        long product = 1L;
        for (int ii = shape.length - 1; ii >= 0; --ii) {
            product *= (long)shape[ii];
        }
        return product;
    }

    private static long computeStrides(int[] shape, int[] stride) {
        long product = 1L;
        for (int ii = shape.length - 1; ii >= 0; --ii) {
            int thisDim = shape[ii];
            if (thisDim < 0) {
                throw new NegativeArraySizeException();
            }
            stride[ii] = (int)product;
            product *= (long)thisDim;
        }
        return product;
    }

    protected Index(int rank) {
        this.rank = rank;
        this.shape = new int[rank];
        this.current = new int[rank];
        this.stride = new int[rank];
    }

    protected Index(int[] _shape) {
        this.shape = new int[_shape.length];
        System.arraycopy(_shape, 0, this.shape, 0, _shape.length);
        this.rank = this.shape.length;
        this.current = new int[this.rank];
        this.stride = new int[this.rank];
        this.size = Index.computeStrides(this.shape, this.stride);
        this.offset = 0;
    }

    public Index(int[] _shape, int[] _stride) {
        this.shape = new int[_shape.length];
        System.arraycopy(_shape, 0, this.shape, 0, _shape.length);
        this.stride = new int[_stride.length];
        System.arraycopy(_stride, 0, this.stride, 0, _stride.length);
        this.rank = this.shape.length;
        this.current = new int[this.rank];
        this.size = Index.computeSize(this.shape);
        this.offset = 0;
    }

    protected void precalc() {
    }

    Index flip(int index) {
        if (index < 0 || index >= this.rank) {
            throw new IllegalArgumentException();
        }
        Index i = (Index)this.clone();
        i.offset += this.stride[index] * (this.shape[index] - 1);
        i.stride[index] = -this.stride[index];
        i.fastIterator = false;
        i.precalc();
        return i;
    }

    Index section(List<Range> ranges) throws InvalidRangeException {
        if (ranges.size() != this.rank) {
            throw new InvalidRangeException("Bad ranges [] length");
        }
        for (int ii = 0; ii < this.rank; ++ii) {
            Range r = ranges.get(ii);
            if (r == null) continue;
            if (r.first() < 0 || r.first() >= this.shape[ii]) {
                throw new InvalidRangeException("Bad range starting value at index " + ii + " == " + r.first());
            }
            if (r.last() >= 0 && r.last() < this.shape[ii]) continue;
            throw new InvalidRangeException("Bad range ending value at index " + ii + " == " + r.last());
        }
        int reducedRank = this.rank;
        for (Range r : ranges) {
            if (r == null || r.length() != 1) continue;
            --reducedRank;
        }
        Index newindex = Index.factory(reducedRank);
        newindex.offset = this.offset;
        int newDim = 0;
        for (int ii = 0; ii < this.rank; ++ii) {
            Range r = ranges.get(ii);
            if (r == null) {
                newindex.shape[newDim] = this.shape[ii];
                newindex.stride[newDim] = this.stride[ii];
                ++newDim;
                continue;
            }
            if (r.length() != 1) {
                newindex.shape[newDim] = r.length();
                newindex.stride[newDim] = this.stride[ii] * r.stride();
                newindex.offset += this.stride[ii] * r.first();
                ++newDim;
                continue;
            }
            newindex.offset += this.stride[ii] * r.first();
        }
        newindex.size = Index.computeSize(newindex.shape);
        newindex.fastIterator = newindex.size == this.size;
        newindex.precalc();
        return newindex;
    }

    Index sectionNoReduce(List<Range> ranges) throws InvalidRangeException {
        if (ranges.size() != this.rank) {
            throw new InvalidRangeException("Bad ranges [] length");
        }
        for (int ii = 0; ii < this.rank; ++ii) {
            Range r = ranges.get(ii);
            if (r == null) continue;
            if (r.first() < 0 || r.first() >= this.shape[ii]) {
                throw new InvalidRangeException("Bad range starting value at index " + ii + " == " + r.first());
            }
            if (r.last() >= 0 && r.last() < this.shape[ii]) continue;
            throw new InvalidRangeException("Bad range ending value at index " + ii + " == " + r.last());
        }
        Index newindex = Index.factory(this.rank);
        newindex.offset = this.offset;
        for (int ii = 0; ii < this.rank; ++ii) {
            Range r = ranges.get(ii);
            if (r == null) {
                newindex.shape[ii] = this.shape[ii];
                newindex.stride[ii] = this.stride[ii];
                continue;
            }
            newindex.shape[ii] = r.length();
            newindex.stride[ii] = this.stride[ii] * r.stride();
            newindex.offset += this.stride[ii] * r.first();
        }
        newindex.size = Index.computeSize(newindex.shape);
        newindex.fastIterator = newindex.size == this.size;
        newindex.precalc();
        return newindex;
    }

    Index reduce() {
        Index c = this;
        for (int ii = 0; ii < this.rank; ++ii) {
            if (this.shape[ii] != 1) continue;
            Index newc = c.reduce(ii);
            return newc.reduce();
        }
        return c;
    }

    Index reduce(int dim) {
        if (dim < 0 || dim >= this.rank) {
            throw new IllegalArgumentException("illegal reduce dim " + dim);
        }
        if (this.shape[dim] != 1) {
            throw new IllegalArgumentException("illegal reduce dim " + dim + " : length != 1");
        }
        Index newindex = Index.factory(this.rank - 1);
        newindex.offset = this.offset;
        int count = 0;
        for (int ii = 0; ii < this.rank; ++ii) {
            if (ii == dim) continue;
            newindex.shape[count] = this.shape[ii];
            newindex.stride[count] = this.stride[ii];
            ++count;
        }
        newindex.size = Index.computeSize(newindex.shape);
        newindex.fastIterator = this.fastIterator;
        newindex.precalc();
        return newindex;
    }

    Index transpose(int index1, int index2) {
        if (index1 < 0 || index1 >= this.rank) {
            throw new IllegalArgumentException();
        }
        if (index2 < 0 || index2 >= this.rank) {
            throw new IllegalArgumentException();
        }
        Index newIndex = (Index)this.clone();
        newIndex.stride[index1] = this.stride[index2];
        newIndex.stride[index2] = this.stride[index1];
        newIndex.shape[index1] = this.shape[index2];
        newIndex.shape[index2] = this.shape[index1];
        newIndex.fastIterator = false;
        newIndex.precalc();
        return newIndex;
    }

    Index permute(int[] dims) {
        if (dims.length != this.shape.length) {
            throw new IllegalArgumentException();
        }
        for (int dim : dims) {
            if (dim >= 0 && dim < this.rank) continue;
            throw new IllegalArgumentException();
        }
        boolean isPermuted = false;
        Index newIndex = (Index)this.clone();
        for (int i = 0; i < dims.length; ++i) {
            newIndex.stride[i] = this.stride[dims[i]];
            newIndex.shape[i] = this.shape[dims[i]];
            if (i == dims[i]) continue;
            isPermuted = true;
        }
        newIndex.fastIterator = !isPermuted;
        newIndex.precalc();
        return newIndex;
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getShape() {
        int[] result = new int[this.shape.length];
        System.arraycopy(this.shape, 0, result, 0, this.shape.length);
        return result;
    }

    public int getShape(int index) {
        return this.shape[index];
    }

    IndexIterator getIndexIterator(Array maa) {
        if (this.fastIterator) {
            return new IteratorFast(this.size, maa);
        }
        return new IteratorImpl(maa);
    }

    IteratorFast getIndexIteratorFast(Array maa) {
        return new IteratorFast(this.size, maa);
    }

    public long getSize() {
        return this.size;
    }

    public int currentElement() {
        int value = this.offset;
        for (int ii = 0; ii < this.rank; ++ii) {
            value += this.current[ii] * this.stride[ii];
        }
        return value;
    }

    public int[] getCurrentCounter() {
        return (int[])this.current.clone();
    }

    public void setCurrentCounter(int currElement) {
        currElement -= this.offset;
        for (int ii = 0; ii < this.rank; ++ii) {
            this.current[ii] = currElement / this.stride[ii];
            currElement -= this.current[ii] * this.stride[ii];
        }
        this.set(this.current);
    }

    public int incr() {
        for (int digit = this.rank - 1; digit >= 0; --digit) {
            int n = digit;
            this.current[n] = this.current[n] + 1;
            if (this.current[digit] < this.shape[digit]) break;
            this.current[digit] = 0;
        }
        return this.currentElement();
    }

    public Index set(int[] index) {
        if (index.length != this.rank) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(index, 0, this.current, 0, this.rank);
        return this;
    }

    public void setDim(int dim, int value) {
        if (value < 0 || value >= this.shape[dim]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.current[dim] = value;
    }

    public Index set0(int v) {
        this.setDim(0, v);
        return this;
    }

    public Index set1(int v) {
        this.setDim(1, v);
        return this;
    }

    public Index set2(int v) {
        this.setDim(2, v);
        return this;
    }

    public Index set3(int v) {
        this.setDim(3, v);
        return this;
    }

    public Index set4(int v) {
        this.setDim(4, v);
        return this;
    }

    public Index set5(int v) {
        this.setDim(5, v);
        return this;
    }

    public Index set6(int v) {
        this.setDim(6, v);
        return this;
    }

    public Index set(int v0) {
        this.setDim(0, v0);
        return this;
    }

    public Index set(int v0, int v1) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        return this;
    }

    public Index set(int v0, int v1, int v2) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3, int v4) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        this.setDim(4, v4);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3, int v4, int v5) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        this.setDim(4, v4);
        this.setDim(5, v5);
        return this;
    }

    public Index set(int v0, int v1, int v2, int v3, int v4, int v5, int v6) {
        this.setDim(0, v0);
        this.setDim(1, v1);
        this.setDim(2, v2);
        this.setDim(3, v3);
        this.setDim(4, v4);
        this.setDim(5, v5);
        this.setDim(6, v6);
        return this;
    }

    public String toStringDebug() {
        int ii;
        StringBuilder sbuff = new StringBuilder(100);
        sbuff.setLength(0);
        sbuff.append(" shape= ");
        for (ii = 0; ii < this.rank; ++ii) {
            sbuff.append(this.shape[ii]);
            sbuff.append(" ");
        }
        sbuff.append(" stride= ");
        for (ii = 0; ii < this.rank; ++ii) {
            sbuff.append(this.stride[ii]);
            sbuff.append(" ");
        }
        sbuff.append(" offset= ").append(this.offset);
        sbuff.append(" rank= ").append(this.rank);
        sbuff.append(" size= ").append(this.size);
        sbuff.append(" current= ");
        for (ii = 0; ii < this.rank; ++ii) {
            sbuff.append(this.current[ii]);
            sbuff.append(" ");
        }
        return sbuff.toString();
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder(100);
        sbuff.setLength(0);
        for (int ii = 0; ii < this.rank; ++ii) {
            if (ii > 0) {
                sbuff.append(",");
            }
            sbuff.append(this.current[ii]);
        }
        return sbuff.toString();
    }

    public Object clone() {
        Index i;
        try {
            i = (Index)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        i.stride = (int[])this.stride.clone();
        i.shape = (int[])this.shape.clone();
        i.current = new int[this.rank];
        return i;
    }

    private class IteratorImpl
    implements IndexIterator {
        private int count = 0;
        private int currElement = 0;
        private Index counter;
        private Array maa;

        private IteratorImpl(Array maa) {
            this.maa = maa;
            this.counter = (Index)Index.this.clone();
            if (Index.this.rank > 0) {
                this.counter.current[Index.this.rank - 1] = -1;
            }
            this.counter.precalc();
        }

        public boolean hasNext() {
            return (long)this.count < Index.this.size;
        }

        public String toString() {
            return this.counter.toString();
        }

        public int[] getCurrentCounter() {
            return this.counter.getCurrentCounter();
        }

        public Object next() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getObject(this.currElement);
        }

        public double getDoubleCurrent() {
            return this.maa.getDouble(this.currElement);
        }

        public double getDoubleNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getDouble(this.currElement);
        }

        public void setDoubleCurrent(double val) {
            this.maa.setDouble(this.currElement, val);
        }

        public void setDoubleNext(double val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setDouble(this.currElement, val);
        }

        public float getFloatCurrent() {
            return this.maa.getFloat(this.currElement);
        }

        public float getFloatNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getFloat(this.currElement);
        }

        public void setFloatCurrent(float val) {
            this.maa.setFloat(this.currElement, val);
        }

        public void setFloatNext(float val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setFloat(this.currElement, val);
        }

        public long getLongCurrent() {
            return this.maa.getLong(this.currElement);
        }

        public long getLongNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getLong(this.currElement);
        }

        public void setLongCurrent(long val) {
            this.maa.setLong(this.currElement, val);
        }

        public void setLongNext(long val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setLong(this.currElement, val);
        }

        public int getIntCurrent() {
            return this.maa.getInt(this.currElement);
        }

        public int getIntNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getInt(this.currElement);
        }

        public void setIntCurrent(int val) {
            this.maa.setInt(this.currElement, val);
        }

        public void setIntNext(int val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setInt(this.currElement, val);
        }

        public short getShortCurrent() {
            return this.maa.getShort(this.currElement);
        }

        public short getShortNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getShort(this.currElement);
        }

        public void setShortCurrent(short val) {
            this.maa.setShort(this.currElement, val);
        }

        public void setShortNext(short val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setShort(this.currElement, val);
        }

        public byte getByteCurrent() {
            return this.maa.getByte(this.currElement);
        }

        public byte getByteNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getByte(this.currElement);
        }

        public void setByteCurrent(byte val) {
            this.maa.setByte(this.currElement, val);
        }

        public void setByteNext(byte val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setByte(this.currElement, val);
        }

        public char getCharCurrent() {
            return this.maa.getChar(this.currElement);
        }

        public char getCharNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getChar(this.currElement);
        }

        public void setCharCurrent(char val) {
            this.maa.setChar(this.currElement, val);
        }

        public void setCharNext(char val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setChar(this.currElement, val);
        }

        public boolean getBooleanCurrent() {
            return this.maa.getBoolean(this.currElement);
        }

        public boolean getBooleanNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getBoolean(this.currElement);
        }

        public void setBooleanCurrent(boolean val) {
            this.maa.setBoolean(this.currElement, val);
        }

        public void setBooleanNext(boolean val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setBoolean(this.currElement, val);
        }

        public Object getObjectCurrent() {
            return this.maa.getObject(this.currElement);
        }

        public Object getObjectNext() {
            ++this.count;
            this.currElement = this.counter.incr();
            return this.maa.getObject(this.currElement);
        }

        public void setObjectCurrent(Object val) {
            this.maa.setObject(this.currElement, val);
        }

        public void setObjectNext(Object val) {
            ++this.count;
            this.currElement = this.counter.incr();
            this.maa.setObject(this.currElement, val);
        }
    }
}

