/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.ProxyReader;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureDS
extends Structure
implements VariableEnhanced {
    private static Logger log = LoggerFactory.getLogger(StructureDS.class);
    private EnhancementsImpl proxy;
    protected Structure orgVar;
    private String orgName;

    public StructureDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDimensions(dims);
        this.proxy = new EnhancementsImpl(this, units, desc);
        if (units != null) {
            this.addAttribute(new Attribute("units", units));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
    }

    public StructureDS(Group g, Structure orgVar) {
        super(orgVar);
        this.group = g;
        this.orgVar = orgVar;
        this.proxy = new EnhancementsImpl(this);
        this.ncfile = null;
        this.spiObject = null;
        this.preReader = null;
        this.postReader = null;
        this.createNewCache();
        if (orgVar instanceof StructureDS) {
            return;
        }
        ArrayList<Variable> newList = new ArrayList<Variable>(this.members.size());
        for (Variable v : this.members) {
            Variable newVar = v instanceof Structure ? new StructureDS(g, (Structure)v) : new VariableDS(g, v, false);
            newVar.setParentStructure(this);
            newList.add(newVar);
        }
        this.setMemberVariables(newList);
    }

    public StructureDS(Group group, Structure parent, String shortName, Structure orgVar) {
        super(null, group, parent, shortName);
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.preReader = null;
        this.postReader = null;
        this.createNewCache();
        this.orgVar = orgVar;
    }

    @Override
    protected Variable copy() {
        return new StructureDS(null, this);
    }

    @Override
    public Structure select(List<Variable> members) {
        StructureDS result = new StructureDS(this.group, this.orgVar);
        result.setMemberVariables(members);
        result.isSubset = true;
        return result;
    }

    @Override
    public Structure select(Variable v) {
        StructureDS result = new StructureDS(this.group, this.orgVar);
        ArrayList<Variable> members = new ArrayList<Variable>(1);
        members.add(v);
        result.setMemberVariables(members);
        result.isSubset = true;
        return result;
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    public void setOriginalVariable(Variable orgVar) {
        if (!(orgVar instanceof Structure)) {
            throw new IllegalArgumentException("STructureDS must wrap a Structure; name=" + orgVar.getName());
        }
        this.orgVar = (Structure)orgVar;
    }

    public DataType getOriginalDataType() {
        return DataType.STRUCTURE;
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public void setName(String newName) {
        this.orgName = this.shortName;
        super.setName(newName);
    }

    @Override
    public void setProxyReader(ProxyReader proxyReader) {
        this.postReader = proxyReader;
    }

    @Override
    public ProxyReader getProxyReader() {
        return this.postReader;
    }

    @Override
    protected Array _read() throws IOException {
        Array result;
        if (this.hasCachedData()) {
            result = super._read();
        } else if (this.postReader != null) {
            result = this.postReader.read(this, null);
        } else if (this.orgVar != null) {
            result = this.orgVar.read();
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        return this.convert(result, null);
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        Array result;
        if (section.computeSize() == this.getSize()) {
            return this._read();
        }
        if (this.hasCachedData()) {
            result = super._read(section);
        } else if (this.postReader != null) {
            result = this.postReader.read(this, section, null);
        } else if (this.orgVar != null) {
            result = this.orgVar.read(section);
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        return this.convert(result, section);
    }

    private boolean convertNeeded(StructureMembers smData) {
        for (Variable v : this.getVariables()) {
            StructureDS nested;
            VariableDS vds;
            if (v instanceof VariableDS && ((vds = (VariableDS)v).getNeedScaleOffsetMissing() || vds.getNeedEnumConversion())) {
                return true;
            }
            if (v instanceof StructureDS && (nested = (StructureDS)v).convertNeeded(null)) {
                return true;
            }
            if (smData == null || this.varHasData(v, smData)) continue;
            return true;
        }
        return false;
    }

    private ArrayStructure convert(Array data, Section section) throws IOException {
        Array mdata;
        ArrayStructure orgAS = (ArrayStructure)data;
        if (!this.convertNeeded(orgAS.getStructureMembers())) {
            this.convertMemberInfo(orgAS.getStructureMembers());
            return orgAS;
        }
        ArrayStructureMA newAS = ArrayStructureMA.factoryMA(orgAS);
        for (StructureMembers.Member m : newAS.getMembers()) {
            VariableEnhanced v2 = (VariableEnhanced)((Object)this.findVariable(m.getName()));
            if (v2 == null && this.orgVar != null) {
                v2 = this.findVariableFromOrgName(m.getName());
            }
            if (v2 == null) continue;
            if (v2 instanceof VariableDS) {
                VariableDS vds = (VariableDS)v2;
                if (vds.getNeedScaleOffsetMissing()) {
                    mdata = newAS.extractMemberArray(m);
                    mdata = vds.convertScaleOffsetMissing(mdata);
                    newAS.setMemberArray(m, mdata);
                    continue;
                }
                if (!vds.getNeedEnumConversion()) continue;
                mdata = newAS.extractMemberArray(m);
                mdata = vds.convertEnums(mdata);
                newAS.setMemberArray(m, mdata);
                continue;
            }
            if (!(v2 instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v2;
            if (innerStruct.convertNeeded(null)) {
                if (innerStruct.getDataType() == DataType.SEQUENCE) {
                    ArrayObject.D1 seqArray = (ArrayObject.D1)newAS.extractMemberArray(m);
                    ArrayObject.D1 newSeq = new ArrayObject.D1(ArraySequence.class, (int)seqArray.getSize());
                    m.setDataArray(newSeq);
                    int i = 0;
                    while ((long)i < seqArray.getSize()) {
                        ArraySequence innerSeq = (ArraySequence)seqArray.get(i);
                        newSeq.set(i, new SequenceConverter(innerStruct, innerSeq));
                        ++i;
                    }
                } else {
                    mdata = newAS.extractMemberArray(m);
                    mdata = innerStruct.convert(mdata, null);
                    newAS.setMemberArray(m, mdata);
                }
            }
            innerStruct.convertMemberInfo(m.getStructureMembers());
        }
        StructureMembers sm = newAS.getStructureMembers();
        this.convertMemberInfo(sm);
        for (Variable v : this.getVariables()) {
            if (this.varHasData(v, sm)) continue;
            try {
                Variable completeVar = this.getParentGroup().findVariable(v.getShortName());
                mdata = completeVar.read(section);
                StructureMembers.Member m = sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), v.getShape());
                newAS.setMemberArray(m, mdata);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        return newAS;
    }

    private StructureData convert(StructureData sdata, int recno) throws IOException {
        if (!this.convertNeeded(sdata.getStructureMembers())) {
            this.convertMemberInfo(sdata.getStructureMembers());
            return sdata;
        }
        StructureMembers smResult = new StructureMembers(sdata.getStructureMembers());
        StructureDataW result = new StructureDataW(smResult);
        for (StructureMembers.Member m : sdata.getMembers()) {
            Array mdata;
            VariableEnhanced v2 = (VariableEnhanced)((Object)this.findVariable(m.getName()));
            if (v2 == null && this.orgVar != null) {
                v2 = this.findVariableFromOrgName(m.getName());
            }
            if (v2 == null) {
                log.warn("StructureDataDS.convert Cant find member " + m.getName());
                continue;
            }
            StructureMembers.Member mResult = smResult.findMember(m.getName());
            if (v2 instanceof VariableDS) {
                VariableDS vds = (VariableDS)v2;
                mdata = sdata.getArray(m);
                if (vds.getNeedScaleOffsetMissing()) {
                    mdata = vds.convertScaleOffsetMissing(mdata);
                } else if (vds.getNeedEnumConversion()) {
                    mdata = vds.convertEnums(mdata);
                }
                result.setMemberData(mResult, mdata);
            }
            if (!(v2 instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v2;
            if (innerStruct.convertNeeded(null)) {
                if (innerStruct.getDataType() == DataType.SEQUENCE) {
                    Array seqArray;
                    Array a = sdata.getArray(m);
                    if (a instanceof ArrayObject.D1) {
                        seqArray = (ArrayObject.D1)a;
                        ArrayObject.D1 newSeq = new ArrayObject.D1(ArraySequence.class, (int)seqArray.getSize());
                        mResult.setDataArray(newSeq);
                        int i = 0;
                        while ((long)i < seqArray.getSize()) {
                            ArraySequence innerSeq = (ArraySequence)((ArrayObject.D1)seqArray).get(i);
                            newSeq.set(i, new SequenceConverter(innerStruct, innerSeq));
                            ++i;
                        }
                    } else {
                        seqArray = (ArraySequence)a;
                        result.setMemberData(mResult, (Array)new SequenceConverter(innerStruct, (ArraySequence)seqArray));
                    }
                } else {
                    mdata = sdata.getArray(m);
                    mdata = innerStruct.convert(mdata, null);
                    result.setMemberData(mResult, mdata);
                }
            }
            innerStruct.convertMemberInfo(mResult.getStructureMembers());
        }
        StructureMembers sm = result.getStructureMembers();
        this.convertMemberInfo(sm);
        for (Variable v : this.getVariables()) {
            if (this.varHasData(v, sm)) continue;
            try {
                Variable completeVar = this.getParentGroup().findVariable(v.getShortName());
                Array mdata = completeVar.read(new Section().appendRange(recno, recno));
                StructureMembers.Member m = sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), v.getShape());
                result.setMemberData(m, mdata);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        return result;
    }

    private void convertMemberInfo(StructureMembers wrapperSm) {
        for (StructureMembers.Member m : wrapperSm.getMembers()) {
            Variable v = this.findVariable(m.getName());
            if (v == null && this.orgVar != null) {
                v = (Variable)((Object)this.findVariableFromOrgName(m.getName()));
            }
            if (v == null) {
                log.error("Cant find " + m.getName());
            } else {
                m.setVariableInfo(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType());
            }
            if (!(v instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v;
            innerStruct.convertMemberInfo(m.getStructureMembers());
        }
    }

    private VariableEnhanced findVariableFromOrgName(String orgName) {
        java.util.Iterator<Variable> i$ = this.getVariables().iterator();
        while (i$.hasNext()) {
            Variable vTop;
            Variable v = vTop = i$.next();
            while (v instanceof VariableEnhanced) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                if (ve.getOriginalName().equals(orgName)) {
                    return (VariableEnhanced)((Object)vTop);
                }
                v = ve.getOriginalVariable();
            }
        }
        return null;
    }

    private boolean varHasData(Variable v, StructureMembers sm) {
        if (sm.findMember(v.getShortName()) != null) {
            return true;
        }
        while (v instanceof VariableEnhanced) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            if (sm.findMember(ve.getOriginalName()) != null) {
                return true;
            }
            v = ve.getOriginalVariable();
        }
        return false;
    }

    @Override
    public StructureDataIterator getStructureIterator(int bufferSize) throws IOException {
        return new Iterator(bufferSize);
    }

    @Override
    public void enhance(EnumSet<NetcdfDataset.Enhance> mode) {
        for (Variable v : this.getVariables()) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            ve.enhance(mode);
        }
    }

    @Override
    public void addCoordinateSystem(CoordinateSystem p0) {
        this.proxy.addCoordinateSystem(p0);
    }

    @Override
    public void removeCoordinateSystem(CoordinateSystem p0) {
        this.proxy.removeCoordinateSystem(p0);
    }

    @Override
    public List<CoordinateSystem> getCoordinateSystems() {
        return this.proxy.getCoordinateSystems();
    }

    @Override
    public String getDescription() {
        return this.proxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.proxy.getUnitsString();
    }

    @Override
    public void setUnitsString(String units) {
        this.proxy.setUnitsString(units);
    }

    private class Iterator
    implements StructureDataIterator {
        private int count = 0;
        private int recnum = (int)StructureDS.this.getSize();
        private int readStart = 0;
        private int readCount = 0;
        private int readAtaTime;
        private ArrayStructure as = null;

        protected Iterator(int bufferSize) {
            this.setBufferSize(bufferSize);
        }

        public boolean hasNext() {
            return this.count < this.recnum;
        }

        public StructureDataIterator reset() {
            this.count = 0;
            this.readStart = 0;
            this.readCount = 0;
            return this;
        }

        public StructureData next() throws IOException {
            if (this.count >= this.readStart) {
                if (StructureDS.this.getRank() == 1) {
                    this.readNextRank1();
                } else {
                    this.readNextGeneralRank();
                }
            }
            ++this.count;
            return this.as.getStructureData(this.readCount++);
        }

        private void readNextRank1() throws IOException {
            int left = Math.min(this.recnum, this.readStart + this.readAtaTime);
            int need = left - this.readStart;
            try {
                this.as = StructureDS.this.readStructure(this.readStart, need);
            }
            catch (InvalidRangeException e) {
                log.error("Structure.Iterator.readNext() ", e);
                throw new IllegalStateException("Structure.Iterator.readNext() ", e);
            }
            this.readStart += need;
            this.readCount = 0;
        }

        private void readNextGeneralRank() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void setBufferSize(int bytes) {
            if (this.count > 0) {
                return;
            }
            int structureSize = StructureDS.this.calcStructureSize();
            if (bytes <= 0) {
                bytes = defaultBufferSize;
            }
            this.readAtaTime = Math.max(10, bytes / structureSize);
        }
    }

    private class StructureDataConverter
    implements StructureDataIterator {
        StructureDataIterator orgIter;
        StructureDS newStruct;
        int count = 0;

        StructureDataConverter(StructureDS newStruct, StructureDataIterator orgIter) {
            this.newStruct = newStruct;
            this.orgIter = orgIter;
        }

        public boolean hasNext() throws IOException {
            return this.orgIter.hasNext();
        }

        public StructureData next() throws IOException {
            StructureData sdata = this.orgIter.next();
            return this.newStruct.convert(sdata, this.count++);
        }

        public void setBufferSize(int bytes) {
            this.orgIter.setBufferSize(bytes);
        }

        public StructureDataIterator reset() {
            this.orgIter.reset();
            return this;
        }
    }

    private class SequenceConverter
    extends ArraySequence {
        StructureDS orgStruct;
        ArraySequence orgSeq;

        SequenceConverter(StructureDS orgStruct, ArraySequence orgSeq) {
            super(orgSeq.getStructureMembers(), orgSeq.getShape());
            this.orgStruct = orgStruct;
            this.orgSeq = orgSeq;
            this.members = new StructureMembers(orgSeq.getStructureMembers());
            orgStruct.convertMemberInfo(this.members);
        }

        public StructureDataIterator getStructureDataIterator() throws IOException {
            return new StructureDataConverter(this.orgStruct, this.orgSeq.getStructureDataIterator());
        }
    }
}

