/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.fmrc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForecastModelRunInventory {
    public static final int OPEN_NORMAL = 1;
    public static final int OPEN_FORCE_NEW = 2;
    public static final int OPEN_XML_ONLY = 3;
    private static Logger log = LoggerFactory.getLogger(ForecastModelRunInventory.class);
    private String name;
    private List<TimeCoord> times = new ArrayList<TimeCoord>();
    private List<VertCoord> vaxes = new ArrayList<VertCoord>();
    private Date runDate;
    private String runTime;
    private GridDataset gds;
    private LatLonRect bb;
    private boolean debugMissing = false;
    private GribServiceProvider gribIosp;
    private int tc_seqno = 0;
    private int vc_seqno = 0;
    private static boolean debug = false;
    private static boolean showXML = false;

    private ForecastModelRunInventory() {
    }

    private ForecastModelRunInventory(String ncfileLocation) throws IOException {
        this(ucar.nc2.dt.grid.GridDataset.open(ncfileLocation), null);
    }

    private ForecastModelRunInventory(GridDataset gds, Date runDate) {
        this.gds = gds;
        this.name = gds.getTitle();
        NetcdfFile ncfile = gds.getNetcdfFile();
        if (runDate == null) {
            this.runTime = ncfile.findAttValueIgnoreCase(null, "_CoordinateModelBaseDate", null);
            if (this.runTime == null) {
                this.runTime = ncfile.findAttValueIgnoreCase(null, "_CoordinateModelRunDate", null);
            }
            if (this.runTime == null) {
                throw new IllegalArgumentException("File must have _CoordinateModelBaseDate or _CoordinateModelRunDate attribute ");
            }
            this.runDate = DateUnit.getStandardOrISO(this.runTime);
            if (this.runDate == null) {
                throw new IllegalArgumentException("_CoordinateModelRunDate must be ISO date string " + this.runTime);
            }
        } else {
            this.runDate = runDate;
            DateFormatter df = new DateFormatter();
            this.runTime = df.toDateTimeStringISO(runDate);
        }
        this.getIosp();
        for (GridDatatype gg : gds.getGrids()) {
            CoordinateAxis1D vaxis;
            GridCoordSystem gcs = gg.getCoordinateSystem();
            Grid grid = new Grid(gg.getName());
            VariableDS ve = gg.getVariable();
            Variable v = ve.getOriginalVariable();
            this.addMissing(v, gcs, grid);
            CoordinateAxis1DTime axis = gcs.getTimeAxis1D();
            if (axis != null) {
                TimeCoord tc = this.getTimeCoordinate(axis);
                tc.vars.add(grid);
                grid.parent = tc;
            }
            if ((vaxis = gcs.getVerticalAxis()) != null) {
                grid.vc = this.getVertCoordinate(vaxis);
            }
            LatLonRect rect = gcs.getLatLonBoundingBox();
            if (null == this.bb) {
                this.bb = rect;
                continue;
            }
            if (this.bb.equals(rect)) continue;
            this.bb.extend(rect);
        }
    }

    public void close() throws IOException {
        if (null != this.gds) {
            this.gds.close();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Date getRunDate() {
        return this.runDate;
    }

    public String getRunDateString() {
        return this.runTime;
    }

    public List<TimeCoord> getTimeCoords() {
        return this.times;
    }

    public List<VertCoord> getVertCoords() {
        return this.vaxes;
    }

    public LatLonRect getBB() {
        return this.bb;
    }

    public void releaseDataset() throws IOException {
        if (this.gds == null) {
            return;
        }
        this.gds.close();
        for (TimeCoord tc : this.times) {
            tc.axis = null;
        }
        for (VertCoord vc : this.vaxes) {
            vc.axis = null;
        }
    }

    public Grid findGrid(String name) {
        for (TimeCoord tc : this.times) {
            List<Grid> grids = tc.getGrids();
            for (Grid g : grids) {
                if (!g.name.equals(name)) continue;
                return g;
            }
        }
        return null;
    }

    private void getIosp() {
        NetcdfDataset ncd = (NetcdfDataset)this.gds.getNetcdfFile();
        NetcdfFile ncfile = ncd.getReferencedFile();
        while (ncfile instanceof NetcdfDataset) {
            ncd = (NetcdfDataset)ncfile;
            ncfile = ncd.getReferencedFile();
        }
        if (ncfile == null) {
            return;
        }
        IOServiceProvider iosp = ncfile.getIosp();
        if (iosp == null) {
            return;
        }
        if (!(iosp instanceof GribServiceProvider)) {
            return;
        }
        this.gribIosp = (GribServiceProvider)iosp;
    }

    private void addMissing(Variable v, GridCoordSystem gcs, Grid grid) {
        if (this.gribIosp == null) {
            return;
        }
        if (gcs.getVerticalAxis() == null) {
            return;
        }
        int ntimes = (int)gcs.getTimeAxis().getSize();
        int nverts = (int)gcs.getVerticalAxis().getSize();
        int total = ntimes * nverts;
        ArrayList<Missing> missing = new ArrayList<Missing>();
        for (int timeIndex = 0; timeIndex < ntimes; ++timeIndex) {
            for (int vertIndex = 0; vertIndex < nverts; ++vertIndex) {
                try {
                    if (!this.gribIosp.isMissingXY(v, timeIndex, vertIndex)) continue;
                    missing.add(new Missing(timeIndex, vertIndex));
                    continue;
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
            }
        }
        if (missing.size() > 0) {
            grid.missing = missing;
            if (this.debugMissing) {
                System.out.println("Missing " + this.gds.getTitle() + " " + v.getName() + " # =" + missing.size() + "/" + total);
            }
        } else if (this.debugMissing) {
            System.out.println(" None missing for " + this.gds.getTitle() + " " + v.getName() + " total = " + total);
        }
    }

    private TimeCoord getTimeCoordinate(CoordinateAxis1D axis) {
        for (TimeCoord tc : this.times) {
            if (tc.axis == null || tc.axis != axis) continue;
            return tc;
        }
        TimeCoord want = new TimeCoord(this.runDate, axis);
        for (TimeCoord tc : this.times) {
            if (!tc.equalsData(want)) continue;
            return tc;
        }
        this.times.add(want);
        want.setId(Integer.toString(this.tc_seqno));
        ++this.tc_seqno;
        return want;
    }

    private VertCoord getVertCoordinate(String vert_id) {
        if (vert_id == null) {
            return null;
        }
        for (VertCoord vc : this.vaxes) {
            if (!vc.id.equals(vert_id)) continue;
            return vc;
        }
        return null;
    }

    private VertCoord getVertCoordinate(CoordinateAxis1D axis) {
        for (VertCoord vc : this.vaxes) {
            if (vc.axis == null || vc.axis != axis) continue;
            return vc;
        }
        VertCoord want = new VertCoord(axis);
        for (VertCoord vc : this.vaxes) {
            if (!vc.equalsData(want)) continue;
            return vc;
        }
        this.vaxes.add(want);
        want.setId(Integer.toString(this.vc_seqno));
        ++this.vc_seqno;
        return want;
    }

    public static double getOffsetInHours(Date origin, Date date) {
        double secs = date.getTime() / 1000L;
        double origin_secs = origin.getTime() / 1000L;
        double diff = secs - origin_secs;
        return diff / 3600.0;
    }

    public void writeXML(String filename) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
        XMLOutputter fmt = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
        fmt.output(this.writeDocument(), (OutputStream)out);
        ((OutputStream)out).close();
    }

    public void writeXML(OutputStream out) throws IOException {
        XMLOutputter fmt = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
        fmt.output(this.writeDocument(), out);
    }

    public String writeXML() {
        XMLOutputter fmt = new XMLOutputter(org.jdom.output.Format.getPrettyFormat());
        return fmt.outputString(this.writeDocument());
    }

    public Document writeDocument() {
        StringBuilder sbuff;
        Element rootElem = new Element("forecastModelRun");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("name", this.getName());
        rootElem.setAttribute("runTime", this.runTime);
        Collections.sort(this.vaxes);
        for (VertCoord vc : this.vaxes) {
            Element vcElem = new Element("vertCoord");
            rootElem.addContent(vcElem);
            vcElem.setAttribute("id", vc.id);
            vcElem.setAttribute("name", vc.name);
            if (vc.units != null) {
                vcElem.setAttribute("units", vc.units);
            }
            sbuff = new StringBuilder();
            for (int j = 0; j < vc.values1.length; ++j) {
                if (j > 0) {
                    sbuff.append(" ");
                }
                sbuff.append(Double.toString(vc.values1[j]));
                if (vc.values2 == null) continue;
                sbuff.append(",");
                sbuff.append(Double.toString(vc.values2[j]));
            }
            vcElem.addContent(sbuff.toString());
        }
        for (TimeCoord tc : this.times) {
            Element offsetElem = new Element("offsetHours");
            rootElem.addContent(offsetElem);
            offsetElem.setAttribute("id", tc.id);
            sbuff = new StringBuilder();
            for (int j = 0; j < tc.offset.length; ++j) {
                if (j > 0) {
                    sbuff.append(" ");
                }
                sbuff.append(Double.toString(tc.offset[j]));
            }
            offsetElem.addContent(sbuff.toString());
            Collections.sort(tc.vars);
            for (Grid grid : tc.vars) {
                Element varElem = new Element("variable");
                offsetElem.addContent(varElem);
                varElem.setAttribute("name", grid.name);
                if (grid.vc != null) {
                    varElem.setAttribute("vert_id", grid.vc.id);
                }
                if (grid.missing == null || grid.missing.size() <= 0) continue;
                Element missingElem = new Element("missing");
                varElem.addContent(missingElem);
                sbuff.setLength(0);
                for (int k = 0; k < grid.missing.size(); ++k) {
                    Missing m = grid.missing.get(k);
                    if (k > 0) {
                        sbuff.append(" ");
                    }
                    sbuff.append(m.timeIndex);
                    sbuff.append(",");
                    sbuff.append(m.vertIndex);
                }
                missingElem.addContent(sbuff.toString());
            }
            if (this.bb == null) continue;
            Element bbElem = new Element("horizBB");
            rootElem.addContent(bbElem);
            LatLonPointImpl llpt = this.bb.getLowerLeftPoint();
            LatLonPointImpl urpt = this.bb.getUpperRightPoint();
            bbElem.setAttribute("west", Format.dfrac(llpt.getLongitude(), 3));
            bbElem.setAttribute("east", Format.dfrac(urpt.getLongitude(), 3));
            bbElem.setAttribute("south", Format.dfrac(llpt.getLatitude(), 3));
            bbElem.setAttribute("north", Format.dfrac(urpt.getLatitude(), 3));
        }
        return doc;
    }

    public static ForecastModelRunInventory readXML(String xmlLocation) throws IOException {
        Document doc;
        if (debug) {
            System.out.println(" read from XML " + xmlLocation);
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(xmlLocation));
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage() + " reading from XML " + xmlLocation);
        }
        Element rootElem = doc.getRootElement();
        ForecastModelRunInventory fmr = new ForecastModelRunInventory();
        fmr.runTime = rootElem.getAttributeValue("runTime");
        DateFormatter formatter = new DateFormatter();
        fmr.runDate = formatter.getISODate(fmr.runTime);
        List vList = rootElem.getChildren("vertCoord");
        for (Element vertElem : vList) {
            VertCoord vc = new VertCoord();
            fmr.vaxes.add(vc);
            vc.id = vertElem.getAttributeValue("id");
            vc.name = vertElem.getAttributeValue("name");
            vc.units = vertElem.getAttributeValue("units");
            String values = vertElem.getText();
            StringTokenizer stoke = new StringTokenizer(values);
            int n = stoke.countTokens();
            vc.values1 = new double[n];
            int count = 0;
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                int pos = toke.indexOf(44);
                if (pos < 0) {
                    vc.values1[count] = Double.parseDouble(toke);
                } else {
                    if (vc.values2 == null) {
                        vc.values2 = new double[n];
                    }
                    String val1 = toke.substring(0, pos);
                    String val2 = toke.substring(pos + 1);
                    vc.values1[count] = Double.parseDouble(val1);
                    vc.values2[count] = Double.parseDouble(val2);
                }
                ++count;
            }
        }
        List tList = rootElem.getChildren("offsetHours");
        for (Element timeElem : tList) {
            TimeCoord tc = new TimeCoord();
            fmr.times.add(tc);
            tc.id = timeElem.getAttributeValue("id");
            String values = timeElem.getText();
            StringTokenizer stoke = new StringTokenizer(values);
            int n = stoke.countTokens();
            TimeCoord.access$602(tc, new double[n]);
            int count = 0;
            while (stoke.hasMoreTokens()) {
                ((TimeCoord)tc).offset[count++] = Double.parseDouble(stoke.nextToken());
            }
            List varList = timeElem.getChildren("variable");
            for (Element vElem : varList) {
                Grid grid = new Grid(vElem.getAttributeValue("name"));
                grid.vc = fmr.getVertCoordinate(vElem.getAttributeValue("vert_id"));
                tc.vars.add(grid);
                grid.parent = tc;
                List mList = vElem.getChildren("missing");
                for (Element mElem : mList) {
                    grid.missing = new ArrayList<Missing>();
                    values = mElem.getText();
                    stoke = new StringTokenizer(values, " ,");
                    while (stoke.hasMoreTokens()) {
                        int timeIdx = Integer.parseInt(stoke.nextToken());
                        int vertIdx = Integer.parseInt(stoke.nextToken());
                        grid.missing.add(new Missing(timeIdx, vertIdx));
                    }
                }
            }
        }
        Element bbElem = rootElem.getChild("horizBB");
        if (bbElem != null) {
            double west = Double.parseDouble(bbElem.getAttributeValue("west"));
            double east = Double.parseDouble(bbElem.getAttributeValue("east"));
            double north = Double.parseDouble(bbElem.getAttributeValue("north"));
            double south = Double.parseDouble(bbElem.getAttributeValue("south"));
            fmr.bb = new LatLonRect(new LatLonPointImpl(south, west), new LatLonPointImpl(north, east));
        }
        return fmr;
    }

    public static ForecastModelRunInventory open(DiskCache2 cache, String ncfileLocation, int mode, boolean isFile) throws IOException {
        File summaryFile;
        boolean force = mode == 2;
        boolean xml_only = mode == 3;
        String summaryFileLocation = ncfileLocation + ".fmrInv.xml";
        if (null != cache) {
            summaryFile = cache.getCacheFile(summaryFileLocation);
            summaryFileLocation = summaryFile.getPath();
        } else {
            summaryFile = new File(summaryFileLocation);
        }
        if (!force) {
            if (summaryFile.exists()) {
                if (isFile) {
                    File ncdFile = new File(ncfileLocation);
                    if (!ncdFile.exists()) {
                        throw new IllegalArgumentException("File must exist = " + ncfileLocation);
                    }
                    if (xml_only || summaryFile.lastModified() >= ncdFile.lastModified()) {
                        try {
                            return ForecastModelRunInventory.readXML(summaryFileLocation);
                        }
                        catch (Exception ee) {
                            log.error("Failed to read FmrcInventory " + summaryFileLocation, ee);
                        }
                    }
                } else {
                    try {
                        return ForecastModelRunInventory.readXML(summaryFileLocation);
                    }
                    catch (Exception ee) {
                        log.error("Failed to read FmrcInventory " + summaryFileLocation, ee);
                    }
                }
            }
            if (xml_only) {
                return null;
            }
        }
        if (debug) {
            System.out.println(" read from dataset " + ncfileLocation + " write to XML " + summaryFileLocation);
        }
        ForecastModelRunInventory fmr = new ForecastModelRunInventory(ncfileLocation);
        fmr.writeXML(summaryFileLocation);
        fmr.releaseDataset();
        if (showXML) {
            IO.copyFile(summaryFileLocation, System.out);
        }
        return fmr;
    }

    public static ForecastModelRunInventory open(GridDataset gds, Date runDate) {
        return new ForecastModelRunInventory(gds, runDate);
    }

    public static void main2(String[] args) throws Exception {
        String def = "R:/testdata/motherlode/grid/NAM_CONUS_80km_20060728_1200.grib1";
        String datasetName = args.length < 1 ? def : args[0];
        ForecastModelRunInventory fmr = ForecastModelRunInventory.open(null, datasetName, 2, true);
        fmr.writeXML(System.out);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            ForecastModelRunInventory.open(null, args[0], 2, true);
            return;
        }
        DiskCache2 cache = new DiskCache2("fmrcInventory/", true, 432000, 3600);
        String url = "http://motherlode.ucar.edu:9080/thredds/dodsC/fmrc/NCEP/NAM/CONUS_12km/files/NAM_CONUS_12km_20070419_1800.grib2";
        ForecastModelRunInventory fmr = ForecastModelRunInventory.open(cache, url, 1, false);
        fmr.writeXML(System.out);
    }

    public static class VertCoord
    implements FmrcCoordSys.VertCoord,
    Comparable {
        CoordinateAxis1D axis;
        private String name;
        private String units;
        private String id;
        double[] values1;
        double[] values2;

        VertCoord() {
        }

        VertCoord(CoordinateAxis1D axis) {
            this.axis = axis;
            this.name = axis.getName();
            this.units = axis.getUnitsString();
            int n = (int)axis.getSize();
            if (axis.isLayer()) {
                this.values1 = axis.getBound1();
                this.values2 = axis.getBound2();
            } else {
                this.values1 = new double[n];
                int i = 0;
                while ((long)i < axis.getSize()) {
                    this.values1[i] = axis.getCoordValue(i);
                    ++i;
                }
            }
        }

        VertCoord(VertCoord vc) {
            this.name = vc.getName();
            this.units = vc.getUnits();
            this.id = vc.getId();
            this.values1 = (double[])vc.getValues1().clone();
            this.values2 = vc.getValues2() == null ? null : (double[])vc.getValues2().clone();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public double[] getValues1() {
            return this.values1;
        }

        public void setValues1(double[] values) {
            this.values1 = values;
        }

        public double[] getValues2() {
            return this.values2;
        }

        public void setValues2(double[] values) {
            this.values2 = values;
        }

        public int getSize() {
            return this.values1.length;
        }

        public boolean equalsData(VertCoord other) {
            int i;
            if (this.values1.length != other.values1.length) {
                return false;
            }
            for (i = 0; i < this.values1.length; ++i) {
                if (Misc.closeEnough(this.values1[i], other.values1[i])) continue;
                return false;
            }
            if (this.values2 == null && other.values2 == null) {
                return true;
            }
            if (this.values2 == null || other.values2 == null) {
                return false;
            }
            if (this.values2.length != other.values2.length) {
                return false;
            }
            for (i = 0; i < this.values2.length; ++i) {
                if (Misc.closeEnough(this.values2[i], other.values2[i])) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Object o) {
            VertCoord other = (VertCoord)o;
            return this.name.compareTo(other.name);
        }
    }

    public static class Missing {
        int timeIndex;
        int vertIndex;

        Missing(int timeIndex, int vertIndex) {
            this.timeIndex = timeIndex;
            this.vertIndex = vertIndex;
        }
    }

    public static class Grid
    implements Comparable {
        String name;
        TimeCoord parent = null;
        VertCoord vc = null;
        List<Missing> missing;

        Grid(String name) {
            this.name = name;
        }

        public int compareTo(Object o) {
            Grid other = (Grid)o;
            return this.name.compareTo(other.name);
        }

        public int countInventory() {
            return this.countTotal() - this.countMissing();
        }

        public int countTotal() {
            int ntimes = this.parent.getOffsetHours().length;
            return ntimes * this.getVertCoordLength();
        }

        public int countMissing() {
            return this.missing == null ? 0 : this.missing.size();
        }

        int getVertCoordLength() {
            return this.vc == null ? 1 : this.vc.getValues1().length;
        }

        public int countInventory(double hourOffset) {
            int timeIndex = this.parent.findIndex(hourOffset);
            if (timeIndex < 0) {
                return 0;
            }
            if (this.missing == null) {
                return this.getVertCoordLength();
            }
            int count = 0;
            for (Missing m : this.missing) {
                if (m.timeIndex != timeIndex) continue;
                ++count;
            }
            return this.getVertCoordLength() - count;
        }

        public double[] getVertCoords(double hourOffset) {
            int timeIndex = this.parent.findIndex(hourOffset);
            if (timeIndex < 0) {
                return new double[0];
            }
            if (this.vc == null) {
                double[] result = new double[]{-0.0};
                return result;
            }
            double[] result = (double[])this.vc.getValues1().clone();
            if (null != this.missing) {
                for (Missing m : this.missing) {
                    if (m.timeIndex != timeIndex) continue;
                    result[m.vertIndex] = Double.NaN;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeCoord
    implements FmrcCoordSys.TimeCoord {
        private CoordinateAxis1D axis;
        private List<Grid> vars = new ArrayList<Grid>();
        private String id;
        private double[] offset;

        TimeCoord() {
        }

        TimeCoord(int num, TimeCoord from) {
            this.id = Integer.toString(num);
            this.offset = from.offset;
        }

        TimeCoord(Date runDate, CoordinateAxis1D axis) {
            this.axis = axis;
            DateUnit unit = null;
            try {
                unit = new DateUnit(axis.getUnitsString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Not a unit of time " + axis.getUnitsString());
            }
            int n = (int)axis.getSize();
            this.offset = new double[n];
            int i = 0;
            while ((long)i < axis.getSize()) {
                Date d = unit.makeDate(axis.getCoordValue(i));
                this.offset[i] = ForecastModelRunInventory.getOffsetInHours(runDate, d);
                ++i;
            }
        }

        public List<Grid> getGrids() {
            return this.vars;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getName() {
            return this.id.equals("0") ? "time" : "time" + this.id;
        }

        @Override
        public double[] getOffsetHours() {
            return this.offset;
        }

        public void setOffsetHours(double[] offset) {
            this.offset = offset;
        }

        public boolean equalsData(TimeCoord tother) {
            if (this.offset.length != tother.offset.length) {
                return false;
            }
            for (int i = 0; i < this.offset.length; ++i) {
                if (Misc.closeEnough(this.offset[i], tother.offset[i])) continue;
                return false;
            }
            return true;
        }

        int findIndex(double offsetHour) {
            for (int i = 0; i < this.offset.length; ++i) {
                if (this.offset[i] != offsetHour) continue;
                return i;
            }
            return -1;
        }

        static /* synthetic */ double[] access$602(TimeCoord x0, double[] x1) {
            x0.offset = x1;
            return x1;
        }
    }
}

