/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpMethod;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamRemote;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonRect;

public class PointDatasetFromNcStream
extends PointDatasetImpl {
    private NcStreamRemote ncremote;

    public static FeatureDatasetPoint factory(String endpoint) throws IOException {
        NcStreamRemote ncremote = new NcStreamRemote(endpoint, null);
        NetcdfDataset ncd = new NetcdfDataset(ncremote);
        return new PointDatasetFromNcStream(ncd, ncremote);
    }

    private PointDatasetFromNcStream(NetcdfDataset ncd, NcStreamRemote ncremote) {
        super(ncd, FeatureType.POINT);
        this.ncremote = ncremote;
        this.collectionList = new ArrayList(1);
        this.collectionList.add(new RemotePointCollection());
    }

    public FeatureType getFeatureType() {
        return FeatureType.POINT;
    }

    public static void main(String[] args) throws IOException {
        String endpoint = "http://localhost:8080/thredds/ncstream/point/data";
        FeatureDatasetPoint fd = PointDatasetFromNcStream.factory(endpoint);
        PointFeatureCollection pc = (PointFeatureCollection)fd.getPointFeatureCollectionList().get(0);
        PointFeatureIterator pfIter = pc.getPointFeatureIterator(-1);
        while (pfIter.hasNext()) {
            PointFeature pf = pfIter.next();
            System.out.println("pf= " + pf);
        }
    }

    private class RemotePointCollection
    extends PointCollectionImpl {
        RemotePointCollection() {
            super(PointDatasetFromNcStream.this.getLocation());
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            try {
                HttpMethod method = PointDatasetFromNcStream.this.ncremote.readSequence(this.makeRequest());
                InputStream in = method.getResponseBodyAsStream();
                int len = NcStream.readVInt(in);
                byte[] b = new byte[len];
                NcStream.readFully(in, b);
                PointStreamProto.PointFeatureCollection pfc = PointStreamProto.PointFeatureCollection.parseFrom(b);
                return new RemotePointFeatureIterator(pfc, method, in);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                return null;
            }
        }

        public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
            return new PointFeatureCollectionSubset(this, boundingBox, dateRange);
        }

        private String makeRequest() {
            return "request";
        }

        private class PointFeatureCollectionSubset
        extends RemotePointCollection {
            PointCollectionImpl from;

            PointFeatureCollectionSubset(PointCollectionImpl from, LatLonRect filter_bb, DateRange filter_date) throws IOException {
                this.from = from;
                if (filter_bb == null) {
                    this.boundingBox = from.getBoundingBox();
                } else {
                    LatLonRect latLonRect = this.boundingBox = from.getBoundingBox() == null ? filter_bb : from.getBoundingBox().intersect(filter_bb);
                }
                this.dateRange = filter_date == null ? from.getDateRange() : (from.getDateRange() == null ? filter_date : from.getDateRange().intersect(filter_date));
            }
        }

        private class RemotePointFeatureIterator
        implements PointFeatureIterator {
            PointStreamProto.PointFeatureCollection pfc;
            HttpMethod method;
            InputStream in;
            int count = 0;
            PointFeature pf;
            DateUnit timeUnit;
            StructureMembers sm;

            RemotePointFeatureIterator(PointStreamProto.PointFeatureCollection pfc, HttpMethod method, InputStream in) throws IOException {
                this.pfc = pfc;
                this.method = method;
                this.in = in;
                try {
                    this.timeUnit = new DateUnit(pfc.getTimeUnit());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.sm = new StructureMembers(pfc.getName());
                for (PointStreamProto.Member m : pfc.getMembersList()) {
                    this.sm.addMember(m.getName(), m.getDesc(), m.getUnits(), NcStream.decodeDataType(m.getDataType()), NcStream.decodeSection(m.getSection()).getShape());
                }
            }

            public boolean hasNext() throws IOException {
                int len = NcStream.readVInt(this.in);
                if (len <= 0) {
                    this.cancel();
                    return false;
                }
                byte[] b = new byte[len];
                NcStream.readFully(this.in, b);
                PointStreamProto.PointFeature pfp = PointStreamProto.PointFeature.parseFrom(b);
                PointStreamProto.Location locp = pfp.getLoc();
                EarthLocationImpl location = new EarthLocationImpl(locp.getLat(), locp.getLon(), locp.getAlt());
                this.pf = new MyPointFeature(location, locp.getTime(), locp.getNomTime(), this.timeUnit, pfp);
                System.out.println(" count= " + this.count + " pf=" + this.pf);
                ++this.count;
                return true;
            }

            public PointFeature next() throws IOException {
                return this.pf;
            }

            public void cancel() {
                if (this.method != null) {
                    this.method.releaseConnection();
                }
                this.method = null;
            }

            public void setBufferSize(int bytes) {
            }

            private class MyPointFeature
            extends PointFeatureImpl {
                PointStreamProto.PointFeature pfp;

                MyPointFeature(EarthLocation location, double obsTime, double nomTime, DateUnit timeUnit, PointStreamProto.PointFeature pfp) {
                    super(location, obsTime, nomTime, timeUnit);
                    this.pfp = pfp;
                }

                public StructureData getData() throws IOException {
                    ByteBuffer bb = ByteBuffer.wrap(this.pfp.getData().toByteArray());
                    ArrayStructureBB asbb = new ArrayStructureBB(RemotePointFeatureIterator.this.sm, new int[]{1}, bb, 0);
                    for (String s : this.pfp.getSdataList()) {
                        asbb.addObjectToHeap(s);
                    }
                    return asbb.getStructureData(0);
                }

                public String toString() {
                    return this.location + " obs=" + this.obsTime + " nom=" + this.nomTime;
                }
            }
        }
    }
}

