/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.PointIteratorImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.units.DateUnit;

public class StandardPointFeatureIterator
extends PointIteratorImpl {
    private NestedTable ft;
    private DateUnit timeUnit;
    private Cursor cursor;

    StandardPointFeatureIterator(NestedTable ft, DateUnit timeUnit, StructureDataIterator structIter, Cursor cursor, boolean calcBB) throws IOException {
        super(structIter, null, calcBB);
        this.ft = ft;
        this.timeUnit = timeUnit;
        this.cursor = cursor;
    }

    protected PointFeature makeFeature(int recnum, StructureData sdata) throws IOException {
        this.cursor.tableData[0] = sdata;
        this.ft.addParentJoin(this.cursor);
        return new StandardPointFeature(this.cursor, this.timeUnit, recnum);
    }

    private class StandardPointFeature
    extends PointFeatureImpl {
        protected int id;
        protected Cursor cursor;

        public StandardPointFeature(Cursor cursor, DateUnit timeUnit, int id) {
            super(timeUnit);
            this.cursor = cursor.copy();
            this.id = id;
            this.obsTime = StandardPointFeatureIterator.this.ft.getObsTime(this.cursor);
            this.nomTime = StandardPointFeatureIterator.this.ft.getNomTime(this.cursor);
            if (Double.isNaN(this.nomTime)) {
                this.nomTime = this.obsTime;
            }
            this.location = StandardPointFeatureIterator.this.ft.getEarthLocation(this.cursor);
        }

        public Object getId() {
            return Integer.toString(this.id);
        }

        public StructureData getData() {
            return StandardPointFeatureIterator.this.ft.makeObsStructureData(this.cursor);
        }
    }
}

