/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Iterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.Station;

public class StandardStationCollectionImpl
extends StationTimeSeriesCollectionImpl {
    private DateUnit timeUnit;
    private NestedTable ft;

    StandardStationCollectionImpl(NestedTable ft, DateUnit timeUnit) throws IOException {
        super(ft.getName());
        this.timeUnit = timeUnit;
        this.ft = ft;
        this.stationHelper = new StationHelper();
        StructureDataIterator siter = ft.getStationDataIterator(-1);
        while (siter.hasNext()) {
            StructureData stationData = siter.next();
            this.stationHelper.addStation(this.makeStation(stationData));
        }
    }

    private Station makeStation(StructureData stationData) {
        Station s = this.ft.makeStation(stationData);
        return new StandardStationFeatureImpl(s, this.timeUnit, stationData);
    }

    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new PointFeatureCollectionIterator(){
            Iterator<Station> stationIter;
            {
                this.stationIter = StandardStationCollectionImpl.this.stationHelper.getStations().iterator();
            }

            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            public PointFeatureCollection next() throws IOException {
                return (StationFeatureImpl)this.stationIter.next();
            }

            public void setBufferSize(int bytes) {
            }
        };
    }

    private class StandardStationPointIterator
    extends StandardPointFeatureIterator {
        StationFeatureImpl station;

        StandardStationPointIterator(StationFeatureImpl station, StructureDataIterator structIter, Cursor tableData) throws IOException {
            super(StandardStationCollectionImpl.this.ft, StandardStationCollectionImpl.this.timeUnit, structIter, tableData, false);
            this.station = station;
        }

        public boolean hasNext() throws IOException {
            boolean result = super.hasNext();
            if (!result && this.station != null) {
                this.station.setNumberPoints(this.getCount());
            }
            return result;
        }
    }

    private class StandardStationFeatureImpl
    extends StationFeatureImpl {
        Cursor cursor;

        StandardStationFeatureImpl(Station s, DateUnit dateUnit, StructureData stationData) {
            super(s, dateUnit, -1);
            this.cursor = new Cursor(2);
            this.cursor.tableData[1] = stationData;
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            StructureDataIterator obsIter = StandardStationCollectionImpl.this.ft.getStationObsDataIterator(this.cursor.tableData[1], bufferSize);
            return new StandardStationPointIterator(this.size() < 0 ? this : null, obsIter, this.cursor);
        }
    }
}

