/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.TrajectoryFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;

public class StandardTrajectoryCollectionImpl
extends OneNestedPointCollectionImpl
implements TrajectoryFeatureCollection {
    private DateUnit timeUnit;
    private NestedTable ft;
    private TrajIterator localIterator = null;

    StandardTrajectoryCollectionImpl(NestedTable ft, DateUnit timeUnit) {
        super(ft.getName(), FeatureType.TRAJECTORY);
        this.ft = ft;
        this.timeUnit = timeUnit;
    }

    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new TrajIterator(this.ft.getFeatureDataIterator(bufferSize));
    }

    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    public TrajectoryFeature next() throws IOException {
        return this.localIterator.next();
    }

    public void resetIteration() throws IOException {
        this.localIterator = (TrajIterator)this.getPointFeatureCollectionIterator(-1);
    }

    private class StandardTrajectoryFeature
    extends TrajectoryFeatureImpl {
        StructureData trajData;

        StandardTrajectoryFeature(StructureData trajData) {
            super(StandardTrajectoryCollectionImpl.this.ft.getFeatureName(trajData), -1);
            this.trajData = trajData;
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursor = new Cursor(StandardTrajectoryCollectionImpl.this.ft.getNumberOfLevels());
            cursor.tableData[1] = this.trajData;
            StructureDataIterator siter = StandardTrajectoryCollectionImpl.this.ft.getFeatureObsDataIterator(this.trajData, bufferSize);
            return new StandardPointFeatureIterator(StandardTrajectoryCollectionImpl.this.ft, StandardTrajectoryCollectionImpl.this.timeUnit, siter, cursor, false);
        }
    }

    private class TrajIterator
    implements PointFeatureCollectionIterator {
        StructureDataIterator structIter;

        TrajIterator(StructureDataIterator structIter) throws IOException {
            this.structIter = structIter;
        }

        public boolean hasNext() throws IOException {
            return this.structIter.hasNext();
        }

        public TrajectoryFeature next() throws IOException {
            return new StandardTrajectoryFeature(this.structIter.next());
        }

        public void setBufferSize(int bytes) {
        }
    }
}

