/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class CFpointObs
extends TableConfigurerImpl {
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String datatype = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        if (datatype == null) {
            datatype = ds.findAttValueIgnoreCase(null, "CF-featureType", null);
        }
        if (datatype == null) {
            return false;
        }
        if (CF.FeatureType.valueOf(datatype) == null) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (toke.startsWith("CF-1.0")) {
                return false;
            }
            if (!toke.startsWith("CF")) continue;
            return true;
        }
        return false;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        String ftypeS = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        if (ftypeS == null) {
            ftypeS = ds.findAttValueIgnoreCase(null, "CF-featureType", null);
        }
        CF.FeatureType ftype = ftypeS == null ? CF.FeatureType.point : CF.FeatureType.valueOf(ftypeS);
        switch (ftype) {
            case point: {
                return this.getPointConfig(ds, errlog);
            }
            case stationTimeSeries: {
                return this.getStationConfig(ds, errlog);
            }
            case profile: {
                return this.getProfileConfig(ds, errlog);
            }
            case trajectory: {
                return this.getTrajectoryConfig(ds, errlog);
            }
            case stationProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("invalid ftype= " + (Object)((Object)ftype));
    }

    protected TableConfig getPointConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig nt = new TableConfig(Table.Type.Structure, "record");
        nt.structName = "record";
        nt.featureType = FeatureType.POINT;
        CoordSysEvaluator.findCoords(nt, ds);
        return nt;
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("Must have a Longitude coordinate", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        boolean isScalar = lat.getRank() == 0;
        boolean isSingle = lat.getRank() == 1 && lat.getSize() == 1L;
        Dimension stationDim = null;
        if (!isScalar) {
            if (lat.getDimension(0) != lon.getDimension(0)) {
                errlog.format("Lat and Lon coordinate must have same size", new Object[0]);
                return null;
            }
            stationDim = lat.getDimension(0);
        }
        Table.Type stationTableType = isScalar ? Table.Type.Top : Table.Type.Structure;
        TableConfig stnTable = new TableConfig(stationTableType, "station");
        stnTable.featureType = FeatureType.STATION;
        stnTable.isPsuedoStructure = !stationDim.isUnlimited();
        stnTable.dim = stationDim;
        stnTable.lat = lat.getName();
        stnTable.lon = lon.getName();
        CoordinateAxis alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (alt != null) {
            stnTable.stnAlt = alt.getName();
        }
        stnTable.stnId = Evaluator.getVariableWithAttribute(ds, "standard_name", "station_id");
        if (stnTable.stnId == null) {
            errlog.format("Must have a Station id variable with standard name station_id", new Object[0]);
            return null;
        }
        Variable stnId = ds.findVariable(stnTable.stnId);
        if (!isScalar && !stnId.getDimension(0).equals(stationDim)) {
            errlog.format("Station id outer dimension must match latitude/longitude dimension", new Object[0]);
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(0);
        boolean hasStruct = obsDim.isUnlimited();
        Table.Type obsTableType = isScalar || isSingle ? Table.Type.Structure : Table.Type.ParentIndex;
        TableConfig obs = new TableConfig(obsTableType, obsDim.getName());
        obs.structName = hasStruct ? "record" : obsDim.getName();
        obs.isPsuedoStructure = !hasStruct;
        obs.dim = obsDim;
        obs.time = time.getName();
        stnTable.addChild(obs);
        if (obsTableType == Table.Type.ParentIndex) {
            String ragged_parentIndex = Evaluator.getVariableWithAttribute(ds, "standard_name", "ragged_parentIndex");
            Variable rpIndex = ds.findVariable(ragged_parentIndex);
            Array index = rpIndex.read();
            int childIndex = 0;
            HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>((int)(2L * index.getSize()));
            while (index.hasNext()) {
                int parent = index.nextInt();
                ArrayList<Integer> list = (ArrayList<Integer>)map.get(parent);
                if (list == null) {
                    list = new ArrayList<Integer>();
                    map.put(parent, list);
                }
                list.add(childIndex);
                ++childIndex;
            }
            obs.indexMap = map;
        }
        return stnTable;
    }

    protected TableConfig getProfileConfig(NetcdfDataset ds, Formatter errlog) {
        return null;
    }

    protected TableConfig getTrajectoryConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig nt = new TableConfig(Table.Type.MultiDimOuter, "trajectory");
        nt.featureType = FeatureType.TRAJECTORY;
        CoordSysEvaluator.findCoords(nt, ds);
        TableConfig obs = new TableConfig(Table.Type.MultiDimInner, "record");
        obs.dim = ds.findDimension("sample");
        obs.outer = ds.findDimension("traj");
        nt.addChild(obs);
        return nt;
    }

    protected TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) {
        return null;
    }
}

