/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.geotiff;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayFloat;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.geotiff.FieldType;
import ucar.nc2.geotiff.GeoKey;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.IFDEntry;
import ucar.nc2.geotiff.Tag;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;

public class GeotiffWriter {
    private String fileOut;
    private GeoTiff geotiff;
    private short pageNumber = 1;

    public GeotiffWriter(String fileOut) {
        this.fileOut = fileOut;
        this.geotiff = new GeoTiff(fileOut);
    }

    public void writeGrid(ucar.nc2.dt.GridDataset dataset, GridDatatype grid, Array data, boolean greyScale) throws IOException {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        if (!gcs.isRegularSpatial()) {
            throw new IllegalArgumentException("Must have 1D x and y axes for " + grid.getName());
        }
        CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
        double scaler = gcs.isLatLon() ? 1.0 : 1000.0;
        double xStart = xaxis.getCoordValue(0) * scaler;
        double yStart = yaxis.getCoordValue(0) * scaler;
        double xInc = xaxis.getIncrement() * scaler;
        double yInc = Math.abs(yaxis.getIncrement()) * scaler;
        if (yaxis.getCoordValue(0) < yaxis.getCoordValue(1)) {
            data = data.flip(0);
            yStart = yaxis.getCoordValue((int)yaxis.getSize() - 1) * scaler;
        }
        if (gcs.isLatLon()) {
            Array lon = xaxis.read();
            data = this.geoShiftDataAtLon(data, lon);
            xStart = this.geoShiftGetXstart(lon, xInc);
        }
        if (!xaxis.isRegular() || !yaxis.isRegular()) {
            throw new IllegalArgumentException("Must be evenly spaced grid = " + grid.getName());
        }
        if (this.pageNumber > 1) {
            this.geotiff.initTags();
        }
        this.writeGrid(grid, data, greyScale, xStart, yStart, xInc, yInc, this.pageNumber);
        this.pageNumber = (short)(this.pageNumber + 1);
    }

    public void writeGrid(String fileName, String gridName, int time, int level, boolean greyScale, LatLonRect pt) throws IOException {
        int y2;
        int x2;
        double xStart;
        double yStart;
        int y1;
        int x1;
        GridDataset dataset = GridDataset.open(fileName);
        GridDatatype grid = dataset.findGridDatatype(gridName);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        ProjectionImpl proj = grid.getProjection();
        if (grid == null) {
            throw new IllegalArgumentException("No grid named " + gridName + " in fileName");
        }
        if (!gcs.isRegularSpatial()) {
            throw new IllegalArgumentException("Must have 1D x and y axes for " + grid.getName());
        }
        CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
        if (!xaxis.isRegular() || !yaxis.isRegular()) {
            throw new IllegalArgumentException("Must be evenly spaced grid = " + grid.getName());
        }
        Array data = grid.readDataSlice(time, level, -1, -1);
        Array lon = xaxis.read();
        Array lat = yaxis.read();
        double scaler = gcs.isLatLon() ? 1.0 : 1000.0;
        if (yaxis.getCoordValue(0) < yaxis.getCoordValue(1)) {
            data = data.flip(0);
            lat = lat.flip(0);
        }
        if (gcs.isLatLon()) {
            data = this.geoShiftDataAtLon(data, lon);
            lon = this.geoShiftLon(lon);
        }
        LatLonPointImpl llp0 = pt.getLowerLeftPoint();
        LatLonPointImpl llpn = pt.getUpperRightPoint();
        double minLon = llp0.getLongitude();
        double minLat = llp0.getLatitude();
        double maxLon = llpn.getLongitude();
        double maxLat = llpn.getLatitude();
        if (!gcs.isLatLon()) {
            ProjectionPointImpl pjp0 = proj.latLonToProj(maxLat, minLon);
            double[] lonArray = (double[])lon.copyTo1DJavaArray();
            double[] latArray = (double[])lat.copyTo1DJavaArray();
            x1 = this.getXIndex(lon, pjp0.getX(), 0);
            y1 = this.getYIndex(lat, pjp0.getY(), 0);
            yStart = pjp0.getY() * 1000.0;
            xStart = pjp0.getX() * 1000.0;
            ProjectionPointImpl pjpn = proj.latLonToProj(minLat, maxLon);
            x2 = this.getXIndex(lon, pjpn.getX(), 1);
            y2 = this.getYIndex(lat, pjpn.getY(), 1);
        } else {
            xStart = minLon;
            yStart = maxLat;
            x1 = this.getLonIndex(lon, minLon, 0);
            y1 = this.getLatIndex(lat, maxLat, 0);
            x2 = this.getLonIndex(lon, maxLon, 1);
            y2 = this.getLatIndex(lat, minLat, 1);
        }
        double xInc = xaxis.getIncrement() * scaler;
        double yInc = Math.abs(yaxis.getIncrement()) * scaler;
        Array data1 = this.getYXDataInBox(data, x1, x2, y1, y2);
        if (this.pageNumber > 1) {
            this.geotiff.initTags();
        }
        this.writeGrid(grid, data1, greyScale, xStart, yStart, xInc, yInc, this.pageNumber);
        this.pageNumber = (short)(this.pageNumber + 1);
    }

    int getXIndex(Array aAxis, double value, int side) {
        IndexIterator aIter = aAxis.getIndexIterator();
        int count = 0;
        boolean isInd = false;
        double aValue = aIter.getFloatNext();
        if (aValue == value || aValue > value) {
            return 0;
        }
        while (aIter.hasNext() && aValue < value) {
            ++count;
            aValue = aIter.getFloatNext();
            if (aValue != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    int getYIndex(Array aAxis, double value, int side) {
        IndexIterator aIter = aAxis.getIndexIterator();
        int count = 0;
        boolean isInd = false;
        double aValue = aIter.getFloatNext();
        if (aValue == value || aValue < value) {
            return 0;
        }
        while (aIter.hasNext() && aValue > value) {
            ++count;
            aValue = aIter.getFloatNext();
            if (aValue != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    int getLatIndex(Array lat, double value, int side) {
        int[] shape = lat.getShape();
        IndexIterator latIter = lat.getIndexIterator();
        Index ind = lat.getIndex();
        int count = 0;
        boolean isInd = false;
        double xlat = latIter.getFloatNext();
        if (xlat == value) {
            return 0;
        }
        while (latIter.hasNext() && xlat > value) {
            ++count;
            xlat = latIter.getFloatNext();
            if (xlat != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    int getLonIndex(Array lon, double value, int side) {
        int[] shape = lon.getShape();
        IndexIterator lonIter = lon.getIndexIterator();
        Index ind = lon.getIndex();
        int count = 0;
        boolean isInd = false;
        float xlon = lonIter.getFloatNext();
        if (xlon > 180.0f) {
            xlon -= 360.0f;
        }
        if ((double)xlon == value) {
            return 0;
        }
        while (lonIter.hasNext() && (double)xlon < value) {
            ++count;
            xlon = lonIter.getFloatNext();
            if (xlon > 180.0f) {
                xlon -= 360.0f;
            }
            if ((double)xlon != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    public Array getYXDataInBox(Array data, int x1, int x2, int y1, int y2) throws IOException {
        Array dataVolume;
        int rank = data.getRank();
        int[] start = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            start[i] = 0;
            shape[i] = 1;
        }
        if (y1 >= 0 && y2 >= 0) {
            start[0] = y1;
            shape[0] = y2 - y1;
        }
        if (x1 >= 0 && x2 >= 0) {
            start[1] = x1;
            shape[1] = x2 - x1;
        }
        try {
            dataVolume = data.section(start, shape);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return dataVolume;
    }

    public void writeGrid(GridDatatype grid, Array data, boolean greyScale, double xStart, double yStart, double xInc, double yInc, int imageNumber) throws IOException {
        Array result;
        int nextStart = 0;
        GridCoordSystem gcs = grid.getCoordinateSystem();
        if (!(gcs.isLatLon() || gcs.getProjection() instanceof LambertConformal || gcs.getProjection() instanceof Stereographic || gcs.getProjection() instanceof Mercator || gcs.getProjection() instanceof AlbersEqualArea)) {
            throw new IllegalArgumentException("Must be lat/lon or LambertConformal or Mercator and grid = " + gcs.getProjection().getClass().getName());
        }
        if (greyScale) {
            result = this.replaceMissingValuesAndScale(grid, data);
            nextStart = this.geotiff.writeData((byte[])((ArrayByte)result).getStorage(), imageNumber);
        } else {
            result = this.replaceMissingValues(grid, data);
            nextStart = this.geotiff.writeData((float[])((ArrayFloat)result).getStorage(), imageNumber);
        }
        int elemSize = greyScale ? 1 : 4;
        int height = data.getShape()[0];
        int width = data.getShape()[1];
        int size = elemSize * height * width;
        this.geotiff.addTag(new IFDEntry(Tag.ImageWidth, FieldType.SHORT).setValue(width));
        this.geotiff.addTag(new IFDEntry(Tag.ImageLength, FieldType.SHORT).setValue(height));
        int ff = 2;
        int page = imageNumber - 1;
        this.geotiff.addTag(new IFDEntry(Tag.NewSubfileType, FieldType.SHORT).setValue(ff));
        this.geotiff.addTag(new IFDEntry(Tag.PageNumber, FieldType.SHORT).setValue(page, 2));
        this.geotiff.addTag(new IFDEntry(Tag.RowsPerStrip, FieldType.SHORT).setValue(1));
        int[] soffset = new int[width];
        int[] sbytecount = new int[width];
        soffset[0] = imageNumber == 1 ? 8 : nextStart;
        sbytecount[0] = width * elemSize;
        for (int i = 1; i < width; ++i) {
            soffset[i] = soffset[i - 1] + width * elemSize;
            sbytecount[i] = width * elemSize;
        }
        this.geotiff.addTag(new IFDEntry(Tag.StripByteCounts, FieldType.LONG, width).setValue(sbytecount));
        this.geotiff.addTag(new IFDEntry(Tag.StripOffsets, FieldType.LONG, width).setValue(soffset));
        this.geotiff.addTag(new IFDEntry(Tag.Orientation, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.Compression, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.Software, FieldType.ASCII).setValue("nc2geotiff"));
        this.geotiff.addTag(new IFDEntry(Tag.PhotometricInterpretation, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.PlanarConfiguration, FieldType.SHORT).setValue(1));
        if (greyScale) {
            this.geotiff.addTag(new IFDEntry(Tag.BitsPerSample, FieldType.SHORT).setValue(8));
            this.geotiff.addTag(new IFDEntry(Tag.SamplesPerPixel, FieldType.SHORT).setValue(1));
            this.geotiff.addTag(new IFDEntry(Tag.XResolution, FieldType.RATIONAL).setValue(1, 1));
            this.geotiff.addTag(new IFDEntry(Tag.YResolution, FieldType.RATIONAL).setValue(1, 1));
            this.geotiff.addTag(new IFDEntry(Tag.ResolutionUnit, FieldType.SHORT).setValue(1));
        } else {
            this.geotiff.addTag(new IFDEntry(Tag.BitsPerSample, FieldType.SHORT).setValue(32));
            this.geotiff.addTag(new IFDEntry(Tag.SampleFormat, FieldType.SHORT).setValue(3));
            this.geotiff.addTag(new IFDEntry(Tag.SamplesPerPixel, FieldType.SHORT).setValue(1));
            MAMath.MinMax dataMinMax = grid.getMinMaxSkipMissingData(data);
            float min = (float)dataMinMax.min;
            float max = (float)dataMinMax.max;
            this.geotiff.addTag(new IFDEntry(Tag.SMinSampleValue, FieldType.FLOAT).setValue(min));
            this.geotiff.addTag(new IFDEntry(Tag.SMaxSampleValue, FieldType.FLOAT).setValue(max));
            this.geotiff.addTag(new IFDEntry(Tag.GDALNoData, FieldType.FLOAT).setValue(min - 1.0f));
        }
        this.geotiff.setTransform(xStart, yStart, xInc, yInc);
        if (gcs.isLatLon()) {
            this.addLatLonTags();
        } else if (gcs.getProjection() instanceof LambertConformal) {
            this.addLambertConformalTags((LambertConformal)gcs.getProjection(), xStart, yStart);
        } else if (gcs.getProjection() instanceof Stereographic) {
            this.addPolarStereographicTags((Stereographic)gcs.getProjection(), xStart, yStart);
        } else if (gcs.getProjection() instanceof Mercator) {
            this.addMercatorTags((Mercator)gcs.getProjection());
        } else if (gcs.getProjection() instanceof TransverseMercator) {
            this.addTransverseMercatorTags((TransverseMercator)gcs.getProjection());
        } else if (gcs.getProjection() instanceof AlbersEqualArea) {
            this.addAlbersEqualAreaTags((AlbersEqualArea)gcs.getProjection());
        }
        this.geotiff.writeMetadata(imageNumber);
    }

    public void close() throws IOException {
        this.geotiff.close();
    }

    private ArrayFloat replaceMissingValues(GridDatatype grid, Array data) {
        MAMath.MinMax dataMinMax = grid.getMinMaxSkipMissingData(data);
        float minValue = (float)(dataMinMax.min - 1.0);
        ArrayFloat floatArray = (ArrayFloat)Array.factory(Float.TYPE, data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator floatIter = floatArray.getIndexIterator();
        while (dataIter.hasNext()) {
            float v = dataIter.getFloatNext();
            if (grid.isMissingData(v)) {
                v = minValue;
            }
            floatIter.setFloatNext(v);
        }
        return floatArray;
    }

    private ArrayByte replaceMissingValuesAndScale(GridDatatype grid, Array data) {
        MAMath.MinMax dataMinMax = grid.getMinMaxSkipMissingData(data);
        double scale = 254.0 / (dataMinMax.max - dataMinMax.min);
        ArrayByte byteArray = (ArrayByte)Array.factory(Byte.TYPE, data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator resultIter = byteArray.getIndexIterator();
        while (dataIter.hasNext()) {
            byte bv;
            double v = dataIter.getDoubleNext();
            if (grid.isMissingData(v)) {
                bv = 0;
            } else {
                int iv = (int)((v - dataMinMax.min) * scale + 1.0);
                bv = (byte)(iv & 0xFF);
            }
            resultIter.setByteNext(bv);
        }
        return byteArray;
    }

    private void addLatLonTags1() {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Geographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogGeodeticDatumGeoKey, GeoKey.TagValue.GeogGeodeticDatum6267));
    }

    private void addLatLonTags() {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Geographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogPrimeMeridianGeoKey, GeoKey.TagValue.GeogPrimeMeridian_GREENWICH));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
    }

    private void addPolarStereographicTags(Stereographic proj, double FalseEasting, double FalseNorthing) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Snyder"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_Stereographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCenterLongGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, 90.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addLambertConformalTags(LambertConformal proj, double FalseEasting, double FalseNorthing) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Snyder"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_LambertConfConic_2SP));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCenterLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addMercatorTags(Mercator proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Mercator"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_Mercator));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getParallel()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addTransverseMercatorTags(TransverseMercator proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Transvers Mercator"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_TransverseMercator));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getTangentLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, proj.getScale()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addAlbersEqualAreaTags(AlbersEqualArea proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Albers Conial Equal Area"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_AlbersConicalEqualArea));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void dump(Array data, int col) {
        int[] shape = data.getShape();
        Index ima = data.getIndex();
        for (int j = 0; j < shape[0]; ++j) {
            float dd = data.getFloat(ima.set(j, col));
            System.out.println(j + " value= " + dd);
        }
    }

    private double geoShiftGetXstart(Array lon, double inc) {
        boolean count = false;
        Index ilon = lon.getIndex();
        int[] lonShape = lon.getShape();
        IndexIterator lonIter = lon.getIndexIterator();
        double xlon = 0.0;
        LatLonPointImpl p0 = new LatLonPointImpl(0.0, lon.getFloat(ilon.set(0)));
        LatLonPointImpl pN = new LatLonPointImpl(0.0, lon.getFloat(ilon.set(lonShape[0] - 1)));
        xlon = p0.getLongitude();
        while (lonIter.hasNext()) {
            float l = lonIter.getFloatNext();
            LatLonPointImpl pn = new LatLonPointImpl(0.0, l);
            if (!(pn.getLongitude() < xlon)) continue;
            xlon = pn.getLongitude();
        }
        if (p0.getLongitude() == pN.getLongitude()) {
            xlon -= inc;
        }
        return xlon;
    }

    private Array geoShiftDataAtLon(Array data, Array lon) {
        int count = 0;
        int[] shape = data.getShape();
        Index ima = data.getIndex();
        Index ilon = lon.getIndex();
        int[] lonShape = lon.getShape();
        ArrayFloat adata = new ArrayFloat(new int[]{shape[0], shape[1]});
        Index imaa = adata.getIndex();
        IndexIterator lonIter = lon.getIndexIterator();
        LatLonPointImpl p0 = new LatLonPointImpl(0.0, lon.getFloat(ilon.set(lonShape[0] - 1)));
        LatLonPointImpl pN = new LatLonPointImpl(0.0, lon.getFloat(ilon.set(0)));
        while (lonIter.hasNext()) {
            float l = lonIter.getFloatNext();
            if (!((double)l > 180.0)) continue;
            ++count;
        }
        int spoint = 0;
        spoint = p0.getLongitude() == pN.getLongitude() ? shape[1] - count - 1 : shape[1] - count;
        if (count > 0 && shape[1] > count) {
            for (int j = 1; j < shape[1]; ++j) {
                int jj = 0;
                jj = j >= count ? j - count : j + spoint;
                for (int i = 0; i < shape[0]; ++i) {
                    float dd = data.getFloat(ima.set(i, jj));
                    adata.setFloat(imaa.set(i, j), dd);
                }
            }
            if (p0.getLongitude() == pN.getLongitude()) {
                for (int i = 0; i < shape[0]; ++i) {
                    float dd = adata.getFloat(imaa.set(i, shape[1] - 1));
                    adata.setFloat(imaa.set(i, 0), dd);
                }
            }
            return adata;
        }
        return data;
    }

    private Array geoShiftLon(Array lon) {
        int count = 0;
        Index lonIndex = lon.getIndex();
        int[] lonShape = lon.getShape();
        ArrayFloat slon = new ArrayFloat(new int[]{lonShape[0]});
        Index slonIndex = slon.getIndex();
        IndexIterator lonIter = lon.getIndexIterator();
        LatLonPointImpl llp = new LatLonPointImpl();
        LatLonPointImpl p0 = new LatLonPointImpl(0.0, lon.getFloat(lonIndex.set(lonShape[0] - 1)));
        LatLonPointImpl pN = new LatLonPointImpl(0.0, lon.getFloat(lonIndex.set(0)));
        while (lonIter.hasNext()) {
            float l = lonIter.getFloatNext();
            if (!((double)l > 180.0)) continue;
            ++count;
        }
        int spoint = 0;
        spoint = p0.getLongitude() == pN.getLongitude() ? lonShape[0] - count - 1 : lonShape[0] - count;
        if (count > 0 && lonShape[0] > count) {
            for (int j = 1; j < lonShape[0]; ++j) {
                int jj = 0;
                jj = j >= count ? j - count : j + spoint;
                float dd = lon.getFloat(lonIndex.set(jj));
                slon.setFloat(slonIndex.set(j), (float)LatLonPointImpl.lonNormal(dd));
            }
            if (p0.getLongitude() == pN.getLongitude()) {
                float dd = slon.getFloat(slonIndex.set(lonShape[0] - 1));
                slon.setFloat(slonIndex.set(0), -((float)LatLonPointImpl.lonNormal(dd)));
            }
            return slon;
        }
        return lon;
    }

    public static void main(String[] args) throws IOException {
        String fileOut = "/home/yuanho/Download/MODSCW_MercatorA.tif";
        LatLonPointImpl p1 = new LatLonPointImpl(16.99, -99.0);
        LatLonPointImpl p2 = new LatLonPointImpl(31.0, -78.0);
        LatLonRect llr = new LatLonRect(p1, p2);
        GeotiffWriter writer = new GeotiffWriter(fileOut);
        writer.writeGrid("/home/yuanho/Desktop/MODSCW_Mercator.nc", "chlorANOMALY", 0, 0, true, llr);
        writer.close();
        GeoTiff geotiff = new GeoTiff(fileOut);
        geotiff.read();
        System.out.println("geotiff read in = " + geotiff.showInfo());
        geotiff.close();
    }
}

