/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.Layout;

public class IndexChunker {
    private List<Dim> dimList = new ArrayList<Dim>();
    private Index chunkIndex;
    private Chunk chunk;
    private int nelems;
    private long start;
    private long total;
    private long done;
    private boolean debug = false;
    private boolean debugMerge = false;
    private boolean debugNext = false;

    public IndexChunker(int[] srcShape, Section wantSection) throws InvalidRangeException {
        Dim elem2;
        Dim elem;
        int i;
        wantSection = Section.fill(wantSection, srcShape);
        this.total = wantSection.computeSize();
        this.done = 0L;
        this.start = 0L;
        if (wantSection.equivalent(srcShape)) {
            this.nelems = (int)this.total;
            this.chunkIndex = Index.factory(new int[]{1});
            return;
        }
        int varRank = srcShape.length;
        int stride = 1;
        for (int ii = varRank - 1; ii >= 0; --ii) {
            this.dimList.add(new Dim(stride, srcShape[ii], wantSection.getRange(ii)));
            stride *= srcShape[ii];
        }
        if (this.debugMerge) {
            System.out.println("merge= " + this);
        }
        int merge = 0;
        for (i = 0; i < this.dimList.size() - 1; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            if (elem.maxSize != elem.wantSize || elem2.want.stride() != 1) break;
            ++merge;
        }
        for (i = 0; i < merge; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            elem2.maxSize *= elem.maxSize;
            elem2.wantSize *= elem.wantSize;
            if (!this.debugMerge) continue;
            System.out.println(" ----" + this);
        }
        for (i = 0; i < merge; ++i) {
            this.dimList.remove(0);
        }
        if (this.debug) {
            System.out.println(" final= " + this);
        }
        if (varRank == 0 || this.dimList.get((int)0).want.stride() > 1) {
            this.nelems = 1;
        } else {
            Dim innerDim = this.dimList.get(0);
            this.nelems = innerDim.wantSize;
            innerDim.wantSize = 1;
        }
        this.start = 0L;
        for (Dim dim : this.dimList) {
            this.start += (long)(dim.stride * dim.want.first());
        }
        int rank = this.dimList.size();
        int[] wstride = new int[rank];
        int[] shape = new int[rank];
        for (int i2 = 0; i2 < rank; ++i2) {
            Dim dim = this.dimList.get(i2);
            wstride[rank - i2 - 1] = dim.stride * dim.want.stride();
            shape[rank - i2 - 1] = dim.wantSize;
        }
        if (this.debug) {
            System.out.println("  elemsPerChunk=" + this.nelems + "  nchunks=" + Index.computeSize(shape));
            this.printa("  indexShape=", shape);
            this.printa("  indexStride=", wstride);
        }
        this.chunkIndex = new Index(shape, wstride);
        assert (Index.computeSize(shape) * (long)this.nelems == this.total);
        if (this.debug) {
            System.out.println("Index2= " + this);
            System.out.println(" start= " + this.start + " varShape= " + this.printa(srcShape) + " wantSection= " + wantSection);
        }
    }

    public long getTotalNelems() {
        return this.total;
    }

    public boolean hasNext() {
        return this.done < this.total;
    }

    public Chunk next() {
        if (this.chunk == null) {
            this.chunk = new Chunk(this.start, this.nelems, 0L);
        } else {
            this.chunkIndex.incr();
            this.chunk.incrDestElem(this.nelems);
        }
        this.chunk.setSrcElem(this.start + (long)this.chunkIndex.currentElement());
        if (this.debugNext) {
            System.out.println(" next chunk: " + this.chunk);
        }
        this.done += (long)this.nelems;
        return this.chunk;
    }

    protected String printa(int[] a) {
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            sbuff.append(a[i] + " ");
        }
        return sbuff.toString();
    }

    protected void printa(String name, int[] a) {
        System.out.print(name + "= ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i] + " ");
        }
        System.out.println();
    }

    public String toString() {
        Dim elem;
        int i;
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("wantSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.wantSize);
        }
        sbuff.append(" maxSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.maxSize);
        }
        sbuff.append(" wantStride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.want.stride());
        }
        sbuff.append(" stride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.stride);
        }
        return sbuff.toString();
    }

    public static class Chunk
    implements Layout.Chunk {
        private long srcElem;
        private int nelems;
        private long destElem;
        private long srcPos;

        public Chunk(long srcElem, int nelems, long destElem) {
            this.srcElem = srcElem;
            this.nelems = nelems;
            this.destElem = destElem;
        }

        public long getSrcElem() {
            return this.srcElem;
        }

        public void setSrcElem(long srcElem) {
            this.srcElem = srcElem;
        }

        public void incrSrcElem(int incr) {
            this.srcElem += (long)incr;
        }

        public int getNelems() {
            return this.nelems;
        }

        public void setNelems(int nelems) {
            this.nelems = nelems;
        }

        public long getDestElem() {
            return this.destElem;
        }

        public void setDestElem(long destElem) {
            this.destElem = destElem;
        }

        public void incrDestElem(int incr) {
            this.destElem += (long)incr;
        }

        public String toString() {
            return " srcPos=" + this.srcPos + " srcElem=" + this.srcElem + " nelems=" + this.nelems + " destElem=" + this.destElem;
        }

        public long getSrcPos() {
            return this.srcPos;
        }

        public void setSrcPos(long srcPos) {
            this.srcPos = srcPos;
        }

        public void incrSrcPos(int incr) {
            this.srcPos += (long)incr;
        }
    }

    private class Dim {
        int stride;
        int maxSize;
        Range want;
        int wantSize;

        Dim(int byteStride, int maxSize, Range want) {
            this.stride = byteStride;
            this.maxSize = maxSize;
            this.wantSize = want.length();
            this.want = want;
        }
    }
}

