/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.BufrIndicatorSection;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrReadMnemonic;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableA;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.iosp.bufr.tables.TableDataSubcategories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableLookup {
    private static Logger log = LoggerFactory.getLogger(TableLookup.class);
    private static TableA tablelookup;
    private static TableA wmoTableA;
    private static TableB wmoTableB;
    private static TableD wmoTableD;
    private static String wmoTableName;
    private static final boolean showErrors = false;
    private final String localTableName;
    private TableB localTableB;
    private TableD localTableD;
    public Mode mode = Mode.wmoOnly;

    public TableLookup(BufrIndicatorSection is, BufrIdentificationSection ids) throws IOException {
        this.localTableName = tablelookup.getCategory(this.makeLookupKey(ids.getCategory(), ids.getCenterId()));
        if (this.localTableName == null) {
            this.localTableB = wmoTableB;
            this.localTableD = wmoTableD;
            return;
        }
        if (this.localTableName.contains("-ABD")) {
            this.localTableB = BufrTables.getTableB(this.localTableName.replace("-ABD", "-B"));
            this.localTableD = BufrTables.getTableD(this.localTableName.replace("-ABD", "-D"));
            return;
        }
        if (BufrTables.hasTableB(this.localTableName)) {
            this.localTableB = BufrTables.getTableB(this.localTableName);
            this.localTableD = BufrTables.getTableD(this.localTableName);
            return;
        }
        BufrReadMnemonic brm = new BufrReadMnemonic();
        brm.readMnemonic(this.localTableName);
        this.localTableB = brm.getTableB();
        this.localTableD = brm.getTableD();
    }

    private short makeLookupKey(int cat, int center_id) {
        if (center_id == 7 || center_id == 8 || center_id == 9) {
            if (cat < 240 || cat > 254) {
                return (short)center_id;
            }
            return (short)(center_id * 1000 + cat);
        }
        return (short)center_id;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getDataCategory(int cat) {
        return wmoTableA.getDataCategory((short)cat);
    }

    public String getSubCategory(int cat, int subCat) {
        return TableDataSubcategories.getSubCategory(cat, subCat);
    }

    public final String getWmoTableName() {
        return wmoTableName;
    }

    public final String getLocalTableName() {
        return this.localTableName;
    }

    public TableB.Descriptor getDescriptorTableB(short fxy) {
        TableB.Descriptor b = null;
        boolean isWmoRange = Descriptor.isWmoRange(fxy);
        if (isWmoRange && this.mode.equals((Object)Mode.wmoOnly)) {
            b = wmoTableB.getDescriptor(fxy);
        } else if (isWmoRange && this.mode.equals((Object)Mode.wmoLocal)) {
            b = wmoTableB.getDescriptor(fxy);
            if (b == null) {
                b = this.localTableB.getDescriptor(fxy);
            }
        } else if (isWmoRange && this.mode.equals((Object)Mode.localOverride)) {
            if (this.localTableB != null) {
                b = this.localTableB.getDescriptor(fxy);
            }
            if (b == null) {
                b = wmoTableB.getDescriptor(fxy);
            }
        } else if (this.localTableB != null) {
            b = this.localTableB.getDescriptor(fxy);
        }
        if (b == null) {
            // empty if block
        }
        return b;
    }

    public List<Short> getDescriptorsTableD(short id) {
        TableD.Descriptor d = this.getDescriptorTableD(id);
        if (d != null) {
            return d.getSequence();
        }
        return null;
    }

    public List<String> getDescriptorsTableD(String fxy) {
        short id = Descriptor.getFxy(fxy);
        List<Short> seq = this.getDescriptorsTableD(id);
        if (seq == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(seq.size());
        for (Short s : seq) {
            result.add(Descriptor.makeString(s));
        }
        return result;
    }

    public TableD.Descriptor getDescriptorTableD(short fxy) {
        TableD.Descriptor d = null;
        boolean isWmoRange = Descriptor.isWmoRange(fxy);
        if (isWmoRange && this.mode.equals((Object)Mode.wmoOnly)) {
            d = wmoTableD.getDescriptor(fxy);
        } else if (isWmoRange && this.mode.equals((Object)Mode.wmoLocal)) {
            d = wmoTableD.getDescriptor(fxy);
            if (d == null) {
                d = this.localTableD.getDescriptor(fxy);
            }
        } else if (isWmoRange && this.mode.equals((Object)Mode.localOverride)) {
            if (this.localTableD != null) {
                d = this.localTableD.getDescriptor(fxy);
            }
            if (d == null) {
                d = wmoTableD.getDescriptor(fxy);
            }
        } else if (this.localTableD != null) {
            d = this.localTableD.getDescriptor(fxy);
        }
        if (d == null) {
            // empty if block
        }
        return d;
    }

    static {
        try {
            tablelookup = BufrTables.getTableA("tablelookup.txt");
            wmoTableName = tablelookup.getDataCategory((short)0);
            wmoTableA = BufrTables.getTableA(wmoTableName + "-A");
            wmoTableB = BufrTables.getTableB(wmoTableName + "-B");
            wmoTableD = BufrTables.getTableD(wmoTableName + "-D");
        }
        catch (IOException ioe) {
            log.error("Filed to read BUFR table ", ioe);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        wmoOnly,
        wmoLocal,
        localOverride;

    }
}

