/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import ucar.grid.GridParameter;
import ucar.unidata.util.StringUtil;

public class GempakParameter
extends GridParameter {
    private int decimalScale = 0;

    public GempakParameter(int number, String name, String description, String unit, int scale) {
        super(number, name, description, unit);
        this.decimalScale = scale;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("GridParameter: ");
        buf.append(StringUtil.padLeft(String.valueOf(this.getNumber()), 4));
        buf.append(" ");
        String param = this.getName() + " (" + this.getDescription() + ")";
        buf.append(StringUtil.padRight(param, 40));
        buf.append(" [");
        buf.append(this.getUnit());
        buf.append("]");
        buf.append(" scale: ");
        buf.append(this.getDecimalScale());
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GempakParameter)) {
            return false;
        }
        GempakParameter that = (GempakParameter)o;
        return super.equals(that) && this.decimalScale == that.decimalScale;
    }

    public int hashCode() {
        return super.hashCode() + 17 * this.decimalScale;
    }
}

