/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil;

public class GempakStation
implements Station {
    public static final String STID = "STID";
    public static final String STNM = "STNM";
    public static final String SLAT = "SLAT";
    public static final String SLON = "SLON";
    public static final String SELV = "SELV";
    public static final String STAT = "STAT";
    public static final String COUN = "COUN";
    public static final String STD2 = "STD2";
    public static final String SPRI = "SPRI";
    public static final String SWFO = "SWFO";
    public static final String WFO2 = "WFO2";
    private String stid = "";
    private String std2 = "";
    private int stnm = -9999;
    private String stat = "";
    private String coun = "";
    private String swfo = "";
    private String wfo2 = "";
    private int slat = -9999;
    private int slon = -9999;
    private int selv = -9999;
    private int spri;
    private String sdesc = "";

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtil.padRight(this.stid.trim() + this.std2.trim(), 8));
        builder.append(" ");
        builder.append(Format.i(this.stnm, 6));
        builder.append(" ");
        builder.append(StringUtil.padRight(this.sdesc, 32));
        builder.append(" ");
        builder.append(StringUtil.padLeft(this.stat.trim(), 2));
        builder.append(" ");
        builder.append(StringUtil.padLeft(this.coun.trim(), 2));
        builder.append(" ");
        builder.append(Format.i(this.slat, 5));
        builder.append(" ");
        builder.append(Format.i(this.slon, 6));
        builder.append(" ");
        builder.append(Format.i(this.selv, 5));
        builder.append(" ");
        builder.append(Format.i(this.spri, 2));
        builder.append(" ");
        builder.append(StringUtil.padLeft(this.swfo.trim(), 3));
        return builder.toString();
    }

    public void setSTID(String value) {
        this.stid = value;
    }

    public String getSTID() {
        return this.stid;
    }

    public void setSTNM(int value) {
        this.stnm = value;
    }

    public int getSTNM() {
        return this.stnm;
    }

    public void setSTAT(String value) {
        this.stat = value;
    }

    public String getSTAT() {
        return this.stat;
    }

    public void setCOUN(String value) {
        this.coun = value;
    }

    public String getCOUN() {
        return this.coun;
    }

    public void setSTD2(String value) {
        this.std2 = value;
    }

    public String getSTD2() {
        return this.std2;
    }

    public void setSWFO(String value) {
        this.swfo = value;
    }

    public String getSWFO() {
        return this.swfo;
    }

    public void setWFO2(String value) {
        this.wfo2 = value;
    }

    public String getWFO2() {
        return this.wfo2;
    }

    public void setSLAT(int value) {
        this.slat = value;
    }

    public int getSLAT() {
        return this.slat;
    }

    public void setSLON(int value) {
        this.slon = value;
    }

    public int getSLON() {
        return this.slon;
    }

    public void setSELV(int value) {
        this.selv = value;
    }

    public int getSELV() {
        return this.selv;
    }

    public void setSPRI(int value) {
        this.spri = value;
    }

    public int getSPRI() {
        return this.spri;
    }

    public double getLatitude() {
        return (double)this.slat / 100.0;
    }

    public double getLongitude() {
        return (double)this.slon / 100.0;
    }

    public double getAltitude() {
        return this.selv;
    }

    public String getName() {
        return this.stid;
    }

    public String getDescription() {
        return this.sdesc;
    }

    public void setDescription(String desc) {
        this.sdesc = desc;
    }

    public String getWmoId() {
        return String.valueOf(this.stnm);
    }

    public int compareTo(Station o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean isMissing() {
        return this.slat == -9999 || this.slon == -9999;
    }

    public LatLonPoint getLatLon() {
        return new LatLonPointImpl(this.getLatitude(), this.getLongitude());
    }
}

