/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.GribReadIndex;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Record;
import ucar.grib.grib1.Grib1WriteIndex;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Record;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;

public class GribGridServiceProvider
extends GridServiceProvider {
    private static Logger log = LoggerFactory.getLogger(GribGridServiceProvider.class);
    private static boolean alwaysInCache = false;
    private long rafLength;
    private long rafLastModified;
    private int edition = 0;
    private String saveLocation;
    private Grib1Data dataReaderGrib1;
    private Grib2Data dataReaderGrib2;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            raf.order(0);
            Grib2Input g2i = new Grib2Input(raf);
            int edition = g2i.getEdition();
            return edition == 1 || edition == 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        GridIndex index;
        Map<String, String> attr;
        this.raf = raf;
        this.ncfile = ncfile;
        this.rafLength = raf.length();
        long start = System.currentTimeMillis();
        if (GridServiceProvider.debugOpen) {
            System.out.println("GribGridServiceProvider open = " + ncfile.getLocation());
        }
        this.edition = (attr = (index = this.getIndex(raf.getLocation())).getGlobalAttributes()).get("grid_edition").equals("2") ? 2 : 1;
        GridTableLookup lookup = this.edition == 2 ? this.getLookup2() : this.getLookup1();
        new GridIndexToNC().open(index, lookup, this.edition, ncfile, this.fmrcCoordSys, cancelTask);
        ncfile.finish();
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println(" open " + ncfile.getLocation() + " took=" + took + " msec ");
        }
        log.debug("GridServiceProvider.open " + ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
    }

    public void open(GridIndex index, CancelTask cancelTask) {
    }

    protected GridTableLookup getLookup2() throws IOException {
        Grib2Record firstRecord = null;
        try {
            Grib2Input g2i = new Grib2Input(this.raf);
            long start2 = System.currentTimeMillis();
            this.raf.seek(0L);
            g2i.scan(false, true);
            List<Grib2Record> records = g2i.getRecords();
            firstRecord = records.get(0);
            if (debugTiming) {
                long took = System.currentTimeMillis() - start2;
                System.out.println("  read one record took=" + took + " msec ");
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        Grib2GridTableLookup lookup = new Grib2GridTableLookup(firstRecord);
        this.dataReaderGrib2 = new Grib2Data(this.raf);
        return lookup;
    }

    protected GridTableLookup getLookup1() throws IOException {
        Grib1Record firstRecord = null;
        try {
            Grib1Input g1i = new Grib1Input(this.raf);
            long start2 = System.currentTimeMillis();
            this.raf.seek(0L);
            g1i.scan(false, true);
            ArrayList records = g1i.getRecords();
            firstRecord = (Grib1Record)records.get(0);
            if (debugTiming) {
                long took = System.currentTimeMillis() - start2;
                System.out.println("  read one record took=" + took + " msec ");
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        catch (NoValidGribException noValid) {
            System.err.println("NoValidGribException : " + noValid);
        }
        Grib1GridTableLookup lookup = new Grib1GridTableLookup(firstRecord);
        this.dataReaderGrib1 = new Grib1Data(this.raf);
        return lookup;
    }

    protected GridIndex getIndex(String location) throws IOException {
        File indexFile;
        this.saveLocation = location;
        String indexLocation = location + ".gbx";
        GridIndex index = null;
        if (indexLocation.startsWith("http:")) {
            index = new GribReadIndex().open(indexLocation);
            if (index == null) {
                log.debug("opened HTTP index = " + indexLocation);
                return index;
            }
            indexFile = DiskCache.getCacheFile(indexLocation);
            log.debug("HTTP index = " + indexFile.getPath());
        } else {
            indexFile = new File(indexLocation);
            if (!indexFile.exists()) {
                log.debug("saveIndexFile not exist " + indexFile.getPath() + " ++ " + indexLocation);
                indexFile = DiskCache.getFile(indexLocation, alwaysInCache);
                log.debug("GribServiceProvider: use " + indexFile.getPath());
            }
        }
        if (indexFile.exists()) {
            try {
                index = new GribReadIndex().open(indexFile.getPath());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (index != null) {
                log.debug("  opened index = " + indexFile.getPath());
            } else {
                log.debug("  write index = " + indexFile.getPath());
                index = this.writeIndex(indexFile, this.raf);
            }
        } else {
            log.debug("  write index = " + indexFile.getPath());
            index = this.writeIndex(indexFile, this.raf);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GridIndex writeIndex(File indexFile, RandomAccessFile raf) throws IOException {
        GridIndex gridIndex;
        GridIndex index = null;
        FilterOutputStream out = null;
        try {
            if (indexFile.exists()) {
                indexFile.delete();
                log.debug("Delete old index " + indexFile);
            }
            raf.seek(0L);
            Grib2Input g2i = new Grib2Input(raf);
            int edition = g2i.getEdition();
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile.getPath(), false)));
            if (edition == 1) {
                index = new Grib1WriteIndex().writeFileIndex(raf, (DataOutputStream)out, true);
            } else if (edition == 2) {
                // empty if block
            }
            gridIndex = index;
            Object var9_9 = null;
            if (out == null) return gridIndex;
        }
        catch (NotSupportedException noSupport) {
            try {
                System.err.println("NotSupportedException : " + noSupport);
                Object var9_10 = null;
                if (out == null) return index;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
            return index;
        }
        out.close();
        return gridIndex;
    }

    protected float[] _readData(GridRecord gr) throws IOException {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (this.edition == 2) {
            return this.dataReaderGrib2.getData(ggr.offset1, ggr.offset2);
        }
        return this.dataReaderGrib1.getData(ggr.offset1, ggr.decimalScale, ggr.bmsExists);
    }
}

