/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.Index;
import ucar.grib.TableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GribTimeCoord {
    private static Logger log = LoggerFactory.getLogger(GribTimeCoord.class);
    private DateFormatter formatter = new DateFormatter();
    private Calendar calendar;
    private String name;
    private TableLookup lookup;
    private List<Date> times = new ArrayList<Date>();
    private int seq = 0;

    GribTimeCoord() {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    GribTimeCoord(List<Index.GribRecord> records, TableLookup lookup) {
        this();
        this.lookup = lookup;
        this.addTimes(records);
        Collections.sort(this.times);
    }

    GribTimeCoord(String name, double[] offsetHours, TableLookup lookup) {
        this();
        DateUnit convertUnit;
        this.name = name;
        this.lookup = lookup;
        Date baseTime = lookup.getFirstBaseTime();
        String refDate = this.formatter.toDateTimeStringISO(baseTime);
        try {
            convertUnit = new DateUnit("hours since " + refDate);
        }
        catch (Exception e) {
            log.error("TimeCoord not added, cant make DateUnit from String 'hours since " + refDate + "'", e);
            return;
        }
        this.times = new ArrayList<Date>(offsetHours.length);
        for (double offsetHour : offsetHours) {
            this.times.add(convertUnit.makeDate(offsetHour));
        }
    }

    void addTimes(List<Index.GribRecord> records) {
        for (Index.GribRecord record : records) {
            Date validTime = this.getValidTime(record, this.lookup);
            if (this.times.contains(validTime)) continue;
            this.times.add(validTime);
        }
    }

    boolean matchLevels(List<Index.GribRecord> records) {
        ArrayList<Date> timeList = new ArrayList<Date>(records.size());
        for (Index.GribRecord record : records) {
            Date validTime = this.getValidTime(record, this.lookup);
            if (timeList.contains(validTime)) continue;
            timeList.add(validTime);
        }
        Collections.sort(timeList);
        boolean isEqual = ((Object)timeList).equals(this.times);
        return isEqual;
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.seq == 0 ? "time" : "time" + this.seq;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        Collections.sort(this.times);
        ncfile.addDimension(g, new Dimension(this.getName(), this.getNTimes()));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        DateUnit dateUnit;
        Variable v = new Variable(ncfile, g, null, this.getName());
        v.setDataType(DataType.INT);
        v.addAttribute(new Attribute("long_name", "forecast time"));
        int ntimes = this.getNTimes();
        int[] data = new int[ntimes];
        Date baseTime = this.lookup.getFirstBaseTime();
        String timeUnit = this.lookup.getFirstTimeRangeUnitName();
        String refDate = this.formatter.toDateTimeStringISO(baseTime);
        try {
            dateUnit = new DateUnit(timeUnit + " since " + refDate);
        }
        catch (Exception e) {
            log.error("TimeCoord not added, cant make DateUnit from String '" + timeUnit + " since " + refDate + "'", e);
            return;
        }
        for (int i = 0; i < this.times.size(); ++i) {
            Date validTime = this.times.get(i);
            data[i] = (int)dateUnit.makeValue(validTime);
        }
        Array dataArray = Array.factory(DataType.INT, new int[]{ntimes}, (Object)data);
        v.setDimensions(v.getShortName());
        v.setCachedData(dataArray, false);
        Date d = this.lookup.getFirstBaseTime();
        v.addAttribute(new Attribute("units", timeUnit + " since " + refDate));
        v.addAttribute(new Attribute("GRIB_orgReferenceTime", this.formatter.toDateTimeStringISO(d)));
        v.addAttribute(new Attribute("GRIB2_significanceOfRTName", this.lookup.getFirstSignificanceOfRTName()));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ncfile.addVariable(g, v);
    }

    int getIndex(Index.GribRecord record) {
        Date validTime = this.getValidTime(record, this.lookup);
        return this.times.indexOf(validTime);
    }

    Date getValidTime(Index.GribRecord record) {
        return this.getValidTime(record, this.lookup);
    }

    int getNTimes() {
        return this.times.size();
    }

    private Date getValidTime(Index.GribRecord record, TableLookup lookup) {
        Date validTime = record.getValidTime();
        if (validTime != null) {
            return validTime;
        }
        try {
            validTime = record.refTime;
        }
        catch (Throwable e) {
            log.error("getValidTime(" + record.refTime + ")", e);
            return null;
        }
        int calendar_unit = 10;
        int factor = 1;
        String timeUnit = lookup.getFirstTimeRangeUnitName();
        if (timeUnit.equalsIgnoreCase("hour") || timeUnit.equalsIgnoreCase("hours")) {
            factor = 1;
        } else if (timeUnit.equalsIgnoreCase("minutes") || timeUnit.equalsIgnoreCase("minute")) {
            calendar_unit = 12;
        } else if (timeUnit.equalsIgnoreCase("second") || timeUnit.equalsIgnoreCase("secs")) {
            calendar_unit = 13;
        } else if (timeUnit.equalsIgnoreCase("day") || timeUnit.equalsIgnoreCase("days")) {
            factor = 24;
        } else if (timeUnit.equalsIgnoreCase("month") || timeUnit.equalsIgnoreCase("months")) {
            factor = 720;
        } else if (timeUnit.equalsIgnoreCase("year") || timeUnit.equalsIgnoreCase("years") || timeUnit.equalsIgnoreCase("1year")) {
            factor = 8760;
        } else if (timeUnit.equalsIgnoreCase("decade")) {
            factor = 87600;
        } else if (timeUnit.equalsIgnoreCase("century")) {
            factor = 876000;
        } else if (timeUnit.equalsIgnoreCase("3hours")) {
            factor = 3;
        } else if (timeUnit.equalsIgnoreCase("6hours")) {
            factor = 6;
        } else if (timeUnit.equalsIgnoreCase("12hours")) {
            factor = 6;
        }
        this.calendar.setTime(validTime);
        this.calendar.add(calendar_unit, factor * record.forecastTime);
        validTime = this.calendar.getTime();
        record.setValidTime(validTime);
        return validTime;
    }
}

