/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import ucar.grid.GridDefRecord;
import ucar.grid.GridTableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Orthographic;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.util.GaussianLatitudes;
import ucar.unidata.util.StringUtil;

public class GridHorizCoordSys {
    private GridTableLookup lookup;
    private GridDefRecord gdsIndex;
    private Group g;
    private String grid_name;
    private String shape_name;
    private String id;
    private boolean isLatLon = true;
    private boolean isGaussian = false;
    HashMap varHash = new HashMap(200);
    HashMap productHash = new HashMap(100);
    HashMap vcsHash = new HashMap(30);
    private double startx;
    private double starty;
    private ProjectionImpl proj;
    private ArrayList attributes = new ArrayList();

    GridHorizCoordSys(GridDefRecord gdsIndex, GridTableLookup lookup, Group g) {
        this.gdsIndex = gdsIndex;
        this.lookup = lookup;
        this.g = g;
        this.grid_name = AbstractIOServiceProvider.createValidNetcdfObjectName(lookup.getGridName(gdsIndex));
        this.shape_name = lookup.getShapeName(gdsIndex);
        this.g = g;
        this.isLatLon = lookup.isLatLon(gdsIndex);
        this.grid_name = StringUtil.replace(this.grid_name, ' ', "_");
        String string = this.id = g == null ? this.grid_name : g.getName();
        if (this.isLatLon && lookup.getProjectionType(gdsIndex) == 8) {
            this.isGaussian = true;
            double np = 90.0;
            String nps = this.getParamString("Np");
            if (null != nps) {
                np = Double.parseDouble(nps);
            }
            gdsIndex.addParam("Dx", String.valueOf(np));
        }
    }

    String getID() {
        return this.id;
    }

    String getGridName() {
        return this.grid_name;
    }

    Group getGroup() {
        return this.g;
    }

    boolean isLatLon() {
        return this.isLatLon;
    }

    int getNx() {
        return (int)this.getParamValue("Nx");
    }

    int getNy() {
        return (int)this.getParamValue("Ny");
    }

    private double getDxInKm() {
        return this.getParamValue("Dx") * 0.001;
    }

    private double getDyInKm() {
        return this.getParamValue("Dy") * 0.001;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile) {
        if (this.isLatLon) {
            ncfile.addDimension(this.g, new Dimension("lat", (int)this.getParamValue("Ny"), true));
            ncfile.addDimension(this.g, new Dimension("lon", (int)this.getParamValue("Nx"), true));
        } else {
            ncfile.addDimension(this.g, new Dimension("y", (int)this.getParamValue("Ny"), true));
            ncfile.addDimension(this.g, new Dimension("x", (int)this.getParamValue("Nx"), true));
        }
    }

    void addToNetcdfFile(NetcdfFile ncfile) {
        if (this.isLatLon) {
            double dy;
            double d = this.getParamValue("La2") < this.getParamValue("La1") ? -this.getParamValue("Dy") : (dy = this.getParamValue("Dy"));
            if (this.isGaussian) {
                this.addGaussianLatAxis(ncfile, "lat", "degrees_north", "latitude coordinate", "latitude", AxisType.Lat);
            } else {
                this.addCoordAxis(ncfile, "lat", (int)this.getParamValue("Ny"), this.getParamValue("La1"), dy, "degrees_north", "latitude coordinate", "latitude", AxisType.Lat);
            }
            this.addCoordAxis(ncfile, "lon", (int)this.getParamValue("Nx"), this.getParamValue("Lo1"), this.getParamValue("Dx"), "degrees_east", "longitude coordinate", "longitude", AxisType.Lon);
            this.addCoordSystemVariable(ncfile, "latLonCoordSys", "time lat lon");
        } else {
            this.makeProjection(ncfile);
            double[] yData = this.addCoordAxis(ncfile, "y", (int)this.getParamValue("Ny"), this.starty, this.getDyInKm(), "km", "y coordinate of projection", "projection_y_coordinate", AxisType.GeoY);
            double[] dArray = this.addCoordAxis(ncfile, "x", (int)this.getParamValue("Nx"), this.startx, this.getDxInKm(), "km", "x coordinate of projection", "projection_x_coordinate", AxisType.GeoX);
        }
    }

    private double[] addCoordAxis(NetcdfFile ncfile, String name, int n, double start, double incr, String units, String desc, String standard_name, AxisType axis) {
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = start + incr * (double)i;
        }
        Array dataArray = Array.factory(DataType.DOUBLE, new int[]{n}, (Object)data);
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("standard_name", standard_name));
        v.addAttribute(new Attribute("grid_spacing", incr + " " + units));
        v.addAttribute(new Attribute("_CoordinateAxisType", axis.toString()));
        ncfile.addVariable(this.g, v);
        return data;
    }

    private double[] addGaussianLatAxis(NetcdfFile ncfile, String name, String units, String desc, String standard_name, AxisType axis) {
        double np = this.getParamValue("NumberParallels");
        if (Double.isNaN(np)) {
            np = this.getParamValue("Np");
        }
        if (Double.isNaN(np)) {
            throw new IllegalArgumentException("Gaussian LAt/Lon grid must have NumberParallels parameter");
        }
        double startLat = this.getParamValue("La1");
        double endLat = this.getParamValue("La2");
        int nlats = (int)(2.0 * np);
        GaussianLatitudes gaussLats = new GaussianLatitudes(nlats);
        int bestStartIndex = 0;
        int bestEndIndex = 0;
        double bestStartDiff = Double.MAX_VALUE;
        double bestEndDiff = Double.MAX_VALUE;
        for (int i = 0; i < nlats; ++i) {
            double diff = Math.abs(gaussLats.latd[i] - startLat);
            if (diff < bestStartDiff) {
                bestStartDiff = diff;
                bestStartIndex = i;
            }
            if (!((diff = Math.abs(gaussLats.latd[i] - endLat)) < bestEndDiff)) continue;
            bestEndDiff = diff;
            bestEndIndex = i;
        }
        assert ((double)Math.abs(bestEndIndex - bestStartIndex + 1) == this.getParamValue("Ny"));
        boolean goesUp = bestEndIndex > bestStartIndex;
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        int n = (int)this.getParamValue("Ny");
        int useIndex = bestStartIndex;
        double[] data = new double[n];
        double[] gaussw = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = gaussLats.latd[useIndex];
            gaussw[i] = gaussLats.gaussw[useIndex];
            if (goesUp) {
                ++useIndex;
                continue;
            }
            --useIndex;
        }
        Array dataArray = Array.factory(DataType.DOUBLE, new int[]{n}, (Object)data);
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("standard_name", standard_name));
        v.addAttribute(new Attribute("weights", "gaussw"));
        v.addAttribute(new Attribute("_CoordinateAxisType", axis.toString()));
        ncfile.addVariable(this.g, v);
        v = new Variable(ncfile, this.g, null, "gaussw");
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        v.addAttribute(new Attribute("long_name", "gaussian weights (unnormalized)"));
        dataArray = Array.factory(DataType.DOUBLE, new int[]{n}, (Object)gaussw);
        v.setCachedData(dataArray, false);
        ncfile.addVariable(this.g, v);
        return data;
    }

    private void addLatLon2D(NetcdfFile ncfile, double[] xData, double[] yData) {
        Variable latVar = new Variable(ncfile, this.g, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions("y x");
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, this.g, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions("y x");
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                this.proj.projToLatLon(projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        ncfile.addVariable(this.g, latVar);
        ncfile.addVariable(this.g, lonVar);
    }

    private void makeProjection(NetcdfFile ncfile) {
        switch (this.lookup.getProjectionType(this.gdsIndex)) {
            case 1: {
                this.makePS();
                break;
            }
            case 2: {
                this.makeLC();
                break;
            }
            case 3: {
                this.makeMercator();
                break;
            }
            case 7: {
                this.makeSpaceViewOrOthographic();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown projection = " + this.getParamValue("grid_type"));
            }
        }
        Variable v = new Variable(ncfile, this.g, null, this.grid_name);
        v.setDataType(DataType.CHAR);
        v.setDimensions(new ArrayList<Dimension>());
        char[] data = new char[]{'d'};
        Array dataArray = Array.factory(DataType.CHAR, new int[0], (Object)data);
        v.setCachedData(dataArray, false);
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute att = (Attribute)this.attributes.get(i);
            v.addAttribute(att);
        }
        v.addAttribute(new Attribute("earth_shape", this.shape_name));
        if (this.getParamValue("grid_shape_code") == 1.0) {
            v.addAttribute(new Attribute("spherical_earth_radius_meters", new Double(this.getParamValue("radius_spherical_earth"))));
        }
        this.addGDSparams(v);
        ncfile.addVariable(this.g, v);
    }

    private void addGDSparams(Variable v) {
        Set keys = this.gdsIndex.getKeys();
        ArrayList keyList = new ArrayList(keys);
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            String name = AbstractIOServiceProvider.createValidNetcdfObjectName("GridDefRecord_param_" + key);
            String vals = this.getParamString(key);
            try {
                int vali = Integer.parseInt(vals);
                v.addAttribute(new Attribute(name, new Integer(vali)));
                continue;
            }
            catch (Exception e) {
                try {
                    double vald = Double.parseDouble(vals);
                    v.addAttribute(new Attribute(name, new Double(vald)));
                    continue;
                }
                catch (Exception e2) {
                    v.addAttribute(new Attribute(name, vals));
                }
            }
        }
    }

    private void addCoordSystemVariable(NetcdfFile ncfile, String name, String dims) {
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.CHAR);
        v.setDimensions(new ArrayList<Dimension>());
        Array dataArray = Array.factory(DataType.CHAR, new int[0], (Object)new char[]{'0'});
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("_CoordinateAxes", dims));
        if (!this.isLatLon()) {
            v.addAttribute(new Attribute("_CoordinateTransforms", this.getGridName()));
        }
        this.addGDSparams(v);
        ncfile.addVariable(this.g, v);
    }

    private void makeLC() {
        this.proj = new LambertConformal(this.getParamValue("Latin1"), this.getParamValue("LoV"), this.getParamValue("Latin1"), this.getParamValue("Latin2"));
        LatLonPointImpl startLL = new LatLonPointImpl(this.getParamValue("La1"), this.getParamValue("Lo1"));
        ProjectionPointImpl start = (ProjectionPointImpl)this.proj.latLonToProj(startLL);
        this.startx = start.getX();
        this.starty = start.getY();
        if (Double.isNaN(this.getDxInKm())) {
            this.setDxDy(this.startx, this.starty, this.proj);
        }
        if (GridServiceProvider.debugProj) {
            System.out.println("GridHorizCoordSys.makeLC start at latlon " + startLL);
            double Lo2 = this.gdsIndex.readDouble("Lo2");
            double La2 = this.gdsIndex.readDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GridHorizCoordSys.makeLC end at latlon " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj(endLL);
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)this.getNx() * this.getDxInKm();
            double endy = this.starty + (double)this.getNy() * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
        this.attributes.add(new Attribute("grid_mapping_name", "lambert_conformal_conic"));
        if (this.getParamValue("Latin1") == this.getParamValue("Latin2")) {
            this.attributes.add(new Attribute("standard_parallel", new Double(this.getParamValue("Latin1"))));
        } else {
            double[] dArray = new double[2];
            dArray[0] = this.getParamValue("Latin1");
            dArray[1] = this.getParamValue("Latin2");
            double[] data = dArray;
            this.attributes.add(new Attribute("standard_parallel", Array.factory(DataType.DOUBLE, new int[]{2}, (Object)data)));
        }
        this.attributes.add(new Attribute("longitude_of_central_meridian", new Double(this.getParamValue("LoV"))));
        this.attributes.add(new Attribute("latitude_of_projection_origin", new Double(this.getParamValue("Latin1"))));
    }

    private void makePS() {
        double scale = 0.933;
        double latOrigin = 90.0;
        String s = this.getParamString("NpProj");
        if (s != null && !s.equalsIgnoreCase("true")) {
            latOrigin = -90.0;
        }
        this.proj = new Stereographic(latOrigin, this.getParamValue("LoV"), scale);
        ProjectionPointImpl start = (ProjectionPointImpl)this.proj.latLonToProj(new LatLonPointImpl(this.getParamValue("La1"), this.getParamValue("Lo1")));
        this.startx = start.getX();
        this.starty = start.getY();
        if (Double.isNaN(this.getDxInKm())) {
            this.setDxDy(this.startx, this.starty, this.proj);
        }
        if (GridServiceProvider.debugProj) {
            System.out.println("start at proj coord " + start);
            LatLonPoint llpt = this.proj.projToLatLon(start);
            System.out.println("   end at lat/lon coord " + llpt);
            System.out.println("   should be lat=" + this.getParamValue("La1") + " lon=" + this.getParamValue("Lo1"));
        }
        this.attributes.add(new Attribute("grid_mapping_name", "polar_stereographic"));
        this.attributes.add(new Attribute("longitude_of_projection_origin", new Double(this.getParamValue("LoV"))));
        this.attributes.add(new Attribute("scale_factor_at_projection_origin", new Double(scale)));
        this.attributes.add(new Attribute("latitude_of_projection_origin", new Double(latOrigin)));
    }

    private void makeMercator() {
        double Latin = this.gdsIndex.readDouble("Latin");
        double Lo1 = this.getParamValue("Lo1");
        double La1 = this.getParamValue("La1");
        this.proj = new Mercator(Lo1, Latin);
        ProjectionPoint startP = this.proj.latLonToProj(new LatLonPointImpl(La1, Lo1));
        this.startx = startP.getX();
        this.starty = startP.getY();
        this.attributes.add(new Attribute("grid_mapping_name", "mercator"));
        this.attributes.add(new Attribute("standard_parallel", Latin));
        this.attributes.add(new Attribute("longitude_of_projection_origin", Lo1));
        if (GridServiceProvider.debugProj) {
            double Lo2 = this.getParamValue("Lo2");
            if (Lo2 < Lo2) {
                Lo2 += 360.0;
            }
            double La2 = this.getParamValue("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GribHorizCoordSys.makeMercator:   end at latlon= " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj(endLL);
            System.out.println("   start at proj coord " + new ProjectionPointImpl(this.startx, this.starty));
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)(this.getNx() - 1) * this.getDxInKm();
            double endy = this.starty + (double)(this.getNy() - 1) * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
    }

    private void makeSpaceViewOrOthographic() {
        double Lat0 = this.getParamValue("Lap");
        double Lon0 = this.getParamValue("Lop");
        double xp = this.getParamValue("Xp");
        double yp = this.getParamValue("Yp");
        double dx = this.getParamValue("Dx");
        double dy = this.getParamValue("Dy");
        double major_axis = this.getParamValue("major_axis_earth");
        double minor_axis = this.getParamValue("minor_axis_earth");
        double nr = this.getParamValue("Nr") * 1.0E-6;
        double apparentDiameter = 2.0 * Math.sqrt((nr - 1.0) / (nr + 1.0));
        double gridLengthX = major_axis * apparentDiameter / dx;
        double gridLengthY = minor_axis * apparentDiameter / dy;
        this.gdsIndex.addParam("Dx", String.valueOf(1000.0 * gridLengthX));
        this.gdsIndex.addParam("Dy", String.valueOf(1000.0 * gridLengthY));
        this.startx = -gridLengthX * xp;
        this.starty = -gridLengthY * yp;
        double radius = Earth.getRadius() / 1000.0;
        if (nr == 1.111111111E9) {
            this.proj = new Orthographic(Lat0, Lon0, radius);
            this.attributes.add(new Attribute("grid_mapping_name", "orthographic"));
            this.attributes.add(new Attribute("longitude_of_projection_origin", new Double(Lon0)));
            this.attributes.add(new Attribute("latitude_of_projection_origin", new Double(Lat0)));
        } else {
            double height = (nr - 1.0) * radius;
            this.proj = new VerticalPerspectiveView(Lat0, Lon0, radius, height);
            this.attributes.add(new Attribute("grid_mapping_name", "vertical_perspective"));
            this.attributes.add(new Attribute("longitude_of_projection_origin", new Double(Lon0)));
            this.attributes.add(new Attribute("latitude_of_projection_origin", new Double(Lat0)));
            this.attributes.add(new Attribute("height_above_earth", new Double(height)));
        }
        if (GridServiceProvider.debugProj) {
            double Lo2 = this.getParamValue("Lo2") + 360.0;
            double La2 = this.getParamValue("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GridHorizCoordSys.makeOrthographic end at latlon " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj(endLL);
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)this.getNx() * this.getDxInKm();
            double endy = this.starty + (double)this.getNy() * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
    }

    private double getParamValue(String id) {
        return this.gdsIndex.readDouble(id);
    }

    private String getParamString(String id) {
        return this.gdsIndex.getParam(id);
    }

    private void setDxDy(double startx, double starty, ProjectionImpl proj) {
        double Lo2 = this.gdsIndex.readDouble("Lo2");
        double La2 = this.gdsIndex.readDouble("La2");
        if (Double.isNaN(Lo2) || Double.isNaN(La2)) {
            return;
        }
        LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
        ProjectionPointImpl end = (ProjectionPointImpl)proj.latLonToProj(endLL);
        double dx = 1000.0 * Math.abs(end.getX() - startx) / (this.getParamValue("Nx") - 1.0);
        double dy = 1000.0 * Math.abs(end.getY() - starty) / (this.getParamValue("Ny") - 1.0);
        this.gdsIndex.addParam("Dx", String.valueOf(dx));
        this.gdsIndex.addParam("Dy", String.valueOf(dy));
    }
}

