/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;

public class GridIndexToNC {
    private static Logger logger = LoggerFactory.getLogger(GridIndexToNC.class);
    private HashMap hcsHash = new HashMap(10);
    private DateFormatter formatter = new DateFormatter();
    private boolean debug = false;
    private boolean useDescriptionForVariableName = true;

    public static String makeLevelName(GridRecord gr, GridTableLookup lookup) {
        if (lookup.getGridType().equals("GRIB2") || lookup.getGridType().equals("GRIB1")) {
            String vname = lookup.getLevelName(gr);
            return lookup.isLayer(gr) ? vname + "_layer" : vname;
        }
        return lookup.getLevelName(gr);
    }

    public static String makeEnsembleName(GridRecord gr, GridTableLookup lookup) {
        if (!lookup.getGridType().equals("GRIB2")) {
            return "";
        }
        Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)lookup;
        if (!g2lookup.isEnsemble(gr)) {
            return "";
        }
        int ensemble = g2lookup.getTypeGenProcess(gr);
        int productDef = g2lookup.getProductDefinition(gr);
        if (productDef == 2) {
            if (ensemble < 41000) {
                String ensembleName = "unweightedMean" + Integer.toString(ensemble - 40000);
            } else if (ensemble < 42000) {
                String ensembleName = "weightedMean" + Integer.toString(ensemble - 41000);
            } else if (ensemble < 43000) {
                String ensembleName = "stdDev" + Integer.toString(ensemble - 42000);
            } else if (ensemble < 44000) {
                String ensembleName = "stdDevNor" + Integer.toString(ensemble - 43000);
            } else if (ensemble < 45000) {
                String ensembleName = "spread" + Integer.toString(ensemble - 44000);
            } else if (ensemble < 46000) {
                String ensembleName = "anomaly" + Integer.toString(ensemble - 45000);
            } else if (ensemble < 47000) {
                String ensembleName = "unweightedMeanCluster" + Integer.toString(ensemble - 46000);
            } else {
                String ensembleName = "unknownEnsemble";
            }
        } else if (productDef == 1 || productDef == 11) {
            String ensembleName = ensemble < 41000 ? "C_high" + Integer.toString(ensemble - 40000) : (ensemble < 42000 ? "C_low" + Integer.toString(ensemble - 41000) : (ensemble < 43000 ? "P_neg" + Integer.toString(ensemble - 42000) : (ensemble < 44000 ? "P_pos" + Integer.toString(ensemble - 43000) : "unknownEnsemble")));
            return ensembleName;
        }
        return "";
    }

    public String makeVariableName(GridRecord gr, GridTableLookup lookup) {
        GridParameter param = lookup.getParameter(gr);
        String levelName = GridIndexToNC.makeLevelName(gr, lookup);
        String ensembleName = GridIndexToNC.makeEnsembleName(gr, lookup);
        String paramName = this.useDescriptionForVariableName ? param.getDescription() : param.getName();
        paramName = ensembleName.length() == 0 ? paramName : paramName + "_" + ensembleName;
        paramName = levelName.length() == 0 ? paramName : paramName + "_" + levelName;
        return paramName;
    }

    public void open(GridIndex index, GridTableLookup lookup, int version, NetcdfFile ncfile, FmrcCoordSys fmrcCoordSys, CancelTask cancelTask) throws IOException {
        GridVariable gv;
        ArrayList gribvars;
        List<GridDefRecord> hcsList = index.getHorizCoordSys();
        boolean needGroups = hcsList.size() > 1;
        for (int i = 0; i < hcsList.size(); ++i) {
            GridDefRecord gdsIndex = hcsList.get(i);
            Group g = null;
            if (needGroups) {
                g = new Group(ncfile, null, gdsIndex.getGroupName());
                ncfile.addGroup(null, g);
            }
            GridHorizCoordSys hcs = new GridHorizCoordSys(gdsIndex, lookup, g);
            this.hcsHash.put(gdsIndex.getParam("GDSkey"), hcs);
        }
        GridRecord firstRecord = null;
        List<GridRecord> records = index.getGridRecords();
        if (GridServiceProvider.debugOpen) {
            System.out.println(" number of products = " + records.size());
        }
        for (int i = 0; i < records.size(); ++i) {
            GridRecord gribRecord = records.get(i);
            if (firstRecord == null) {
                firstRecord = gribRecord;
            }
            GridHorizCoordSys hcs = (GridHorizCoordSys)this.hcsHash.get(gribRecord.getGridDefRecordId());
            String name = this.makeVariableName(gribRecord, lookup);
            GridVariable pv = (GridVariable)hcs.varHash.get(name);
            if (null == pv) {
                String pname = lookup.getParameter(gribRecord).getDescription();
                pv = new GridVariable(name, pname, hcs, lookup);
                hcs.varHash.put(name, pv);
                ArrayList<GridVariable> plist = (ArrayList<GridVariable>)hcs.productHash.get(pname);
                if (null == plist) {
                    plist = new ArrayList<GridVariable>();
                    hcs.productHash.put(pname, plist);
                }
                plist.add(pv);
            }
            pv.addProduct(gribRecord);
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.0"));
        ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        String gridType = lookup.getGridType();
        ncfile.addAttribute(null, new Attribute("file_format", gridType + "-" + version));
        ncfile.addAttribute(null, new Attribute("location", ncfile.getLocation()));
        ncfile.addAttribute(null, new Attribute("history", "Direct read of " + gridType + " into NetCDF-Java 4.0 API"));
        ncfile.addAttribute(null, new Attribute("_CoordinateModelRunDate", this.formatter.toDateTimeStringISO(lookup.getFirstBaseTime())));
        if (fmrcCoordSys != null) {
            this.makeDefinedCoordSys(ncfile, lookup, fmrcCoordSys);
        } else {
            this.makeDenseCoordSys(ncfile, lookup, cancelTask);
        }
        if (GridServiceProvider.debugMissing) {
            int count = 0;
            for (GridHorizCoordSys hcs : this.hcsHash.values()) {
                gribvars = new ArrayList(hcs.varHash.values());
                for (int i = 0; i < gribvars.size(); ++i) {
                    gv = (GridVariable)gribvars.get(i);
                    count += gv.dumpMissingSummary();
                }
            }
            System.out.println(" total missing= " + count);
        }
        if (GridServiceProvider.debugMissingDetails) {
            for (GridHorizCoordSys hcs : this.hcsHash.values()) {
                System.out.println("******** Horiz Coordinate= " + hcs.getGridName());
                String lastVertDesc = null;
                gribvars = new ArrayList(hcs.varHash.values());
                Collections.sort(gribvars, new CompareGridVariableByVertName());
                for (int i = 0; i < gribvars.size(); ++i) {
                    gv = (GridVariable)gribvars.get(i);
                    String vertDesc = gv.getVertName();
                    if (!vertDesc.equals(lastVertDesc)) {
                        System.out.println("---Vertical Coordinate= " + vertDesc);
                        lastVertDesc = vertDesc;
                    }
                    gv.dumpMissing();
                }
            }
        }
    }

    private void makeDenseCoordSys(NetcdfFile ncfile, GridTableLookup lookup, CancelTask cancelTask) throws IOException {
        ArrayList<GridTimeCoord> timeCoords = new ArrayList<GridTimeCoord>();
        ArrayList<GridVertCoord> vertCoords = new ArrayList<GridVertCoord>();
        for (GridHorizCoordSys hcs : this.hcsHash.values()) {
            int i;
            for (GridVariable pv : hcs.varHash.values()) {
                List recordList = pv.getRecords();
                GridRecord record = (GridRecord)recordList.get(0);
                String vname = GridIndexToNC.makeLevelName(record, lookup);
                GridVertCoord useVertCoord = null;
                for (int i2 = 0; i2 < vertCoords.size(); ++i2) {
                    GridVertCoord gvcs = (GridVertCoord)vertCoords.get(i2);
                    if (!vname.equals(gvcs.getLevelName()) || !gvcs.matchLevels(recordList)) continue;
                    useVertCoord = gvcs;
                }
                if (useVertCoord == null) {
                    useVertCoord = new GridVertCoord(recordList, vname, lookup);
                    vertCoords.add(useVertCoord);
                }
                pv.setVertCoord(useVertCoord);
                GridTimeCoord useTimeCoord = null;
                for (int i3 = 0; i3 < timeCoords.size(); ++i3) {
                    GridTimeCoord gtc = (GridTimeCoord)timeCoords.get(i3);
                    if (!gtc.matchLevels(recordList)) continue;
                    useTimeCoord = gtc;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = new GridTimeCoord(recordList, lookup);
                    timeCoords.add(useTimeCoord);
                }
                pv.setTimeCoord(useTimeCoord);
            }
            GridTimeCoord tcs0 = null;
            int maxTimes = 0;
            for (int i4 = 0; i4 < timeCoords.size(); ++i4) {
                GridTimeCoord tcs = (GridTimeCoord)timeCoords.get(i4);
                if (tcs.getNTimes() <= maxTimes) continue;
                tcs0 = tcs;
                maxTimes = tcs.getNTimes();
            }
            int seqno = 1;
            for (int i5 = 0; i5 < timeCoords.size(); ++i5) {
                GridTimeCoord tcs = (GridTimeCoord)timeCoords.get(i5);
                if (tcs != tcs0) {
                    tcs.setSequence(seqno++);
                }
                tcs.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            Collections.sort(vertCoords);
            int vcIndex = 0;
            String listName = null;
            int start = 0;
            for (vcIndex = 0; vcIndex < vertCoords.size(); ++vcIndex) {
                GridVertCoord gvcs = (GridVertCoord)vertCoords.get(vcIndex);
                String vname = gvcs.getLevelName();
                if (listName == null) {
                    listName = vname;
                }
                if (vname.equals(listName)) continue;
                this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
                listName = vname;
                start = vcIndex;
            }
            this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
            ArrayList products = new ArrayList(hcs.productHash.values());
            Collections.sort(products, new CompareGridVariableListByName());
            for (i = 0; i < products.size(); ++i) {
                ArrayList plist = (ArrayList)products.get(i);
                if (plist.size() == 1) {
                    GridVariable pv = (GridVariable)plist.get(0);
                    Variable v = pv.makeVariable(ncfile, hcs.getGroup(), this.useDescriptionForVariableName);
                    ncfile.addVariable(hcs.getGroup(), v);
                    continue;
                }
                Collections.sort(plist, new CompareGridVariableByNumberVertLevels());
                for (int k = 0; k < plist.size(); ++k) {
                    GridVariable pv = (GridVariable)plist.get(k);
                    boolean useDesc = k == 0 && this.useDescriptionForVariableName;
                    ncfile.addVariable(hcs.getGroup(), pv.makeVariable(ncfile, hcs.getGroup(), useDesc));
                }
            }
            for (i = 0; i < timeCoords.size(); ++i) {
                GridTimeCoord tcs = (GridTimeCoord)timeCoords.get(i);
                tcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (i = 0; i < vertCoords.size(); ++i) {
                GridVertCoord gvcs = (GridVertCoord)vertCoords.get(i);
                gvcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
    }

    private void makeVerticalDimensions(List vertCoordList, NetcdfFile ncfile, Group group) {
        GridVertCoord gvcs0 = null;
        int maxLevels = 0;
        for (int i = 0; i < vertCoordList.size(); ++i) {
            GridVertCoord gvcs = (GridVertCoord)vertCoordList.get(i);
            if (gvcs.getNLevels() <= maxLevels) continue;
            gvcs0 = gvcs;
            maxLevels = gvcs.getNLevels();
        }
        int seqno = 1;
        for (int i = 0; i < vertCoordList.size(); ++i) {
            GridVertCoord gvcs = (GridVertCoord)vertCoordList.get(i);
            if (gvcs != gvcs0) {
                gvcs.setSequence(seqno++);
            }
            gvcs.addDimensionsToNetcdfFile(ncfile, group);
        }
    }

    private void makeDefinedCoordSys(NetcdfFile ncfile, GridTableLookup lookup, FmrcCoordSys fmr) throws IOException {
        ArrayList<GridTimeCoord> timeCoords = new ArrayList<GridTimeCoord>();
        ArrayList<GridVertCoord> vertCoords = new ArrayList<GridVertCoord>();
        ArrayList<String> removeVariables = new ArrayList<String>();
        for (GridHorizCoordSys hcs : this.hcsHash.values()) {
            int i;
            for (String key : hcs.varHash.keySet()) {
                GridVariable pv = (GridVariable)hcs.varHash.get(key);
                GridRecord record = pv.getFirstRecord();
                String searchName = this.findVariableName(ncfile, record, lookup, fmr);
                System.out.println("Search name = " + searchName);
                if (searchName == null) {
                    System.out.println("removing " + searchName);
                    removeVariables.add(key);
                    continue;
                }
                pv.setVarName(searchName);
                FmrcCoordSys.VertCoord vc_def = fmr.findVertCoordForVariable(searchName);
                if (vc_def != null) {
                    String vc_name = vc_def.getName();
                    GridVertCoord useVertCoord = null;
                    for (int i2 = 0; i2 < vertCoords.size(); ++i2) {
                        GridVertCoord gvcs = (GridVertCoord)vertCoords.get(i2);
                        if (!vc_name.equals(gvcs.getLevelName())) continue;
                        useVertCoord = gvcs;
                    }
                    if (useVertCoord == null) {
                        useVertCoord = new GridVertCoord(record, vc_name, lookup, vc_def.getValues1(), vc_def.getValues2());
                        useVertCoord.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
                        vertCoords.add(useVertCoord);
                    }
                    pv.setVertCoord(useVertCoord);
                } else {
                    pv.setVertCoord(new GridVertCoord(searchName));
                }
                FmrcCoordSys.TimeCoord tc_def = fmr.findTimeCoordForVariable(searchName, lookup.getFirstBaseTime());
                String tc_name = tc_def.getName();
                GridTimeCoord useTimeCoord = null;
                for (int i3 = 0; i3 < timeCoords.size(); ++i3) {
                    GridTimeCoord gtc = (GridTimeCoord)timeCoords.get(i3);
                    if (!tc_name.equals(gtc.getName())) continue;
                    useTimeCoord = gtc;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = new GridTimeCoord(tc_name, tc_def.getOffsetHours(), lookup);
                    useTimeCoord.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
                    timeCoords.add(useTimeCoord);
                }
                pv.setTimeCoord(useTimeCoord);
            }
            for (int i4 = 0; i4 < removeVariables.size(); ++i4) {
                String key = (String)removeVariables.get(i4);
                hcs.varHash.remove(key);
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            for (GridVariable pv : hcs.varHash.values()) {
                Variable v = pv.makeVariable(ncfile, hcs.getGroup(), true);
                ncfile.addVariable(hcs.getGroup(), v);
            }
            for (i = 0; i < timeCoords.size(); ++i) {
                GridTimeCoord tcs = (GridTimeCoord)timeCoords.get(i);
                tcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (i = 0; i < vertCoords.size(); ++i) {
                GridVertCoord gvcs = (GridVertCoord)vertCoords.get(i);
                gvcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
        if (this.debug) {
            System.out.println("GridIndexToNC.makeDefinedCoordSys for " + ncfile.getLocation());
        }
    }

    private String findVariableName(NetcdfFile ncfile, GridRecord gr, GridTableLookup lookup, FmrcCoordSys fmr) {
        String name = AbstractIOServiceProvider.createValidNetcdfObjectName(this.makeVariableName(gr, lookup));
        if (fmr.hasVariable(name)) {
            return name;
        }
        String pname = AbstractIOServiceProvider.createValidNetcdfObjectName(lookup.getParameter(gr).getDescription());
        if (fmr.hasVariable(pname)) {
            return pname;
        }
        logger.warn("GridIndexToNC: FmrcCoordSys does not have the variable named =" + name + " or " + pname + " for file " + ncfile.getLocation());
        return null;
    }

    public void setUseDescriptionForVariableName(boolean value) {
        this.useDescriptionForVariableName = value;
    }

    private class CompareGridVariableByNumberVertLevels
    implements Comparator {
        private CompareGridVariableByNumberVertLevels() {
        }

        public int compare(Object o1, Object o2) {
            int n2;
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            int n1 = gv1.getVertCoord().getNLevels();
            if (n1 == (n2 = gv2.getVertCoord().getNLevels())) {
                return gv1.getVertCoord().getLevelName().compareTo(gv2.getVertCoord().getLevelName());
            }
            return n2 - n1;
        }
    }

    private class CompareGridVariableByVertName
    implements Comparator {
        private CompareGridVariableByVertName() {
        }

        public int compare(Object o1, Object o2) {
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            return gv1.getVertName().compareToIgnoreCase(gv2.getVertName());
        }
    }

    private class CompareGridVariableListByName
    implements Comparator {
        private CompareGridVariableListByName() {
        }

        public int compare(Object o1, Object o2) {
            ArrayList list1 = (ArrayList)o1;
            ArrayList list2 = (ArrayList)o2;
            GridVariable gv1 = (GridVariable)list1.get(0);
            GridVariable gv2 = (GridVariable)list2.get(0);
            return gv1.getName().compareToIgnoreCase(gv2.getName());
        }
    }
}

