/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.grid.GridCoordSys;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.units.DateFormatter;

public class GridVariable {
    private static Logger log = LoggerFactory.getLogger(GridVariable.class);
    private String name;
    private String desc;
    private String vname;
    private GridRecord firstRecord;
    private GridTableLookup lookup;
    private boolean isGrib1;
    private GridHorizCoordSys hcs;
    private GridCoordSys vcs;
    private GridTimeCoord tcs;
    private GridVertCoord vc;
    private ArrayList records = new ArrayList();
    private int nlevels;
    private int ntimes;
    private GridRecord[] recordTracker;
    private int decimalScale = 0;
    private boolean hasVert = false;
    private boolean showRecords = false;
    private boolean showGen = false;
    private volatile int hashCode = 0;

    GridVariable(String name, String desc, GridHorizCoordSys hcs, GridTableLookup lookup) {
        this.name = name;
        this.desc = desc;
        this.hcs = hcs;
        this.lookup = lookup;
        this.isGrib1 = false;
    }

    void addProduct(GridRecord record) {
        this.records.add(record);
        if (this.firstRecord == null) {
            this.firstRecord = record;
        }
    }

    List getRecords() {
        return this.records;
    }

    GridRecord getFirstRecord() {
        return (GridRecord)this.records.get(0);
    }

    GridHorizCoordSys getHorizCoordSys() {
        return this.hcs;
    }

    GridCoordSys getVertCoordSys() {
        return this.vcs;
    }

    GridVertCoord getVertCoord() {
        return this.vc;
    }

    boolean hasVert() {
        return this.hasVert;
    }

    void setVarName(String vname) {
        this.vname = vname;
    }

    void setVertCoordSys(GridCoordSys vcs) {
        this.vcs = vcs;
    }

    void setVertCoord(GridVertCoord vc) {
        this.vc = vc;
    }

    void setTimeCoord(GridTimeCoord tcs) {
        this.tcs = tcs;
    }

    int getVertNlevels() {
        return this.vcs == null ? this.vc.getNLevels() : this.vcs.getNLevels();
    }

    String getVertName() {
        return this.vcs == null ? this.vc.getVariableName() : this.vcs.getVerticalName();
    }

    String getVertLevelName() {
        return this.vcs == null ? this.vc.getLevelName() : this.vcs.getVerticalName();
    }

    boolean getVertIsUsed() {
        return this.vcs == null ? !this.vc.dontUseVertical : !this.vcs.dontUseVertical;
    }

    int getVertIndex(GridRecord p) {
        return this.vcs == null ? this.vc.getIndex(p) : this.vcs.getIndex(p);
    }

    int getNTimes() {
        return this.tcs == null ? 1 : this.tcs.getNTimes();
    }

    Variable makeVariable(NetcdfFile ncfile, Group g, boolean useDesc) {
        this.nlevels = this.getVertNlevels();
        this.ntimes = this.tcs.getNTimes();
        this.decimalScale = this.firstRecord.getDecimalScale();
        if (this.vname == null) {
            this.vname = AbstractIOServiceProvider.createValidNetcdfObjectName(useDesc ? this.desc : this.name);
        }
        Variable v = new Variable(ncfile, g, null, this.vname);
        v.setDataType(DataType.FLOAT);
        String dims = this.tcs.getName();
        if (this.getVertIsUsed()) {
            dims = dims + " " + this.getVertName();
            this.hasVert = true;
        }
        dims = this.hcs.isLatLon() ? dims + " lat lon" : dims + " y x";
        v.setDimensions(dims);
        GridParameter param = this.lookup.getParameter(this.firstRecord);
        String unit = param.getUnit();
        if (unit == null) {
            unit = "";
        }
        v.addAttribute(new Attribute("units", unit));
        v.addAttribute(new Attribute("long_name", this.makeLongName(this.firstRecord, this.lookup)));
        v.addAttribute(new Attribute("missing_value", new Float(this.lookup.getFirstMissingValue())));
        if (!this.hcs.isLatLon()) {
            if (GribServiceProvider.addLatLon) {
                v.addAttribute(new Attribute("coordinates", "lat lon"));
            }
            v.addAttribute(new Attribute("grid_mapping", this.hcs.getGridName()));
        }
        v.setSPobject(this);
        if (this.showRecords) {
            System.out.println("Variable " + this.getName());
        }
        this.recordTracker = new GridRecord[this.ntimes * this.nlevels];
        for (int i = 0; i < this.records.size(); ++i) {
            GridRecord p = (GridRecord)this.records.get(i);
            if (this.showRecords) {
                System.out.println(" " + this.vc.getVariableName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevelType1() + "," + p.getLevelType2());
            }
            int level = this.getVertIndex(p);
            if (!this.getVertIsUsed() && level > 0) {
                log.warn("inconsistent level encoding=" + level);
                level = 0;
            }
            int time = this.tcs.getIndex(p);
            if (level < 0) {
                log.warn("NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + "   " + this.getVertLevelName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevel1() + "," + p.getLevel2() + "\n");
                this.getVertIndex(p);
                continue;
            }
            if (time < 0) {
                log.warn("NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + " forecastTime= " + p.getValidTimeOffset() + " date= " + this.tcs.getValidTime(p) + "\n");
                this.tcs.getIndex(p);
                continue;
            }
            int recno = time * this.nlevels + level;
            if (this.recordTracker[recno] == null) {
                this.recordTracker[recno] = p;
                continue;
            }
            GridRecord q = this.recordTracker[recno];
            this.recordTracker[recno] = p;
        }
        return v;
    }

    void dumpMissing() {
        System.out.println("  " + this.name);
        for (int j = 0; j < this.nlevels; ++j) {
            System.out.print("   ");
            for (int i = 0; i < this.ntimes; ++i) {
                boolean missing = this.recordTracker[i * this.nlevels + j] == null;
                System.out.print(missing ? "-" : "X");
            }
            System.out.println();
        }
    }

    int dumpMissingSummary() {
        if (this.nlevels == 1) {
            return 0;
        }
        int count = 0;
        int total = this.nlevels * this.ntimes;
        for (int i = 0; i < total; ++i) {
            if (this.recordTracker[i] != null) continue;
            ++count;
        }
        System.out.println("  MISSING= " + count + "/" + total + " " + this.name);
        return count;
    }

    public GridRecord findRecord(int time, int level) {
        return this.recordTracker[time * this.nlevels + level];
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof GridVariable)) {
            return false;
        }
        return this.hashCode() == oo.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getParamName() {
        return this.desc;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result += 37 * result + this.firstRecord.getLevelType1();
            result += 37 * result + this.hcs.getID().hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String dump() {
        DateFormatter formatter = new DateFormatter();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(this.name + " " + this.records.size() + "\n");
        for (int i = 0; i < this.records.size(); ++i) {
            GridRecord record = (GridRecord)this.records.get(i);
            sbuff.append(" level = " + record.getLevelType1() + " " + record.getLevel1());
            if (null != record.getValidTime()) {
                sbuff.append(" time = " + formatter.toDateTimeString(record.getValidTime()));
            }
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    private String makeLongName(GridRecord gr, GridTableLookup lookup) {
        GridParameter param = lookup.getParameter(gr);
        String levelName = lookup.getLevelDescription(gr);
        return levelName.length() == 0 ? param.getDescription() : param.getDescription() + " @ " + levelName;
    }
}

