/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.xml.Parse;

public class AggregationExisting
extends AggregationOuterDimension {
    private static boolean debugPersist = true;
    private static boolean debugPersistDetail = true;

    public AggregationExisting(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.joinExisting, recheckS);
    }

    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, null);
        String dimName = this.getDimensionName();
        Variable tcv = typical.findVariable(dimName);
        AggregationOuterDimension.CoordValueVar coordCacheVar = new AggregationOuterDimension.CoordValueVar(this, dimName, tcv.getDataType(), tcv.getUnitsString());
        this.cacheList.add(coordCacheVar);
        this.buildCoords(cancelTask);
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        this.promoteGlobalAttributes((AggregationOuterDimension.DatasetOuterDimension)typicalDataset);
        for (Variable v : typical.getVariables()) {
            Dimension d;
            if (v.getRank() < 1 || !dimName.equals((d = v.getDimension(0)).getName())) continue;
            Group newGroup = DatasetConstructor.findGroup(this.ncDataset, v.getParentGroup());
            VariableDS vagg = new VariableDS(this.ncDataset, newGroup, null, v.getShortName(), v.getDataType(), v.getDimensionsString(), null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(v, vagg);
            newGroup.removeVariable(v.getShortName());
            newGroup.addVariable(vagg);
            this.aggVars.add(vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(dimName);
        if (joinAggCoord == null && this.type == Aggregation.Type.joinExisting) {
            typicalDataset.close(typical);
            throw new IllegalArgumentException("No existing coordinate variable for joinExisting on " + this.getLocation());
        }
        if (this.type == Aggregation.Type.joinExistingOne) {
            if (joinAggCoord == null) {
                joinAggCoord = new VariableDS(this.ncDataset, null, null, dimName, DataType.STRING, dimName, null, null);
                joinAggCoord.setProxyReader(this);
                this.ncDataset.getRootGroup().addVariable(joinAggCoord);
                this.aggVars.add(joinAggCoord);
            }
            joinAggCoord.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
            joinAggCoord.addAttribute(new Attribute("long_name", "time coordinate"));
            joinAggCoord.addAttribute(new Attribute("standard_name", "time"));
        }
        if (this.timeUnitsChange) {
            this.readTimeCoordinates(joinAggCoord, cancelTask);
        }
        joinAggCoord.setSPobject(coordCacheVar);
        this.persistRead();
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
        if (debugInvocation) {
            System.out.println(this.ncDataset.getLocation() + " invocation count = " + AggregationOuterDimension.invocation);
        }
    }

    protected void rebuildDataset() throws IOException {
        super.rebuildDataset();
        if (this.timeUnitsChange) {
            VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(this.dimName);
            this.readTimeCoordinates(joinAggCoord, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readTimeCoordinates(VariableDS timeAxis, CancelTask cancelTask) throws IOException {
        DateUnit du;
        ArrayList<Date> dateList = new ArrayList<Date>();
        String units = null;
        for (Aggregation.Dataset dataset : this.getDatasets()) {
            Object var13_14;
            NetcdfFile ncfile;
            block12: {
                block11: {
                    ncfile = null;
                    try {
                        ncfile = dataset.acquireFile(cancelTask);
                        Variable v = ncfile.findVariable(timeAxis.getName());
                        if (v == null) {
                            logger.warn("readTimeCoordinates: variable = " + timeAxis.getName() + " not found in file " + dataset.getLocation());
                            var13_14 = null;
                            break block11;
                        }
                        VariableDS vds = v instanceof VariableDS ? (VariableDS)v : new VariableDS(null, v, true);
                        CoordinateAxis1DTime timeCoordVar = CoordinateAxis1DTime.factory(this.ncDataset, vds, null);
                        Date[] dates = timeCoordVar.getTimeDates();
                        dateList.addAll(Arrays.asList(dates));
                        if (units == null) {
                            units = v.getUnitsString();
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        var13_14 = null;
                        dataset.close(ncfile);
                        throw throwable;
                    }
                }
                dataset.close(ncfile);
                return;
            }
            var13_14 = null;
            dataset.close(ncfile);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        int[] shape = timeAxis.getShape();
        int ntimes = shape[0];
        assert (ntimes == dateList.size());
        Array timeCoordVals = Array.factory(timeAxis.getDataType(), shape);
        IndexIterator ii = timeCoordVals.getIndexIterator();
        timeAxis.setCachedData(timeCoordVals, false);
        if (timeAxis.getDataType() == DataType.STRING) {
            for (Date date : dateList) {
                ii.setObjectNext(this.dateFormatter.toDateTimeStringISO(date));
            }
            return;
        }
        try {
            du = new DateUnit(units);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        timeAxis.addAttribute(new Attribute("units", units));
        for (Date date : dateList) {
            double val = du.makeValue(date);
            ii.setDoubleNext(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void persistWrite() throws IOException {
        AbstractInterruptibleChannel channel;
        block16: {
            block15: {
                if (diskCache2 == null) {
                    return;
                }
                String cacheName = this.getCacheName();
                if (cacheName == null) {
                    return;
                }
                File cacheFile = diskCache2.getCacheFile(cacheName);
                if (!this.cacheDirty && cacheFile.exists()) {
                    return;
                }
                channel = null;
                try {
                    FileLock lock;
                    if (!cacheFile.exists()) {
                        File dir = cacheFile.getParentFile();
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(cacheFile);
                    channel = fos.getChannel();
                    try {
                        lock = ((FileChannel)channel).tryLock();
                    }
                    catch (OverlappingFileLockException e) {
                        Object var15_8 = null;
                        if (channel == null) return;
                        channel.close();
                        return;
                    }
                    if (lock == null) {
                        Object var15_9 = null;
                        if (channel == null) return;
                        break block15;
                    }
                    PrintWriter out = new PrintWriter(fos);
                    out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
                    out.print("<aggregation xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' version='3' ");
                    out.print("type='" + (Object)((Object)this.type) + "' ");
                    if (this.dimName != null) {
                        out.print("dimName='" + this.dimName + "' ");
                    }
                    if (this.datasetManager.getRecheck() != null) {
                        out.print("recheckEvery='" + this.datasetManager.getRecheck() + "' ");
                    }
                    out.print(">\n");
                    List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
                    for (Aggregation.Dataset dataset : nestedDatasets) {
                        AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)dataset;
                        if (dod.getId() == null) {
                            logger.warn("id is null");
                        }
                        out.print("  <netcdf id='" + dod.getId() + "' ");
                        out.print("ncoords='" + dod.getNcoords(null) + "' >\n");
                        for (AggregationOuterDimension.CacheVar pv : this.cacheList) {
                            Array data = pv.dataMap.get(dod.getId());
                            if (data == null) continue;
                            out.print("    <cache varName='" + pv.varName + "' >");
                            NCdumpW.printArray(data, out);
                            out.print("</cache>\n");
                            if (!debugPersist) continue;
                            System.out.println(" wrote array = " + pv.varName + " nelems= " + data.getSize() + " for " + dataset.getLocation());
                        }
                        out.print("  </netcdf>\n");
                    }
                    out.print("</aggregation>\n");
                    out.close();
                    cacheFile.setLastModified(this.datasetManager.getLastScanned());
                    this.cacheDirty = false;
                    if (debugPersist) {
                        System.out.println("Aggregation persisted = " + cacheFile.getPath() + " lastModified= " + new Date(this.datasetManager.getLastScanned()));
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var15_11 = null;
                    if (channel == null) throw throwable;
                    channel.close();
                    throw throwable;
                }
            }
            channel.close();
            return;
        }
        Object var15_10 = null;
        if (channel == null) return;
        channel.close();
    }

    protected void persistRead() {
        Element aggElem;
        if (diskCache2 == null) {
            return;
        }
        String cacheName = this.getCacheName();
        if (cacheName == null) {
            return;
        }
        File cacheFile = diskCache2.getCacheFile(cacheName);
        if (!cacheFile.exists()) {
            return;
        }
        if (debugPersist) {
            System.out.println(" Try to Read cache " + cacheFile.getPath());
        }
        try {
            aggElem = Parse.readRootElement("file:" + cacheFile.getPath());
        }
        catch (IOException e) {
            if (debugCache) {
                System.out.println(" No cache for " + cacheName + " - " + e.getMessage());
            }
            return;
        }
        String version = aggElem.getAttributeValue("version");
        if (version == null || !version.equals("3")) {
            return;
        }
        HashMap<String, Aggregation.Dataset> map = new HashMap<String, Aggregation.Dataset>();
        for (Aggregation.Dataset ds : this.getDatasets()) {
            map.put(ds.getId(), ds);
        }
        List ncList = aggElem.getChildren("netcdf", NcMLReader.ncNS);
        for (Element netcdfElemNested : ncList) {
            String id = netcdfElemNested.getAttributeValue("id");
            AggregationOuterDimension.DatasetOuterDimension dod = (AggregationOuterDimension.DatasetOuterDimension)map.get(id);
            if (null == dod) {
                if (debugPersist) {
                    System.out.println(" have cache but no dataset= " + id);
                }
                logger.warn(" have cache but no dataset= " + id);
                continue;
            }
            if (debugPersist) {
                System.out.println(" use cache for dataset= " + id);
            }
            if (dod.ncoord == 0) {
                String ncoordsS = netcdfElemNested.getAttributeValue("ncoords");
                try {
                    dod.ncoord = Integer.parseInt(ncoordsS);
                    if (debugPersist) {
                        System.out.println(" Read the cache; ncoords = " + dod.ncoord);
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("bad ncoord attribute on dataset=" + id);
                }
            }
            List cacheElemList = netcdfElemNested.getChildren("cache", NcMLReader.ncNS);
            for (Element cacheElemNested : cacheElemList) {
                String varName = cacheElemNested.getAttributeValue("varName");
                AggregationOuterDimension.CacheVar pv = this.findCacheVariable(varName);
                if (pv != null) {
                    String sdata = cacheElemNested.getText();
                    if (sdata.length() == 0) continue;
                    if (debugPersist) {
                        System.out.println(" read data for var = " + varName + " size= " + sdata.length());
                    }
                    long start = System.nanoTime();
                    String[] vals = sdata.split(" ");
                    double took = 1.0E-9 * (double)(System.nanoTime() - start);
                    if (debugPersist) {
                        System.out.println("  split took = " + took + " sec; ");
                    }
                    try {
                        start = System.nanoTime();
                        Array data = Array.makeArray(pv.dtype, vals);
                        took = 1.0E-9 * (double)(System.nanoTime() - start);
                        if (debugPersist) {
                            System.out.println("  makeArray took = " + took + " sec nelems= " + data.getSize());
                        }
                        pv.dataMap.put(id, data);
                    }
                    catch (Exception e) {
                        logger.warn("Error reading cached data ", e);
                    }
                    continue;
                }
                logger.error("not a cache var=" + varName);
            }
        }
    }

    private String getCacheName() {
        String cacheName = this.ncDataset.getLocation();
        if (cacheName == null) {
            cacheName = this.ncDataset.getCacheName();
        }
        return cacheName;
    }
}

