/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStreamReader;
import ucar.nc2.stream.old.NetcdfRemote;
import ucar.nc2.util.CancelTask;

public class NcStreamRemote
extends NetcdfFile {
    public static final String SCHEME = "ncstream:";
    private static Logger logger = LoggerFactory.getLogger(NetcdfRemote.class);
    private static HttpClient httpClient;
    private final String remoteURI;

    public static String canonicalURL(String urlName) {
        if (urlName.startsWith("http:")) {
            return SCHEME + urlName.substring(5);
        }
        return urlName;
    }

    public static void setHttpClient(HttpClient client) {
        httpClient = client;
    }

    private synchronized void initHttpClient() {
        if (httpClient != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        httpClient = new HttpClient(connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NcStreamRemote(String _remoteURI, CancelTask cancel) throws IOException {
        this.initHttpClient();
        if (_remoteURI.startsWith(SCHEME)) {
            this.remoteURI = "http:" + _remoteURI.substring(SCHEME.length());
            this.location = _remoteURI;
        } else if (_remoteURI.startsWith("http:")) {
            this.location = SCHEME + _remoteURI.substring(5);
            this.remoteURI = _remoteURI;
        } else {
            throw new MalformedURLException(_remoteURI + " must start with " + SCHEME + " or http:");
        }
        GetMethod method = null;
        try {
            method = new GetMethod(this.remoteURI);
            method.setFollowRedirects(true);
            int statusCode = httpClient.executeMethod(method);
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            InputStream is = method.getResponseBodyAsStream();
            NcStreamReader reader = new NcStreamReader();
            reader.readStream(is, this);
            Object var8_7 = null;
            if (method != null) {
                method.releaseConnection();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (method != null) {
                method.releaseConnection();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        StringBuilder sbuff = new StringBuilder(this.remoteURI);
        sbuff.append("?");
        sbuff.append(v.getShortName());
        sbuff.append("(");
        sbuff.append(section.toString());
        sbuff.append(")");
        if (showRequest) {
            System.out.println("NetcdfRemote data request for variable: " + v.getName() + " section= " + section + " url=" + sbuff);
        }
        GetMethod method = null;
        try {
            String s;
            int readLen;
            method = new GetMethod(sbuff.toString());
            method.setFollowRedirects(true);
            int statusCode = httpClient.executeMethod(method);
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            int wantSize = (int)((long)v.getElementSize() * section.computeSize());
            Header h = method.getResponseHeader("Content-Length");
            if (h != null && (readLen = Integer.parseInt(s = h.getValue())) != wantSize) {
                throw new IOException("content-length= " + readLen + " not equal expected Size= " + wantSize);
            }
            InputStream is = method.getResponseBodyAsStream();
            NcStreamReader reader = new NcStreamReader();
            NcStreamReader.DataResult result = reader.readData(is);
            assert (v.getName().equals(result.varName));
            result.data.setUnsigned(v.isUnsigned());
            Array array = result.data;
            Object var13_13 = null;
            if (method != null) {
                method.releaseConnection();
            }
            return array;
        }
        catch (Throwable throwable) {
            block8: {
                Object var13_14 = null;
                if (method == null) break block8;
                method.releaseConnection();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpMethod readSequence(String constraint) throws IOException, InvalidRangeException {
        StringBuilder sbuff = new StringBuilder(this.remoteURI);
        sbuff.append("?");
        sbuff.append(constraint);
        if (showRequest) {
            System.out.println("NetcdfRemote data request constraint= " + constraint + " url=" + sbuff);
        }
        GetMethod method = null;
        try {
            method = new GetMethod(sbuff.toString());
            method.setFollowRedirects(true);
            int statusCode = httpClient.executeMethod(method);
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            GetMethod getMethod = method;
            Object var7_6 = null;
            return getMethod;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }
}

