/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.ui.BAMutil;
import thredds.ui.FileManager;
import thredds.ui.IndependentWindow;
import thredds.ui.PopupMenu;
import thredds.ui.TextHistoryPane;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.ui.StructureTable;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufrTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted messageTable;
    private BeanTableSorted obsTable;
    private BeanTableSorted ddsTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private FileManager fileChooser;
    private String location;
    private MessageScanner scan;

    public BufrTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messageTable = new BeanTableSorted(MessageBean.class, (PreferencesExt)prefs.node("MessageBean"), false);
        this.messageTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BufrTable.this.ddsTable.setBeans(new ArrayList());
                BufrTable.this.obsTable.setBeans(new ArrayList());
                MessageBean mb = (MessageBean)BufrTable.this.messageTable.getSelectedBean();
                ArrayList beanList = new ArrayList();
                try {
                    BufrTable.this.setDataDescriptors(beanList, mb.m.getRootDataDescriptor(), 0);
                    BufrTable.this.setObs(mb.m);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(BufrTable.this, e1.getMessage());
                    e1.printStackTrace();
                }
                BufrTable.this.ddsTable.setBeans(beanList);
            }
        });
        this.obsTable = new BeanTableSorted(ObsBean.class, (PreferencesExt)prefs.node("ObsBean"), false);
        this.obsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ObsBean csb = (ObsBean)BufrTable.this.obsTable.getSelectedBean();
            }
        });
        this.ddsTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)BufrTable.this.ddsTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messageTable.getJTable(), "Options");
        varPopup.addAction("Show DDS", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MessageBean vb = (MessageBean)BufrTable.this.messageTable.getSelectedBean();
                BufrTable.this.infoTA.clear();
                Formatter f = new Formatter();
                try {
                    if (!vb.m.isTablesComplete()) {
                        f.format(" MISSING DATA DESCRIPTORS= ", new Object[0]);
                        vb.m.showMissingFields(f);
                        f.format("%n%n", new Object[0]);
                    }
                    vb.m.dump(f);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(BufrTable.this, e1.getMessage());
                    e1.printStackTrace();
                }
                BufrTable.this.infoTA.appendLine(f.toString());
                BufrTable.this.infoTA.gotoTop();
                BufrTable.this.infoWindow.showIfNotIconified();
            }
        });
        varPopup.addAction("Data Table", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrTable.this.messageTable.getSelectedBean();
                try {
                    NetcdfDataset ncd = BufrTable.this.getBufrMessageAsDataset(mb.m);
                    Variable v = ncd.findVariable("obsRecord");
                    if (v != null && v instanceof Structure) {
                        if (BufrTable.this.dataTable == null) {
                            BufrTable.this.makeDataTable();
                        }
                        BufrTable.this.dataTable.setStructure((Structure)v);
                        BufrTable.this.dataWindow.showIfNotIconified();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrTable.this, ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        varPopup.addAction("Bit Count", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrTable.this.messageTable.getSelectedBean();
                Message m = mb.m;
                Formatter out = new Formatter();
                try {
                    int nbitsCounted = m.calcTotalBits(out);
                    int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
                    boolean ok = Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) <= 1;
                    BufrTable.this.infoTA.clear();
                    if (!ok) {
                        out.format("*** BAD BIT COUNT %n", new Object[0]);
                    }
                    long last = m.dataSection.getDataPos() + (long)m.dataSection.getDataLength();
                    DataDescriptor root = m.getRootDataDescriptor();
                    out.format("Message nobs=%d compressed=%s vlen=%s countBits= %d givenBits=%d %n", m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), nbitsCounted, nbitsGiven);
                    out.format(" countBits= %d givenBits=%d %n", nbitsCounted, nbitsGiven);
                    out.format(" countBytes= %d dataSize=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
                    out.format("%n", new Object[0]);
                    BufrTable.this.infoTA.appendLine(out.toString());
                }
                catch (Exception ex) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ex.printStackTrace(new PrintStream(bos));
                    BufrTable.this.infoTA.appendLine(out.toString());
                    BufrTable.this.infoTA.appendLine(bos.toString());
                }
                BufrTable.this.infoTA.gotoTop();
                BufrTable.this.infoWindow.showIfNotIconified();
            }
        });
        varPopup.addAction("Write Message", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)BufrTable.this.messageTable.getSelectedBean();
                try {
                    String filename;
                    String defloc = BufrTable.this.location == null ? "." : BufrTable.this.location;
                    int pos = defloc.lastIndexOf(".");
                    if (pos > 0) {
                        defloc = defloc.substring(0, pos);
                    }
                    if (BufrTable.this.fileChooser == null) {
                        BufrTable.this.fileChooser = new FileManager(null);
                    }
                    if ((filename = BufrTable.this.fileChooser.chooseFilenameToSave(defloc + ".save1.bufr")) == null) {
                        return;
                    }
                    File file = new File(filename);
                    FileOutputStream fos = new FileOutputStream(file);
                    FileChannel wbc = fos.getChannel();
                    wbc.write(ByteBuffer.wrap(mb.m.getHeader().getBytes()));
                    byte[] raw = BufrTable.this.scan.getMessageBytes(mb.m);
                    wbc.write(ByteBuffer.wrap(raw));
                    wbc.close();
                    JOptionPane.showMessageDialog(BufrTable.this, filename + " successfully written");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrTable.this, "ERROR: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        varPopup.addAction("Dump distinct DDS", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BufrTable.this.dumpDDS();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.split2 = new JSplitPane(0, false, this.ddsTable, this.obsTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.messageTable, this.split2);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    private void makeDataTable() {
        this.dataTable = new StructureTable((PreferencesExt)this.prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)this.prefs.getBean("dataWindow", new Rectangle(50, 300, 1000, 600)));
    }

    private void dumpDDS() {
        List beans = this.messageTable.getBeans();
        HashMap<Integer, Message> map = new HashMap<Integer, Message>(2 * beans.size());
        for (MessageBean mb : beans) {
            map.put(mb.m.hashCode(), mb.m);
        }
        int count = 0;
        String dirName = "C:/temp/";
        for (Message m : map.values()) {
            try {
                File file = new File(dirName + "bufr" + count + ".txt");
                FileOutputStream fos = new FileOutputStream(file);
                Formatter f = new Formatter(fos);
                m.dump(f);
                f.flush();
                fos.close();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage());
                e1.printStackTrace();
            }
            ++count;
        }
        JOptionPane.showMessageDialog(this, count + " successfully written to " + dirName);
    }

    public void save() {
        this.messageTable.saveState(false);
        this.ddsTable.saveState(false);
        this.obsTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
    }

    public void setBufrFile(RandomAccessFile raf) throws IOException {
        this.location = raf.getLocation();
        long start = System.nanoTime();
        ArrayList<MessageBean> beanList = new ArrayList<MessageBean>();
        this.scan = new MessageScanner(raf);
        int count = 0;
        while (this.scan.hasNext()) {
            Message m = this.scan.next();
            if (m == null) continue;
            beanList.add(new MessageBean(m));
            ++count;
        }
        this.messageTable.setBeans(beanList);
        this.obsTable.setBeans(new ArrayList());
        this.ddsTable.setBeans(new ArrayList());
    }

    private NetcdfDataset getBufrMessageAsDataset(Message m) throws IOException {
        byte[] mbytes = this.scan.getMessageBytes(m);
        NetcdfFile ncfile = NetcdfFile.openInMemory("test", mbytes);
        return new NetcdfDataset(ncfile);
    }

    private int setDataDescriptors(List<DdsBean> beanList, DataDescriptor dds, int seqno) {
        for (DataDescriptor key : dds.getSubKeys()) {
            beanList.add(new DdsBean(key, seqno++));
            if (key.getSubKeys() == null) continue;
            seqno = this.setDataDescriptors(beanList, key, seqno);
        }
        return seqno;
    }

    private void setObs(Message m) {
        ArrayList<ObsBean> beanList = new ArrayList<ObsBean>();
        try {
            NetcdfDataset ncd = this.getBufrMessageAsDataset(m);
            Variable v = ncd.findVariable("obsRecord");
            if (v != null && v instanceof Structure) {
                Structure obs = (Structure)v;
                StructureDataIterator iter = obs.getStructureIterator();
                while (iter.hasNext()) {
                    beanList.add(new ObsBean(obs, iter.next()));
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
            ex.printStackTrace();
        }
        this.obsTable.setBeans(beanList);
    }

    public class ObsBean {
        double lat = Double.NaN;
        double lon = Double.NaN;
        double alt = Double.NaN;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int sec = -1;
        Date time;
        int wmo_block = -1;
        int wmo_id = -1;
        String stn = null;

        public ObsBean() {
        }

        public ObsBean(Structure obs, StructureData sdata) {
            String val;
            Attribute att;
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-1") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-1") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-30") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-1") && this.year < 0) {
                    this.year = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-2") && this.month < 0) {
                    this.month = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-3") && this.day < 0) {
                    this.day = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-4") && this.hour < 0) {
                    this.hour = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-5") && this.minute < 0) {
                    this.minute = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-6") && this.sec < 0) {
                    this.sec = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-1") && this.wmo_block < 0) {
                    this.wmo_block = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-2") && this.wmo_id < 0) {
                    this.wmo_id = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (this.stn != null || !val.equals("0-1-7") && !val.equals("0-1-194") && !val.equals("0-1-11") && !val.equals("0-1-18")) continue;
                if (v.getDataType().isString()) {
                    this.stn = sdata.getScalarString(v.getShortName());
                    continue;
                }
                this.stn = Integer.toString(sdata.convertScalarInt(v.getShortName()));
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-2") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-2") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-1") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (!val.equals("0-4-7") || this.sec >= 0) continue;
                this.sec = sdata.convertScalarInt(v.getShortName());
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-7-10") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (!val.equals("0-7-2") || !Double.isNaN(this.alt)) continue;
                this.alt = sdata.convertScalarDouble(v.getShortName());
            }
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public double getHeight() {
            return this.alt;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSec() {
            return this.sec;
        }

        public String getWmoId() {
            return this.wmo_block + "/" + this.wmo_id;
        }

        public String getStation() {
            return this.stn;
        }
    }

    public class DdsBean {
        DataDescriptor dds;
        int seq;

        public DdsBean() {
        }

        public DdsBean(DataDescriptor dds, int seq) {
            this.dds = dds;
            this.seq = seq;
        }

        public String getFxy() {
            return this.dds.getFxyName();
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getUnits() {
            return this.dds.getUnits();
        }

        public int getBitWidth() {
            return this.dds.getBitWidth();
        }

        public int getScale() {
            return this.dds.getScale();
        }

        public int getReference() {
            return this.dds.getRefVal();
        }

        public int getSeq() {
            return this.seq;
        }

        public String getLocal() {
            return this.dds.isLocal() ? "true" : "false";
        }
    }

    public class MessageBean {
        Message m;

        public MessageBean() {
        }

        public MessageBean(Message m) {
            this.m = m;
        }

        public String getCategory() throws IOException {
            return this.m.getCategoryFullName();
        }

        public String getCenter() {
            return this.m.getCenterName();
        }

        public String getTable() {
            return this.m.getTableName();
        }

        public String getHeader() {
            return this.m.getHeader();
        }

        public int getEdition() {
            return this.m.is.getBufrEdition();
        }

        public int getNobs() {
            return this.m.getNumberDatasets();
        }

        public long getSize() {
            return this.m.getMessageSize();
        }

        public int getHash() {
            return this.m.hashCode();
        }

        public String getCompress() {
            return this.m.dds.isCompressed() ? "true" : "false";
        }

        public Date getDate() {
            return this.m.ids.getReferenceTime();
        }

        public String getComplete() {
            try {
                return this.m.isTablesComplete() ? "true" : "false";
            }
            catch (IOException e) {
                return "exception";
            }
        }

        public String getBitsOk() {
            try {
                return this.m.isBitCountOk() ? "true" : "false";
            }
            catch (Exception e) {
                return "exception";
            }
        }

        public String getLocal() {
            try {
                return this.m.usesLocalTable() ? "true" : "false";
            }
            catch (Exception e) {
                return "exception";
            }
        }
    }
}

