/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.ui.BAMutil;
import thredds.ui.IndependentDialog;
import thredds.ui.TextHistoryPane;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.StationCollection;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.point.StationRegionDateChooser;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointFeatureDatasetViewer
extends JPanel {
    private static Logger log = LoggerFactory.getLogger(PointFeatureDatasetViewer.class);
    private PreferencesExt prefs;
    private FeatureCollection selectedCollection;
    private FeatureType selectedType;
    private BeanTableSorted fcTable;
    private BeanTableSorted profileTable;
    private BeanTableSorted stnTable;
    private BeanTableSorted stnProfileTable;
    private BeanTableSorted trajTable;
    private JPanel changingPane = new JPanel(new BorderLayout());
    private StationRegionDateChooser stationMap;
    private StructureTable obsTable;
    private JSplitPane splitFeatures;
    private JSplitPane splitMap;
    private JSplitPane splitObs;
    private IndependentDialog infoWindow;
    private TextHistoryPane infoTA;
    private DateFormatter df = new DateFormatter();
    private boolean eventsOK = true;
    private boolean debugStationRegionSelect = false;
    private boolean debugQuery = false;
    private int maxCount = 100;

    public PointFeatureDatasetViewer(PreferencesExt prefs) {
        this.prefs = prefs;
        this.stationMap = new StationRegionDateChooser();
        this.stationMap.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Station")) {
                    StationBean selectedStation = (StationBean)e.getNewValue();
                    if (PointFeatureDatasetViewer.this.debugStationRegionSelect) {
                        System.out.println("selectedStation= " + selectedStation.getName());
                    }
                    PointFeatureDatasetViewer.this.eventsOK = false;
                    PointFeatureDatasetViewer.this.stnTable.setSelectedBean(selectedStation);
                    PointFeatureDatasetViewer.this.eventsOK = true;
                }
            }
        });
        AbstractAction queryAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PointFeatureDatasetViewer.this.selectedCollection == null) {
                    return;
                }
                DateRange dateRange = PointFeatureDatasetViewer.this.stationMap.getDateRange();
                if (PointFeatureDatasetViewer.this.debugQuery) {
                    System.out.println("date range=" + dateRange);
                }
                LatLonRect geoRegion = null;
                StationBean selectedStation = null;
                boolean useRegion = PointFeatureDatasetViewer.this.stationMap.getGeoSelectionMode();
                if (useRegion) {
                    geoRegion = PointFeatureDatasetViewer.this.stationMap.getGeoSelectionLL();
                    if (PointFeatureDatasetViewer.this.debugQuery) {
                        System.out.println("geoRegion=" + geoRegion);
                    }
                } else {
                    selectedStation = (StationBean)PointFeatureDatasetViewer.this.stationMap.getSelectedStation();
                }
                try {
                    if (selectedStation != null) {
                        PointFeatureDatasetViewer.this.setStation(selectedStation, dateRange);
                    } else if (useRegion) {
                        PointFeatureDatasetViewer.this.subset(geoRegion, dateRange);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(queryAction, "query", "query for data", false, 81, -1);
        this.stationMap.addToolbarAction(queryAction);
        AbstractAction getallAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PointFeatureDatasetViewer.this.selectedCollection == null) {
                    return;
                }
                try {
                    PointFeatureDatasetViewer.this.setObservationsAll();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(getallAction, "GetAll", "get ALL data", false, 65, -1);
        this.stationMap.addToolbarAction(getallAction);
        this.fcTable = new BeanTableSorted(FeatureCollectionBean.class, (PreferencesExt)prefs.node("FeatureCollectionBean"), false);
        this.fcTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FeatureCollectionBean fcb = (FeatureCollectionBean)PointFeatureDatasetViewer.this.fcTable.getSelectedBean();
                try {
                    PointFeatureDatasetViewer.this.setFeatureCollection(fcb);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(null, "Error reading FeatureCollection " + fcb.fc.getName() + " error=" + e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        this.profileTable = new BeanTableSorted(ProfileFeatureBean.class, (PreferencesExt)prefs.node("ProfileFeatureBean"), false);
        this.profileTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ProfileFeatureBean sb = (ProfileFeatureBean)PointFeatureDatasetViewer.this.profileTable.getSelectedBean();
                try {
                    PointFeatureDatasetViewer.this.setProfile(sb);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.stnTable = new BeanTableSorted(StationBean.class, (PreferencesExt)prefs.node("StationBeans"), false);
        this.stnTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                StationBean sb = (StationBean)PointFeatureDatasetViewer.this.stnTable.getSelectedBean();
                try {
                    PointFeatureDatasetViewer.this.setStation(sb, null);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (PointFeatureDatasetViewer.this.eventsOK) {
                    PointFeatureDatasetViewer.this.stationMap.setSelectedStation(sb.getName());
                }
            }
        });
        this.stnProfileTable = new BeanTableSorted(StnProfileFeatureBean.class, (PreferencesExt)prefs.node("StnProfileFeatureBean"), false);
        this.stnProfileTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                StnProfileFeatureBean sb = (StnProfileFeatureBean)PointFeatureDatasetViewer.this.stnProfileTable.getSelectedBean();
                try {
                    PointFeatureDatasetViewer.this.setStnProfile(sb);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.trajTable = new BeanTableSorted(TrajectoryFeatureBean.class, (PreferencesExt)prefs.node("TrajFeatureBean"), false);
        this.trajTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TrajectoryFeatureBean sb = (TrajectoryFeatureBean)PointFeatureDatasetViewer.this.trajTable.getSelectedBean();
                try {
                    PointFeatureDatasetViewer.this.setTrajectory(sb);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.obsTable = new StructureTable((PreferencesExt)prefs.node("ObsBean"));
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentDialog(null, true, "Station Information", this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.splitFeatures = new JSplitPane(0, false, this.fcTable, this.changingPane);
        this.splitFeatures.setDividerLocation(prefs.getInt("splitPosF", 50));
        this.splitMap = new JSplitPane(1, false, this.splitFeatures, this.stationMap);
        this.splitMap.setDividerLocation(prefs.getInt("splitPosM", 400));
        this.splitObs = new JSplitPane(0, false, this.splitMap, this.obsTable);
        this.splitObs.setDividerLocation(prefs.getInt("splitPosO", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitObs, "Center");
    }

    public void save() {
        this.fcTable.saveState(false);
        this.stnTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPosO", this.splitObs.getDividerLocation());
        this.prefs.putInt("splitPosF", this.splitFeatures.getDividerLocation());
        this.prefs.putInt("splitPosM", this.splitMap.getDividerLocation());
        this.obsTable.saveState();
    }

    public void setDataset(FeatureDatasetPoint dataset) {
        this.infoTA.clear();
        this.stnTable.setBeans(new ArrayList());
        this.stationMap.setStations(new ArrayList());
        this.obsTable.clear();
        ArrayList<FeatureCollectionBean> fcBeans = new ArrayList<FeatureCollectionBean>();
        for (FeatureCollection fc : dataset.getPointFeatureCollectionList()) {
            FeatureType ftype = fc.getCollectionFeatureType();
            if (ftype != FeatureType.POINT && ftype != FeatureType.PROFILE && ftype != FeatureType.STATION && ftype != FeatureType.TRAJECTORY && ftype != FeatureType.STATION_PROFILE) continue;
            fcBeans.add(new FeatureCollectionBean(fc));
        }
        if (fcBeans.size() == 0) {
            JOptionPane.showMessageDialog(null, "No PointFeatureCollections found that could be displayed");
        }
        this.fcTable.setBeans(fcBeans);
        this.infoTA.clear();
    }

    private void setFeatureCollection(FeatureCollectionBean fcb) throws IOException {
        this.changingPane.removeAll();
        FeatureType ftype = fcb.fc.getCollectionFeatureType();
        if (ftype == FeatureType.POINT) {
            PointFeatureCollection pfc = (PointFeatureCollection)fcb.fc;
            this.setPointCollection(pfc);
            this.changingPane.add((Component)this.stnTable, "Center");
        } else if (ftype == FeatureType.PROFILE) {
            ProfileFeatureCollection pfc = (ProfileFeatureCollection)fcb.fc;
            this.setProfileCollection(pfc);
            this.changingPane.add((Component)this.stnTable, "Center");
        } else if (ftype == FeatureType.STATION) {
            StationCollection sfc = (StationCollection)((Object)fcb.fc);
            this.setStations(sfc);
            this.changingPane.add((Component)this.stnTable, "Center");
        } else if (ftype == FeatureType.STATION_PROFILE) {
            StationCollection sfc = (StationCollection)((Object)fcb.fc);
            this.setStations(sfc);
            JSplitPane splitExtra = new JSplitPane(0, false, this.stnTable, this.stnProfileTable);
            splitExtra.setDividerLocation(this.prefs.getInt("splitPosX", 50));
            this.changingPane.add((Component)splitExtra, "Center");
        } else if (ftype == FeatureType.TRAJECTORY) {
            TrajectoryFeatureCollection pfc = (TrajectoryFeatureCollection)fcb.fc;
            this.setTrajectoryCollection(pfc);
            this.changingPane.add((Component)this.stnTable, "Center");
        }
        this.selectedCollection = fcb.fc;
        this.selectedType = ftype;
    }

    private void setStations(StationCollection stationCollection) {
        ArrayList<StationBean> stationBeans = new ArrayList<StationBean>();
        try {
            List<Station> stations = stationCollection.getStations();
            if (stations == null) {
                return;
            }
            for (Station station : stations) {
                stationBeans.add(new StationBean(station));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        this.stnTable.setBeans(stationBeans);
        this.stationMap.setStations(stationBeans);
        this.obsTable.clear();
    }

    private void setPointCollection(PointFeatureCollection pointCollection) throws IOException {
        ArrayList<PointObsBean> pointBeans = new ArrayList<PointObsBean>();
        int count = 0;
        PointFeatureIterator iter = pointCollection.getPointFeatureIterator(-1);
        while (iter.hasNext()) {
            PointFeature pob = iter.next();
            pointBeans.add(new PointObsBean(count++, pob, this.df));
        }
        this.stnTable.setBeans(pointBeans);
        this.stationMap.setStations(pointBeans);
        this.stnTable.clearSelectedCells();
    }

    private void setProfileCollection(ProfileFeatureCollection profileCollection) throws IOException {
        ArrayList<ProfileFeatureBean> beans = new ArrayList<ProfileFeatureBean>();
        PointFeatureCollectionIterator iter = profileCollection.getPointFeatureCollectionIterator(-1);
        while (iter.hasNext()) {
            PointFeatureCollection pob = iter.next();
            beans.add(new ProfileFeatureBean((ProfileFeature)pob));
        }
        this.stnTable.setBeans(beans);
        this.stationMap.setStations(beans);
        this.stnTable.clearSelectedCells();
    }

    private void setTrajectoryCollection(TrajectoryFeatureCollection trajCollection) throws IOException {
        ArrayList<TrajectoryFeatureBean> beans = new ArrayList<TrajectoryFeatureBean>();
        PointFeatureCollectionIterator iter = trajCollection.getPointFeatureCollectionIterator(-1);
        while (iter.hasNext()) {
            PointFeatureCollection pob = iter.next();
            beans.add(new TrajectoryFeatureBean((TrajectoryFeature)pob));
        }
        this.stnTable.setBeans(beans);
        this.stationMap.setStations(beans);
        this.stnTable.clearSelectedCells();
    }

    private void subset(LatLonRect geoRegion, DateRange dateRange) throws IOException {
        PointFeatureCollection pc = null;
        if (this.selectedType == FeatureType.STATION) {
            StationTimeSeriesFeatureCollection stationCollection = (StationTimeSeriesFeatureCollection)this.selectedCollection;
            pc = stationCollection.flatten(geoRegion, dateRange);
        }
        if (this.selectedType == FeatureType.STATION_PROFILE) {
            StationProfileFeatureCollection stationProfileCollection = (StationProfileFeatureCollection)this.selectedCollection;
            pc = stationProfileCollection.flatten(geoRegion, dateRange);
        }
        if (null != pc) {
            this.setObservations(pc);
        }
    }

    private void setStation(StationBean sb, DateRange dr) throws IOException {
        if (this.selectedType == FeatureType.POINT) {
            PointObsBean pobsBean = (PointObsBean)sb;
            ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
            obsList.add(pobsBean.pobs);
            this.setObservations(obsList);
        } else if (this.selectedType == FeatureType.PROFILE) {
            ProfileFeatureBean profBean = (ProfileFeatureBean)sb;
            ProfileFeature feature = profBean.pfc;
            this.setObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        } else if (this.selectedType == FeatureType.STATION) {
            StationTimeSeriesFeatureCollection stationCollection = (StationTimeSeriesFeatureCollection)this.selectedCollection;
            StationTimeSeriesFeature feature = stationCollection.getStationFeature(sb.s);
            if (dr != null) {
                feature = feature.subset(dr);
            }
            this.setObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        } else if (this.selectedType == FeatureType.STATION_PROFILE) {
            StationProfileFeatureCollection stationCollection = (StationProfileFeatureCollection)this.selectedCollection;
            StationProfileFeature feature = stationCollection.getStationProfileFeature(sb.s);
            this.setStnProfileObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        } else if (this.selectedType == FeatureType.TRAJECTORY) {
            TrajectoryFeatureBean trajBean = (TrajectoryFeatureBean)sb;
            TrajectoryFeature feature = trajBean.pfc;
            this.setObservations(feature);
            int npts = feature.size();
            if (npts >= 0) {
                sb.setNobs(npts);
            }
        }
    }

    private void setStnProfile(StnProfileFeatureBean sb) throws IOException {
        ProfileFeature feature = sb.pfc;
        this.setObservations(feature);
        int npts = feature.size();
        if (npts >= 0) {
            sb.setNobs(npts);
        }
    }

    private void setProfile(ProfileFeatureBean sb) throws IOException {
        ProfileFeature feature = sb.pfc;
        this.setObservations(feature);
        int npts = feature.size();
        if (npts >= 0) {
            sb.setNobs(npts);
            this.stnTable.refresh();
        }
    }

    private void setTrajectory(TrajectoryFeatureBean sb) throws IOException {
        TrajectoryFeature feature = sb.pfc;
        this.setObservations(feature);
        int npts = feature.size();
        if (npts >= 0) {
            sb.setNobs(npts);
            this.stnTable.refresh();
        }
    }

    private void setStnProfiles(List<PointFeatureCollection> pfcList) throws IOException {
        ArrayList<StnProfileFeatureBean> beans = new ArrayList<StnProfileFeatureBean>();
        for (PointFeatureCollection pfc : pfcList) {
            beans.add(new StnProfileFeatureBean((ProfileFeature)pfc));
        }
        this.stnProfileTable.setBeans(beans);
        this.obsTable.clear();
    }

    private void setObservationsAll() throws IOException {
        if (this.selectedType == FeatureType.POINT) {
            PointFeatureCollection pointCollection = (PointFeatureCollection)this.selectedCollection;
            this.setObservations(pointCollection);
        } else if (this.selectedType == FeatureType.STATION) {
            StationTimeSeriesFeatureCollection stationCollection = (StationTimeSeriesFeatureCollection)this.selectedCollection;
            PointFeatureCollectionIterator iter = stationCollection.getPointFeatureCollectionIterator(-1);
            ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
            int count = 0;
            while (iter.hasNext() && count++ < this.maxCount) {
                obsList.add((PointFeature)((Object)iter.next()));
            }
            this.setObservations(obsList);
        } else if (this.selectedType == FeatureType.STATION_PROFILE) {
            StationProfileFeatureCollection stationCollection = (StationProfileFeatureCollection)this.selectedCollection;
            PointFeatureCollectionIterator iter = stationCollection.getPointFeatureCollectionIterator(-1);
            ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
            int count = 0;
            while (iter.hasNext() && count++ < this.maxCount) {
                obsList.add((PointFeature)((Object)iter.next()));
            }
            this.setObservations(obsList);
        }
    }

    private void setObservations(PointFeatureCollection pointCollection) throws IOException {
        PointFeatureIterator iter = pointCollection.getPointFeatureIterator(-1);
        ArrayList<PointFeature> obsList = new ArrayList<PointFeature>();
        int count = 0;
        while (iter.hasNext() && count++ < this.maxCount) {
            obsList.add(iter.next());
        }
        this.setObservations(obsList);
    }

    private void setStnProfileObservations(NestedPointFeatureCollection nestedPointCollection) throws IOException {
        PointFeatureCollectionIterator iter = nestedPointCollection.getPointFeatureCollectionIterator(-1);
        ArrayList<PointFeatureCollection> pfcList = new ArrayList<PointFeatureCollection>();
        while (iter.hasNext()) {
            pfcList.add(iter.next());
        }
        this.setStnProfiles(pfcList);
    }

    private void setObservations(List<PointFeature> obsList) throws IOException {
        if (obsList.size() == 0) {
            this.obsTable.clear();
            return;
        }
        this.obsTable.setPointFeatureData(obsList);
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public static class PointObsBean
    extends StationBean {
        private PointFeature pobs;
        private String timeObs;
        private int id;
        private DateFormatter df;

        public PointObsBean(int id, PointFeature obs, DateFormatter df) {
            this.id = id;
            this.pobs = obs;
            this.df = df;
            this.setTime(obs.getObservationTimeAsDate());
        }

        public String getTime() {
            return this.timeObs;
        }

        public void setTime(Date timeObs) {
            this.timeObs = this.df.toDateTimeString(timeObs);
        }

        public String getName() {
            return Integer.toString(this.id);
        }

        public String getDescription() {
            return null;
        }

        public String getWmoId() {
            return null;
        }

        public double getLatitude() {
            return this.pobs.getLocation().getLatitude();
        }

        public double getLongitude() {
            return this.pobs.getLocation().getLongitude();
        }

        public double getAltitude() {
            return this.pobs.getLocation().getAltitude();
        }

        public LatLonPoint getLatLon() {
            return new LatLonPointImpl(this.getLatitude(), this.getLongitude());
        }

        public boolean isMissing() {
            return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
        }

        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public class ProfileFeatureBean
    extends StationBean {
        int npts;
        ProfileFeature pfc;
        PointFeature pf;

        public ProfileFeatureBean(ProfileFeature pfc) {
            this.pfc = pfc;
            try {
                if (pfc.hasNext()) {
                    this.pf = pfc.next();
                }
            }
            catch (IOException ioe) {
                log.warn("Trajectory empty ", ioe);
            }
            this.npts = pfc.size();
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        public int getNobs() {
            return this.npts;
        }

        public String getName() {
            return this.pfc.getName();
        }

        public String getDescription() {
            return null;
        }

        public String getWmoId() {
            return null;
        }

        public double getLatitude() {
            return this.pf.getLocation().getLatitude();
        }

        public double getLongitude() {
            return this.pf.getLocation().getLongitude();
        }

        public double getAltitude() {
            return this.pf.getLocation().getAltitude();
        }

        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class TrajectoryFeatureBean
    extends StationBean {
        int npts;
        TrajectoryFeature pfc;
        PointFeature pf;

        public TrajectoryFeatureBean(TrajectoryFeature pfc) {
            this.pfc = pfc;
            try {
                if (pfc.hasNext()) {
                    this.pf = pfc.next();
                }
            }
            catch (IOException ioe) {
                log.warn("Trajectory empty ", ioe);
            }
            this.npts = pfc.size();
        }

        public static String hiddenProperties() {
            return "latLon";
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        public int getNobs() {
            return this.npts;
        }

        public String getName() {
            return this.pfc.getName();
        }

        public String getDescription() {
            return null;
        }

        public String getWmoId() {
            return null;
        }

        public double getLatitude() {
            return this.pf.getLocation().getLatitude();
        }

        public double getLongitude() {
            return this.pf.getLocation().getLongitude();
        }

        public double getAltitude() {
            return this.pf.getLocation().getAltitude();
        }

        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class StationBean
    implements Station {
        private Station s;
        private int npts = -1;

        public StationBean() {
        }

        public StationBean(Station s) {
            this.s = s;
        }

        public static String hiddenProperties() {
            return "latLon";
        }

        public String getName() {
            return this.s.getName();
        }

        public String getDescription() {
            return this.s.getDescription();
        }

        public int getNobs() {
            return this.npts;
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        public String getWmoId() {
            return "";
        }

        public double getLatitude() {
            return this.s.getLatitude();
        }

        public double getLongitude() {
            return this.s.getLongitude();
        }

        public double getAltitude() {
            return this.s.getAltitude();
        }

        public LatLonPoint getLatLon() {
            return this.s.getLatLon();
        }

        public boolean isMissing() {
            return this.s.isMissing();
        }

        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public class StnProfileFeatureBean {
        ProfileFeature pfc;
        int npts;

        public StnProfileFeatureBean(ProfileFeature pfc) {
            this.pfc = pfc;
            this.npts = pfc.size();
        }

        public String getProfileName() {
            return this.pfc.getName();
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        public int getNobs() {
            return this.npts;
        }

        public double getLatitude() {
            return this.pfc.getLatLon().getLatitude();
        }

        public double getLongitude() {
            return this.pfc.getLatLon().getLongitude();
        }
    }

    public class FeatureCollectionBean {
        FeatureCollection fc;

        public FeatureCollectionBean(FeatureCollection fc) {
            this.fc = fc;
        }

        public String getName() {
            return this.fc.getName();
        }

        public String getFeatureType() {
            return this.fc.getCollectionFeatureType().toString();
        }
    }
}

