/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import ucar.nc2.units.TimeUnit;
import ucar.units.ConversionException;
import ucar.units.ScaledUnit;
import ucar.units.Unit;
import ucar.units.UnitDB;
import ucar.units.UnitDBManager;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;
import ucar.units.UnitName;
import ucar.units.UnknownUnit;

public class SimpleUnit {
    public static SimpleUnit kmUnit;
    public static SimpleUnit meterUnit;
    protected static UnitFormat format;
    protected static Unit secsUnit;
    protected static Unit dateUnit;
    protected static boolean debugParse;
    protected Unit uu = null;

    public static SimpleUnit factory(String name) {
        try {
            return SimpleUnit.factoryWithExceptions(name);
        }
        catch (Exception e) {
            if (debugParse) {
                System.out.println("Parse " + name + " got Exception " + e);
            }
            return null;
        }
    }

    public static SimpleUnit factoryWithExceptions(String name) throws Exception {
        Unit uu = format.parse(name);
        if (SimpleUnit.isTimeUnit(uu)) {
            return new TimeUnit(name);
        }
        return new SimpleUnit(uu);
    }

    protected static Unit makeUnit(String name) throws Exception {
        return format.parse(name);
    }

    public static boolean isCompatible(String unitString1, String unitString2) {
        Unit uu2;
        Unit uu1;
        try {
            uu1 = format.parse(unitString1);
        }
        catch (Exception e) {
            if (debugParse) {
                System.out.println("Parse " + unitString1 + " got Exception1 " + e);
            }
            return false;
        }
        try {
            uu2 = format.parse(unitString2);
        }
        catch (Exception e) {
            if (debugParse) {
                System.out.println("Parse " + unitString2 + " got Exception2 " + e);
            }
            return false;
        }
        return uu1.isCompatible(uu2);
    }

    public static boolean isCompatibleWithExceptions(String unitString1, String unitString2) throws Exception {
        Unit uu1 = format.parse(unitString1);
        Unit uu2 = format.parse(unitString2);
        return uu1.isCompatible(uu2);
    }

    public static boolean isDateUnit(Unit uu) {
        boolean ok = uu.isCompatible(dateUnit);
        if (!ok) {
            return false;
        }
        try {
            uu.getConverterTo(dateUnit);
            return true;
        }
        catch (ConversionException e) {
            return false;
        }
    }

    public static boolean isTimeUnit(Unit uu) {
        return uu.isCompatible(secsUnit);
    }

    public static boolean isDateUnit(String unitString) {
        SimpleUnit su = SimpleUnit.factory(unitString);
        return su != null && SimpleUnit.isDateUnit(su.getUnit());
    }

    public static boolean isTimeUnit(String unitString) {
        SimpleUnit su = SimpleUnit.factory(unitString);
        return su != null && SimpleUnit.isTimeUnit(su.getUnit());
    }

    public static double getConversionFactor(String inputUnitString, String outputUnitString) throws IllegalArgumentException {
        SimpleUnit inputUnit = SimpleUnit.factory(inputUnitString);
        SimpleUnit outputUnit = SimpleUnit.factory(outputUnitString);
        return inputUnit.convertTo(1.0, outputUnit);
    }

    protected SimpleUnit() {
    }

    SimpleUnit(Unit uu) {
        this.uu = uu;
    }

    public String toString() {
        return ((Object)this.uu).toString();
    }

    public Unit getUnit() {
        return this.uu;
    }

    public double convertTo(double value, SimpleUnit outputUnit) throws IllegalArgumentException {
        try {
            return this.uu.convertTo(value, outputUnit.getUnit());
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean isCompatible(String unitString) {
        Unit uuWant;
        try {
            uuWant = format.parse(unitString);
        }
        catch (Exception e) {
            if (debugParse) {
                System.out.println("Parse " + unitString + " got Exception1 " + e);
            }
            return false;
        }
        return this.uu.isCompatible(uuWant);
    }

    public boolean isUnknownUnit() {
        ScaledUnit scu;
        Unit u;
        Unit uu = this.getUnit();
        if (uu instanceof UnknownUnit) {
            return true;
        }
        return uu instanceof ScaledUnit && (u = (scu = (ScaledUnit)uu).getUnit()) instanceof UnknownUnit;
    }

    public double getValue() {
        if (!(this.uu instanceof ScaledUnit)) {
            return Double.NaN;
        }
        ScaledUnit offset = (ScaledUnit)this.uu;
        return offset.getScale();
    }

    public String getUnitString() {
        return this.uu.getDerivedUnit().toString();
    }

    public String getCanonicalString() {
        return this.uu.getCanonicalString();
    }

    public String getImplementingClass() {
        return this.uu.getClass().getName();
    }

    static {
        debugParse = false;
        try {
            format = UnitFormatManager.instance();
            secsUnit = format.parse("sec");
            dateUnit = format.parse("secs since 1970-01-01 00:00:00");
            UnitDB unitDB = UnitDBManager.instance();
            Unit u = format.parse("millibar");
            Unit alias = u.clone(UnitName.newUnitName("mb"));
            unitDB.addUnit(alias);
            kmUnit = SimpleUnit.factoryWithExceptions("km");
            meterUnit = SimpleUnit.factoryWithExceptions("m");
        }
        catch (Exception e) {
            System.out.println("SimpleUnit initialization failed " + e);
            throw new RuntimeException("SimpleUnit initialization failed " + e);
        }
    }
}

