/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import ucar.nc2.util.net.EasySSLProtocolSocketFactory;

public class HttpClientManager {
    private static boolean debug = false;
    private static HttpClient _client;
    private static int timeout;

    public static HttpClient init(CredentialsProvider provider, String userAgent) {
        HttpClientManager.initHttpClient();
        if (provider != null) {
            _client.getParams().setParameter("http.authentication.credential-provider", provider);
        }
        if (userAgent != null) {
            _client.getParams().setParameter("http.useragent", userAgent + "/NetcdfJava/HttpClient");
        } else {
            _client.getParams().setParameter("http.useragent", "NetcdfJava/HttpClient");
        }
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            _client.getHostConfiguration().setProxy(proxyHost, Integer.parseInt(proxyPort));
        }
        return _client;
    }

    public static HttpClient getHttpClient() {
        return _client;
    }

    private static synchronized void initHttpClient() {
        if (_client != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        _client = new HttpClient(connectionManager);
        HttpClientParams params = _client.getParams();
        params.setParameter("http.socket.timeout", timeout);
        params.setParameter("http.protocol.allow-circular-redirects", Boolean.TRUE);
        params.setParameter("http.protocol.cookie-policy", "rfc2109");
        Protocol.registerProtocol("https", new Protocol("https", new EasySSLProtocolSocketFactory(), 8443));
    }

    public static void clearState() {
        _client.getState().clearCookies();
        _client.getState().clearCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String urlString) throws IOException {
        String string;
        GetMethod m = new GetMethod(urlString);
        m.setFollowRedirects(true);
        try {
            _client.executeMethod(m);
            string = m.getResponseBodyAsString();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            m.releaseConnection();
            throw throwable;
        }
        m.releaseConnection();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int putContent(String urlString, String content) throws IOException {
        int n;
        PutMethod m = new PutMethod(urlString);
        m.setDoAuthentication(true);
        try {
            Header locationHeader;
            m.setRequestEntity(new StringRequestEntity(content));
            _client.executeMethod(m);
            int resultCode = m.getStatusCode();
            if (resultCode == 302 && (locationHeader = m.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                if (debug) {
                    System.out.println("***Follow Redirection = " + redirectLocation);
                }
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            n = resultCode;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            m.releaseConnection();
            throw throwable;
        }
        m.releaseConnection();
        return n;
    }

    static {
        timeout = 0;
    }
}

