/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ucar.unidata.geoloc.Earth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EarthEllipsoid
extends Earth {
    public static final EarthEllipsoid WGS84 = new EarthEllipsoid("WGS84", 7030, 6378137.0, 0.0033528106647474805);
    public static final EarthEllipsoid Airy1830 = new EarthEllipsoid("Airy 1830", 7001, 6377563.396, 0.0033408506414970775);
    private static Map<String, EarthEllipsoid> hash;
    private static List<EarthEllipsoid> list;
    private String name;
    private int epsgId;

    protected EarthEllipsoid(String name, int epsgId, double a, double f) {
        super(a, f, true);
        this.name = name;
        this.epsgId = epsgId;
        if (hash == null) {
            hash = new LinkedHashMap<String, EarthEllipsoid>(10);
        }
        hash.put(name, this);
        EarthEllipsoid.getAll().add(this);
    }

    public static Collection<EarthEllipsoid> getAll() {
        if (list == null) {
            list = new ArrayList<EarthEllipsoid>();
        }
        return list;
    }

    public static EarthEllipsoid getType(String name) {
        if (name == null) {
            return null;
        }
        if (hash == null) {
            hash = new LinkedHashMap<String, EarthEllipsoid>(10);
        }
        return hash.get(name);
    }

    public static EarthEllipsoid getType(int epsgId) {
        Collection<EarthEllipsoid> all = EarthEllipsoid.getAll();
        for (EarthEllipsoid ellipsoid : all) {
            if (ellipsoid.epsgId != epsgId) continue;
            return ellipsoid;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getEpsgId() {
        return this.epsgId;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarthEllipsoid)) {
            return false;
        }
        EarthEllipsoid oe = (EarthEllipsoid)o;
        return oe.name.equals(this.name);
    }
}

