/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import ucar.unidata.io.RandomAccessFile;

public class InMemoryRandomAccessFile
extends RandomAccessFile {
    public InMemoryRandomAccessFile(String name, byte[] data) {
        super(1);
        this.location = name;
        this.file = null;
        if (data == null) {
            throw new IllegalArgumentException("data array is null");
        }
        this.buffer = data;
        this.bufferStart = 0L;
        this.dataSize = this.buffer.length;
        this.dataEnd = this.buffer.length;
        this.filePosition = 0L;
        this.endOfFile = false;
        if (debugLeaks) {
            openFiles.add(this.location);
        }
    }

    public long length() {
        return this.dataEnd;
    }

    protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
        len = Math.min(len, (int)((long)this.buffer.length - pos));
        System.arraycopy(this.buffer, (int)pos, b, offset, len);
        return len;
    }

    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        return dest.write(ByteBuffer.wrap(this.buffer, (int)offset, (int)nbytes));
    }
}

