/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.DerivedUnit;
import ucar.units.DerivedUnitImpl;
import ucar.units.Factor;
import ucar.units.NameException;
import ucar.units.OffsetUnit;
import ucar.units.OperationException;
import ucar.units.ParseException;
import ucar.units.Prefix;
import ucar.units.PrefixDB;
import ucar.units.PrefixDBException;
import ucar.units.PrefixDBManager;
import ucar.units.ScaledUnit;
import ucar.units.SimpleCharStream;
import ucar.units.SpecificationException;
import ucar.units.StandardUnitFormatConstants;
import ucar.units.StandardUnitFormatTokenManager;
import ucar.units.TimeScaleUnit;
import ucar.units.Token;
import ucar.units.TokenMgrError;
import ucar.units.Unit;
import ucar.units.UnitClassException;
import ucar.units.UnitDB;
import ucar.units.UnitDBAccessException;
import ucar.units.UnitDBException;
import ucar.units.UnitFormatImpl;
import ucar.units.UnitParseException;
import ucar.units.UnitSystemException;
import ucar.units.UnitSystemManager;
import ucar.units.UnknownUnit;

public final class StandardUnitFormat
extends UnitFormatImpl
implements StandardUnitFormatConstants {
    private boolean isTimeUnit;
    private static StandardUnitFormat _instance;
    private static final long julianDayOrigin;
    private static final SimpleDateFormat dateFormat;
    private static final Comparator factorComparator;
    public StandardUnitFormatTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[22];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[9];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private StandardUnitFormat() {
        this(new StringReader(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardUnitFormat instance() {
        if (_instance != null) return _instance;
        Class<StandardUnitFormat> clazz = StandardUnitFormat.class;
        synchronized (StandardUnitFormat.class) {
            if (_instance != null) return _instance;
            _instance = new StandardUnitFormat();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public Unit parse(String spec, UnitDB unitDB) throws UnitParseException, SpecificationException, UnitDBException, PrefixDBException, UnitSystemException {
        this.ReInit(new StringReader(spec.trim()));
        try {
            Unit unit = this.unitSpec(unitDB);
            return unit;
        }
        catch (TokenMgrError e) {
            throw new UnitParseException(spec, e.getMessage());
        }
        catch (ParseException e) {
            throw new UnitParseException(spec, e.getMessage());
        }
        catch (OperationException e) {
            throw new SpecificationException(spec, e.getMessage());
        }
    }

    public StringBuffer format(Factor factor, StringBuffer buf) {
        return buf.append(factor.toString());
    }

    public StringBuffer format(Unit unit, StringBuffer buf) throws UnitClassException {
        return this.format(unit, buf, true);
    }

    public StringBuffer longFormat(Unit unit, StringBuffer buf) throws UnitClassException {
        return this.format(unit, buf, false);
    }

    private StringBuffer format(Unit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        boolean done = false;
        if (!normalize) {
            String id = unit.getSymbol();
            if (id == null) {
                id = unit.getName();
            }
            if (id != null) {
                buf.append(id.replace(' ', '_'));
                done = true;
            }
        }
        if (!done) {
            if (unit instanceof BaseUnit) {
                this.format((BaseUnit)unit, buf);
            } else if (unit instanceof DerivedUnit) {
                this.format((DerivedUnit)unit, buf);
            } else if (unit instanceof ScaledUnit) {
                this.format((ScaledUnit)unit, buf, normalize);
            } else if (unit instanceof OffsetUnit) {
                this.format((OffsetUnit)unit, buf, normalize);
            } else if (unit instanceof TimeScaleUnit) {
                this.format((TimeScaleUnit)unit, buf, normalize);
            } else {
                throw new UnitClassException(unit);
            }
        }
        return buf;
    }

    private StringBuffer format(BaseUnit baseUnit, StringBuffer buf) {
        return buf.append(baseUnit.getSymbol());
    }

    private StringBuffer format(DerivedUnit unit, StringBuffer buf) {
        Factor[] factors = unit.getDimension().getFactors();
        Arrays.sort(factors, factorComparator);
        for (int i = 0; i < factors.length; ++i) {
            this.format(factors[i], buf).append('.');
        }
        if (factors.length != 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf;
    }

    private StringBuffer format(ScaledUnit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        double scale = unit.getScale();
        if (scale != 0.0) {
            if (scale == 1.0) {
                this.format(unit.getUnit(), buf, normalize);
            } else {
                buf.append(scale).append(' ');
                int start = buf.length();
                this.format(unit.getUnit(), buf, normalize);
                if (start == buf.length()) {
                    buf.setLength(start - 1);
                }
            }
        }
        return buf;
    }

    private StringBuffer format(OffsetUnit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        double offset = unit.getOffset();
        if (offset != 0.0) {
            int start = buf.length();
            this.format(unit.getUnit(), buf, normalize);
            return (StandardUnitFormat.isBlackSpace(buf, start) ? buf : buf.insert(start, '(').append(')')).append(" @ ").append(offset);
        }
        this.format(unit.getUnit(), buf, normalize);
        return buf;
    }

    private boolean contains(StringBuffer buf, int start, char[] chars) {
        int n = buf.length();
        for (int i = start; i < n; ++i) {
            char c = buf.charAt(i);
            for (int j = 0; j < chars.length; ++j) {
                if (c != chars[j]) continue;
                return true;
            }
        }
        return false;
    }

    private StringBuffer formatBinaryUnit(Unit first, Unit second, char separator, StringBuffer buf, boolean normalize) throws UnitClassException {
        int start = buf.length();
        this.group(first, buf, normalize);
        if (start < buf.length()) {
            buf.append(separator);
        }
        this.group(second, buf, normalize);
        if (buf.charAt(buf.length() - 1) == separator) {
            buf.setLength(buf.length() - 1);
        }
        return buf;
    }

    private StringBuffer group(Unit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        int start = buf.length();
        this.format(unit, buf, normalize);
        if (!StandardUnitFormat.isBlackSpace(buf, start)) {
            buf.insert(start, '(');
            buf.append(')');
        }
        return buf;
    }

    private static boolean isBlackSpace(StringBuffer buf, int start) {
        return buf.substring(start).indexOf(32) == -1;
    }

    private StringBuffer format(TimeScaleUnit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        return this.format(unit.getUnit(), buf, normalize).append(dateFormat.format(unit.getOrigin()));
    }

    private static long julianDay(int year, int month, int day) {
        int jm;
        int jy;
        long igreg = 588829L;
        if (year == 0) {
            year = 1;
        }
        int iy = year;
        if (year < 0) {
            ++iy;
        }
        if (month > 2) {
            jy = iy;
            jm = month + 1;
        } else {
            jy = iy - 1;
            jm = month + 13;
        }
        long julday = day + (int)(30.6001 * (double)jm);
        if (jy >= 0) {
            julday += (long)(365 * jy);
            julday = (long)((double)julday + 0.25 * (double)jy);
        } else {
            double xi = 365.25 * (double)jy;
            if ((double)((int)xi) != xi) {
                xi -= 1.0;
            }
            julday += (long)((int)xi);
        }
        julday += 1720995L;
        if ((long)(day + 31 * (month + 12 * iy)) >= igreg) {
            int ja = jy / 100;
            julday -= (long)ja;
            julday += 2L;
            julday += (long)(ja / 4);
        }
        return julday;
    }

    private static double toDouble(int year, int month, int day, int hour, int minute, float second, int zone) {
        return (double)(StandardUnitFormat.julianDay(year, month, day) - julianDayOrigin) * 86400.0 + (double)((hour * 60 + minute - zone) * 60) + (double)second;
    }

    private static Unit getUnit(UnitDB unitDB, String string) throws UnitDBAccessException {
        return unitDB.get(string);
    }

    private static Prefix getPrefix(String string) throws PrefixDBException {
        PrefixDB prefixDB = PrefixDBManager.instance();
        Prefix prefix = prefixDB.getPrefixByName(string);
        if (prefix == null) {
            prefix = prefixDB.getPrefixBySymbol(string);
        }
        return prefix;
    }

    public static void main(String[] args) throws Exception {
        StandardUnitFormat parser = StandardUnitFormat.instance();
        LineNumberReader lineInput = new LineNumberReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("Enter a unit specification or ^D to quit: ");
            String spec = lineInput.readLine();
            if (spec == null) break;
            try {
                System.out.println(parser.parse(spec.trim()));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println("");
    }

    public final Unit unitSpec(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit = DerivedUnitImpl.DIMENSIONLESS;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                unit = this.unitTerm(unitDB);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        return unit;
    }

    public final Unit unitTerm(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit = this.unitFactor(unitDB);
        block14: while (this.jj_2_1(1)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 3: 
                        case 14: 
                        case 15: {
                            if (this.jj_2_2(2)) {
                                this.jj_consume_token(3);
                                break;
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 14: {
                                    this.jj_consume_token(14);
                                    break block4;
                                }
                                case 15: {
                                    this.jj_consume_token(15);
                                    break block4;
                                }
                            }
                            this.jj_la1[1] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                        }
                    }
                    Unit unit2 = this.unitFactor(unitDB);
                    unit = unit.multiplyBy(unit2);
                    continue block14;
                }
                case 5: {
                    this.jj_consume_token(5);
                    Unit unit2 = this.unitFactor(unitDB);
                    unit = unit.divideBy(unit2);
                    continue block14;
                }
            }
            this.jj_la1[3] = this.jj_gen;
            if (this.isTimeUnit) {
                Date timestamp = this.timeOriginExpression();
                unit = new TimeScaleUnit(unit, timestamp);
                continue;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    double origin = this.numericalOriginExpression();
                    unit = new OffsetUnit(unit, origin);
                    continue block14;
                }
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return unit;
    }

    public final Unit unitFactor(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 14: 
            case 18: 
            case 19: {
                double scale = this.number();
                unit = new ScaledUnit(scale);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        unit = this.unitIdentifier(unitDB);
                        break;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        unit = this.unitTerm(unitDB);
                        this.jj_consume_token(17);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (!this.jj_2_3(2)) break;
                int exponent = this.powerExpression();
                unit = unit.raiseTo(exponent);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.isTimeUnit = unit.isCompatible(UnitSystemManager.instance().getBaseUnit(BaseQuantity.TIME));
        return unit;
    }

    public final double numericalOriginExpression() throws ParseException {
        double origin = 0.0;
        this.jj_consume_token(6);
        origin = this.number();
        return origin;
    }

    public final double number() throws ParseException {
        int sign = 1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        double number = this.unsignedDecimal();
        if (this.jj_2_4(2)) {
            this.jj_consume_token(7);
            int exponent = this.integer();
            number *= Math.pow(10.0, exponent);
        }
        return sign == 1 ? number : -number;
    }

    public final int integer() throws ParseException {
        int sign = 1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        int integer = this.unsignedInteger();
        return sign == 1 ? integer : -integer;
    }

    public final int sign() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                return 1;
            }
            case 19: {
                this.jj_consume_token(19);
                return -1;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int unsignedInteger() throws ParseException {
        Token t = this.jj_consume_token(1);
        return Integer.parseInt(t.image);
    }

    public final double unsignedDecimal() throws ParseException {
        int integer = 0;
        double fraction = 0.0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                integer = this.unsignedInteger();
                if (!this.jj_2_6(2)) break;
                this.jj_consume_token(14);
                if (!this.jj_2_5(2)) break;
                Token t = this.jj_consume_token(1);
                fraction = new Double("." + t.image);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                Token t = this.jj_consume_token(1);
                fraction = new Double("." + t.image);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return (double)integer + fraction;
    }

    public final int powerExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        int exponent = this.integer();
        return exponent;
    }

    public final Unit unitIdentifier(UnitDB unitDB) throws ParseException, UnitDBException, UnitSystemException, PrefixDBException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                t = this.jj_consume_token(7);
                break;
            }
            case 8: {
                t = this.jj_consume_token(8);
                break;
            }
            case 10: {
                t = this.jj_consume_token(10);
                break;
            }
            case 11: {
                t = this.jj_consume_token(11);
                break;
            }
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String string = t.image;
        double scale = 1.0;
        Unit unit = StandardUnitFormat.getUnit(unitDB, string);
        while (unit == null) {
            Prefix prefix = StandardUnitFormat.getPrefix(string);
            if (prefix == null) {
                try {
                    unit = UnknownUnit.create(string);
                    break;
                }
                catch (NameException e) {
                    // empty catch block
                }
            }
            scale *= prefix.getValue();
            string = string.substring(prefix.length());
            unit = StandardUnitFormat.getUnit(unitDB, string);
        }
        if (scale != 1.0) {
            unit = new ScaledUnit(scale, unit);
        }
        return unit;
    }

    public final Date timeOriginExpression() throws ParseException {
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        double when = 0.0;
        int sign = 1;
        int zoneMinute = 0;
        int zone = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        year = this.integer();
        if (this.jj_2_9(2)) {
            this.jj_consume_token(19);
            month = this.unsignedInteger();
            this.jj_consume_token(19);
            day = this.unsignedInteger();
            if (this.jj_2_8(2)) {
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 3: {
                                this.jj_consume_token(3);
                                break block4;
                            }
                        }
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                hour = this.unsignedInteger();
                block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        minute = this.unsignedInteger();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                this.jj_consume_token(21);
                                double sec = this.unsignedDecimal();
                                second = (int)sec;
                                millisecond = (int)Math.round((sec - (double)second) * 1000.0);
                                break block10;
                            }
                        }
                        this.jj_la1[16] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                if (this.jj_2_7(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 3: {
                            this.jj_consume_token(3);
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 18: 
                        case 19: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 18: 
                                case 19: {
                                    sign = this.sign();
                                    break;
                                }
                                default: {
                                    this.jj_la1[19] = this.jj_gen;
                                }
                            }
                            int zoneHour = this.unsignedInteger();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    this.jj_consume_token(21);
                                    zoneMinute = this.unsignedInteger();
                                    break;
                                }
                                default: {
                                    this.jj_la1[20] = this.jj_gen;
                                }
                            }
                            if (zoneHour >= 100) {
                                zoneMinute += zoneHour % 100;
                                zoneHour /= 100;
                            }
                            zone = sign * (zoneHour * 60 + zoneMinute);
                            break;
                        }
                        case 10: {
                            this.jj_consume_token(10);
                            break;
                        }
                        case 8: {
                            this.jj_consume_token(8);
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
            }
        }
        if (month < 1 || month > 12 || day < 1 || day > 31 || hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 61 || zone < -1440 || zone > 1440) {
            throw new ParseException("invalid timestamp");
        }
        StringBuffer zoneId = new StringBuffer(12);
        zoneId.append("GMT");
        if (zone >= 0) {
            zoneId.append('+');
        } else {
            zoneId.append('-');
            zone = -zone;
        }
        zoneId.append(zone / 60);
        zoneId.append(':');
        if ((zone %= 60) < 10) {
            zoneId.append('0');
        }
        zoneId.append(zone);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(zoneId.toString()));
        calendar.clear();
        calendar.set(year, month - 1, day, hour, minute, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            Object var5_4 = null;
            this.jj_save(0, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(0, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(0, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            Object var5_4 = null;
            this.jj_save(1, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(1, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(1, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            Object var5_4 = null;
            this.jj_save(2, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(2, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(2, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            Object var5_4 = null;
            this.jj_save(3, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(3, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(3, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            Object var5_4 = null;
            this.jj_save(4, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(4, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(4, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            Object var5_4 = null;
            this.jj_save(5, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(5, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(5, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            Object var5_4 = null;
            this.jj_save(6, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(6, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(6, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            Object var5_4 = null;
            this.jj_save(7, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(7, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(7, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            Object var5_4 = null;
            this.jj_save(8, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(8, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(8, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_3R_24() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3_3() {
        return this.jj_3R_6();
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_29();
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_10();
    }

    private final boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_24()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_19() {
        return this.jj_3R_22();
    }

    private final boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_10() {
        return this.jj_scan_token(1);
    }

    private final boolean jj_3R_26() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_26()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_25() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_5() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_18() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_4() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_16()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_3() {
        return this.jj_scan_token(5);
    }

    private final boolean jj_3_2() {
        return this.jj_scan_token(3);
    }

    private final boolean jj_3R_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(14)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(15)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(8)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(7)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(8)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(10)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(11)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(12)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(13)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_3()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.isTimeUnit;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_4()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_5()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private final boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_27() {
        return this.jj_3R_21();
    }

    private final boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_28();
    }

    private final boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_9()) {
                return true;
            }
        }
        if (this.jj_3R_10()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_7();
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(6);
    }

    private final boolean jj_3R_31() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3_5() {
        return this.jj_scan_token(1);
    }

    private final boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(2)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{884098, 49152, 49160, 916906, 64, 81280, 884098, 786432, 786432, 786432, 16386, 0x100000, 15744, 68, 8, 4096, 0x200000, 0x200000, 8, 786432, 0x200000, 787714};
    }

    public StandardUnitFormat(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new StandardUnitFormatTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public StandardUnitFormat(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new StandardUnitFormatTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public StandardUnitFormat(StandardUnitFormatTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(StandardUnitFormatTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[22];
        for (i = 0; i < 22; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 22; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 22; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 9; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        julianDayOrigin = StandardUnitFormat.julianDay(2001, 1, 1);
        factorComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Factor f1 = (Factor)o1;
                Factor f2 = (Factor)o2;
                int comp = f2.getExponent() - f1.getExponent();
                if (comp == 0) {
                    comp = f1.getID().compareTo(f2.getID());
                }
                return comp;
            }
        };
        dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.applyPattern(" '@' yyyy-MM-dd HH:mm:ss.SSS 'UTC'");
        StandardUnitFormat.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

