/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.ContourStripSet;
import visad.Gridded3DSet;
import visad.PlotDigits;
import visad.VisADException;

class ContourStrip {
    static final int LBL_ALGM_THRESHHOLD = 20;
    static final int INTERP_THRESHHOLD = 4;
    int[] idx_array;
    int low_idx;
    int hi_idx;
    int lev_idx;
    private boolean isLabeled = false;
    private int start_break;
    private int stop_break;
    private int n_skip;
    int numLabels;
    boolean isDashed = false;
    PlotDigits plot;
    ContourStripSet css;
    float lbl_half;

    ContourStrip(int mxsize, int lev_idx, int idx0, int idx1, PlotDigits plot, ContourStripSet css) {
        this.idx_array = new int[mxsize];
        this.lev_idx = lev_idx;
        this.plot = plot;
        this.low_idx = mxsize / 2;
        this.hi_idx = this.low_idx + 1;
        this.idx_array[this.low_idx] = idx0;
        this.idx_array[this.hi_idx] = idx1;
        this.css = css;
        this.lbl_half = (css.plot_min_max[lev_idx][1] - css.plot_min_max[lev_idx][0]) / 2.0f;
        this.lbl_half = (float)((double)this.lbl_half + (double)this.lbl_half * 0.3);
    }

    ContourStrip(int[] idx_array, int lev_idx, PlotDigits plot, ContourStripSet css) {
        this.lev_idx = lev_idx;
        int mxsize = idx_array.length + 400;
        this.idx_array = new int[mxsize];
        this.plot = plot;
        this.low_idx = mxsize / 2 - idx_array.length / 2;
        this.hi_idx = this.low_idx + idx_array.length - 1;
        System.arraycopy(idx_array, 0, this.idx_array, this.low_idx, idx_array.length);
        this.css = css;
        this.lbl_half = (css.plot_min_max[lev_idx][1] - css.plot_min_max[lev_idx][0]) / 2.0f;
        this.lbl_half = (float)((double)this.lbl_half + (double)this.lbl_half * 0.3);
    }

    boolean addPair(float[] vx, float[] vy, int idx0, int idx1) {
        float vx0 = vx[idx0];
        float vy0 = vy[idx0];
        float vx1 = vx[idx1];
        float vy1 = vy[idx1];
        float vx_s = vx[this.idx_array[this.low_idx]];
        float vy_s = vy[this.idx_array[this.low_idx]];
        float dist = (vx0 - vx_s) * (vx0 - vx_s) + (vy0 - vy_s) * (vy0 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.low_idx < 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            --this.low_idx;
            this.idx_array[this.low_idx] = idx0;
            --this.low_idx;
            this.idx_array[this.low_idx] = idx1;
            return true;
        }
        dist = (vx1 - vx_s) * (vx1 - vx_s) + (vy1 - vy_s) * (vy1 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.low_idx < 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            --this.low_idx;
            this.idx_array[this.low_idx] = idx1;
            --this.low_idx;
            this.idx_array[this.low_idx] = idx0;
            return true;
        }
        vx_s = vx[this.idx_array[this.hi_idx]];
        vy_s = vy[this.idx_array[this.hi_idx]];
        dist = (vx0 - vx_s) * (vx0 - vx_s) + (vy0 - vy_s) * (vy0 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.hi_idx > this.idx_array.length - 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx0;
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx1;
            return true;
        }
        dist = (vx1 - vx_s) * (vx1 - vx_s) + (vy1 - vy_s) * (vy1 - vy_s);
        if ((double)dist <= 1.0E-5) {
            if (this.hi_idx > this.idx_array.length - 2) {
                int[] tmp = new int[this.idx_array.length + 200];
                System.arraycopy(this.idx_array, 0, tmp, 100, this.idx_array.length);
                this.idx_array = tmp;
                tmp = null;
                this.low_idx += 100;
                this.hi_idx += 100;
            }
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx1;
            ++this.hi_idx;
            this.idx_array[this.hi_idx] = idx0;
            return true;
        }
        return false;
    }

    void getLabeledLineColorArray(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, float[][][] out_vv, byte[][][] out_colors, float[][][][] out_vvL, byte[][][][] out_colorsL, float[][][] lbl_loc) {
        float[][] vv = this.getLineArray(vx, vy);
        byte[][] bb = this.getColorArray(colors);
        this.processLineArrays(vv, bb, labelColor, out_vv, out_colors, out_vvL, out_colorsL, lbl_loc);
    }

    void getInterpolatedLabeledColorArray(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, float[][][] out_vv, byte[][][] out_colors, float[][][][] out_vvL, byte[][][][] out_colorsL, float[][][] lbl_loc) {
        byte[][] bb = this.getColorArray(colors);
        byte[][] interp_bb = this.interpolateColorArray(bb);
        float[][] vv = this.getLineArray(vx, vy);
        float[][] interp_vv = this.interpolateLineArray(vv);
        int ptCnt = vv.length / 2;
        if (ptCnt < 4) {
            interp_bb = this.interpolateColorArray(interp_bb);
            interp_vv = this.interpolateLineArray(interp_vv);
        }
        this.processLineArrays(interp_vv, interp_bb, labelColor, out_vv, out_colors, out_vvL, out_colorsL, lbl_loc);
    }

    private void processLineArrays(float[][] vv_grid, byte[][] bb, byte[] labelColor, float[][][] out_vv, byte[][][] out_colors, float[][][][] out_vvL, byte[][][][] out_colorsL, float[][][] lbl_loc) {
        float[][] lbl_dcoords;
        byte[][] lbl_clr;
        float[] vxB_tmp;
        float[] vy_tmp;
        float[][] vv = null;
        try {
            vv = this.css.spatial_set.gridToValue(vv_grid);
        }
        catch (VisADException e) {
            System.out.println(e.getMessage());
        }
        int clr_dim = 0;
        if (bb != null) {
            clr_dim = bb.length;
        }
        int n_lbl = 1;
        out_vvL[0] = null;
        out_colorsL[0] = null;
        out_vvL[1] = null;
        out_colorsL[1] = null;
        lbl_loc[0] = null;
        out_vvL[2] = null;
        out_colorsL[2] = null;
        out_vvL[3] = null;
        out_colorsL[3] = null;
        lbl_loc[1] = null;
        lbl_loc[2] = null;
        out_vv[0] = vv;
        out_colors[0] = bb;
        out_vv[1] = null;
        out_colors[1] = null;
        int totalPts = vv[0].length / 2;
        if (totalPts > 20 && (this.lev_idx & 1) == 1 || this.css.n_levs == 1) {
            int cc;
            float ctr_dist;
            float dz;
            float dy;
            float dx;
            this.isLabeled = true;
            int loc = vv[0].length / 2;
            int n_pairs_b = 1;
            int n_pairs_f = 1;
            boolean found = false;
            int pos = loc;
            while (!found) {
                if ((pos -= 2) < 0 || pos > vv[0].length - 1) {
                    return;
                }
                dx = vv[0][pos] - vv[0][loc];
                dy = vv[1][pos] - vv[1][loc];
                dz = vv[2][pos] - vv[2][loc];
                ctr_dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (ctr_dist > (float)Math.abs((double)this.lbl_half)) {
                    found = true;
                    continue;
                }
                ++n_pairs_b;
            }
            pos = loc;
            found = false;
            while (!found) {
                if ((pos += 2) < 0 || pos > vv[0].length - 1) {
                    return;
                }
                dx = vv[0][pos] - vv[0][loc];
                dy = vv[1][pos] - vv[1][loc];
                dz = vv[2][pos] - vv[2][loc];
                ctr_dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (ctr_dist > (float)Math.abs((double)this.lbl_half)) {
                    found = true;
                    continue;
                }
                ++n_pairs_f;
            }
            this.n_skip = (n_pairs_b + n_pairs_f) * 2;
            if ((loc & 1) == 1) {
                this.start_break = loc - (1 + (n_pairs_b - 1) * 2);
                this.stop_break = loc + (2 + (n_pairs_f - 1) * 2);
            } else {
                this.start_break = loc - (2 + (n_pairs_b - 1) * 2);
                this.stop_break = loc + (1 + (n_pairs_f - 1) * 2);
            }
            float[] vx_tmp = new float[this.plot.NumVerts];
            vy_tmp = new float[this.plot.NumVerts];
            System.arraycopy(this.plot.Vx, 0, vx_tmp, 0, this.plot.NumVerts);
            System.arraycopy(this.plot.Vy, 0, vy_tmp, 0, this.plot.NumVerts);
            vxB_tmp = new float[this.plot.NumVerts];
            float[] vyB_tmp = new float[this.plot.NumVerts];
            System.arraycopy(this.plot.VxB, 0, vxB_tmp, 0, this.plot.NumVerts);
            System.arraycopy(this.plot.VyB, 0, vyB_tmp, 0, this.plot.NumVerts);
            lbl_clr = null;
            if (bb != null) {
                lbl_clr = new byte[clr_dim][this.plot.NumVerts];
            }
            boolean rotate = true;
            lbl_dcoords = null;
            if (rotate) {
                int kk;
                float[][] norm = null;
                Gridded3DSet cg3d = this.css.spatial_set;
                try {
                    norm = cg3d.getNormals(new float[][]{{vv_grid[0][loc]}, {vv_grid[1][loc]}});
                }
                catch (VisADException e) {
                    System.out.println(e.getMessage());
                }
                if (norm[2][0] < 0.0f) {
                    norm[0][0] = -norm[0][0];
                    norm[1][0] = -norm[1][0];
                    norm[2][0] = -norm[2][0];
                }
                float del_z = vv[2][this.stop_break] - vv[2][this.start_break];
                float del_y = vv[1][this.stop_break] - vv[1][this.start_break];
                float del_x = vv[0][this.stop_break] - vv[0][this.start_break];
                float mag = (float)Math.sqrt(del_y * del_y + del_x * del_x + del_z * del_z);
                float[] fArray = new float[]{del_x / mag, del_y / mag, del_z / mag};
                float[] ctr_u = fArray;
                if (ctr_u[0] < 0.0f) {
                    ctr_u[0] = -ctr_u[0];
                    ctr_u[1] = -ctr_u[1];
                    ctr_u[2] = -ctr_u[2];
                }
                float[] norm_x_ctr = new float[]{norm[1][0] * ctr_u[2] - norm[2][0] * ctr_u[1], -(norm[0][0] * ctr_u[2] - norm[2][0] * ctr_u[0]), norm[0][0] * ctr_u[1] - norm[1][0] * ctr_u[0]};
                mag = (float)Math.sqrt(norm_x_ctr[0] * norm_x_ctr[0] + norm_x_ctr[1] * norm_x_ctr[1] + norm_x_ctr[2] * norm_x_ctr[2]);
                norm_x_ctr[0] = norm_x_ctr[0] / mag;
                norm_x_ctr[1] = norm_x_ctr[1] / mag;
                norm_x_ctr[2] = norm_x_ctr[2] / mag;
                if (Math.abs((double)norm[2][0]) <= 1.0E-5) {
                    if (norm_x_ctr[2] < 0.0f) {
                        norm_x_ctr[0] = -norm_x_ctr[0];
                        norm_x_ctr[1] = -norm_x_ctr[1];
                        norm_x_ctr[2] = -norm_x_ctr[2];
                    }
                } else if (norm_x_ctr[1] < 0.0f) {
                    norm_x_ctr[0] = -norm_x_ctr[0];
                    norm_x_ctr[1] = -norm_x_ctr[1];
                    norm_x_ctr[2] = -norm_x_ctr[2];
                }
                lbl_dcoords = new float[3][this.plot.NumVerts];
                for (kk = 0; kk < this.plot.NumVerts; ++kk) {
                    lbl_dcoords[0][kk] = vx_tmp[kk] * ctr_u[0] + vyB_tmp[kk] * norm_x_ctr[0];
                    lbl_dcoords[1][kk] = vx_tmp[kk] * ctr_u[1] + vyB_tmp[kk] * norm_x_ctr[1];
                    lbl_dcoords[2][kk] = vx_tmp[kk] * ctr_u[2] + vyB_tmp[kk] * norm_x_ctr[2];
                }
                kk = 0;
                while (kk < this.plot.NumVerts) {
                    float[] fArray2 = lbl_dcoords[0];
                    int n = kk;
                    fArray2[n] = fArray2[n] + vv[0][loc];
                    float[] fArray3 = lbl_dcoords[1];
                    int n2 = kk;
                    fArray3[n2] = fArray3[n2] + vv[1][loc];
                    float[] fArray4 = lbl_dcoords[2];
                    int n3 = kk++;
                    fArray4[n3] = fArray4[n3] + vv[2][loc];
                }
            }
            int kk = 0;
            while (kk < this.plot.NumVerts) {
                int n = kk;
                vx_tmp[n] = vx_tmp[n] + vv[0][loc];
                int n4 = kk;
                vy_tmp[n4] = vy_tmp[n4] + vv[1][loc];
                int n5 = kk;
                vxB_tmp[n5] = vxB_tmp[n5] + vv[0][loc];
                int n6 = kk++;
                vyB_tmp[n6] = vyB_tmp[n6] + vv[1][loc];
            }
            if (labelColor != null) {
                for (kk = 0; kk < this.plot.NumVerts; ++kk) {
                    lbl_clr[0][kk] = labelColor[0];
                    lbl_clr[1][kk] = labelColor[1];
                    lbl_clr[2][kk] = labelColor[2];
                    if (clr_dim != 4) continue;
                    lbl_clr[3][kk] = labelColor[3];
                }
            } else if (bb != null) {
                for (kk = 0; kk < this.plot.NumVerts; ++kk) {
                    lbl_clr[0][kk] = bb[0][loc];
                    lbl_clr[1][kk] = bb[1][loc];
                    lbl_clr[2][kk] = bb[2][loc];
                    if (clr_dim != 4) continue;
                    lbl_clr[3][kk] = bb[3][loc];
                }
            }
            out_vvL[0] = new float[n_lbl][][];
            out_colorsL[0] = new byte[n_lbl][][];
            out_vvL[1] = new float[n_lbl][][];
            out_colorsL[1] = new byte[n_lbl][][];
            lbl_loc[0] = new float[n_lbl][7];
            lbl_loc[0][0][0] = vv[0][loc];
            lbl_loc[0][0][1] = vv[1][loc];
            lbl_loc[0][0][2] = vv[2][loc];
            out_vv[0] = new float[3][vv[0].length - this.n_skip];
            out_vv[1] = new float[3][this.n_skip];
            if (bb != null) {
                out_colors[0] = new byte[clr_dim][bb[0].length - this.n_skip];
                out_colors[1] = new byte[clr_dim][this.n_skip];
            }
            int s_pos = 0;
            int d_pos = 0;
            int cnt = this.start_break;
            System.arraycopy(vv[0], s_pos, out_vv[0][0], d_pos, cnt);
            System.arraycopy(vv[1], s_pos, out_vv[0][1], d_pos, cnt);
            System.arraycopy(vv[2], s_pos, out_vv[0][2], d_pos, cnt);
            if (bb != null) {
                for (int cc2 = 0; cc2 < clr_dim; ++cc2) {
                    System.arraycopy(bb[cc2], s_pos, out_colors[0][cc2], d_pos, cnt);
                }
            }
            s_pos = this.start_break;
            d_pos = 0;
            cnt = this.n_skip;
            System.arraycopy(vv[0], s_pos, out_vv[1][0], d_pos, cnt);
            System.arraycopy(vv[1], s_pos, out_vv[1][1], d_pos, cnt);
            System.arraycopy(vv[2], s_pos, out_vv[1][2], d_pos, cnt);
            if (bb != null) {
                for (int cc3 = 0; cc3 < clr_dim; ++cc3) {
                    System.arraycopy(bb[cc3], s_pos, out_colors[1][cc3], d_pos, cnt);
                }
            }
            s_pos = this.stop_break + 1;
            d_pos = this.start_break;
            cnt = vv[0].length - s_pos;
            System.arraycopy(vv[0], s_pos, out_vv[0][0], d_pos, cnt);
            System.arraycopy(vv[1], s_pos, out_vv[0][1], d_pos, cnt);
            System.arraycopy(vv[2], s_pos, out_vv[0][2], d_pos, cnt);
            if (bb != null) {
                for (int cc4 = 0; cc4 < clr_dim; ++cc4) {
                    System.arraycopy(bb[cc4], s_pos, out_colors[0][cc4], d_pos, cnt);
                }
            }
            out_vvL[2] = new float[n_lbl][3][2];
            out_vvL[3] = new float[n_lbl][3][2];
            lbl_loc[1] = new float[n_lbl][3];
            lbl_loc[2] = new float[n_lbl][3];
            if (bb != null) {
                out_colorsL[2] = new byte[n_lbl][clr_dim][2];
                out_colorsL[3] = new byte[n_lbl][clr_dim][2];
            }
            s_pos = this.start_break;
            d_pos = 0;
            cnt = 2;
            lbl_loc[1][0][0] = vv[0][s_pos];
            lbl_loc[1][0][1] = vv[1][s_pos];
            lbl_loc[1][0][2] = vv[2][s_pos];
            float dx2 = vv[0][loc] - vv[0][s_pos];
            float dy2 = vv[1][loc] - vv[1][s_pos];
            float dz2 = vv[2][loc] - vv[2][s_pos];
            float dd = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
            dx2 /= dd;
            dy2 /= dd;
            dz2 /= dd;
            float mm = dd - (float)Math.abs((double)this.lbl_half);
            dx2 *= mm;
            dy2 *= mm;
            dz2 *= mm;
            out_vvL[2][0][0][0] = vv[0][s_pos];
            out_vvL[2][0][1][0] = vv[1][s_pos];
            out_vvL[2][0][2][0] = vv[2][s_pos];
            out_vvL[2][0][0][1] = vv[0][s_pos] + dx2;
            out_vvL[2][0][1][1] = vv[1][s_pos] + dy2;
            out_vvL[2][0][2][1] = vv[2][s_pos] + dz2;
            lbl_loc[0][0][3] = this.lbl_half;
            lbl_loc[0][0][4] = dd;
            if (bb != null) {
                for (cc = 0; cc < clr_dim; ++cc) {
                    System.arraycopy(bb[cc], s_pos, out_colorsL[2][0][cc], d_pos, cnt);
                }
            }
            s_pos = this.stop_break - 1;
            d_pos = 0;
            cnt = 2;
            lbl_loc[2][0][0] = vv[0][this.stop_break];
            lbl_loc[2][0][1] = vv[1][this.stop_break];
            lbl_loc[2][0][2] = vv[2][this.stop_break];
            dx2 = vv[0][loc] - vv[0][this.stop_break];
            dy2 = vv[1][loc] - vv[1][this.stop_break];
            dz2 = vv[2][loc] - vv[2][this.stop_break];
            dd = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
            dx2 /= dd;
            dy2 /= dd;
            dz2 /= dd;
            mm = dd - (float)Math.abs((double)this.lbl_half);
            dx2 *= mm;
            dy2 *= mm;
            dz2 *= mm;
            out_vvL[3][0][0][0] = vv[0][this.stop_break];
            out_vvL[3][0][1][0] = vv[1][this.stop_break];
            out_vvL[3][0][2][0] = vv[2][this.stop_break];
            out_vvL[3][0][0][1] = vv[0][this.stop_break] + dx2;
            out_vvL[3][0][1][1] = vv[1][this.stop_break] + dy2;
            out_vvL[3][0][2][1] = vv[2][this.stop_break] + dz2;
            lbl_loc[0][0][5] = this.lbl_half;
            lbl_loc[0][0][6] = dd;
            if (bb != null) {
                for (cc = 0; cc < clr_dim; ++cc) {
                    System.arraycopy(bb[cc], s_pos, out_colorsL[3][0][cc], d_pos, cnt);
                }
            }
        } else {
            out_vv[0] = vv;
            out_colors[0] = bb;
            out_vv[1] = null;
            out_colors[1] = null;
            return;
        }
        out_vvL[0][0] = new float[3][];
        out_vvL[0][0][0] = lbl_dcoords[0];
        out_vvL[0][0][1] = vy_tmp;
        out_colorsL[0][0] = lbl_clr;
        out_vvL[1][0] = new float[3][];
        out_vvL[1][0][0] = vxB_tmp;
        out_vvL[1][0][1] = lbl_dcoords[1];
        out_colorsL[1][0] = lbl_clr;
        out_vvL[0][0][2] = lbl_dcoords[2];
        out_vvL[1][0][2] = lbl_dcoords[2];
    }

    float[][] getLineArray(float[] vx, float[] vy) {
        if (vx == null || vy == null) {
            return null;
        }
        float[] vvx = new float[this.hi_idx - this.low_idx + 1];
        float[] vvy = new float[vvx.length];
        int kk = this.low_idx;
        int ii = 0;
        while (kk <= this.hi_idx) {
            vvx[ii] = vx[this.idx_array[kk]];
            vvy[ii] = vy[this.idx_array[kk]];
            ++kk;
            ++ii;
        }
        return new float[][]{vvx, vvy};
    }

    float[][][] getLineStripArrays(float[] vx, float[] vy) {
        int count = this.hi_idx - this.low_idx + 1;
        int lenBefore = this.start_break / 2 + 1;
        int lenAfter = (count - this.stop_break + 1) / 2;
        if (this.isLabeled && lenBefore >= 2 && lenAfter >= 2) {
            float[][] vvBefore = new float[2][lenBefore];
            vvBefore[0][0] = vx[this.idx_array[this.low_idx]];
            vvBefore[1][0] = vy[this.idx_array[this.low_idx]];
            int kk = this.low_idx + 1;
            for (int ii = 1; ii < vvBefore[0].length; ++ii) {
                vvBefore[0][ii] = vx[this.idx_array[kk]];
                vvBefore[1][ii] = vy[this.idx_array[kk]];
                kk += 2;
            }
            float[][] vvAfter = new float[2][lenAfter];
            vvAfter[0][0] = vx[this.idx_array[kk += this.n_skip - 1]];
            vvAfter[1][0] = vy[this.idx_array[kk]];
            ++kk;
            for (int ii = 1; ii < vvAfter[0].length; ++ii) {
                vvAfter[0][ii] = vx[this.idx_array[kk]];
                vvAfter[1][ii] = vy[this.idx_array[kk]];
                kk += 2;
            }
            return new float[][][]{vvBefore, vvAfter};
        }
        float[][] vv = null;
        vv = count == 2 ? new float[2][count] : new float[2][count / 2 + 1];
        vv[0][0] = vx[this.idx_array[this.low_idx]];
        vv[1][0] = vy[this.idx_array[this.low_idx]];
        int kk = this.low_idx + 1;
        int ii = 1;
        while (kk <= this.hi_idx) {
            vv[0][ii] = vx[this.idx_array[kk]];
            vv[1][ii] = vy[this.idx_array[kk]];
            kk += 2;
            ++ii;
        }
        return new float[][][]{vv};
    }

    byte[][] getColorArray(byte[][] colors) {
        if (colors == null) {
            return null;
        }
        int clr_dim = colors.length;
        int clr_len = this.hi_idx - this.low_idx + 1;
        byte[][] new_colors = new byte[clr_dim][clr_len];
        int ii = 0;
        for (int kk = this.low_idx; kk <= this.hi_idx; ++kk) {
            for (int cc = 0; cc < clr_dim; ++cc) {
                new_colors[cc][ii] = colors[cc][this.idx_array[kk]];
            }
            ++ii;
        }
        return new_colors;
    }

    byte[][][] getColorStripArrays(byte[][] colors) {
        int clrDim = colors.length;
        int count = this.hi_idx - this.low_idx + 1;
        int lenBefore = this.start_break / 2 + 1;
        int lenAfter = (count - this.stop_break + 1) / 2;
        if (this.isLabeled && lenBefore >= 2 && lenAfter >= 2) {
            int cc;
            byte[][] colorsBefore = new byte[clrDim][this.start_break / 2 + 1];
            for (int cc2 = 0; cc2 < clrDim; ++cc2) {
                colorsBefore[cc2][0] = colors[cc2][this.idx_array[this.low_idx]];
            }
            int kk = this.low_idx + 1;
            for (int ii = 1; ii < colorsBefore[0].length; ++ii) {
                for (cc = 0; cc < clrDim; ++cc) {
                    colorsBefore[cc][ii] = colors[cc][this.idx_array[kk]];
                }
                kk += 2;
            }
            kk += this.n_skip - 1;
            byte[][] colorsAfter = new byte[clrDim][(count - this.stop_break + 1) / 2];
            for (cc = 0; cc < clrDim; ++cc) {
                colorsAfter[cc][0] = colors[cc][this.idx_array[kk]];
            }
            ++kk;
            for (int ii = 1; ii < colorsAfter[0].length; ++ii) {
                for (int cc3 = 0; cc3 < clrDim; ++cc3) {
                    colorsAfter[cc3][ii] = colors[cc3][this.idx_array[kk]];
                }
                kk += 2;
            }
            return new byte[][][]{colorsBefore, colorsAfter};
        }
        byte[][] bb = null;
        bb = count == 2 ? new byte[clrDim][count] : new byte[clrDim][count / 2 + 1];
        for (int cc = 0; cc < clrDim; ++cc) {
            bb[cc][0] = colors[cc][this.idx_array[this.low_idx]];
        }
        int ii = 1;
        int kk = this.low_idx + 1;
        while (kk <= this.hi_idx) {
            for (int cc = 0; cc < clrDim; ++cc) {
                bb[cc][ii] = colors[cc][this.idx_array[kk]];
            }
            kk += 2;
            ++ii;
        }
        return new byte[][][]{bb};
    }

    boolean isLabeled() {
        return this.isLabeled;
    }

    float[][] getDashedLineArray(float[][] vv) {
        int X = 0;
        int Y = 1;
        int len = vv[0].length;
        float[][] interp = new float[2][len];
        for (int i = 0; i < vv[0].length; i += 2) {
            float vxa = vv[X][i + 1];
            float vya = vv[Y][i + 1];
            float vxb = vv[X][i];
            float vyb = vv[Y][i];
            interp[X][i + 1] = (3.0f * vxa + vxb) * 0.25f;
            interp[Y][i + 1] = (3.0f * vya + vyb) * 0.25f;
            interp[X][i] = (vxa + 3.0f * vxb) * 0.25f;
            interp[Y][i] = (vya + 3.0f * vyb) * 0.25f;
        }
        return interp;
    }

    float[][] interpolateLineArray(float[][] vv) {
        int X = 0;
        int Y = 1;
        int len = vv[0].length * 2;
        float[][] interp = new float[2][len];
        int i = 0;
        int j = 0;
        while (i < vv[0].length) {
            interp[X][j] = vv[X][i];
            interp[Y][j] = vv[Y][i];
            interp[X][j + 1] = vv[X][i] + 0.5f * (vv[X][i + 1] - vv[X][i]);
            interp[Y][j + 1] = vv[Y][i] + 0.5f * (vv[Y][i + 1] - vv[Y][i]);
            interp[X][j + 2] = interp[X][j + 1];
            interp[Y][j + 2] = interp[Y][j + 1];
            interp[X][j + 3] = vv[X][i + 1];
            interp[Y][j + 3] = vv[Y][i + 1];
            i += 2;
            j += 4;
        }
        return interp;
    }

    byte[][] interpolateColorArray(byte[][] colors) {
        if (colors == null) {
            return null;
        }
        byte[][] interp = new byte[colors.length][colors[0].length * 2];
        int i = 0;
        int j = 0;
        while (i < colors[0].length) {
            for (int k = 0; k < colors.length; ++k) {
                byte avg = (byte)((colors[k][i] + colors[k][i + 1]) / 2);
                interp[k][j] = colors[k][i];
                interp[k][j + 1] = avg;
                interp[k][j + 2] = avg;
                interp[k][j + 3] = colors[k][i + 1];
            }
            i += 2;
            j += 4;
        }
        return interp;
    }

    ContourStrip merge(ContourStrip c_strp) {
        if (this.lev_idx != c_strp.lev_idx) {
            System.out.println("Contour2D.ContourStrip.merge: !BIG ATTENTION!");
        }
        int[] new_idx_array = null;
        int[] thisLo = new int[2];
        int[] thisHi = new int[2];
        int[] thatLo = new int[2];
        int[] thatHi = new int[2];
        thisLo[0] = this.idx_array[this.low_idx];
        thisLo[1] = this.idx_array[this.low_idx + 1];
        thisHi[0] = this.idx_array[this.hi_idx];
        thisHi[1] = this.idx_array[this.hi_idx - 1];
        thatLo[0] = c_strp.idx_array[c_strp.low_idx];
        thatLo[1] = c_strp.idx_array[c_strp.low_idx + 1];
        thatHi[0] = c_strp.idx_array[c_strp.hi_idx];
        thatHi[1] = c_strp.idx_array[c_strp.hi_idx - 1];
        if (thisLo[0] == thatLo[0] || thisLo[0] == thatLo[1] || thisLo[1] == thatLo[0] || thisLo[1] == thatLo[1]) {
            int kk;
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            for (kk = this.hi_idx; kk >= this.low_idx; --kk) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
            }
            for (kk = c_strp.low_idx + 2; kk <= c_strp.hi_idx; ++kk) {
                new_idx_array[ii] = c_strp.idx_array[kk];
                ++ii;
            }
        } else if (thisLo[0] == thatHi[0] || thisLo[0] == thatHi[1] || thisLo[1] == thatHi[0] || thisLo[1] == thatHi[1]) {
            int kk;
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            for (kk = this.hi_idx; kk >= this.low_idx; --kk) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
            }
            for (kk = c_strp.hi_idx - 2; kk >= c_strp.low_idx; --kk) {
                new_idx_array[ii] = c_strp.idx_array[kk];
                ++ii;
            }
        } else if (thisHi[0] == thatHi[0] || thisHi[0] == thatHi[1] || thisHi[1] == thatHi[0] || thisHi[1] == thatHi[1]) {
            int kk;
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            for (kk = this.low_idx; kk <= this.hi_idx; ++kk) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
            }
            for (kk = c_strp.hi_idx - 2; kk >= c_strp.low_idx; --kk) {
                new_idx_array[ii] = c_strp.idx_array[kk];
                ++ii;
            }
        } else if (thisHi[0] == thatLo[0] || thisHi[0] == thatLo[1] || thisHi[1] == thatLo[0] || thisHi[1] == thatLo[1]) {
            int kk;
            int new_length = this.hi_idx - this.low_idx + 1 + (c_strp.hi_idx - c_strp.low_idx) + 1;
            new_idx_array = new int[new_length -= 2];
            int ii = 0;
            for (kk = this.low_idx; kk <= this.hi_idx; ++kk) {
                new_idx_array[ii] = this.idx_array[kk];
                ++ii;
            }
            for (kk = c_strp.low_idx + 2; kk <= c_strp.hi_idx; ++kk) {
                new_idx_array[ii] = c_strp.idx_array[kk];
                ++ii;
            }
        } else {
            return null;
        }
        return new ContourStrip(new_idx_array, this.lev_idx, this.plot, this.css);
    }

    public String toString() {
        return "(" + this.idx_array[this.low_idx] + "," + this.idx_array[this.low_idx + 1] + "), (" + this.idx_array[this.hi_idx] + "," + this.idx_array[this.hi_idx - 1] + ")";
    }
}

