/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import visad.ContourQuadSet;
import visad.ContourStrip;
import visad.Gridded3DSet;
import visad.PlotDigits;
import visad.VisADException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContourStripSet {
    static final int DEFAULT_DASH_VALUE = 2;
    static final int DISABLE_DASH_VALUE = -1;
    int mxsize;
    float[] levels;
    int[][] labelIndexes;
    int n_levs;
    int nr;
    int nc;
    Gridded3DSet spatial_set;
    Vector<ContourStrip>[] vecArray;
    Vector<ContourStrip> vec;
    PlotDigits[] plot_s;
    float[][] plot_min_max;
    boolean[] swap;
    ContourQuadSet[] qSet;
    int contourDifficulty = 0;
    private float[] gridX;
    private float[] gridY;
    private byte[][] gridColors;

    ContourStripSet(int size, float[] levels, boolean[] swap, double scale_ratio, double label_size, int nr, int nc, Gridded3DSet spatial_set, int contourDifficulty) throws VisADException {
        int kk;
        this.mxsize = 40 * size;
        this.levels = levels;
        this.n_levs = levels.length;
        this.labelIndexes = new int[this.n_levs][];
        this.vecArray = new Vector[this.n_levs];
        this.plot_s = new PlotDigits[this.n_levs];
        this.plot_min_max = new float[this.n_levs][2];
        float fac = (float)(0.15 * (1.0 / scale_ratio) * label_size);
        this.nr = nr;
        this.nc = nc;
        this.swap = swap;
        this.spatial_set = spatial_set;
        this.contourDifficulty = contourDifficulty;
        for (kk = 0; kk < this.n_levs; ++kk) {
            this.vecArray[kk] = new Vector();
            PlotDigits plot = new PlotDigits();
            plot.Number = levels[kk];
            plot.plotdigits(levels[kk], 0.0f, 0.0f, fac * 1.0f, fac * 1.0f, 400, new boolean[]{false, false, false});
            float[][] tmp = new float[][]{plot.Vx, plot.Vy};
            plot.Vx = tmp[1];
            plot.Vy = tmp[0];
            tmp[0] = plot.VxB;
            tmp[1] = plot.VyB;
            plot.VxB = tmp[1];
            plot.VyB = tmp[0];
            float vx_min = Float.MAX_VALUE;
            float vy_min = Float.MAX_VALUE;
            float vx_max = -3.4028235E38f;
            float vy_max = -3.4028235E38f;
            float vxB_min = Float.MAX_VALUE;
            float vyB_min = Float.MAX_VALUE;
            float vxB_max = -3.4028235E38f;
            float vyB_max = -3.4028235E38f;
            for (int ii = 0; ii < plot.NumVerts; ++ii) {
                if (plot.Vx[ii] < vx_min) {
                    vx_min = plot.Vx[ii];
                }
                if (plot.Vy[ii] < vy_min) {
                    vy_min = plot.Vy[ii];
                }
                if (plot.Vx[ii] > vx_max) {
                    vx_max = plot.Vx[ii];
                }
                if (plot.Vy[ii] > vy_max) {
                    vy_max = plot.Vy[ii];
                }
                if (plot.VxB[ii] < vxB_min) {
                    vxB_min = plot.VxB[ii];
                }
                if (plot.VyB[ii] < vyB_min) {
                    vyB_min = plot.VyB[ii];
                }
                if (plot.VxB[ii] > vxB_max) {
                    vxB_max = plot.VxB[ii];
                }
                if (!(plot.VyB[ii] > vyB_max)) continue;
                vyB_max = plot.VyB[ii];
            }
            float t_x = (vx_max - vx_min) / 2.0f + vx_min;
            float t_y = (vy_max - vy_min) / 2.0f + vy_min;
            float t_xB = (vxB_max - vxB_min) / 2.0f + vxB_min;
            float t_yB = (vyB_max - vyB_min) / 2.0f + vyB_min;
            int ii = 0;
            while (ii < plot.NumVerts) {
                int n = ii;
                plot.Vx[n] = plot.Vx[n] - t_x;
                int n2 = ii;
                plot.Vy[n2] = plot.Vy[n2] - t_y;
                int n3 = ii;
                plot.VxB[n3] = plot.VxB[n3] - t_xB;
                int n4 = ii++;
                plot.VyB[n4] = plot.VyB[n4] - t_yB;
            }
            this.plot_s[kk] = plot;
            if (!swap[0]) {
                this.plot_min_max[kk][0] = vy_min;
                this.plot_min_max[kk][1] = vy_max;
            } else {
                this.plot_min_max[kk][0] = vx_min;
                this.plot_min_max[kk][1] = vx_max;
            }
            this.plot_min_max[kk][0] = vx_min;
            this.plot_min_max[kk][1] = vx_max;
        }
        this.qSet = new ContourQuadSet[this.n_levs];
        for (kk = 0; kk < this.n_levs; ++kk) {
            this.qSet[kk] = new ContourQuadSet(nr, nc, kk, this);
        }
    }

    void setGridValues(float[] gx, float[] gy) {
        this.gridX = gx;
        this.gridY = gy;
    }

    void setGridColors(byte[][] colors) {
        this.gridColors = colors;
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, int lev_idx, int ir, int ic) {
        this.qSet[lev_idx].add(idx0, ir, ic);
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, float level) {
        int lev_idx = 0;
        for (int kk = 0; kk < this.n_levs; ++kk) {
            if (level != this.levels[kk]) continue;
            lev_idx = kk;
        }
        this.add(vx, vy, idx0, idx1, lev_idx);
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, int lev_idx) {
        this.vec = this.vecArray[lev_idx];
        int n_strip = this.vec.size();
        if (n_strip == 0) {
            ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
            this.vec.add(c_strp);
        } else {
            int[] found_array = new int[3];
            int found = 0;
            for (int kk = 0; kk < n_strip; ++kk) {
                ContourStrip c_strp = this.vec.get(kk);
                if (!c_strp.addPair(vx, vy, idx0, idx1)) continue;
                found_array[found] = kk;
                ++found;
            }
            if (found == 3) {
                ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
                this.vec.add(c_strp);
            } else if (found == 2) {
                ContourStrip c_strpA = this.vec.get(found_array[0]);
                ContourStrip c_strpB = this.vec.get(found_array[1]);
                ContourStrip c_strp = c_strpA.merge(c_strpB);
                this.vec.add(c_strp);
                this.vec.remove(c_strpA);
                this.vec.remove(c_strpB);
            } else if (found == 0) {
                ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
                this.vec.add(c_strp);
            }
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, int lev_idx, float[][][] out_vv, byte[][][] out_bb, float[][][][] out_vvL, byte[][][][] out_bbL, float[][][] out_loc, boolean[] dashed) {
        int kk;
        int tt;
        int mm;
        int n_strips = this.vecArray[lev_idx].size();
        float[][][][] la = new float[n_strips][2][][];
        byte[][][][] ca = new byte[n_strips][2][][];
        float[][][][][] laL = new float[n_strips][4][][][];
        byte[][][][][] caL = new byte[n_strips][4][][][];
        float[][][][] locL = new float[n_strips][3][][];
        for (int kk2 = 0; kk2 < n_strips; ++kk2) {
            ContourStrip cs = this.vecArray[lev_idx].get(kk2);
            cs.isDashed = dashed[lev_idx];
            cs.getLabeledLineColorArray(vx, vy, colors, labelColor, la[kk2], ca[kk2], laL[kk2], caL[kk2], locL[kk2]);
        }
        for (int tt2 = 0; tt2 < 2; ++tt2) {
            int mm2;
            int len = 0;
            for (int mm3 = 0; mm3 < n_strips; ++mm3) {
                if (la[mm3][tt2] == null) continue;
                len += la[mm3][tt2][0].length;
            }
            out_vv[tt2] = new float[3][len];
            int cnt = 0;
            for (mm = 0; mm < n_strips; ++mm) {
                if (la[mm][tt2] == null) continue;
                System.arraycopy(la[mm][tt2][0], 0, out_vv[tt2][0], cnt, la[mm][tt2][0].length);
                System.arraycopy(la[mm][tt2][1], 0, out_vv[tt2][1], cnt, la[mm][tt2][1].length);
                System.arraycopy(la[mm][tt2][2], 0, out_vv[tt2][2], cnt, la[mm][tt2][1].length);
                cnt += la[mm][tt2][0].length;
            }
            int clr_dim = 0;
            if (colors == null) continue;
            clr_dim = colors.length;
            len = 0;
            for (mm2 = 0; mm2 < n_strips; ++mm2) {
                if (ca[mm2][tt2] == null) continue;
                len += ca[mm2][tt2][0].length;
            }
            out_bb[tt2] = new byte[clr_dim][len];
            cnt = 0;
            for (mm2 = 0; mm2 < n_strips; ++mm2) {
                if (ca[mm2][tt2] == null) continue;
                for (int cc = 0; cc < clr_dim; ++cc) {
                    System.arraycopy(ca[mm2][tt2][cc], 0, out_bb[tt2][cc], cnt, ca[mm2][tt2][cc].length);
                }
                cnt += ca[mm2][tt2][0].length;
            }
        }
        int n_lbl = 0;
        for (int mm4 = 0; mm4 < n_strips; ++mm4) {
            if (laL[mm4][0] == null) continue;
            n_lbl += laL[mm4][0].length;
        }
        out_vvL[0] = new float[n_lbl][][];
        out_vvL[1] = new float[n_lbl][][];
        out_vvL[2] = new float[n_lbl][][];
        out_vvL[3] = new float[n_lbl][][];
        out_bbL[0] = new byte[n_lbl][][];
        out_bbL[1] = new byte[n_lbl][][];
        out_bbL[2] = new byte[n_lbl][][];
        out_bbL[3] = new byte[n_lbl][][];
        out_loc[0] = new float[n_lbl][];
        out_loc[1] = new float[n_lbl][];
        out_loc[2] = new float[n_lbl][];
        for (tt = 0; tt < 4; ++tt) {
            n_lbl = 0;
            for (kk = 0; kk < n_strips; ++kk) {
                if (laL[kk][tt] == null) continue;
                for (mm = 0; mm < laL[kk][tt].length; ++mm) {
                    out_vvL[tt][n_lbl] = laL[kk][tt][mm];
                    if (caL[kk][tt] != null) {
                        out_bbL[tt][n_lbl] = caL[kk][tt][mm];
                    }
                    ++this.vecArray[lev_idx].get((int)kk).numLabels;
                    ++n_lbl;
                }
            }
        }
        for (tt = 0; tt < 3; ++tt) {
            n_lbl = 0;
            for (kk = 0; kk < n_strips; ++kk) {
                if (locL[kk][0] == null) continue;
                for (mm = 0; mm < locL[kk][tt].length; ++mm) {
                    out_loc[tt][n_lbl] = locL[kk][tt][mm];
                    ++n_lbl;
                }
            }
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, float[][][] out_vv, byte[][][] out_bb, float[][][][] out_vvL, byte[][][][] out_bbL, float[][][] out_loc, boolean[] dashFlags, int contourDifficulty) {
        int ll;
        int lvl;
        int cnt;
        int tt;
        if (contourDifficulty == 0) {
            this.makeContourStrips(vx, vy);
        } else {
            for (int kk = 0; kk < this.qSet.length; ++kk) {
                this.qSet[kk].get(vx, vy);
            }
        }
        float[][][][] tmp = new float[this.n_levs][2][][];
        byte[][][][] btmp = new byte[this.n_levs][2][][];
        float[][][][][] tmpL = new float[this.n_levs][4][][][];
        byte[][][][][] btmpL = new byte[this.n_levs][4][][][];
        float[][][][] tmpLoc = new float[this.n_levs][3][][];
        int n_lbl = 0;
        for (int kk = 0; kk < this.n_levs; ++kk) {
            this.getLineColorArrays(vx, vy, colors, labelColor, kk, tmp[kk], btmp[kk], tmpL[kk], btmpL[kk], tmpLoc[kk], dashFlags);
            this.labelIndexes[kk] = new int[tmpL[kk][0].length];
            for (int ii = 0; ii < tmpL[kk][0].length; ++ii) {
                this.labelIndexes[kk][ii] = n_lbl + ii;
            }
            n_lbl += tmpL[kk][0].length;
        }
        for (tt = 0; tt < 2; ++tt) {
            int lvl2;
            int len = 0;
            for (int kk = 0; kk < this.n_levs; ++kk) {
                len += tmp[kk][tt][0].length;
            }
            out_vv[tt] = new float[3][len];
            int cnt2 = 0;
            for (int lvl3 = 0; lvl3 < this.n_levs; ++lvl3) {
                System.arraycopy(tmp[lvl3][tt][0], 0, out_vv[tt][0], cnt2, tmp[lvl3][tt][0].length);
                System.arraycopy(tmp[lvl3][tt][1], 0, out_vv[tt][1], cnt2, tmp[lvl3][tt][0].length);
                System.arraycopy(tmp[lvl3][tt][2], 0, out_vv[tt][2], cnt2, tmp[lvl3][tt][0].length);
                cnt2 += tmp[lvl3][tt][0].length;
            }
            int clr_dim = 0;
            if (colors == null) continue;
            clr_dim = colors.length;
            len = 0;
            for (lvl2 = 0; lvl2 < this.n_levs; ++lvl2) {
                len += btmp[lvl2][tt][0].length;
            }
            out_bb[tt] = new byte[clr_dim][len];
            cnt2 = 0;
            for (lvl2 = 0; lvl2 < this.n_levs; ++lvl2) {
                for (int cc = 0; cc < clr_dim; ++cc) {
                    System.arraycopy(btmp[lvl2][tt][cc], 0, out_bb[tt][cc], cnt2, btmp[lvl2][tt][cc].length);
                }
                cnt2 += btmp[lvl2][tt][0].length;
            }
        }
        btmp = null;
        for (tt = 0; tt < 4; ++tt) {
            out_vvL[tt] = new float[n_lbl][][];
            cnt = 0;
            for (lvl = 0; lvl < this.n_levs; ++lvl) {
                for (ll = 0; ll < tmpL[lvl][tt].length; ++ll) {
                    out_vvL[tt][cnt] = tmpL[lvl][tt][ll];
                    ++cnt;
                }
            }
            out_bbL[tt] = new byte[n_lbl][][];
            cnt = 0;
            for (lvl = 0; lvl < this.n_levs; ++lvl) {
                for (ll = 0; ll < tmpL[lvl][tt].length; ++ll) {
                    out_bbL[tt][cnt] = btmpL[lvl][tt][ll];
                    ++cnt;
                }
            }
        }
        tmpL = null;
        btmpL = null;
        for (tt = 0; tt < 3; ++tt) {
            out_loc[tt] = new float[n_lbl][];
            cnt = 0;
            for (lvl = 0; lvl < this.n_levs; ++lvl) {
                if (tmpLoc[lvl][tt] == null) continue;
                for (ll = 0; ll < tmpLoc[lvl][tt].length; ++ll) {
                    out_loc[tt][cnt] = tmpLoc[lvl][tt][ll];
                    ++cnt;
                }
            }
        }
    }

    void makeContourStrips(float[] vx, float[] vy) {
        for (int kk = 0; kk < this.n_levs; ++kk) {
            int nx = this.qSet[kk].nx;
            int ny = this.qSet[kk].ny;
            for (int j = 0; j < ny; ++j) {
                for (int i = 0; i < nx; ++i) {
                    if (this.qSet[kk].qarray[j][i] == null) continue;
                    int[] vert_indices = this.qSet[kk].qarray[j][i].vert_indices;
                    int len = this.qSet[kk].qarray[j][i].numv;
                    for (int q = 0; q < len; ++q) {
                        int idx = vert_indices[q];
                        this.add(vx, vy, idx, idx + 1, kk);
                    }
                }
            }
        }
    }

    List<float[][][]> getLineStripCoordinates(int lvlIdx) {
        if (lvlIdx > this.vecArray.length - 1) {
            return new ArrayList<float[][][]>(0);
        }
        Vector<ContourStrip> strips = this.vecArray[lvlIdx];
        ArrayList<float[][][]> stripValues = new ArrayList<float[][][]>();
        for (ContourStrip strip : strips) {
            stripValues.add(strip.getLineStripArrays(this.gridX, this.gridY));
        }
        return stripValues;
    }

    List<byte[][][]> getLineStripColors(int lvlIdx) {
        if (lvlIdx > this.vecArray.length - 1) {
            return new ArrayList<byte[][][]>(0);
        }
        Vector<ContourStrip> strips = this.vecArray[lvlIdx];
        ArrayList<byte[][][]> stripColors = new ArrayList<byte[][][]>();
        for (ContourStrip strip : strips) {
            stripColors.add(strip.getColorStripArrays(this.gridColors));
        }
        return stripColors;
    }

    boolean isLevelStyled(int lvl) {
        if (this.vecArray.length > lvl + 1 && this.vecArray[lvl] != null && this.vecArray[lvl].size() > 0) {
            return this.vecArray[lvl].get((int)0).isDashed;
        }
        return false;
    }

    boolean isLabeled(int lvl) {
        return this.vecArray[lvl].get(0).isLabeled();
    }
}

