/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import visad.CommonUnit;
import visad.Data;
import visad.DataImpl;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.util.DataUtility;

public class DoubleStringTuple
extends Tuple {
    String[] strings;
    double[] doubles;
    TupleType tt;
    Unit[] units;
    Data[] components;
    int size;

    public DoubleStringTuple(TupleType type, double[] doubles, String[] strings, Unit[] units) {
        super(type);
        this.tt = type;
        this.units = units;
        this.doubles = doubles;
        this.strings = strings;
        this.size = 0;
        if (doubles != null) {
            this.size += doubles.length;
        }
        if (strings != null) {
            this.size += strings.length;
        }
    }

    public static TupleType makeTupleType(List numericTypes, List stringTypes) throws VisADException, RemoteException {
        ArrayList allTypes = new ArrayList();
        allTypes.addAll(numericTypes);
        allTypes.addAll(stringTypes);
        MathType[] tmp = allTypes.toArray(new MathType[allTypes.size()]);
        return new TupleType(tmp);
    }

    public Data getComponent(int i) throws VisADException, RemoteException {
        if (this.components == null) {
            this.components = new Data[this.size];
        }
        if (0 <= i && i < this.getDimension()) {
            if (this.components[i] == null) {
                this.components[i] = this.getComponentInner(i);
                if (this.components[i] != null) {
                    ((DataImpl)this.components[i]).setParent(this);
                }
            }
            return this.components[i];
        }
        throw new TypeException("Tuple: component index out of range: " + i);
    }

    private Data getComponentInner(int i) throws VisADException, RemoteException {
        if (this.doubles != null && i < this.doubles.length) {
            if (this.units == null || this.units[i] == null) {
                return new Real((RealType)this.tt.getComponent(i), this.doubles[i]);
            }
            return new Real((RealType)this.tt.getComponent(i), this.doubles[i], this.units[i]);
        }
        int idx = i - this.doubles.length;
        return new Text((TextType)this.tt.getComponent(i), this.strings[idx]);
    }

    public Data[] getComponents() {
        try {
            if (this.components == null) {
                this.components = new Data[this.size];
            }
            for (int i = 0; i < this.size; ++i) {
                this.components[i] = this.getComponent(i);
            }
            return this.components;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalStateException("Error making component array:" + exc);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleStringTuple)) {
            return false;
        }
        DoubleStringTuple that = (DoubleStringTuple)obj;
        return Arrays.equals(this.doubles, that.doubles) && Arrays.equals(this.strings, that.strings) && this.tt.equals(that.tt) && Arrays.equals(this.units, that.units);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.doubles != null) {
            hashCode ^= this.doubles.hashCode();
        }
        if (this.strings != null) {
            hashCode ^= this.strings.hashCode();
        }
        return hashCode ^= this.tt.hashCode();
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        ArrayList<RealType> reals = new ArrayList<RealType>();
        reals.add(RealType.Latitude);
        reals.add(RealType.Longitude);
        reals.add(RealType.Altitude);
        ArrayList<TextType> strings = new ArrayList<TextType>();
        strings.add(TextType.getTextType("id"));
        double[] vals = new double[]{40.0, -105.0, 5337.0};
        String[] svals = new String[]{"Boulder"};
        Unit foot = CommonUnit.meter.scale(0.3048);
        try {
            foot = Parser.parse("foot");
        }
        catch (ParseException pe) {
            // empty catch block
        }
        Unit[] units = new Unit[]{CommonUnit.degree, CommonUnit.degree, foot};
        DoubleStringTuple dst = new DoubleStringTuple(DoubleStringTuple.makeTupleType(reals, strings), vals, svals, units);
        System.out.println(dst);
        System.out.println("serializable? " + DataUtility.isSerializable(dst));
    }
}

