/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.PromiscuousUnit;
import visad.Unit;
import visad.UnitException;

public final class ScaledUnit
extends Unit
implements Serializable {
    final double amount;
    final DerivedUnit derivedUnit;

    public ScaledUnit(double amount) {
        this(amount, "");
    }

    public ScaledUnit(double amount, String identifier) {
        super(identifier);
        this.amount = amount;
        this.derivedUnit = new DerivedUnit();
    }

    public ScaledUnit(double amount, BaseUnit that) {
        this(amount, that, amount == 1.0 ? that.getIdentifier() : null);
    }

    public ScaledUnit(double amount, BaseUnit that, String identifier) {
        super(identifier);
        this.amount = amount;
        this.derivedUnit = new DerivedUnit(that);
    }

    public ScaledUnit(double amount, DerivedUnit that) {
        this(amount, that, amount == 1.0 ? that.getIdentifier() : null);
    }

    public ScaledUnit(double amount, DerivedUnit that, String identifier) {
        super(identifier);
        this.amount = amount;
        this.derivedUnit = that;
    }

    public ScaledUnit(double amount, ScaledUnit unit) {
        this(amount, unit, amount == 1.0 && unit.amount == 1.0 ? unit.getIdentifier() : null);
    }

    public ScaledUnit(double amount, ScaledUnit that, String identifier) {
        super(identifier);
        this.amount = amount * that.amount;
        this.derivedUnit = that.derivedUnit;
    }

    public static ScaledUnit create(double amount, Unit unit) throws UnitException {
        ScaledUnit result;
        if (unit instanceof BaseUnit) {
            result = new ScaledUnit(amount, (BaseUnit)unit);
        } else if (unit instanceof DerivedUnit) {
            result = new ScaledUnit(amount, (DerivedUnit)unit);
        } else if (unit instanceof ScaledUnit) {
            result = new ScaledUnit(amount, (ScaledUnit)unit);
        } else {
            throw new UnitException("Can't create Scaled Unit from " + unit);
        }
        return result;
    }

    public boolean isDimensionless() {
        return this.derivedUnit.isDimensionless();
    }

    protected Unit protectedClone(String identifier) {
        return new ScaledUnit(this.amount, this.derivedUnit, identifier);
    }

    public Unit pow(int power) {
        return new ScaledUnit(Math.pow(this.amount, power), (DerivedUnit)this.derivedUnit.pow(power));
    }

    public Unit root(int root) throws IllegalArgumentException {
        return new ScaledUnit(Math.pow(this.amount, 1.0 / (double)root), (DerivedUnit)this.derivedUnit.root(root));
    }

    public Unit pow(double power) throws IllegalArgumentException {
        return new ScaledUnit(Math.pow(this.amount, power), (DerivedUnit)this.derivedUnit.pow(power));
    }

    public String getDefinition() {
        String definition;
        if (this.derivedUnit == null) {
            definition = "<unconstructed ScaledUnit>";
        } else {
            String derivedString = this.derivedUnit.toString();
            definition = this.amount == 1.0 ? derivedString : (derivedString.length() == 0 ? Double.toString(this.amount) : Double.toString(this.amount) + " " + derivedString);
        }
        return definition;
    }

    public double getAmount() {
        return this.amount;
    }

    public DerivedUnit getUnit() {
        return this.derivedUnit;
    }

    public Unit multiply(Unit that) throws UnitException {
        return ScaledUnit.create(this.amount, this.derivedUnit.multiply(that));
    }

    public Unit divide(Unit that) throws UnitException {
        return ScaledUnit.create(this.amount, this.derivedUnit.divide(that));
    }

    protected Unit divideInto(Unit that) throws UnitException {
        return ScaledUnit.create(1.0 / this.amount, this.derivedUnit.divideInto(that));
    }

    public double[] toThis(double[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    public float[] toThis(float[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    public double[] toThis(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (double[])values.clone() : values;
        } else {
            newValues = that.toThat(values, (Unit)this.derivedUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = newValues[n] / this.amount;
            }
        }
        return newValues;
    }

    public float[] toThis(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (float[])values.clone() : values;
        } else {
            newValues = that.toThat(values, (Unit)this.derivedUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = (float)((double)newValues[n] / this.amount);
            }
        }
        return newValues;
    }

    public double[] toThat(double[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    public float[] toThat(float[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    public double[] toThat(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        double[] dArray = newValues = copy ? (double[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            int i = 0;
            while (i < newValues.length) {
                int n = i++;
                newValues[n] = newValues[n] * this.amount;
            }
            newValues = that.toThis(newValues, (Unit)this.derivedUnit);
        }
        return newValues;
    }

    public float[] toThat(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        float[] fArray = newValues = copy ? (float[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            int i = 0;
            while (i < newValues.length) {
                int n = i++;
                newValues[n] = (float)((double)newValues[n] * this.amount);
            }
            newValues = that.toThis(newValues, (Unit)this.derivedUnit);
        }
        return newValues;
    }

    public boolean isConvertible(Unit unit) {
        return unit == null ? false : this.derivedUnit.isConvertible(unit);
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit meter = BaseUnit.addBaseUnit("Length", "meter");
        BaseUnit second = BaseUnit.addBaseUnit("Time", "second");
        DerivedUnit meterPerSec = new DerivedUnit(new BaseUnit[]{meter, second}, new int[]{1, -1});
        ScaledUnit milePerHour = new ScaledUnit(0.44704, meterPerSec);
        Unit milePerHour2 = ((Unit)milePerHour).pow(2);
        BaseUnit kg = BaseUnit.addBaseUnit("Mass", "kilogram");
        DerivedUnit kgPerSec = new DerivedUnit(new BaseUnit[]{kg, second}, new int[]{1, -1});
        ScaledUnit poundPerSec = new ScaledUnit(0.453592, kgPerSec);
        System.out.println("milePerHour=\"" + milePerHour + "\"");
        System.out.println("milePerHour.pow(2)=\"" + ((Unit)milePerHour).pow(2) + "\"");
        System.out.println("milePerHour2.root(2)=\"" + milePerHour2.root(2) + "\"");
        System.out.println("poundPerSec=\"" + poundPerSec + "\"");
        System.out.println("milePerHour*poundPerSec=\"" + ((Unit)milePerHour).multiply(poundPerSec) + "\"");
        System.out.println("poundPerSec*milePerHour=\"" + ((Unit)poundPerSec).multiply(milePerHour) + "\"");
        System.out.println("milePerHour/poundPerSec=\"" + ((Unit)milePerHour).divide(poundPerSec) + "\"");
        System.out.println("poundPerSec/milePerHour=\"" + ((Unit)poundPerSec).divide(milePerHour) + "\"");
        System.out.println("milePerHour.toThis(1,meterPerSec)=" + milePerHour.toThis(1.0, (Unit)meterPerSec));
        System.out.println("milePerHour.toThat(1,meterPerSec)=" + milePerHour.toThat(1.0, (Unit)meterPerSec));
        double[] values = ((Unit)milePerHour).toThis(new double[]{1.0, 2.0}, (Unit)meterPerSec);
        System.out.println("milePerHour.toThis({1,2},meterPerSec)=" + values[0] + "," + values[1]);
        values = ((Unit)milePerHour).toThat(new double[]{1.0, 2.0}, (Unit)meterPerSec);
        System.out.println("milePerHour.toThat({1,2},meterPerSec)=" + values[0] + "," + values[1]);
        System.out.println("new ScaledUnit(0.5).isConvertible(new ScaledUnit(2.0)) = " + new ScaledUnit(0.5).isConvertible(new ScaledUnit(2.0)));
        System.out.println("Checking exceptions:");
        try {
            milePerHour.toThis(5.0, (Unit)poundPerSec);
            System.err.println("ERROR: poundPerSec -> milePerHour");
            System.exit(1);
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
        }
    }

    public boolean equals(Unit unit) {
        if (unit == null) {
            return false;
        }
        if (unit instanceof BaseUnit) {
            return this.equals(new ScaledUnit(1.0, (BaseUnit)unit));
        }
        if (unit instanceof DerivedUnit) {
            return this.equals(new ScaledUnit(1.0, (DerivedUnit)unit));
        }
        if (!(unit instanceof ScaledUnit)) {
            return unit.equals(this);
        }
        return this.derivedUnit.equals(((ScaledUnit)unit).derivedUnit) && this.amount == ((ScaledUnit)unit).amount;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode ^= this.derivedUnit.hashCode() ^ new Double(this.amount).hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }
}

