/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hrit;

import edu.wisc.ssec.mcidas.CalibratorException;
import edu.wisc.ssec.mcidas.CalibratorMsg;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.hrit.HRITCoordinateSystem;

public class HRITAdapter {
    private FlatField field = null;
    private static final int HEADER_TYPE_PRIMARY_HEADER = 0;
    private static final int HEADER_TYPE_IMAGE_STRUCTURE = 1;
    private static final int HEADER_TYPE_IMAGE_NAVIGATION = 2;
    private static final int PRIMARY_HEADER_LENGTH = 16;

    public HRITAdapter(String[] filenames) throws IOException, VisADException {
        if (filenames == null) {
            throw new IOException("No filenames specified");
        }
        for (int i = 0; i < filenames.length; ++i) {
            if (filenames[i] == null) {
                throw new IOException("File name in array position " + (i + 1) + " is null");
            }
            File f = new File(filenames[i]);
            if (f.exists()) continue;
            throw new IOException("File in array position " + (i + 1) + " does not exist");
        }
        int[] imageSegmentLines = new int[filenames.length];
        int[] imageSegmentElements = new int[filenames.length];
        int[] imageBitsPerPixel = new int[filenames.length];
        int[] lengthAllHeaders = new int[filenames.length];
        int[] lineOffset = new int[filenames.length];
        int minLineOffset = Integer.MAX_VALUE;
        int columnOffset = -1;
        int lineScalingFactor = -1;
        int columnScalingFactor = -1;
        byte[] tenBitInputArray = null;
        short[] tenBitOutputArray = null;
        for (int i = 0; i < filenames.length; ++i) {
            File f = new File(filenames[i]);
            FileInputStream fis = new FileInputStream(f);
            byte[] primaryHeader = new byte[16];
            int bytesRead = fis.read(primaryHeader);
            if (bytesRead < 0 || bytesRead != 16) {
                throw new IOException("File " + filenames[i] + " is not an HRIT file");
            }
            int headerSize = HRITAdapter.bytesToShort(primaryHeader, 1);
            if (headerSize != 16) {
                throw new IOException("File " + filenames[i] + " is not a valid HRIT file");
            }
            lengthAllHeaders[i] = HRITAdapter.bytesToInt(primaryHeader, 4);
            if (f.length() < (long)lengthAllHeaders[i]) {
                throw new IOException("File " + filenames[i] + " is not a valid HRIT file");
            }
            int headerBytesConsumed = 16;
            byte[] headerType = new byte[1];
            byte[] headerLength = new byte[2];
            while (headerBytesConsumed < lengthAllHeaders[i]) {
                bytesRead = fis.read(headerType);
                headerBytesConsumed += bytesRead;
                bytesRead = fis.read(headerLength);
                headerBytesConsumed += bytesRead;
                headerSize = HRITAdapter.bytesToShort(headerLength, 0);
                byte[] header = new byte[headerSize - 3];
                bytesRead = fis.read(header);
                headerBytesConsumed += bytesRead;
                if (HRITAdapter.unsignedByteToInt(headerType[0]) == 1) {
                    imageSegmentLines[i] = HRITAdapter.bytesToShort(header, 3);
                    imageSegmentElements[i] = HRITAdapter.bytesToShort(header, 1);
                    imageBitsPerPixel[i] = HRITAdapter.unsignedByteToInt(header[0]);
                }
                if (HRITAdapter.unsignedByteToInt(headerType[0]) != 2) continue;
                String projectionName = new String(header, 0, 32);
                projectionName = projectionName.trim();
                columnScalingFactor = HRITAdapter.bytesToInt(header, 32);
                if (columnScalingFactor < 0) {
                    columnScalingFactor = -columnScalingFactor;
                }
                if ((lineScalingFactor = HRITAdapter.bytesToInt(header, 36)) < 0) {
                    lineScalingFactor = -lineScalingFactor;
                }
                columnOffset = HRITAdapter.bytesToInt(header, 40);
                lineOffset[i] = HRITAdapter.bytesToInt(header, 44);
                if (minLineOffset <= lineOffset[i]) continue;
                minLineOffset = lineOffset[i];
            }
            fis.close();
        }
        RealType line = RealType.getRealType("ImageLine", null, null);
        RealType element = RealType.getRealType("ImageElement", null, null);
        RealType[] domainComponents = new RealType[]{element, line};
        int resMultiplier = 3;
        if (filenames[0].contains("HRV")) {
            resMultiplier = 1;
        }
        int[] iparms = new int[]{1195724627, 55720, 55720, lineScalingFactor * resMultiplier * 10, columnScalingFactor * resMultiplier * 10, 0};
        int[] dir = new int[64];
        dir[5] = resMultiplier * (minLineOffset - 464) + 5568 + 1;
        dir[6] = filenames[0].contains("HRV") ? columnOffset + 1 : 1;
        dir[8] = imageSegmentLines[0] * filenames.length;
        dir[9] = imageSegmentElements[0];
        dir[11] = resMultiplier;
        dir[12] = resMultiplier;
        HRITCoordinateSystem cs = new HRITCoordinateSystem(iparms, dir, false);
        RealTupleType imageDomain = new RealTupleType(domainComponents, (CoordinateSystem)cs, null);
        double[][] calBlock = this.makeMSGCal();
        CalibratorMsg cmsg = null;
        try {
            cmsg = new CalibratorMsg(calBlock);
        }
        catch (CalibratorException ce) {
            ce.printStackTrace();
        }
        Linear2DSet domainSet = new Linear2DSet((MathType)imageDomain, 0.0, (double)(imageSegmentElements[0] - 1), imageSegmentElements[0], imageSegmentLines[0] * filenames.length - 1, 0.0, imageSegmentLines[0] * filenames.length);
        int numBands = 1;
        RealType[] bands = new RealType[numBands];
        bands[0] = RealType.getRealType("Band1");
        RealTupleType radiance = new RealTupleType(bands);
        FunctionType imageType = new FunctionType(imageDomain, radiance);
        Set[] rangeSets = new Set[numBands];
        rangeSets[0] = new Integer1DSet((MathType)bands[0], 255);
        Object calUnit = null;
        Unit[] rangeUnits = null;
        this.field = new FlatField(imageType, (Set)domainSet, (CoordinateSystem)null, null, rangeUnits);
        for (int i = 0; i < filenames.length; ++i) {
            File f = new File(filenames[i]);
            FileInputStream fis = new FileInputStream(f);
            fis.skip(lengthAllHeaders[i]);
            tenBitInputArray = new byte[(int)f.length() - lengthAllHeaders[i] + 2];
            tenBitOutputArray = new short[imageSegmentLines[i] * imageSegmentElements[i]];
            double[][] samples = new double[numBands][imageSegmentElements[i] * imageSegmentLines[i]];
            byte[] sampleTwoByte = new byte[2];
            byte[] sampleOneByte = new byte[1];
            if (imageBitsPerPixel[i] != 10) {
                for (int b = 0; b < numBands; ++b) {
                    for (int l = 0; l < imageSegmentLines[i]; ++l) {
                        for (int j = 0; j < imageSegmentElements[i]; ++j) {
                            if (imageBitsPerPixel[i] == 16) {
                                fis.read(sampleTwoByte);
                                samples[b][j + imageSegmentElements[i] * l] = HRITAdapter.bytesToShort(sampleTwoByte, 0);
                                continue;
                            }
                            fis.read(sampleOneByte);
                            samples[b][j + imageSegmentElements[i] * l] = HRITAdapter.unsignedByteToInt(sampleOneByte[0]);
                        }
                    }
                }
            } else {
                int convert;
                int numRead = fis.read(tenBitInputArray, 0, tenBitInputArray.length - 2);
                if (numRead == tenBitInputArray.length - 2 && (convert = HRITAdapter.tenBitToTwoByte(tenBitInputArray, tenBitOutputArray)) == 0) {
                    int idx = 0;
                    for (int b = 0; b < numBands; ++b) {
                        for (int l = imageSegmentLines[i] - 1; l >= 0; --l) {
                            for (int j = imageSegmentElements[i] - 1; j >= 0; --j) {
                                samples[b][j + imageSegmentElements[i] * l] = cmsg.calibrateFromRaw(tenBitOutputArray[idx], 1, 5);
                                ++idx;
                            }
                        }
                    }
                }
            }
            this.field.setSamples(samples[0].length * (filenames.length - (i + 1)), samples);
            fis.close();
        }
    }

    private double[][] makeMSGCal() {
        double[][] msgCal = new double[12][6];
        double[] waveNum = new double[12];
        double[] alpha = new double[12];
        double[] beta = new double[12];
        double[] gain = new double[12];
        double[] offset = new double[12];
        waveNum[0] = 0.0;
        waveNum[1] = 0.0;
        waveNum[2] = 0.0;
        waveNum[3] = 2568.832;
        waveNum[4] = 1600.548;
        waveNum[5] = 1360.33;
        waveNum[6] = 1148.62;
        waveNum[7] = 1035.289;
        waveNum[8] = 931.7;
        waveNum[9] = 836.445;
        waveNum[10] = 751.792;
        waveNum[11] = 0.0;
        alpha[0] = 0.0;
        alpha[1] = 0.0;
        alpha[2] = 0.0;
        alpha[3] = 0.9954;
        alpha[4] = 0.9963;
        alpha[5] = 0.9991;
        alpha[6] = 0.9996;
        alpha[7] = 0.9999;
        alpha[8] = 0.9983;
        alpha[9] = 0.9988;
        alpha[10] = 0.9981;
        alpha[11] = 0.0;
        beta[0] = 0.0;
        beta[1] = 0.0;
        beta[2] = 0.0;
        beta[3] = 3.438;
        beta[4] = 2.185;
        beta[5] = 0.47;
        beta[6] = 0.179;
        beta[7] = 0.056;
        beta[8] = 0.64;
        beta[9] = 0.408;
        beta[10] = 0.561;
        beta[11] = 0.0;
        gain[0] = 0.0233101;
        gain[1] = 0.0254043;
        gain[2] = 0.0218785;
        gain[3] = 0.003742751227;
        gain[4] = 0.04641033727;
        gain[5] = 0.08197182308;
        gain[6] = 0.1256206112;
        gain[7] = 0.152327637;
        gain[8] = 0.1959369086;
        gain[9] = 0.2145945762;
        gain[10] = 0.2091678681;
        gain[11] = 0.028003;
        offset[0] = -1.18881;
        offset[1] = -1.29562;
        offset[2] = -1.1158;
        offset[3] = -0.1908803126;
        offset[4] = -2.366927201;
        offset[5] = -4.180562977;
        offset[6] = -6.40665117;
        offset[7] = -7.768709489;
        offset[8] = -9.99278234;
        offset[9] = -10.94432338;
        offset[10] = -10.66756128;
        offset[11] = -1.42815;
        double c1 = 0.0;
        double c2 = 0.0;
        double w = 0.0;
        double c1w3 = 0.0;
        double c2w = 0.0;
        double PLANCK = 6.626176E-34;
        double LIGHT = 2.99792458E8;
        double BOLTZMAN = 1.380662E-23;
        for (int band = 0; band < 12; ++band) {
            c1 = 200000.0 * PLANCK * (LIGHT * LIGHT);
            c2 = PLANCK * LIGHT / BOLTZMAN;
            w = 100.0 * waveNum[band];
            c1w3 = c1 * w * w * w;
            c2w = c2 * w;
            msgCal[band][0] = c1w3;
            msgCal[band][1] = c2w;
            msgCal[band][2] = alpha[band];
            msgCal[band][3] = beta[band];
            msgCal[band][4] = gain[band];
            msgCal[band][5] = offset[band];
        }
        return msgCal;
    }

    private void dumpHeader(byte[] header) {
        if (header != null && header.length >= 3) {
            System.out.println("Header type: " + header[0]);
            System.out.println("Length of this header: " + HRITAdapter.bytesToShort(header, 1));
        }
        switch (header[0]) {
            case 0: {
                System.out.println("Length of all headers: " + HRITAdapter.bytesToInt(header, 4));
                break;
            }
        }
    }

    public FlatField getData() {
        return this.field;
    }

    public static int bytesToInt(byte[] data, int offset) {
        int i = 0;
        i += HRITAdapter.unsignedByteToInt(data[offset]) << 24;
        i += HRITAdapter.unsignedByteToInt(data[offset + 1]) << 16;
        i += HRITAdapter.unsignedByteToInt(data[offset + 2]) << 8;
        return i += HRITAdapter.unsignedByteToInt(data[offset + 3]);
    }

    public static int bytesToShort(byte[] data, int offset) {
        int i = 0;
        i += HRITAdapter.unsignedByteToInt(data[offset]) << 8;
        return i += HRITAdapter.unsignedByteToInt(data[offset + 1]);
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static int tenBitToTwoByte(byte[] input, short[] output) {
        int total = output.length;
        int index = 0;
        int temp = 0;
        int skip = 0;
        int outputIndex = 0;
        index = skip / 8;
        skip %= 8;
        while (total > 0) {
            --total;
            switch (skip) {
                case 0: {
                    temp = 4 * (input[index] & 0xFF) + (input[index + 1] & 0xFF) / 64;
                    break;
                }
                case 1: {
                    temp = 8 * (input[index] & 0xFF) + (input[index + 1] & 0xFF) / 32;
                    break;
                }
                case 2: {
                    temp = 16 * (input[index] & 0xFF) + (input[index + 1] & 0xFF) / 16;
                    break;
                }
                case 3: {
                    temp = 32 * (input[index] & 0xFF) + (input[index + 1] & 0xFF) / 8;
                    break;
                }
                case 4: {
                    temp = 64 * (input[index] & 0xFF) + (input[index + 1] & 0xFF) / 4;
                    break;
                }
                case 5: {
                    temp = 128 * (input[index] & 0xFF) + (input[index + 1] & 0xFF) / 2;
                    break;
                }
                case 6: {
                    temp = 256 * (input[index] & 0xFF) + (input[index + 1] & 0xFF);
                    break;
                }
                case 7: {
                    temp = 512 * (1 & (input[index] & 0xFF)) + 2 * (input[index + 1] & 0xFF) + ((input[index + 2] & 0xFF) > 127 ? 1 : 0);
                }
            }
            output[outputIndex] = (short)(temp & 0x3FF);
            ++outputIndex;
            ++index;
            if ((skip += 2) <= 7) continue;
            ++index;
            skip -= 8;
        }
        return 0;
    }
}

