/*
 * Decompiled with CFR 0.152.
 */
package visad.data.text;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.in.ArithProg;
import visad.data.units.Parser;
import visad.jmet.DumpType;

public class TextAdapter {
    private static final String ATTR_COLSPAN = "colspan";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_OFFSET = "off";
    private static final String ATTR_ERROR = "err";
    private static final String ATTR_SCALE = "sca";
    private static final String ATTR_POSITION = "pos";
    private static final String ATTR_FORMAT = "fmt";
    private static final String ATTR_TIMEZONE = "tz";
    private static final String ATTR_UNIT = "unit";
    private static final String ATTR_MISSING = "mis";
    private static final String ATTR_INTERVAL = "int";
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private static final String TAB = "\t";
    private static final String BLANK = " ";
    private static final String BLANK_DELIM = "\\s+";
    private FlatField ff = null;
    private Field field = null;
    private boolean debug = false;
    private String DELIM;
    private boolean DOQUOTE = true;
    private boolean GOTTIME = false;
    HeaderInfo[] infos;
    double[] rangeErrorEstimates;
    Unit[] rangeUnits;
    Set[] rangeSets;
    double[] domainErrorEstimates;
    Unit[] domainUnits;
    int[][] hdrColumns;
    int[][] values_to_index;
    private boolean onlyReadOneLine = false;
    private static List dateParsers;

    public TextAdapter(String filename) throws IOException, VisADException {
        this(filename, null, null);
    }

    public TextAdapter(String filename, String map, String params) throws IOException, VisADException {
        FileInputStream is = new FileInputStream(filename);
        this.DELIM = TextAdapter.getDelimiter(filename);
        this.readit(is, map, params);
    }

    public TextAdapter(URL url) throws IOException, VisADException {
        this(url, null, null);
    }

    public TextAdapter(URL url, String map, String params) throws IOException, VisADException {
        this.DELIM = TextAdapter.getDelimiter(url.getFile());
        InputStream is = url.openStream();
        this.readit(is, map, params);
    }

    public TextAdapter(InputStream inputStream, String delimiter, String map, String params) throws IOException, VisADException {
        this(inputStream, delimiter, map, params, false);
    }

    public TextAdapter(InputStream inputStream, String delimiter, String map, String params, boolean onlyReadOneLine) throws IOException, VisADException {
        this.onlyReadOneLine = onlyReadOneLine;
        this.DELIM = delimiter;
        this.readit(inputStream, map, params);
    }

    public static String getDelimiter(String filename) {
        if (filename == null) {
            return null;
        }
        if ((filename = filename.trim().toLowerCase()).endsWith(".csv")) {
            return COMMA;
        }
        if (filename.endsWith(".tsv")) {
            return TAB;
        }
        if (filename.endsWith(".bsv")) {
            return BLANK;
        }
        return null;
    }

    public static boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("!") || line.startsWith("%") || line.length() < 1;
    }

    public static String readLine(BufferedReader bis) throws IOException {
        String line;
        do {
            if ((line = bis.readLine()) == null) {
                return null;
            }
            if (TextAdapter.isText(line)) continue;
            return null;
        } while (TextAdapter.isComment(line));
        return line;
    }

    void readit(InputStream is, String map, String params) throws IOException, VisADException {
        BufferedReader bis;
        block200: {
            int k;
            float[][] samples;
            int i;
            int i2;
            TupleType rngType;
            RealTupleType domType;
            this.ff = null;
            this.field = null;
            if (this.debug) {
                System.out.println("####   Text Adapter v2.x running");
            }
            bis = new BufferedReader(new InputStreamReader(is));
            String maps = null;
            if (map == null) {
                maps = TextAdapter.readLine(bis);
                if (maps != null) {
                    maps = maps.trim();
                }
            } else {
                maps = map;
            }
            if (maps != null) {
                maps = this.makeMT(maps);
            }
            if (maps == null) {
                throw new BadFormException("TextAdapter: Invalid or missing MathType");
            }
            if (this.debug) {
                System.out.println("Specified MathType = " + maps);
            }
            String hdr = null;
            hdr = params == null ? TextAdapter.readLine(bis) : params;
            String hdrDelim = this.DELIM;
            if (this.DELIM == null) {
                if (hdr.indexOf(BLANK) != -1) {
                    hdrDelim = BLANK_DELIM;
                }
                if (hdr.indexOf(COMMA) != -1) {
                    hdrDelim = COMMA;
                }
                if (hdr.indexOf(SEMICOLON) != -1) {
                    hdrDelim = SEMICOLON;
                }
                if (hdr.indexOf(TAB) != -1) {
                    hdrDelim = TAB;
                }
                if (this.debug) {
                    System.out.println("Using header delimiter = " + hdrDelim + "(" + hdrDelim.getBytes()[0] + ")");
                }
            }
            String[] sthdr = hdr.split(hdrDelim);
            int nhdr = sthdr.length;
            this.infos = new HeaderInfo[nhdr];
            for (int i3 = 0; i3 < this.infos.length; ++i3) {
                this.infos[i3] = new HeaderInfo();
            }
            Real[] prototypeReals = new Real[nhdr];
            this.hdrColumns = new int[2][nhdr];
            int numHdrValues = 0;
            for (int i4 = 0; i4 < nhdr; ++i4) {
                String rttemp;
                String name = sthdr[i4].trim();
                String hdrUnitString = null;
                this.hdrColumns[0][i4] = -1;
                int m = name.indexOf("[");
                if (m == -1) {
                    this.infos[i4].name = name;
                    hdrUnitString = null;
                } else {
                    int m2 = name.indexOf("]");
                    if (m2 == -1) {
                        throw new VisADException("TextAdapter: Bad [descriptor] named in:" + name);
                    }
                    this.infos[i4].name = m2 >= name.length() ? name.substring(0, m).trim() : (name.substring(0, m) + name.substring(m2 + 1)).trim();
                    String cl = name.substring(m + 1, m2).trim();
                    String[] stcl = cl.split(BLANK_DELIM);
                    int ncl = stcl.length;
                    if (ncl == 1 && cl.indexOf("=") == -1) {
                        hdrUnitString = cl;
                    } else {
                        for (int l = 0; l < ncl; ++l) {
                            String s = stcl[l];
                            String[] sts = s.split("=");
                            if (sts.length != 2) {
                                throw new VisADException("TextAdapter: Invalid clause in: " + s);
                            }
                            String tok = sts[0];
                            String val = sts[1];
                            if (val.startsWith("\"")) {
                                String v2;
                                if (val.endsWith("\"")) {
                                    val = v2 = val.substring(1, val.length() - 1);
                                } else {
                                    try {
                                        String v3;
                                        v2 = "";
                                        for (int q = l + 1; q < ncl; ++q) {
                                            String vTmp = stcl[q];
                                            int pos = vTmp.indexOf("\"");
                                            ++l;
                                            if (pos >= 0) {
                                                v2 = v2 + BLANK + vTmp.substring(0, pos);
                                                break;
                                            }
                                            v2 = v2 + BLANK + vTmp;
                                        }
                                        val = v3 = val.substring(1) + v2;
                                    }
                                    catch (ArrayIndexOutOfBoundsException nse2) {
                                        val = "";
                                    }
                                }
                            }
                            if (this.debug) {
                                System.out.println("####   tok = " + tok + " val = '" + val + "'");
                            }
                            if (tok.toLowerCase().startsWith(ATTR_UNIT)) {
                                hdrUnitString = val;
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_MISSING)) {
                                this.infos[i4].missingString = val.trim();
                                try {
                                    this.infos[i4].missingValue = Double.parseDouble(val);
                                }
                                catch (NumberFormatException me) {
                                    this.infos[i4].missingValue = Double.NaN;
                                }
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_INTERVAL)) {
                                this.infos[i4].isInterval = -1;
                                if (val.toLowerCase().startsWith("t")) {
                                    this.infos[i4].isInterval = 1;
                                }
                                if (val.toLowerCase().startsWith("f")) {
                                    this.infos[i4].isInterval = 0;
                                }
                                if (this.infos[i4].isInterval != -1) continue;
                                throw new VisADException("TextAdapter: Value of 'interval' must be 'true' or 'false'");
                            }
                            if (tok.toLowerCase().startsWith(ATTR_ERROR)) {
                                this.infos[i4].errorEstimate = Double.parseDouble(val);
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_SCALE)) {
                                this.infos[i4].scale = Double.parseDouble(val);
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_OFFSET)) {
                                this.infos[i4].offset = Double.parseDouble(val);
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_VALUE)) {
                                this.infos[i4].fixedValue = val.trim();
                                ++numHdrValues;
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_COLSPAN)) {
                                this.infos[i4].colspan = (int)Double.parseDouble(val.trim());
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_POSITION)) {
                                String[] stp = val.split(":");
                                if (stp.length != 2) {
                                    throw new VisADException("TextAdapter: invalid Position parameter in:" + s);
                                }
                                this.hdrColumns[0][i4] = Integer.parseInt(stp[0].trim());
                                this.hdrColumns[1][i4] = Integer.parseInt(stp[1].trim());
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_FORMAT)) {
                                this.infos[i4].formatString = val.trim();
                                continue;
                            }
                            if (tok.toLowerCase().startsWith(ATTR_TIMEZONE)) {
                                this.infos[i4].tzString = val.trim();
                                continue;
                            }
                            throw new VisADException("TextAdapter: invalid token name: " + s);
                        }
                    }
                }
                if (this.debug) {
                    System.out.println("hdr name = " + this.infos[i4] + " units=" + hdrUnitString + " miss=" + this.infos[i4].missingValue + " interval=" + this.infos[i4].isInterval + " errorest=" + this.infos[i4].errorEstimate + " scale=" + this.infos[i4].scale + " offset=" + this.infos[i4].offset + " pos=" + this.hdrColumns[0][i4] + ":" + this.hdrColumns[1][i4]);
                }
                Unit u = null;
                if (hdrUnitString != null && !hdrUnitString.trim().equalsIgnoreCase("null")) {
                    try {
                        u = Parser.parse(hdrUnitString.trim());
                    }
                    catch (Exception ue) {
                        try {
                            u = Parser.parse(hdrUnitString.trim().replace(' ', '_'));
                        }
                        catch (Exception ue2) {
                            System.out.println("Unit name problem:" + ue + " with: " + hdrUnitString);
                            u = null;
                        }
                    }
                }
                if (this.debug) {
                    System.out.println("####   assigned Unit as u=" + u);
                }
                if ((rttemp = this.infos[i4].name.trim()).indexOf("(Text)") == -1) {
                    String rtname;
                    RealType rt;
                    int parenIndex = rttemp.indexOf("(");
                    if (parenIndex < 0) {
                        parenIndex = rttemp.indexOf("[");
                    }
                    if (parenIndex < 0) {
                        parenIndex = rttemp.indexOf("{");
                    }
                    if (parenIndex < 0) {
                        parenIndex = rttemp.indexOf(BLANK);
                    }
                    if ((rt = RealType.getRealType(rtname = parenIndex < 0 ? rttemp.trim() : rttemp.substring(0, parenIndex), u, null, this.infos[i4].isInterval)) == null) {
                        if (this.debug) {
                            System.out.println("####   rt was returned as null");
                        }
                        if (u != null) {
                            System.out.println("####  Could not make RealType using specified Unit (" + hdrUnitString + ") for parameter name: " + rtname);
                        }
                        rt = RealType.getRealType(rtname);
                    }
                    if (rt.equals(RealType.Time)) {
                        this.GOTTIME = true;
                        if (this.debug) {
                            System.out.println("####  found a visad.RealType.Time component");
                        }
                    } else {
                        this.GOTTIME = false;
                    }
                    if (u == null) {
                        u = rt.getDefaultUnit();
                    }
                    if (this.debug) {
                        System.out.println("####  retrieve units from RealType = " + u);
                    }
                }
                this.infos[i4].unit = u;
            }
            MathType mt = null;
            try {
                mt = MathType.stringToType(maps);
            }
            catch (Exception mte) {
                System.out.println("####  Exception: " + mte);
                throw new VisADException("TextAdapter: MathType badly formed or missing: " + maps);
            }
            if (this.debug) {
                System.out.println(mt);
                new DumpType();
                DumpType.dumpMathType(mt, System.out);
            }
            String[] domainNames = null;
            String[] rangeNames = null;
            int numDom = 0;
            int numRng = 0;
            if (mt instanceof FunctionType) {
                int i5;
                domType = ((FunctionType)mt).getDomain();
                numDom = domType.getDimension();
                domainNames = new String[numDom];
                for (i5 = 0; i5 < numDom; ++i5) {
                    MathType comp = domType.getComponent(i5);
                    domainNames[i5] = ((RealType)comp).toString().trim();
                    if (!this.debug) continue;
                    System.out.println("dom " + i5 + " = " + domainNames[i5]);
                }
                rngType = (TupleType)((FunctionType)mt).getRange();
                numRng = rngType.getDimension();
                rangeNames = new String[numRng];
                this.rangeSets = new Set[numRng];
                for (i5 = 0; i5 < numRng; ++i5) {
                    MathType comp = rngType.getComponent(i5);
                    rangeNames[i5] = comp.toString().trim();
                    if (this.debug) {
                        System.out.println("range " + i5 + " = " + rangeNames[i5]);
                    }
                    if (comp instanceof RealType) {
                        this.rangeSets[i5] = ((RealType)comp).getDefaultSet();
                        if (this.rangeSets[i5] == null) {
                            this.rangeSets[i5] = comp.equals(RealType.Time) ? new DoubleSet(new SetType(comp)) : new FloatSet(new SetType(comp));
                        }
                    } else {
                        this.rangeSets[i5] = null;
                    }
                    if (!this.debug) continue;
                    System.out.println("####  rangeSet = " + this.rangeSets[i5]);
                }
            } else {
                throw new VisADException("TextAdapter: Math Type is not a simple FunctionType");
            }
            int[] domainPointer = new int[numDom];
            double[][] domainRanges = new double[3][numDom];
            boolean[] gotDomainRanges = new boolean[numDom];
            this.domainErrorEstimates = new double[numDom];
            this.domainUnits = new Unit[numDom];
            this.rangeErrorEstimates = new double[numRng];
            this.rangeUnits = new Unit[numRng];
            int countDomain = 0;
            for (int i6 = 0; i6 < numDom; ++i6) {
                domainPointer[i6] = -1;
                gotDomainRanges[i6] = false;
                this.domainErrorEstimates[i6] = Double.NaN;
                this.domainUnits[i6] = null;
            }
            int[] rangePointer = new int[numRng];
            int countRange = 0;
            for (int i7 = 0; i7 < numRng; ++i7) {
                rangePointer[i7] = -1;
                this.rangeErrorEstimates[i7] = Double.NaN;
                this.rangeUnits[i7] = null;
            }
            int countValues = -1;
            this.values_to_index = new int[3][nhdr];
            for (i2 = 0; i2 < nhdr; ++i2) {
                int k2;
                this.values_to_index[0][i2] = -1;
                this.values_to_index[1][i2] = -1;
                this.values_to_index[2][i2] = -1;
                ++countValues;
                String name = this.infos[i2].name;
                boolean gotName = false;
                String test_name = name;
                int n = test_name.indexOf("(");
                if (n != -1 && test_name.indexOf("(Text)") == -1) {
                    test_name = name.substring(0, n).trim();
                    --countValues;
                    --countDomain;
                }
                for (k2 = 0; k2 < numDom; ++k2) {
                    if (!test_name.equals(domainNames[k2])) continue;
                    domainPointer[k2] = countValues;
                    this.domainErrorEstimates[k2] = this.infos[i2].errorEstimate;
                    this.domainUnits[k2] = this.infos[i2].unit;
                    gotName = true;
                    ++countDomain;
                    if (n != -1) {
                        try {
                            String ss = name.substring(n + 1, name.length() - 1);
                            String[] sct = ss.split(":");
                            String first = sct[0].trim();
                            String second = sct[1].trim();
                            String third = "1";
                            if (sct.length == 3) {
                                third = sct[2].trim();
                            }
                            domainRanges[0][k2] = Double.parseDouble(first);
                            domainRanges[1][k2] = Double.parseDouble(second);
                            domainRanges[2][k2] = Double.parseDouble(third);
                            gotDomainRanges[k2] = true;
                            break;
                        }
                        catch (Exception ef) {
                            throw new VisADException("TextAdapter: Error while interpreting min:max values for domain " + name);
                        }
                    }
                    if (countValues <= -1) break;
                    this.values_to_index[0][countValues] = k2;
                    this.values_to_index[2][countValues] = i2;
                    break;
                }
                if (gotName) continue;
                for (k2 = 0; k2 < numRng; ++k2) {
                    if (!name.equals(rangeNames[k2])) continue;
                    rangePointer[k2] = countValues;
                    this.rangeErrorEstimates[k2] = this.infos[i2].errorEstimate;
                    this.rangeUnits[k2] = this.infos[i2].unit;
                    ++countRange;
                    this.values_to_index[1][countValues] = k2;
                    this.values_to_index[2][countValues] = i2;
                    gotName = true;
                }
            }
            if (this.debug) {
                System.out.println("countDom/numDom=" + countDomain + BLANK + numDom);
                System.out.println("countRange/numRng=" + countRange + BLANK + numRng);
                System.out.println("Domain info:");
                for (i2 = 0; i2 < numDom; ++i2) {
                    System.out.println("Dom name / index = " + domainNames[i2] + "  " + domainPointer[i2]);
                    if (!gotDomainRanges[i2]) continue;
                    System.out.println("    ..." + domainRanges[0][i2] + "  " + domainRanges[1][i2] + "    " + domainRanges[2][i2]);
                }
                System.out.println("Range info:");
                for (i2 = 0; i2 < numRng; ++i2) {
                    System.out.println("Rng name / index / error est = " + rangeNames[i2] + "  " + rangePointer[i2] + "  " + this.rangeErrorEstimates[i2] + BLANK + this.rangeUnits[i2]);
                }
                System.out.println("values_to_index pointers = ");
                for (i2 = 0; i2 < nhdr; ++i2) {
                    System.out.println(" inx / value = " + i2 + BLANK + this.values_to_index[0][i2] + "    " + this.values_to_index[1][i2] + BLANK + this.values_to_index[2][i2]);
                }
            }
            ArrayList<double[]> domainValues = new ArrayList<double[]>();
            ArrayList<double[]> rangeValues = new ArrayList<double[]>();
            ArrayList<Tuple> tupleValues = new ArrayList<Tuple>();
            boolean tryToMakeTuple = true;
            Tuple tuple = null;
            String dataDelim = this.DELIM;
            boolean isRaster = false;
            int numElements = 1;
            if (countRange == 1 && numRng == 1 && numDom == 2 && countDomain < 2) {
                isRaster = true;
            }
            while (true) {
                String[] st;
                int n;
                String s = bis.readLine();
                if (this.debug) {
                    System.out.println("read:" + s);
                }
                if (s == null) break;
                if (!TextAdapter.isText(s)) {
                    return;
                }
                if (TextAdapter.isComment(s)) continue;
                int index = s.indexOf("=");
                if (index >= 0) {
                    String name = s.substring(0, index).trim();
                    String value = s.substring(index + 1).trim();
                    boolean foundIt = false;
                    for (int paramIdx = 0; paramIdx < this.infos.length; ++paramIdx) {
                        if (!this.infos[paramIdx].isParam(name)) continue;
                        if (this.infos[paramIdx].fixedValue == null) {
                            ++numHdrValues;
                        }
                        this.infos[paramIdx].fixedValue = value;
                        foundIt = true;
                        break;
                    }
                    if (foundIt) continue;
                    throw new VisADException("TextAdapter: Cannot find field with name:" + name + " from line:" + s);
                }
                if (dataDelim == null) {
                    if (s.indexOf(BLANK) != -1) {
                        dataDelim = BLANK_DELIM;
                    }
                    if (s.indexOf(COMMA) != -1) {
                        dataDelim = COMMA;
                    }
                    if (s.indexOf(SEMICOLON) != -1) {
                        dataDelim = SEMICOLON;
                    }
                    if (s.indexOf(TAB) != -1) {
                        dataDelim = TAB;
                    }
                    if (this.debug) {
                        System.out.println("Using data delimiter = " + (dataDelim == null ? "null" : dataDelim + " (" + dataDelim.getBytes()[0] + ")"));
                    }
                }
                if ((n = (st = s.split(dataDelim)).length) < 1) continue;
                double[] dValues = new double[numDom];
                double[] rValues = null;
                Data[] tValues = null;
                if (isRaster) {
                    if (this.debug) {
                        System.out.println("probably a raster...");
                    }
                    boolean gotFirst = false;
                    int rvaluePointer = 0;
                    int irange = 0;
                    for (int i8 = 0; i8 < n; ++i8) {
                        String sa = st[i8];
                        if (i8 >= nhdr) {
                            if (!gotFirst) {
                                throw new VisADException("TextAdapter: Cannot find first raster value");
                            }
                            rValues[++rvaluePointer] = this.getVal(sa, irange);
                            continue;
                        }
                        if (this.values_to_index[0][i8] != -1) {
                            dValues[this.values_to_index[0][i8]] = this.getVal(sa, i8);
                        }
                        if (gotFirst) {
                            rValues[++rvaluePointer] = this.getVal(sa, irange);
                            continue;
                        }
                        if (this.values_to_index[1][i8] == -1) continue;
                        rValues = new double[n - i8];
                        irange = i8;
                        rValues[rvaluePointer] = this.getVal(sa, irange);
                        gotFirst = true;
                    }
                } else {
                    tValues = new Data[numRng];
                    if (this.debug) {
                        System.out.println("probably not a raster...");
                    }
                    rValues = new double[numRng];
                    if (n > nhdr) {
                        n = nhdr;
                    }
                    n += numHdrValues;
                    int l = 0;
                    for (int i9 = 0; i9 < nhdr; ++i9) {
                        double value;
                        String sa;
                        if (this.infos[i9].fixedValue != null) {
                            sa = this.infos[i9].fixedValue;
                        } else if (l >= st.length) {
                            sa = "";
                        } else {
                            sa = st[l++].trim();
                            for (int moreColumns = this.infos[i9].colspan - 1; moreColumns > 0; --moreColumns) {
                                sa = sa + BLANK + st[l++].trim();
                            }
                        }
                        if (this.values_to_index[0][i9] != -1) {
                            dValues[this.values_to_index[0][i9]] = this.getVal(sa, i9);
                            continue;
                        }
                        if (this.values_to_index[1][i9] == -1) continue;
                        MathType thisMT = rngType.getComponent(this.values_to_index[1][i9]);
                        if (thisMT instanceof TextType) {
                            String sThisText;
                            if (sa.startsWith("\"")) {
                                if (sa.endsWith("\"")) {
                                    String sa2;
                                    sThisText = sa2 = sa.substring(1, sa.length() - 1);
                                } else {
                                    try {
                                        String delim = dataDelim.equals(BLANK_DELIM) ? BLANK : dataDelim;
                                        String sa2 = "";
                                        for (int q = l; q < st.length; ++q) {
                                            String saTmp = st[q];
                                            int pos = saTmp.indexOf("\"");
                                            ++l;
                                            if (pos >= 0) {
                                                sa2 = sa2 + saTmp.substring(0, pos);
                                                break;
                                            }
                                            sa2 = sa2 + delim + saTmp;
                                        }
                                        sThisText = sa.substring(1) + delim + sa2;
                                    }
                                    catch (ArrayIndexOutOfBoundsException nse) {
                                        sThisText = "";
                                    }
                                }
                                if (this.debug) {
                                    System.out.println("####   Text value='" + sThisText + "'");
                                }
                            } else {
                                sThisText = sa;
                            }
                            try {
                                tValues[this.values_to_index[1][i9]] = new Text((TextType)thisMT, sThisText);
                                if (!this.debug) continue;
                                System.out.println("tValues[" + this.values_to_index[1][i9] + "] = " + tValues[this.values_to_index[1][i9]]);
                            }
                            catch (Exception e) {
                                System.out.println(" Exception converting " + thisMT + " to TextType " + e);
                            }
                            continue;
                        }
                        rValues[this.values_to_index[1][i9]] = value = this.getVal(sa, i9);
                        try {
                            if (prototypeReals[i9] == null) {
                                prototypeReals[i9] = new Real((RealType)thisMT, this.getVal(sa, i9), this.infos[i9].unit);
                            }
                            tValues[this.values_to_index[1][i9]] = prototypeReals[i9].cloneButValue(value);
                            if (!this.debug) continue;
                            System.out.println("tValues[" + this.values_to_index[1][i9] + "] = " + tValues[this.values_to_index[1][i9]]);
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println(" Exception converting " + thisMT + BLANK + e);
                        }
                    }
                }
                if (tryToMakeTuple) {
                    try {
                        if (tValues != null) {
                            tuple = new Tuple(tValues);
                        }
                    }
                    catch (TypeException te) {
                        tuple = null;
                        tryToMakeTuple = false;
                    }
                    catch (NullPointerException npe) {
                        for (i = 0; i < tValues.length; ++i) {
                            if (tValues[i] != null) continue;
                            throw new IllegalArgumentException("An error occurred reading column number:" + (i + 1));
                        }
                        throw npe;
                    }
                }
                domainValues.add(dValues);
                rangeValues.add(rValues);
                if (tuple != null) {
                    tupleValues.add(tuple);
                }
                if (isRaster) {
                    numElements = rValues.length;
                }
                if (this.onlyReadOneLine) break;
            }
            int numSamples = rangeValues.size();
            if (this.debug) {
                try {
                    System.out.println("domain size = " + domainValues.size());
                    double[] dt = (double[])domainValues.get(1);
                    System.out.println("domain.array[0] = " + dt[0]);
                    System.out.println("range size = " + rangeValues.size());
                    System.out.println("# samples = " + numSamples);
                }
                catch (Exception er) {
                    System.out.println("out range");
                }
            }
            Linear1DSet[] lset = new Linear1DSet[numDom];
            boolean keepConstant = false;
            int numVal = numRng;
            if (numDom == 1) {
                numVal = numSamples;
            }
            if (numDom == 2 && numRng == 1 && numElements > 1) {
                numVal = numElements;
            }
            if (numDom > 2 && numRng == 1 && numElements == 1) {
                numVal = numSamples / (2 * numDom);
                keepConstant = true;
            }
            for (int i10 = 0; i10 < numDom; ++i10) {
                if (gotDomainRanges[i10]) {
                    if (numDom == 2 && numRng == 1 && numElements == 1) {
                        numVal = (int)domainRanges[2][i10];
                    }
                    lset[i10] = new Linear1DSet(domType.getComponent(i10), domainRanges[0][i10], domainRanges[1][i10], numVal);
                    if (this.debug) {
                        System.out.println("lset from domain = " + lset[i10]);
                    }
                } else if (domainPointer[i10] == -1) {
                    lset[i10] = new Linear1DSet(0.0, numVal - 1, numVal);
                    if (this.debug) {
                        System.out.println("lset from range = " + lset[i10]);
                    }
                } else {
                    lset[i10] = null;
                }
                if (keepConstant) continue;
                numVal = numSamples;
            }
            Set domain = null;
            if (numDom == 1) {
                domain = lset[0] == null ? this.createAppropriate1DDomain(domType, numSamples, domainValues) : lset[0];
            } else if (numDom == 2) {
                if (lset[0] != null && lset[1] != null) {
                    domain = new Linear2DSet((MathType)domType, lset);
                } else {
                    samples = new float[numDom][numSamples];
                    for (k = 0; k < numDom; ++k) {
                        samples[k] = lset[k] == null ? this.getDomSamples(k, numSamples, domainValues)[0] : lset[k].getSamples()[0];
                    }
                    domain = new Irregular2DSet((MathType)domType, samples);
                }
            } else if (numDom == 3) {
                if (lset[0] != null && lset[1] != null && lset[2] != null) {
                    domain = new Linear3DSet((MathType)domType, lset);
                } else {
                    samples = new float[numDom][numSamples];
                    for (k = 0; k < numDom; ++k) {
                        samples[k] = lset[k] == null ? this.getDomSamples(k, numSamples, domainValues)[0] : lset[k].getSamples()[0];
                    }
                    domain = new Irregular3DSet((MathType)domType, samples);
                }
            } else {
                boolean allLinear = true;
                for (k = 0; k < numDom; ++k) {
                    if (lset[k] != null) continue;
                    allLinear = false;
                }
                if (allLinear) {
                    if (this.debug) {
                        System.out.println("####   Making LinearNDset");
                    }
                    domain = new LinearNDSet((MathType)domType, lset);
                } else {
                    if (this.debug) {
                        System.out.println("####   Making IrregularSet");
                    }
                    float[][] samples2 = new float[numDom][numSamples];
                    for (int k3 = 0; k3 < numDom; ++k3) {
                        samples2[k3] = lset[k3] == null ? this.getDomSamples(k3, numSamples, domainValues)[0] : lset[k3].getSamples()[0];
                    }
                    domain = new IrregularSet((MathType)domType, samples2);
                }
            }
            try {
                this.ff = new FlatField((FunctionType)mt, domain, null, null, this.rangeSets, this.rangeUnits);
            }
            catch (FieldException fe) {
                this.field = new FieldImpl((FunctionType)mt, domain);
            }
            catch (UnitException fe) {
                System.out.println("####  Problem with Units; attempting to make Field anyway");
                this.field = new FieldImpl((FunctionType)mt, domain);
            }
            if (this.debug) {
                if (this.ff != null) {
                    System.out.println("ff.Length " + this.ff.getLength());
                    System.out.println("ff.getType " + this.ff.getType());
                }
                if (this.field != null) {
                    System.out.println("field.Length " + this.field.getLength());
                    System.out.println("field.getType " + this.field.getType());
                }
                System.out.println("domain = " + domain);
                System.out.println("size of a = " + numRng + " x " + numSamples * numElements);
            }
            double[][] a = new double[numRng][numSamples * numElements];
            Data[] at = new Tuple[numSamples];
            if (isRaster) {
                int samPointer = 0;
                for (int i11 = 0; i11 < numSamples; ++i11) {
                    double[] rs = (double[])rangeValues.get(i11);
                    for (int j = 0; j < numElements; ++j) {
                        a[0][samPointer] = rs[j];
                        ++samPointer;
                    }
                }
            } else {
                for (i = 0; i < numSamples; ++i) {
                    double[] rs = (double[])rangeValues.get(i);
                    for (int j = 0; j < numRng; ++j) {
                        a[j][i] = rs[j];
                    }
                    if (tupleValues.isEmpty()) continue;
                    at[i] = (Tuple)tupleValues.get(i);
                }
            }
            if (this.debug) {
                System.out.println("about to field.setSamples");
            }
            try {
                if (this.ff != null) {
                    if (this.debug) {
                        System.out.println("####   ff is not null");
                    }
                    this.ff.setSamples(a, false);
                    this.field = this.ff;
                } else {
                    if (this.debug) {
                        System.out.println("####   ff is null..use FieldImpl");
                    }
                    this.field.setSamples(at, false);
                }
            }
            catch (Exception ffe) {
                ffe.printStackTrace();
            }
            ErrorEstimate[] es = new ErrorEstimate[numRng];
            for (int i12 = 0; i12 < numRng; ++i12) {
                es[i12] = new ErrorEstimate(a[i12], this.rangeErrorEstimates[i12], this.rangeUnits[i12]);
            }
            try {
                ((FlatField)this.field).setRangeErrors(es);
            }
            catch (FieldException fe) {
                if (this.debug) {
                    System.out.println("caught " + fe);
                }
            }
            catch (ClassCastException cce) {
                if (!this.debug) break block200;
                System.out.println("caught " + cce);
            }
        }
        if (this.debug) {
            new DumpType();
            DumpType.dumpDataType(this.field, System.out);
            System.out.println("field = " + this.field);
        }
        bis.close();
    }

    private String makeMT(String s) {
        String t2;
        int k = s.indexOf("->");
        if (k < 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < s.length(); ++i) {
            String r = s.substring(i, i + 1);
            if (r.equals(BLANK) || r.equals(TAB) || r.equals("\n")) continue;
            sb.append(r);
        }
        String t = sb.toString();
        if (t.charAt((k = t.indexOf("->")) - 1) != ')') {
            t = t.charAt(k + 2) != '(' ? (t2 = "(" + t.substring(0, k) + ")->(" + t.substring(k + 2) + ")") : (t2 = "(" + t.substring(0, k) + ")" + t.substring(k));
        } else if (t.charAt(k + 2) != '(') {
            t = t2 = t.substring(0, k + 2) + "(" + t.substring(k + 2) + ")";
        }
        if (!t.startsWith("((")) {
            t = t2 = "(" + t + ")";
        }
        return t;
    }

    private static final boolean isText(String s) {
        int len;
        int n = len = s == null ? -1 : s.length();
        if (len <= 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (!Character.isISOControl(ch) || Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    private static DateTime makeDateTimeFromString(String string, String format, String tz) throws ParseException {
        DateTime dt = null;
        try {
            if (dateParsers != null) {
                for (int i = 0; i < dateParsers.size(); ++i) {
                    DateParser dateParser = (DateParser)dateParsers.get(i);
                    dt = dateParser.createDateTime(string, format, TimeZone.getTimeZone(tz));
                    if (dt == null) continue;
                    return dt;
                }
            }
            dt = DateTime.createDateTime(string, format, TimeZone.getTimeZone(tz));
        }
        catch (VisADException e) {
            // empty catch block
        }
        if (dt == null) {
            throw new ParseException("Couldn't parse visad.DateTime from \"" + string + "\"", -1);
        }
        return dt;
    }

    public static void addDateParser(DateParser dateParser) {
        if (dateParsers == null) {
            dateParsers = new ArrayList();
        }
        dateParsers.add(dateParser);
    }

    double getVal(String s, int k) {
        int i = this.values_to_index[2][k];
        if (i < 0 || s == null || s.length() < 1 || s.equals(this.infos[i].missingString)) {
            return Double.NaN;
        }
        if (this.infos[i].formatString == null) {
            try {
                double v;
                block11: {
                    try {
                        v = Double.parseDouble(s);
                    }
                    catch (NumberFormatException nfe1) {
                        if (this.infos[i].unit == null || !Unit.canConvert(this.infos[i].unit, CommonUnit.degree)) {
                            throw nfe1;
                        }
                        v = TextAdapter.decodeLatLon(s);
                        if (v == v) break block11;
                        throw new NumberFormatException(s);
                    }
                }
                if (v == this.infos[i].missingValue) {
                    return Double.NaN;
                }
                v = v * this.infos[i].scale + this.infos[i].offset;
                return v;
            }
            catch (NumberFormatException ne) {
                System.out.println("Invalid number format for " + s);
            }
        } else {
            try {
                DateTime dt = TextAdapter.makeDateTimeFromString(s, this.infos[i].formatString, this.infos[i].tzString);
                return dt.getReal().getValue();
            }
            catch (ParseException pe) {
                System.out.println("Invalid number/time format for " + s);
            }
        }
        return Double.NaN;
    }

    float[][] getDomSamples(int comp, int numDomValues, ArrayList domValues) {
        float[][] a = new float[1][numDomValues];
        for (int i = 0; i < numDomValues; ++i) {
            double[] d = (double[])domValues.get(i);
            a[0][i] = (float)d[comp];
        }
        return a;
    }

    public Field getData() {
        return this.field;
    }

    private Set createAppropriate1DDomain(MathType type, int numSamples, ArrayList domValues) throws VisADException {
        ArithProg arithProg;
        int i;
        boolean ascending;
        if (0 == numSamples) {
            return null;
        }
        double[][] values = new double[1][numSamples];
        for (int i2 = 0; i2 < numSamples; ++i2) {
            double[] d = (double[])domValues.get(i2);
            values[0][i2] = d[0];
        }
        boolean ordered = true;
        boolean bl = ascending = values[0][numSamples - 1] > values[0][0];
        if (ascending) {
            for (i = 1; i < numSamples; ++i) {
                if (!(values[0][i] < values[0][i - 1])) continue;
                ordered = false;
                break;
            }
        } else {
            for (i = 1; i < numSamples; ++i) {
                if (!(values[0][i] > values[0][i - 1])) continue;
                ordered = false;
                break;
            }
        }
        SampledSet set = null;
        set = ordered ? ((arithProg = new ArithProg()).accumulate(values[0]) ? new Linear1DSet(type, values[0][0], values[0][numSamples - 1], numSamples) : new Gridded1DDoubleSet(type, values, numSamples)) : new Irregular1DSet(type, Set.doubleToFloat(values));
        return set;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a filename");
            System.exit(1);
        }
        TextAdapter ta = new TextAdapter(args[0]);
        System.out.println(ta.getData().getType());
        new DumpType();
        DumpType.dumpMathType(ta.getData().getType(), System.out);
        new DumpType();
        DumpType.dumpDataType(ta.getData(), System.out);
        System.out.println("####  Data = " + ta.getData());
        System.out.println("EOF... ");
    }

    public static double decodeLatLon(String latlon) {
        latlon = latlon.trim();
        int dirIndex = -1;
        int southOrWest = 1;
        double value = Double.NaN;
        if (latlon.indexOf("S") > 0) {
            southOrWest = -1;
            dirIndex = latlon.indexOf("S");
        } else if (latlon.indexOf("W") > 0) {
            southOrWest = -1;
            dirIndex = latlon.indexOf("W");
        } else if (latlon.indexOf("N") > 0) {
            dirIndex = latlon.indexOf("N");
        } else if (latlon.indexOf("E") > 0) {
            dirIndex = latlon.indexOf("E");
        }
        if (dirIndex > 0) {
            latlon = latlon.substring(0, dirIndex).trim();
        }
        if (latlon.indexOf("-") == 0) {
            southOrWest *= -1;
            latlon = latlon.substring(latlon.indexOf("-") + 1).trim();
        }
        if (latlon.indexOf(":") >= 0) {
            int firstIdx = latlon.indexOf(":");
            String hours = latlon.substring(0, firstIdx);
            String minutes = latlon.substring(firstIdx + 1);
            String seconds = "";
            if (minutes.indexOf(":") >= 0) {
                firstIdx = minutes.indexOf(":");
                String temp = minutes.substring(0, firstIdx);
                seconds = minutes.substring(firstIdx + 1);
                minutes = temp;
            }
            try {
                double d = value = hours.equals("") ? 0.0 : Double.parseDouble(hours);
                if (!minutes.equals("")) {
                    value += Double.parseDouble(minutes) / 60.0;
                }
                if (!seconds.equals("")) {
                    value += Double.parseDouble(seconds) / 3600.0;
                }
            }
            catch (NumberFormatException nfe) {
                value = Double.NaN;
            }
        } else {
            try {
                value = Double.parseDouble(latlon);
            }
            catch (NumberFormatException nfe) {
                value = Double.NaN;
            }
        }
        return value * (double)southOrWest;
    }

    private static class HeaderInfo {
        String name;
        Unit unit;
        double missingValue = Double.NaN;
        String missingString;
        String formatString;
        String tzString = "GMT";
        int isInterval = 0;
        double errorEstimate = 0.0;
        double scale = 1.0;
        double offset = 0.0;
        String fixedValue;
        int colspan = 1;

        private HeaderInfo() {
        }

        public boolean isParam(String param) {
            return this.name.equals(param) || this.name.equals(param + "(Text)");
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface DateParser {
        public DateTime createDateTime(String var1, String var2, TimeZone var3) throws VisADException;
    }
}

