/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import visad.util.ExtensionFileFilter;

public class TextEditor
extends JScrollPane
implements UndoableEditListener {
    public static final Font MONO = new Font("monospaced", 0, 12);
    public static final boolean DEBUG = false;
    protected JTextArea text;
    protected JFileChooser fileChooser;
    protected UndoManager undo = new UndoManager();
    protected File currentFile;
    protected boolean changed = false;

    public TextEditor() {
        this((String)null);
    }

    public TextEditor(String filename) {
        this.text = new JTextArea();
        try {
            this.openFile(filename);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.text.setFont(MONO);
        this.setViewportView(this.text);
        this.addUndoableEditListener(this);
        this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
        this.fileChooser.addChoosableFileFilter(new ExtensionFileFilter("txt", "Text files"));
    }

    public void newFile() {
        this.currentFile = null;
        this.setText("");
        this.undo.discardAllEdits();
        this.changed = false;
    }

    public void openFile(String filename) throws IOException {
        File file = filename == null ? null : new File(filename);
        this.openFile(file);
    }

    public void openFile(File file) throws IOException {
        String fileText;
        if (file == null) {
            fileText = "";
        } else {
            int len = (int)file.length();
            byte[] bytes = new byte[len];
            FileInputStream in = new FileInputStream(file);
            in.read(bytes);
            in.close();
            fileText = new String(bytes);
        }
        this.currentFile = file;
        this.setText(fileText);
        this.changed = false;
    }

    public void saveFile(String filename) throws IOException {
        File file = filename == null ? null : new File(filename);
        this.saveFile(file);
    }

    public void saveFile(File file) throws IOException {
        byte[] bytes = this.getText().getBytes();
        FileOutputStream out = new FileOutputStream(file);
        out.write(bytes);
        out.close();
        this.currentFile = file;
        this.changed = false;
    }

    public boolean openDialog() {
        this.fileChooser.setDialogType(0);
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return false;
        }
        try {
            this.openFile(this.fileChooser.getSelectedFile());
        }
        catch (IOException exc) {
            return false;
        }
        return true;
    }

    public boolean saveDialog() {
        this.fileChooser.setDialogType(1);
        if (this.fileChooser.showSaveDialog(this) != 0) {
            return false;
        }
        try {
            this.saveFile(this.fileChooser.getSelectedFile());
        }
        catch (IOException exc) {
            return false;
        }
        return true;
    }

    public boolean saveFile() {
        boolean success = false;
        if (this.currentFile == null) {
            success = this.saveDialog();
        } else {
            try {
                this.saveFile(this.currentFile);
                success = true;
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this, "Could not save the file.", "VisAD Text Editor", 0);
            }
        }
        return success;
    }

    public void undo() throws CannotUndoException {
        this.undo.undo();
        this.changed = true;
    }

    public void redo() throws CannotRedoException {
        this.undo.redo();
        this.changed = true;
    }

    public void cut() {
        this.text.cut();
    }

    public void copy() {
        this.text.copy();
    }

    public void paste() {
        this.text.paste();
    }

    public JTextComponent getTextComponent() {
        return this.text;
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void insertText(String textToInsert) {
        int pos = this.text.getCaretPosition();
        String t = this.text.getText();
        t = t.substring(0, pos) + textToInsert + t.substring(pos);
        this.text.setText(t);
        this.text.setCaretPosition(pos + textToInsert.length());
    }

    public String getFilename() {
        return this.currentFile == null ? null : this.currentFile.getPath();
    }

    public File getFile() {
        return this.currentFile;
    }

    public boolean canUndo() {
        return this.undo.canUndo();
    }

    public boolean canRedo() {
        return this.undo.canRedo();
    }

    public String getUndoName() {
        return this.undo.getUndoPresentationName();
    }

    public String getRedoName() {
        return this.undo.getRedoPresentationName();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (!e.getEdit().isSignificant()) {
            return;
        }
        this.undo.addEdit(e.getEdit());
        this.changed = true;
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.text.getDocument().addUndoableEditListener(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.text.getDocument().removeUndoableEditListener(l);
    }
}

