/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import ucar.grib.Index;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Indexer {
    private final boolean showTime = false;

    public final Index writeFileIndex(RandomAccessFile inputRaf, PrintStream ps, boolean makeIndex) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        long start = System.currentTimeMillis();
        int count = 0;
        Index index = makeIndex ? new Index() : null;
        try {
            inputRaf.seek(0L);
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(true, false);
            ps.println("index_version = 6.0");
            ps.println("grid_edition = 1");
            ps.println("location = " + inputRaf.getLocation());
            ps.println("length = " + inputRaf.length());
            ps.println("created = " + dateFormat.format(now));
            if (makeIndex) {
                index.addGlobalAttribute("length", Long.toString(inputRaf.length()));
                index.addGlobalAttribute("location", inputRaf.getLocation());
                index.addGlobalAttribute("created", dateFormat.format(now));
            }
            HashMap gdsHM = g1i.getGDSs();
            ArrayList products = g1i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = (Grib1Product)products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                if (i == 0) {
                    ps.println("center = " + pds.getCenter());
                    ps.println("sub_center = " + pds.getSubCenter());
                    ps.println("table_version = " + pds.getTableVersion());
                    this.checkForTiledThinEnsemble(makeIndex, index, pds, gdsHM, null, ps);
                    ps.println("--------------------------------------------------------------------");
                }
                ps.println(pds.getProductDefinition() + " " + product.getDiscipline() + " " + product.getCategory() + " " + pds.getParameter().getNumber() + " " + pds.getTypeGenProcess() + " " + pds.getLevelType() + " " + pds.getLevelValue1() + " " + "255 " + pds.getLevelValue2() + " " + pds.getReferenceTime() + " " + pds.getForecastTime() + " " + product.getGDSkey() + " " + product.getDataOffset() + " " + product.getEndRecordOffset() + " " + pds.getDecimalScale() + " " + pds.bmsExists() + " " + pds.getCenter() + " " + pds.getSubCenter() + " " + pds.getTableVersion());
                if (makeIndex) {
                    index.addGribRecord(Grib1Indexer.makeGribRecord(index, product));
                }
                ++count;
            }
            Iterator it = gdsHM.keySet().iterator();
            while (it.hasNext()) {
                ps.println("--------------------------------------------------------------------");
                String key = (String)it.next();
                ps.println("GDSkey = " + key);
                Grib1GridDefinitionSection gds = (Grib1GridDefinitionSection)gdsHM.get(key);
                this.printGDS(gds, ps);
                if (!makeIndex) continue;
                index.addHorizCoordSys(Grib1Indexer.makeGdsRecord(gds));
            }
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + noGrib);
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        ps.close();
        return index;
    }

    protected final void checkForTiledThinEnsemble(boolean makeIndex, Index index, Grib1ProductDefinitionSection pds, HashMap gdsHM, HashMap extIdxGDSs, PrintStream ps) {
        int tiles = 1;
        boolean thin = false;
        boolean ensemble = false;
        Iterator iter = gdsHM.keySet().iterator();
        String key2 = (String)iter.next();
        Grib1GridDefinitionSection gds = (Grib1GridDefinitionSection)gdsHM.get(key2);
        if (gds.getGridType() == 0 || gds.getGridType() == 4) {
            if (extIdxGDSs == null) {
                tiles = gdsHM.size();
            } else {
                tiles = 0;
                for (String key2 : gdsHM.keySet()) {
                    if (extIdxGDSs.containsKey(key2)) continue;
                    ++tiles;
                }
                tiles += extIdxGDSs.size();
            }
        }
        thin = gds.getIsThin();
        ps.println("tiles = " + tiles);
        ps.println("thin = " + thin);
        if (pds.getSubCenter() == 2 && pds.getCenter() == 7) {
            ensemble = true;
        }
        ps.println("ensemble = " + ensemble);
        if (makeIndex) {
            index.addGlobalAttribute("tiles", Integer.toString(tiles));
        }
    }

    protected static final Index.GribRecord makeGribRecord(Index index, Grib1Product product) {
        Index.GribRecord gr = index.getGribRecord();
        Grib1ProductDefinitionSection pds = product.getPDS();
        gr.productType = pds.getProductDefinition();
        gr.discipline = product.getDiscipline();
        gr.category = -1;
        gr.paramNumber = pds.getParameterNumber();
        gr.typeGenProcess = Integer.toString(pds.getTypeGenProcess());
        gr.levelType1 = pds.getLevelType();
        gr.levelValue1 = pds.getLevelValue1();
        gr.levelType2 = 255;
        gr.levelValue2 = pds.getLevelValue2();
        gr.refTime = pds.getReferenceTime();
        gr.forecastTime = pds.getForecastTime();
        gr.gdsKey = product.getGDSkey().trim();
        gr.offset1 = product.getDataOffset();
        gr.offset2 = -1L;
        gr.decimalScale = pds.getDecimalScale();
        gr.bmsExists = pds.bmsExists();
        gr.center = pds.getCenter();
        gr.subCenter = pds.getSubCenter();
        gr.table = pds.getTableVersion();
        return gr;
    }

    protected static final Index.GdsRecord makeGdsRecord(Grib1GridDefinitionSection gds) {
        Index.GdsRecord igds = new Index.GdsRecord();
        igds.gdsKey = gds.getCheckSum();
        igds.addParam("GDSkey", gds.getCheckSum());
        igds.grid_type = gds.getGdtn();
        igds.addParam("grid_type", Integer.toString(gds.getGdtn()));
        if (gds.getGdtn() != 50) {
            String winds;
            igds.grid_shape_code = gds.getShape();
            igds.addParam("grid_shape_code", Integer.toString(gds.getShape()));
            if (gds.getShape() == 0) {
                igds.radius_spherical_earth = gds.getShapeRadius();
                igds.addParam("grid_radius_spherical_earth", Double.toString(gds.getShapeRadius()));
            } else if (gds.getShape() == 1) {
                igds.major_axis_earth = gds.getShapeMajorAxis();
                igds.addParam("grid_major_axis_earth", Double.toString(gds.getShapeMajorAxis()));
                igds.minor_axis_earth = gds.getShapeMinorAxis();
                igds.addParam("grid_minor_axis_earth", Double.toString(gds.getShapeMinorAxis()));
            }
            igds.nx = gds.getNx();
            igds.addParam("Nx", Integer.toString(gds.getNx()));
            igds.ny = gds.getNy();
            igds.addParam("Ny", Integer.toString(gds.getNy()));
            igds.La1 = gds.getLa1();
            igds.addParam("La1", Double.toString(gds.getLa1()));
            igds.Lo1 = gds.getLo1();
            igds.addParam("Lo1", Double.toString(gds.getLo1()));
            igds.resolution = gds.getResolution();
            igds.addParam("ResCompFlag", Integer.toString(gds.getResolution()));
            igds.winds = winds = (gds.getResolution() & 8) == 0 ? "Relative" : "True";
            igds.addParam("Winds", winds);
        }
        igds.LaD = gds.getLad();
        igds.LoV = gds.getLov();
        igds.dx = gds.getDx();
        igds.dy = gds.getDy();
        igds.latin1 = gds.getLatin1();
        igds.latin2 = gds.getLatin2();
        switch (gds.getGdtn()) {
            case 0: 
            case 4: 
            case 40: 
            case 201: 
            case 202: {
                igds.addParam("La2", Double.toString(gds.getLa2()));
                igds.addParam("Lo2", Double.toString(gds.getLo2()));
                igds.addParam("Dx", Double.toString(gds.getDx()));
                if (gds.getGdtn() == 4) {
                    igds.addParam("NumberParallels", Double.toString(gds.getNp()));
                    break;
                }
                igds.addParam("Dy", Double.toString(gds.getDy()));
                break;
            }
            case 1: {
                igds.addParam("La2", Double.toString(gds.getLa2()));
                igds.addParam("Lo2", Double.toString(gds.getLo2()));
                igds.addParam("Latin", Double.toString(gds.getLatin()));
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.addParam("Dy", Double.toString(gds.getDy()));
                break;
            }
            case 3: {
                igds.addParam("LoV", Double.toString(gds.getLov()));
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.addParam("Dy", Double.toString(gds.getDy()));
                String NpProj = (gds.getProjectionCenter() & 0x80) == 0 ? "true" : "false";
                igds.addParam("NpProj", NpProj);
                igds.addParam("Latin1", Double.toString(gds.getLatin1()));
                igds.addParam("Latin2", Double.toString(gds.getLatin2()));
                igds.addParam("SpLat", Double.toString(gds.getSpLat()));
                igds.addParam("SpLon", Double.toString(gds.getSpLon()));
                break;
            }
            case 5: {
                igds.addParam("LoV", Double.toString(gds.getLov()));
                igds.addParam("Dx", Double.toString(gds.getDx()));
                igds.addParam("Dy", Double.toString(gds.getDy()));
                String NpProj = (gds.getProjectionCenter() & 0x80) == 0 ? "true" : "false";
                igds.addParam("NpProj", NpProj);
                break;
            }
        }
        return igds;
    }

    protected void printGDS(Grib1GridDefinitionSection gds, PrintStream ps) {
        ps.println("grid_type = " + gds.getGdtn());
        ps.println("grid_name = " + gds.getName());
        if (gds.getGdtn() != 50) {
            ps.println("grid_shape_code = " + gds.getShape());
            ps.println("grid_shape = " + gds.getShapeName());
            if (gds.getShape() == 0) {
                ps.println("grid_radius_spherical_earth = " + gds.getShapeRadius());
            } else {
                ps.println("grid_major_axis_earth = " + gds.getShapeMajorAxis());
                ps.println("grid_minor_axis_earth = " + gds.getShapeMinorAxis());
            }
            ps.println("Nx = " + gds.getNx());
            ps.println("Ny = " + gds.getNy());
            ps.println("La1 = " + gds.getLa1());
            ps.println("Lo1 = " + gds.getLo1());
            ps.println("ResCompFlag = " + gds.getResolution());
            String winds = (gds.getResolution() & 8) == 0 ? "Relative" : "True";
            ps.println("Winds = " + winds);
        }
        switch (gds.getGdtn()) {
            case 0: 
            case 4: 
            case 40: 
            case 201: 
            case 202: {
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Dx = " + gds.getDx());
                if (gds.getGdtn() == 4) {
                    ps.println("NumberParallels = " + gds.getNp());
                } else {
                    ps.println("Dy = " + gds.getDy());
                }
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            case 1: {
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Latin = " + gds.getLatin());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                break;
            }
            case 3: {
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("NpProj = " + ((gds.getProjectionCenter() & 0x80) == 0));
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("Latin1 = " + gds.getLatin1());
                ps.println("Latin2 = " + gds.getLatin2());
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                break;
            }
            case 5: {
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("NpProj = " + ((gds.getProjectionCenter() & 0x80) == 0));
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            default: {
                ps.println("Unknown Grid Type" + gds.getGdtn());
            }
        }
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans for index");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib1Indexer indexer = new Grib1Indexer();
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib1Indexer.usage(cl.getName());
            System.exit(0);
        }
        RandomAccessFile raf = null;
        PrintStream ps = System.out;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        if (args.length == 2) {
            String idxfile = args[1].endsWith(".gbx") ? args[1] : args[1].concat(".gbx");
            File idx = new File(idxfile);
            idxfile = idxfile + ".tmp";
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(idxfile, false)));
            indexer.writeFileIndex(raf, ps, false);
            ps.close();
            File tidx = new File(idxfile);
            tidx.renameTo(idx);
        } else if (args.length == 1) {
            ps = System.out;
            indexer.writeFileIndex(raf, ps, true);
        }
    }
}

