/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.util.Date;
import ucar.grib.Index;
import ucar.grib.NotSupportedException;
import ucar.grib.Parameter;
import ucar.grib.TableLookup;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.GribPDSLevel;
import ucar.grib.grib1.GribPDSParamTable;

public final class Grib1Lookup
implements TableLookup {
    private final Grib1ProductDefinitionSection firstPDS;

    public Grib1Lookup(Grib1Product firstProduct) {
        this.firstPDS = firstProduct.getPDS();
    }

    public final String getGridName(Index.GdsRecord gds) {
        return Grib1GridDefinitionSection.getName(gds.grid_type);
    }

    public final String getShapeName(Index.GdsRecord gds) {
        return Grib1GridDefinitionSection.getShapeName(gds.grid_shape_code);
    }

    public final Parameter getParameter(Index.GribRecord gr) {
        try {
            GribPDSParamTable pt = gr.center == 0 ? GribPDSParamTable.getParameterTable(this.firstPDS.getCenter(), this.firstPDS.getSubCenter(), this.firstPDS.getTableVersion()) : GribPDSParamTable.getParameterTable(gr.center, gr.subCenter, gr.table);
            return pt.getParameter(gr.paramNumber);
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
            return null;
        }
    }

    public int[] getParameterId(Index.GribRecord gr) {
        int[] result = new int[]{1, this.firstPDS.getCenter(), this.firstPDS.getTableVersion(), gr.paramNumber};
        return result;
    }

    public final String getDisciplineName(Index.GribRecord gr) {
        return "Meteorological Products";
    }

    public final String getCategoryName(Index.GribRecord gr) {
        return "Meteorological Parameters";
    }

    public final String getProductDefinitionName(Index.GribRecord gr) {
        return Grib1ProductDefinitionSection.getProductDefinitionName(gr.productType);
    }

    public final String getTypeGenProcessName(Index.GribRecord gr) {
        return Grib1ProductDefinitionSection.getTypeGenProcessName(gr.typeGenProcess);
    }

    public final String getLevelName(Index.GribRecord gr) {
        return GribPDSLevel.getNameShort(gr.levelType1);
    }

    public final String getLevelDescription(Index.GribRecord gr) {
        return GribPDSLevel.getLevelDescription(gr.levelType1);
    }

    public final String getLevelUnit(Index.GribRecord gr) {
        return GribPDSLevel.getUnits(gr.levelType1);
    }

    public final String getFirstTimeRangeUnitName() {
        return this.firstPDS.getTimeUnit();
    }

    public final String getFirstCenterName() {
        return this.firstPDS.getCenter_idName();
    }

    public final int getFirstSubcenterId() {
        return this.firstPDS.getSubCenter();
    }

    public final String getFirstProductStatusName() {
        return null;
    }

    public final String getFirstProductTypeName() {
        return Grib1ProductDefinitionSection.getProductDefinitionName(this.firstPDS.getTimeRange());
    }

    public final String getFirstSignificanceOfRTName() {
        return "Start of forecast";
    }

    public final Date getFirstBaseTime() {
        return this.firstPDS.getBaseTime();
    }

    public final boolean isLatLon(Index.GdsRecord gds) {
        return gds.grid_type == 0 || gds.grid_type == 4 || gds.grid_type == 10 || gds.grid_type == 20 || gds.grid_type == 24 || gds.grid_type == 30 || gds.grid_type == 34 || gds.grid_type == 201 || gds.grid_type == 202;
    }

    public final int getProjectionType(Index.GdsRecord gds) {
        switch (gds.grid_type) {
            case 1: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return -1;
    }

    public final boolean isVerticalCoordinate(Index.GribRecord gr) {
        if (gr.levelType1 == 20) {
            return true;
        }
        if (gr.levelType1 == 100) {
            return true;
        }
        if (gr.levelType1 == 101) {
            return true;
        }
        if (gr.levelType1 >= 103 && gr.levelType1 <= 128) {
            return true;
        }
        if (gr.levelType1 == 141) {
            return true;
        }
        return gr.levelType1 == 160;
    }

    public final boolean isPositiveUp(Index.GribRecord gr) {
        if (gr.levelType1 == 103) {
            return true;
        }
        if (gr.levelType1 == 104) {
            return true;
        }
        if (gr.levelType1 == 105) {
            return true;
        }
        if (gr.levelType1 == 106) {
            return true;
        }
        if (gr.levelType1 == 111) {
            return true;
        }
        if (gr.levelType1 == 112) {
            return true;
        }
        return gr.levelType1 == 125;
    }

    public final float getFirstMissingValue() {
        return -9999.0f;
    }
}

