/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2BitMapSection {
    private final int length;
    private final int section;
    private final int bitMapIndicator;
    private boolean[] bitmap = null;

    public Grib2BitMapSection(RandomAccessFile raf, Grib2GridDefinitionSection gds) throws IOException {
        int[] bitmask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        long sectionEnd = raf.getFilePointer();
        this.length = GribNumbers.int4(raf);
        sectionEnd += (long)this.length;
        this.section = raf.read();
        this.bitMapIndicator = raf.read();
        if (this.bitMapIndicator != 0) {
            return;
        }
        byte[] data = new byte[this.length - 6];
        raf.read(data);
        this.bitmap = new boolean[gds.getNumberPoints()];
        for (int i = 0; i < this.bitmap.length; ++i) {
            this.bitmap[i] = (data[i / 8] & bitmask[i % 8]) != 0;
        }
        raf.seek(sectionEnd);
    }

    public final int getBitmapIndicator() {
        return this.bitMapIndicator;
    }

    public final boolean[] getBitmap() {
        return this.bitmap;
    }
}

