/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.QuasiRegular;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2Data {
    private RandomAccessFile raf = null;
    private boolean expandQuasi = true;

    public Grib2Data(RandomAccessFile raf) {
        this.raf = raf;
    }

    public Grib2Data(RandomAccessFile raf, boolean expandQuasi) {
        this.raf = raf;
        this.expandQuasi = expandQuasi;
    }

    public final float[] getData(long GdsOffset, long PdsOffset) throws IOException {
        long start = System.currentTimeMillis();
        this.raf.seek(GdsOffset);
        Grib2GridDefinitionSection gds = new Grib2GridDefinitionSection(this.raf, false);
        this.raf.seek(PdsOffset);
        Grib2ProductDefinitionSection pds = new Grib2ProductDefinitionSection(this.raf);
        Grib2DataRepresentationSection drs = new Grib2DataRepresentationSection(this.raf);
        Grib2BitMapSection bms = new Grib2BitMapSection(this.raf, gds);
        if (bms.getBitmapIndicator() == 254) {
            long offset = this.raf.getFilePointer();
            this.raf.seek(GdsOffset);
            gds = new Grib2GridDefinitionSection(this.raf, false);
            Grib2ProductDefinitionSection savepds = pds;
            pds = new Grib2ProductDefinitionSection(this.raf);
            Grib2DataRepresentationSection savedrs = drs;
            drs = new Grib2DataRepresentationSection(this.raf);
            bms = new Grib2BitMapSection(this.raf, gds);
            pds = savepds;
            drs = savedrs;
            this.raf.seek(offset);
        }
        Grib2DataSection ds = new Grib2DataSection(true, this.raf, gds, drs, bms);
        if (gds.getOlon() == 0 || !this.expandQuasi) {
            return ds.getData();
        }
        QuasiRegular qr = new QuasiRegular(ds.getData(), gds);
        return qr.getData();
    }
}

