/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2GridDefinitionSection {
    private static final float tenToNegSix = 1.0E-6f;
    private static final float tenToNegThree = 0.001f;
    private final int length;
    private final int section;
    private final int source;
    private final int numberPoints;
    private final int olon;
    private final int iolon;
    private int[] olonPts;
    private int maxPts;
    private final int gdtn;
    private final String name;
    private int shape;
    private float earthRadius;
    private float majorAxis;
    private float minorAxis;
    private int nx;
    private int ny;
    private int angle;
    private int subdivisionsangle;
    private float la1;
    private float lo1;
    private int resolution;
    private float la2;
    private float lo2;
    private float lad;
    private float lov;
    private float dx;
    private float dy;
    private int projectionCenter;
    private int scanMode;
    private float latin1;
    private float latin2;
    private float spLat;
    private float spLon;
    private float rotationangle;
    private float poleLat;
    private float poleLon;
    private int lonofcenter;
    private int factor;
    private int n;
    private float j;
    private float k;
    private float m;
    private int method;
    private int mode;
    private float xp;
    private float yp;
    private int lap;
    private int lop;
    private int xo;
    private int yo;
    private int altitude;
    private int n2;
    private int n3;
    private int ni;
    private int nd;
    private int position;
    private int order;
    private float nb;
    private float nr;
    private float dstart;
    private String checksum = "";

    public Grib2GridDefinitionSection(RandomAccessFile raf, boolean doCheckSum) throws IOException {
        int scalefactorradius = 0;
        int scaledvalueradius = 0;
        int scalefactormajor = 0;
        int scaledvaluemajor = 0;
        int scalefactorminor = 0;
        int scaledvalueminor = 0;
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        this.source = raf.read();
        this.numberPoints = GribNumbers.int4(raf);
        double checkSum = this.numberPoints;
        this.olon = raf.read();
        this.iolon = raf.read();
        this.gdtn = GribNumbers.int2(raf);
        checkSum = 7.0 * checkSum + (double)this.gdtn;
        this.name = Grib2GridDefinitionSection.getGridName(this.gdtn);
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.angle = GribNumbers.int4(raf);
                this.subdivisionsangle = GribNumbers.int4(raf);
                float ratio = this.angle == 0 ? 1.0E-6f : (float)(this.angle / this.subdivisionsangle);
                this.la1 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.resolution = raf.read();
                this.la2 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.la2;
                this.lo2 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.lo2;
                this.dx = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dy = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.dy;
                this.scanMode = raf.read();
                if (this.gdtn == 1) {
                    this.spLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.spLat;
                    this.spLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.spLon;
                    this.rotationangle = raf.readFloat();
                    break;
                }
                if (this.gdtn == 2) {
                    this.poleLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.poleLat;
                    this.poleLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.poleLon;
                    this.factor = GribNumbers.int4(raf);
                    break;
                }
                if (this.gdtn != 3) break;
                this.spLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLat;
                this.spLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLon;
                this.rotationangle = raf.readFloat();
                this.poleLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.poleLat;
                this.poleLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.poleLon;
                this.factor = GribNumbers.int4(raf);
                break;
            }
            case 10: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.resolution = raf.read();
                this.lad = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lad;
                this.la2 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.la2;
                this.lo2 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lo2;
                this.scanMode = raf.read();
                this.angle = GribNumbers.int4(raf);
                this.dx = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dy = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dy;
                break;
            }
            case 20: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.resolution = raf.read();
                this.lad = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lad;
                this.lov = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lov;
                this.dx = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dy = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dy;
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                break;
            }
            case 30: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.resolution = raf.read();
                this.lad = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lad;
                this.lov = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lov;
                this.dx = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dy = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dy;
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                this.latin1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.latin1;
                this.latin2 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.latin2;
                this.spLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLat;
                this.spLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLon;
                break;
            }
            case 31: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.resolution = raf.read();
                this.lad = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lad;
                this.lov = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lov;
                this.dx = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dy = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dy;
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                this.latin1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.latin1;
                this.latin2 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.latin2;
                this.spLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLat;
                this.spLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLon;
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.angle = GribNumbers.int4(raf);
                this.subdivisionsangle = GribNumbers.int4(raf);
                float ratio = this.angle == 0 ? 1.0E-6f : (float)(this.angle / this.subdivisionsangle);
                this.la1 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.resolution = raf.read();
                this.la2 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.la2;
                this.lo2 = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.lo2;
                this.dx = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.n = GribNumbers.int4(raf);
                this.scanMode = raf.read();
                if (this.gdtn == 41) {
                    this.spLat = (float)GribNumbers.int4(raf) * ratio;
                    checkSum = 7.0 * checkSum + (double)this.spLat;
                    this.spLon = (float)GribNumbers.int4(raf) * ratio;
                    checkSum = 7.0 * checkSum + (double)this.spLon;
                    this.rotationangle = raf.readFloat();
                    break;
                }
                if (this.gdtn == 42) {
                    this.poleLat = (float)GribNumbers.int4(raf) * ratio;
                    checkSum = 7.0 * checkSum + (double)this.poleLat;
                    this.poleLon = (float)GribNumbers.int4(raf) * ratio;
                    checkSum = 7.0 * checkSum + (double)this.poleLon;
                    this.factor = GribNumbers.int4(raf);
                    break;
                }
                if (this.gdtn != 43) break;
                this.spLat = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.spLat;
                this.spLon = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.spLon;
                this.rotationangle = raf.readFloat();
                this.poleLat = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.poleLat;
                this.poleLon = (float)GribNumbers.int4(raf) * ratio;
                checkSum = 7.0 * checkSum + (double)this.poleLon;
                this.factor = GribNumbers.int4(raf);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.j = raf.readFloat();
                this.k = raf.readFloat();
                this.m = raf.readFloat();
                this.method = raf.read();
                this.mode = raf.read();
                if (this.gdtn == 51) {
                    this.spLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.spLat;
                    this.spLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.spLon;
                    this.rotationangle = raf.readFloat();
                    break;
                }
                if (this.gdtn == 52) {
                    this.poleLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.poleLat;
                    this.poleLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                    checkSum = 7.0 * checkSum + (double)this.poleLon;
                    this.factor = GribNumbers.int4(raf);
                    break;
                }
                if (this.gdtn != 53) break;
                this.spLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLat;
                this.spLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.spLon;
                this.rotationangle = raf.readFloat();
                this.poleLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.poleLat;
                this.poleLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.poleLon;
                this.factor = GribNumbers.int4(raf);
                break;
            }
            case 90: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.lap = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.lap;
                this.lop = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.lop;
                this.resolution = raf.read();
                this.dx = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dy = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.dy;
                this.xp = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.xp;
                this.yp = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.yp;
                this.scanMode = raf.read();
                this.angle = GribNumbers.int4(raf);
                this.altitude = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.altitude;
                this.xo = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.xo;
                this.yo = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.yo;
                break;
            }
            case 100: {
                this.n2 = raf.read();
                checkSum = 7.0 * checkSum + (double)this.n2;
                this.n3 = raf.read();
                checkSum = 7.0 * checkSum + (double)this.n3;
                this.ni = GribNumbers.int2(raf);
                checkSum = 7.0 * checkSum + (double)this.ni;
                this.nd = raf.read();
                checkSum = 7.0 * checkSum + (double)this.nd;
                this.poleLat = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.poleLat;
                this.poleLon = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.poleLon;
                this.lonofcenter = GribNumbers.int4(raf);
                this.position = raf.read();
                this.order = raf.read();
                this.scanMode = raf.read();
                this.n = GribNumbers.int4(raf);
                break;
            }
            case 110: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = (float)GribNumbers.int4(raf) * 1.0E-6f;
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.resolution = raf.read();
                this.dx = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dy = (float)GribNumbers.int4(raf) * 0.001f;
                checkSum = 7.0 * checkSum + (double)this.dy;
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                break;
            }
            case 120: {
                this.nb = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.nb;
                this.nr = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.nr;
                this.la1 = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.la1;
                this.lo1 = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.lo1;
                this.dx = GribNumbers.int4(raf);
                checkSum = 7.0 * checkSum + (double)this.dx;
                this.dstart = raf.readFloat();
                this.scanMode = raf.read();
                int i = 0;
                while ((float)i < this.nr) {
                    ++i;
                }
                System.out.println("need code to get azi and adelta");
                break;
            }
            case 204: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                byte[] dst = new byte[16];
                raf.read(dst);
                this.resolution = raf.read();
                raf.read(dst);
                this.scanMode = raf.read();
                break;
            }
            default: {
                System.out.println("Unknown Grid Type " + Integer.toString(this.gdtn));
            }
        }
        if ((this.gdtn < 50 || this.gdtn > 53) && this.gdtn != 100 && this.gdtn != 120) {
            if (this.shape == 0) {
                this.earthRadius = 6367470.0f;
            } else if (this.shape == 1) {
                this.earthRadius = scaledvalueradius;
                if (scalefactorradius != 0) {
                    this.earthRadius = (float)((double)this.earthRadius / Math.pow(10.0, scalefactorradius));
                }
            } else if (this.shape == 2) {
                this.majorAxis = 6378160.0f;
                this.minorAxis = 6356775.0f;
            } else if (this.shape == 3) {
                this.majorAxis = scaledvaluemajor;
                this.majorAxis = (float)((double)this.majorAxis / Math.pow(10.0, scalefactormajor));
                this.minorAxis = scaledvalueminor;
                this.minorAxis = (float)((double)this.minorAxis / Math.pow(10.0, scalefactorminor));
            } else if (this.shape == 4) {
                this.majorAxis = 6378137.0f;
                this.minorAxis = 6356752.5f;
            } else if (this.shape == 6) {
                this.earthRadius = 6371229.0f;
            }
        }
        if (this.olon != 0) {
            int numPts = (this.scanMode & 0x20) == 0 ? this.ny : this.nx;
            this.olonPts = new int[numPts];
            this.maxPts = 0;
            if (this.olon == 1) {
                for (int i = 0; i < numPts; ++i) {
                    this.olonPts[i] = raf.read();
                    if (this.maxPts >= this.olonPts[i]) continue;
                    this.maxPts = this.olonPts[i];
                }
            } else if (this.olon == 2) {
                for (int i = 0; i < numPts; ++i) {
                    this.olonPts[i] = raf.readUnsignedShort();
                    if (this.maxPts >= this.olonPts[i]) continue;
                    this.maxPts = this.olonPts[i];
                }
            }
            if ((this.scanMode & 0x20) == 0) {
                this.nx = this.maxPts;
            } else {
                this.ny = this.maxPts;
            }
            this.dx = (this.lo2 - this.lo1) / (float)(this.nx - 0);
        }
        this.checksum = Integer.toString(Double.toString(checkSum).hashCode());
    }

    public static String getGridName(int gdtn) {
        switch (gdtn) {
            case 0: {
                return "Latitude/Longitude";
            }
            case 1: {
                return "Rotated Latitude/Longitude";
            }
            case 2: {
                return "Stretched Latitude/Longitude";
            }
            case 3: {
                return "iStretched and Rotated Latitude/Longitude";
            }
            case 10: {
                return "Mercator";
            }
            case 20: {
                return "Polar stereographic";
            }
            case 30: {
                return "Lambert Conformal";
            }
            case 31: {
                return "Albers Equal Area";
            }
            case 40: {
                return "Gaussian latitude/longitude";
            }
            case 41: {
                return "Rotated Gaussian Latitude/longitude";
            }
            case 42: {
                return "Stretched Gaussian Latitude/longitude";
            }
            case 43: {
                return "Stretched and Rotated Gaussian Latitude/longitude";
            }
            case 50: {
                return "Spherical harmonic coefficients";
            }
            case 51: {
                return "Rotated Spherical harmonic coefficients";
            }
            case 52: {
                return "Stretched Spherical harmonic coefficients";
            }
            case 53: {
                return "Stretched and Rotated Spherical harmonic coefficients";
            }
            case 90: {
                return "Space View Perspective or Orthographic";
            }
            case 100: {
                return "Triangular Grid Based on an Icosahedron";
            }
            case 110: {
                return "Equatorial Azimuthal Equidistant";
            }
            case 120: {
                return "Azimuth-Range";
            }
            case 204: {
                return "Curvilinear Orthogonal Grid";
            }
        }
        return "Unknown projection" + gdtn;
    }

    public final int getSource() {
        return this.source;
    }

    public final int getNumberPoints() {
        return this.numberPoints;
    }

    public final int getOlon() {
        return this.olon;
    }

    public final int getIolon() {
        return this.iolon;
    }

    public final int[] getOlonPoints() {
        return this.olonPts;
    }

    public final int getMaxPts() {
        return this.maxPts;
    }

    public final int getGdtn() {
        return this.gdtn;
    }

    public final String getName() {
        return this.name;
    }

    public final int getShape() {
        return this.shape;
    }

    public final String getShapeName() {
        return Grib2GridDefinitionSection.getShapeName(this.shape);
    }

    public static String getShapeName(int shape) {
        switch (shape) {
            case 0: {
                return "Earth spherical with radius = 6367470 m";
            }
            case 1: {
                return "Earth spherical with radius specified by producer";
            }
            case 2: {
                return "Earth oblate spheroid with major axis = 6378160.0 m and minor axis = 6356775.0 m";
            }
            case 3: {
                return "Earth oblate spheroid with axes specified by producer";
            }
            case 4: {
                return "Earth oblate spheroid with major axis = 6378137.0 m and minor axis = 6356752.314 m";
            }
            case 5: {
                return "Earth represent by WGS84";
            }
            case 6: {
                return "Earth spherical with radius of 6371229.0 m";
            }
        }
        return "Unknown Earth Shape";
    }

    public final float getEarthRadius() {
        return this.earthRadius;
    }

    public final float getMajorAxis() {
        return this.majorAxis;
    }

    public final float getMinorAxis() {
        return this.minorAxis;
    }

    public final int getNx() {
        return this.nx;
    }

    public final int getNy() {
        return this.ny;
    }

    public final int getAngle() {
        return this.angle;
    }

    public final int getSubdivisionsangle() {
        return this.subdivisionsangle;
    }

    public final float getLa1() {
        return this.la1;
    }

    public final float getLo1() {
        return this.lo1;
    }

    public final int getResolution() {
        return this.resolution;
    }

    public final float getLa2() {
        return this.la2;
    }

    public final float getLo2() {
        return this.lo2;
    }

    public final float getLad() {
        return this.lad;
    }

    public final float getLov() {
        return this.lov;
    }

    public final float getDx() {
        return this.dx;
    }

    public final float getDy() {
        return this.dy;
    }

    public final int getProjectionCenter() {
        return this.projectionCenter;
    }

    public final int getScanMode() {
        return this.scanMode;
    }

    public final float getLatin1() {
        return this.latin1;
    }

    public final float getLatin2() {
        return this.latin2;
    }

    public final float getSpLat() {
        return this.spLat;
    }

    public final float getSpLon() {
        return this.spLon;
    }

    public final float getRotationangle() {
        return this.rotationangle;
    }

    public final float getPoleLat() {
        return this.poleLat;
    }

    public final float getPoleLon() {
        return this.poleLon;
    }

    public final float getFactor() {
        return this.factor;
    }

    public final int getN() {
        return this.n;
    }

    public final float getJ() {
        return this.j;
    }

    public final float getK() {
        return this.k;
    }

    public final float getM() {
        return this.m;
    }

    public final int getMethod() {
        return this.method;
    }

    public final int getMode() {
        return this.mode;
    }

    public final float getLap() {
        return this.lap;
    }

    public final float getLop() {
        return this.lop;
    }

    public final float getXp() {
        return this.xp;
    }

    public final float getYp() {
        return this.yp;
    }

    public final float getXo() {
        return this.xo;
    }

    public final float getYo() {
        return this.yo;
    }

    public final float getAltitude() {
        return this.altitude;
    }

    public final int getN2() {
        return this.n2;
    }

    public final int getN3() {
        return this.n3;
    }

    public final int getNi() {
        return this.ni;
    }

    public final int getNd() {
        return this.nd;
    }

    public final int getPosition() {
        return this.position;
    }

    public final int getOrder() {
        return this.order;
    }

    public final float getNb() {
        return this.nb;
    }

    public final float getNr() {
        return this.nr;
    }

    public final float getDstart() {
        return this.dstart;
    }

    public final String getCheckSum() {
        return this.checksum;
    }
}

