/*
 * Generated by MyEclipse Struts
 * Template path: templates/java/JavaClass.vtl
 */
package gov.noaa.pmel.tmap.las.ui;

import gov.noaa.pmel.tmap.las.exception.LASException;
import gov.noaa.pmel.tmap.las.jdom.LASConfig;
import gov.noaa.pmel.tmap.las.product.server.LASConfigPlugIn;
import gov.noaa.pmel.tmap.las.util.Arange;
import gov.noaa.pmel.tmap.las.util.Axis;
import gov.noaa.pmel.tmap.las.util.Grid;
import gov.noaa.pmel.tmap.las.util.NameValuePair;
import gov.noaa.pmel.tmap.las.util.TimeAxis;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

/** 
 * MyEclipse Struts
 * Creation date: 01-08-2007
 * 
 * XDoclet definition:
 * @struts.action validate="true"
 */
public class GetGrid extends ConfigService {
    /*
     * Generated Methods
     */

    /** 
     * Method execute
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return ActionForward
     */
    private static Logger log = LogManager.getLogger(GetGrid.class.getName());
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) {
        
        // TODO Add a format=json|xml|json-xml and then for XML extract the data set JDOM element collection and return that as XML
        // Get the LASConfig (sub-class of JDOM Document) from the servlet context.
		String query = request.getQueryString();
		if ( query != null ) {
			try{
				query = URLDecoder.decode(query, "UTF-8");
				log.info("START: "+request.getRequestURL()+"?"+query);
			} catch (UnsupportedEncodingException e) {
				// Don't care we missed a log message.
			}			
		} else {
			log.info("START: "+request.getRequestURL());
		}
        LASConfig lasConfig = (LASConfig)servlet.getServletContext().getAttribute(LASConfigPlugIn.LAS_CONFIG_KEY);
        String dsID = request.getParameter("dsid");
        String varID = request.getParameter("varid");
        String format = request.getParameter("format");
        if ( format == null ) {
            format = "json";
        }
        
        Grid grid = null;
        
        StringBuffer xml = new StringBuffer();
        
        // I'm starting to distrust JSON.  Since getGrid is singular (there's only one) then there won't
        // be an inner array like there is with the others.  Therefore, we don't need the Util code 
        // to make the case where there is only one look like the case where there are many.  But,
        // this JSON object won't be consistent with the others...
        try {
            grid = lasConfig.getGrid(dsID, varID);
            // special case to add status message since container is a singleton ("grid").
            grid.ok();
            xml.append(grid.toXML());
            PrintWriter respout = response.getWriter();
            if ( format.equals("xml") ) {
                respout.print(xml.toString());
            } else {
                JSONObject json_response = XML.toJSONObject(xml.toString());
                json_response.put("status", "ok");
                json_response.put("error", "");
                log.debug(json_response.toString(3));
                json_response.write(respout);
            }
        } catch (JSONException e) {
            sendError(response, "grid", format, e.toString());
        } catch (IOException e) {
        	sendError(response, "grid", format, e.toString());
        } catch (JDOMException e) {
        	sendError(response, "grid", format, e.toString());
        } catch (LASException e) {
        	sendError(response, "grid", format, e.toString());
        }
        if ( query != null ) {
			log.info("END:   "+request.getRequestURL()+"?"+query);						
		} else {
			log.info("END:   "+request.getRequestURL());
		}
		
        return null;
    }
}