/*
 * Generated by MyEclipse Struts
 * Template path: templates/java/JavaClass.vtl
 */
package gov.noaa.pmel.tmap.las.ui;

import gov.noaa.pmel.tmap.las.jdom.LASConfig;
import gov.noaa.pmel.tmap.las.product.server.LASConfigPlugIn;
import gov.noaa.pmel.tmap.las.util.Category;
import gov.noaa.pmel.tmap.las.util.Constants;
import gov.noaa.pmel.tmap.las.util.NameValuePair;
import gov.noaa.pmel.tmap.las.util.Option;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

/** 
 * MyEclipse Struts
 * Creation date: 03-13-2007
 * 
 * XDoclet definition:
 * @struts.action validate="true"
 */
public class GetOptions extends ConfigService {
	private static Logger log = LogManager.getLogger(GetOptions.class.getName());
	/*
	 * Generated Methods
	 */

	/** 
	 * Method execute
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return ActionForward
	 */
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		String query = request.getQueryString();
		if ( query != null ) {
			try{
				query = URLDecoder.decode(query, "UTF-8");
				log.info("START: "+request.getRequestURL()+"?"+query);
			} catch (UnsupportedEncodingException e) {
				// Don't care we missed a log message.
			}			
		} else {
			log.info("START: "+request.getRequestURL());
		}
		LASConfig lasConfig = (LASConfig)servlet.getServletContext().getAttribute(LASConfigPlugIn.LAS_CONFIG_KEY);
		String opid = request.getParameter("opid");
		String format = request.getParameter("format");

		
		// Handle the case of a forward from a confluence server to retrieve local options.

		if ( opid.contains(Constants.NAME_SPACE_SPARATOR)) {
			String[] parts = opid.split(Constants.NAME_SPACE_SPARATOR);
			String server_key = parts[0];

			String local_server_key = null;
			try {
				local_server_key = lasConfig.getBaseServerURLKey();
			} catch (UnsupportedEncodingException e) {
				sendError(response, "options", format, e.toString());
			} catch (JDOMException e) {
				sendError(response, "options", format, e.toString());
			}
            if ( server_key.equals(local_server_key) ) opid = parts[1];

		}
		if ( format == null ) {
			format = "json";
		}
		
		ArrayList<Option> options = new ArrayList<Option>();

		try {
			options = lasConfig.getOptions(opid);
			PrintWriter respout = response.getWriter();

			if ( format.equals("xml") ) {
				response.setContentType("application/xml");
				respout.print(Util.toXML(options, "options"));
			} else {
				response.setContentType("application/json");
				JSONObject json_response = toJSON(options, "options");
				log.debug(json_response.toString(3));
				json_response.write(respout);      
			}
			// JDOMException, JSONException and IOException expected.
		} catch (Exception e) {
			sendError(response, "options", format, e.toString());
		} 
		if ( query != null ) {
			log.info("END:   "+request.getRequestURL()+"?"+query);						
		} else {
			log.info("END:   "+request.getRequestURL());
		}
		return null;
	}
	private JSONObject toJSON(ArrayList<Option> options, String string) throws JSONException {
		JSONObject json_response = new JSONObject();
		JSONObject options_object = new JSONObject();
		for (Iterator opIt = options.iterator(); opIt.hasNext();) {
			Option op = (Option) opIt.next();
			JSONObject option = op.toJSON();           
			options_object.array_accumulate("option", option);
		}
		options_object.put("status", "ok");
		options_object.put("error", "");
		json_response.put("options", options_object);
		return json_response;
	}
	
}