--
-- Add the 'platform' table to Database: LAS_insitu_demo
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ LAS_insitu_demo;

USE LAS_insitu_demo;

--
-- Table structure for table `platforms`
--

CREATE TABLE platforms (
  id char(8) default NULL,
  type char(16) default NULL,
  country char(2) default NULL,
  time datetime default NULL,
  lon float default NULL,
  lat float default NULL,
  sst float default NULL
) TYPE=MyISAM;

--
-- Dumping data for table `Indian`
--

INSERT INTO platforms VALUES ('2900428','ARGO FLOAT','KR','20050526184400',138.674,9.208,-999);
INSERT INTO platforms VALUES ('2900429','ARGO FLOAT','KR','20050526060400',138.191,10.849,-999);
INSERT INTO platforms VALUES ('2900436','ARGO FLOAT','KR','20050527183600',144.828,3.423,-999);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526024000',173.19,-4.46,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526042700',173.19,-4.46,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526065800',173.16,-4.43,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526134700',173.16,-4.43,30.1);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526173700',173.11,-4.35,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526212600',173.07,-4.27,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527022800',173.04,-4.24,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527223300',172.67,-3.91,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527192700',172.67,-3.91,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527174700',172.72,-3.93,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527152500',172.77,-3.95,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527134200',172.81,-3.96,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527100300',172.99,-4.15,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527063600',173.04,-4.24,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527050300',172.97,-4.15,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050527040800',173.04,-4.24,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528165100',172.05,-3.81,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528151500',172.1,-3.81,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528111000',172.27,-3.83,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528094000',172.27,-3.83,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528093100',172.27,-3.83,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528080000',172.33,-3.83,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528062400',172.37,-3.84,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528040800',172.45,-3.84,30.6);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528002000',172.67,-3.91,30.4);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528221500',171.88,-3.78,30);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528221100',171.99,-3.79,30);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528203700',171.99,-3.79,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528190400',171.99,-3.79,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050528182600',172.05,-3.81,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526230800',173.04,-4.24,30.3);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526194900',173.08,-4.3,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526175900',173.09,-4.32,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526153700',173.11,-4.35,30.2);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526115800',173.29,-4.4,30.1);
INSERT INTO platforms VALUES ('32639','DRIFTING BUOY','US','20050526052900',173.16,-4.44,30.4);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526023800',166.99,-4.95,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526153700',166.88,-4.95,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528062400',166.46,-4.35,29.8);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528040900',166.5,-4.4,29.9);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528002400',166.51,-4.49,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527192800',166.55,-4.58,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527174700',166.57,-4.61,29.6);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527165700',166.6,-4.65,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527152600',166.6,-4.65,29.8);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527100100',166.65,-4.73,30.1);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527061500',166.69,-4.79,30.3);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527040800',166.74,-4.88,30.4);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527022800',166.74,-4.88,30.3);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050527003900',166.79,-4.94,30.2);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526230900',166.76,-4.91,30);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526195000',166.88,-4.95,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526192000',166.82,-4.95,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526180000',166.82,-4.95,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526173700',166.88,-4.95,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528222100',166.22,-3.88,30);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528221200',166.3,-4.04,30);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528204100',166.25,-3.92,29.9);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528203900',166.3,-4.04,-999);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528190500',166.3,-4.04,29.8);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528183000',166.27,-3.99,29.8);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528165000',166.3,-4.04,29.8);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528151500',166.34,-4.09,29.8);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528111000',166.46,-4.3,29.8);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528093600',166.46,-4.3,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528093000',166.46,-4.3,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050528080100',166.46,-4.3,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526095400',166.96,-4.94,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526115700',167.3,-4.91,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526084600',166.96,-4.94,-999);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526065800',166.92,-4.94,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526042700',166.96,-4.94,29.7);
INSERT INTO platforms VALUES ('32712','DRIFTING BUOY','US','20050526052700',166.96,-4.94,29.6);
INSERT INTO platforms VALUES ('3EZF5','SHIP','','20050527060000',145.3,9.9,29);
INSERT INTO platforms VALUES ('3EZF5','SHIP','','20050528060000',147.8,5.3,30);
INSERT INTO platforms VALUES ('3EZF5','SHIP','','20050528180000',149.3,2.9,30);
INSERT INTO platforms VALUES ('3FKM8','SHIP','','20050528180000',144.3,-.1,24);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526010000',148.76,-.96,30.2);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526042700',148.67,-1.01,30.3);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528054900',148.2,-1.16,30.3);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528040900',148.2,-1.16,30.5);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528002600',148.23,-1.15,30.3);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527205700',148.27,-1.13,30);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527192700',148.28,-1.12,30);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527165700',148.3,-1.12,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527152200',148.3,-1.12,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527131600',148.42,-1.11,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527131600',148.55,-1.07,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527061300',148.42,-1.11,30.4);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527055700',148.42,-1.11,30.4);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527003600',148.48,-1.1,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528221700',148.15,-1.1,29.9);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528204300',148.15,-1.1,29.9);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528190300',148.16,-1.11,30);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528183200',148.16,-1.17,30);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528182600',148.16,-1.15,30);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526230600',148.47,-1.11,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526224000',148.48,-1.1,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526212900',148.48,-1.1,30);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526195200',148.53,-1.08,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526191300',148.53,-1.08,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526153600',148.53,-1.08,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526134700',148.53,-1.07,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526115800',148.87,-.93,30.2);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528165500',148.16,-1.17,30);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528151100',148.16,-1.15,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528125300',148.16,-1.16,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528112200',148.16,-1.17,30.1);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528093600',148.18,-1.17,30.2);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050528080000',148.19,-1.17,30.2);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050527040800',148.43,-1.12,30.4);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526085100',148.58,-1.04,30.2);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526071200',148.61,-1.03,30.2);
INSERT INTO platforms VALUES ('44093','MOORED BUOY','US','20050526060400',148.63,-1.02,30.3);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526023900',169.73,-12.61,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526042700',169.71,-12.62,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526052600',169.71,-12.63,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526065800',169.71,-12.62,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526084000',169.71,-12.62,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527193000',169.41,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527174900',169.44,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527170300',169.47,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527061000',169.56,-12.65,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527040700',169.55,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527022800',169.55,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527004300',169.63,-12.64,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526231100',169.62,-12.65,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526212900',169.63,-12.64,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526195200',169.63,-12.64,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526181400',169.65,-12.64,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526174000',169.66,-12.64,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528222500',169.1,-12.7,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528221900',169.07,-12.71,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528203900',169.1,-12.7,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528190700',169.1,-12.7,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528182900',169.12,-12.69,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528165400',169.19,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528151700',169.12,-12.69,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528110900',169.19,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528093500',169.23,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528092900',169.23,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528075100',169.35,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528062200',169.25,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528040400',169.28,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050528002300',169.35,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527152800',169.47,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527134500',169.49,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527100000',169.52,-12.67,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050527063600',169.55,-12.66,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526153900',169.68,-12.64,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526134700',169.68,-12.64,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526115800',169.67,-12.63,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526095400',169.71,-12.62,-999);
INSERT INTO platforms VALUES ('51511','DRIFTING BUOY','US','20050526081300',169.71,-12.62,-999);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526005900',154.55,-3.54,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526042700',154.55,-3.54,30);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526115800',154.68,-3.46,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527192900',154.02,-3.6,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527165700',154.03,-3.6,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527055800',154.3,-3.65,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527040700',154.23,-3.68,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527003800',154.3,-3.65,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526230800',154.32,-3.64,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526212700',154.41,-3.62,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526195200',154.41,-3.62,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526191800',154.41,-3.62,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526180900',154.41,-3.62,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526173900',154.41,-3.62,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528204400',153.82,-3.58,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528190400',153.83,-3.57,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528182900',153.82,-3.56,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528165600',153.9,-3.63,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528151300',153.82,-3.56,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528125200',153.82,-3.58,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528112200',153.84,-3.6,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528093100',153.9,-3.63,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528080100',153.9,-3.63,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528221700',153.82,-3.58,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528072900',153.99,-3.62,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528062100',153.92,-3.63,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528054600',153.95,-3.63,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528041000',153.95,-3.63,29.6);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050528002600',153.99,-3.62,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527205700',154.02,-3.61,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527152500',154.03,-3.6,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050527061200',154.23,-3.68,29.7);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526153700',154.41,-3.62,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526134400',154.49,-3.61,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526095500',154.49,-3.61,29.8);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526060500',154.55,-3.54,30);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526085000',154.49,-3.61,29.9);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526065900',154.52,-3.6,30);
INSERT INTO platforms VALUES ('51517','DRIFTING BUOY','US','20050526024700',154.56,-3.56,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526005800',147.79,-1.37,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528235800',147.03,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528222700',147.02,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528151000',147.16,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528125400',147.22,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528112200',147.16,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528093700',147.2,-1.47,-999);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527060100',147.51,-1.55,30.3);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526224000',147.61,-1.53,29.6);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526212900',147.61,-1.53,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526195100',147.61,-1.53,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526191400',147.61,-1.53,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526174400',147.59,-1.55,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526153700',147.61,-1.53,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526134800',147.63,-1.52,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526115900',147.89,-1.27,29.8);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526095500',147.68,-1.5,29.8);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528204400',147.03,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528200600',147.05,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528190300',147.05,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528183700',147.05,-1.47,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528182600',147.05,-1.47,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528165600',147.18,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528080100',147.2,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528073800',147.22,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528073600',147.22,-1.47,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528054900',147.24,-1.49,30.4);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528040900',147.24,-1.51,30.8);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050528002500',147.29,-1.53,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527210800',147.33,-1.54,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527165600',147.51,-1.55,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527152300',147.51,-1.55,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527131500',147.51,-1.55,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527131500',147.66,-1.52,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527080300',147.51,-1.55,30.1);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527062300',147.51,-1.55,30.2);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527040800',147.5,-1.56,30.3);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527003800',147.57,-1.55,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526230400',147.54,-1.54,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050527192800',147.36,-1.54,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526084000',147.68,-1.5,29.9);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526071200',147.69,-1.49,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526060600',147.71,-1.48,30);
INSERT INTO platforms VALUES ('51528','DRIFTING BUOY','US','20050526042700',147.71,-1.48,30);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526023900',173.35,-6.49,29.6);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526042700',173.37,-6.46,29.7);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526065900',173.37,-6.47,29.7);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526095400',173.37,-6.46,29.8);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528222100',173.07,-5.88,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528221000',173.08,-5.87,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528203900',173.05,-5.87,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528190400',173.08,-5.87,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528182900',173.18,-5.88,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528151500',173.18,-5.88,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528112200',173.18,-5.88,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528094000',173.28,-5.93,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528093000',173.21,-5.89,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528075800',173.39,-6.01,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528062400',173.25,-5.91,30);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528040600',173.28,-5.93,30.1);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527223200',173.39,-6.01,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527061300',173.48,-6.21,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050528165100',173.18,-5.88,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527050400',173.32,-6.5,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527040800',173.47,-6.25,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527022800',173.46,-6.33,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526230900',173.46,-6.33,29.8);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526212700',173.45,-6.35,29.8);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526194800',173.42,-6.39,29.7);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526180000',173.43,-6.38,29.7);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526174000',173.42,-6.39,29.7);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527192700',173.39,-6.01,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527174900',173.41,-6.03,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527152600',173.42,-6.06,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527134300',173.48,-6.21,29.8);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527100300',173.47,-6.25,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050527063700',173.46,-6.33,29.9);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526153700',173.42,-6.39,29.8);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526134600',173.38,-6.45,-999);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526115800',173.32,-6.5,29.8);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526081400',173.37,-6.46,29.8);
INSERT INTO platforms VALUES ('51621','DRIFTING BUOY','US','20050526053000',173.38,-6.46,29.7);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526010000',158.18,-4.23,30.5);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526071200',158.09,-4.27,30.3);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526173700',157.99,-4.3,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528222000',157.31,-4.36,30.1);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528221700',157.31,-4.36,30.1);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528204400',157.31,-4.35,30);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528190500',157.34,-4.33,30);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528182800',157.37,-4.32,30);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528165300',157.37,-4.32,29.9);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528151400',157.4,-4.32,29.7);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528125100',157.42,-4.32,28.9);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528112300',157.44,-4.32,29.8);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528093000',157.49,-4.31,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528075100',157.6,-4.32,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528062200',157.52,-4.32,30.3);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528054400',157.52,-4.32,30.3);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528040900',157.55,-4.32,30.3);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050528001500',157.6,-4.32,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527210400',157.68,-4.34,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527192800',157.68,-4.34,30.1);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527174300',157.7,-4.36,30.1);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527165600',157.72,-4.36,30.1);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527152600',157.72,-4.36,30.1);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527131600',157.82,-4.37,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527061300',157.82,-4.37,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527055800',157.82,-4.37,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527040700',157.87,-4.34,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050527003700',157.87,-4.34,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526230800',157.88,-4.33,30.3);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526224000',157.93,-4.32,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526195100',157.93,-4.32,30.3);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526181100',157.96,-4.31,30.2);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526153700',157.99,-4.3,30.3);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526134100',158.07,-4.27,30.4);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526115700',158.41,-4.22,30.5);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526095500',158.07,-4.27,30.5);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526085000',158.07,-4.27,30.5);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526024800',158.16,-4.25,30);
INSERT INTO platforms VALUES ('51622','DRIFTING BUOY','US','20050526042800',158.12,-4.26,30);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526005800',149.41,-.43,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527222500',149.22,-.33,29.9);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527205800',149.23,-.32,29.9);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527203200',149.23,-.32,29.9);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527192800',149.22,-.33,29.9);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527184900',149.23,-.32,29.9);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527165600',149.24,-.32,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527152300',149.24,-.32,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527131600',149.27,-.35,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526224000',149.33,-.38,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526212900',149.34,-.4,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526195200',149.34,-.4,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526192600',149.33,-.38,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526174400',149.34,-.39,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526153700',149.34,-.4,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526134600',149.35,-.41,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526115800',149.55,-.46,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526095500',149.36,-.43,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528112300',149.2,-.33,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528112000',149.19,-.34,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528093500',149.19,-.34,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528080100',149.19,-.34,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528073800',149.19,-.34,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528073500',149.19,-.34,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528062000',149.2,-.34,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528054900',149.2,-.34,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528040800',149.21,-.34,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528235800',149.17,-.32,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528222600',149.18,-.33,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528204300',149.19,-.34,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528190200',149.19,-.34,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528183700',149.19,-.34,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528182600',149.2,-.33,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528165500',149.2,-.33,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528151100',149.2,-.33,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528125300',149.19,-.34,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528001300',149.22,-.33,30);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050528001000',149.22,-.33,30);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527080200',149.27,-.35,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527062300',149.29,-.35,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527060100',149.29,-.35,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527040800',149.33,-.37,30.4);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050527003700',149.33,-.38,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526230500',149.31,-.38,30.1);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526085000',149.36,-.43,30.2);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526071300',149.37,-.43,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526064900',149.37,-.43,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526042800',149.39,-.43,30.3);
INSERT INTO platforms VALUES ('51635','DRIFTING BUOY','US','20050526060400',149.39,-.43,30.3);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526010600',161.28,-2.4,30.2);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526023900',161.27,-2.42,30.2);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526084800',161.26,-2.46,30.2);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528040900',161.09,-2.53,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527210100',161.16,-2.5,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527192800',161.16,-2.5,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527174400',161.16,-2.5,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527165500',161.16,-2.5,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527152600',161.16,-2.5,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527100100',161.19,-2.51,30);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527063700',161.18,-2.49,30);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527062200',161.18,-2.49,30);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528222500',160.9,-2.65,29.8);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528221200',160.92,-2.64,-999);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528204500',160.92,-2.64,29.8);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528204100',160.92,-2.64,29.8);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528190500',160.94,-2.63,29.8);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528183600',160.95,-2.63,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528165400',160.96,-2.61,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528151300',160.98,-2.6,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528125200',161.03,-2.56,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528112200',161.01,-2.58,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528093100',161.03,-2.56,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528080100',161.04,-2.56,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528073500',161.03,-2.56,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528062200',161.05,-2.55,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528054300',161.09,-2.53,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527040800',161.18,-2.49,30);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050527003700',161.21,-2.48,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526230900',161.19,-2.49,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526224000',161.21,-2.48,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526195000',161.22,-2.46,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526191400',161.21,-2.48,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526180000',161.21,-2.47,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526174600',161.21,-2.47,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050528001300',161.09,-2.53,29.9);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526153800',161.24,-2.45,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526115600',161.31,-2.32,30.1);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526100700',161.24,-2.45,30.2);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526065900',161.27,-2.43,30.2);
INSERT INTO platforms VALUES ('51640','DRIFTING BUOY','US','20050526042700',161.27,-2.42,30.2);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526005900',146.95,-.65,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526120300',147.13,-.64,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526174300',146.75,-.65,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528235700',146,-.49,30.2);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528222600',145.99,-.48,30.1);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528204000',146,-.49,30.1);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528190100',146.02,-.49,30.1);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528183700',146.02,-.5,30.1);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528182600',146.12,-.54,30.1);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528165600',146.14,-.55,30.1);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528125300',146.16,-.56,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528112100',146.12,-.54,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528112000',146.14,-.55,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528093700',146.14,-.55,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528075700',146.16,-.56,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528073800',146.16,-.56,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528073700',146.16,-.56,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528054900',146.18,-.56,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528040900',146.2,-.56,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527131500',146.51,-.62,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527062300',146.51,-.62,30.4);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527055900',146.51,-.62,30.4);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527042100',146.54,-.62,30.4);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527003800',146.66,-.64,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526230600',146.66,-.64,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526212800',146.66,-.64,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526195100',146.68,-.65,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526191300',146.69,-.65,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050528001500',146.24,-.57,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527205500',146.28,-.57,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527203800',146.37,-.59,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527192700',146.31,-.57,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527165600',146.37,-.59,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050527152300',146.37,-.59,29.8);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526153500',146.75,-.65,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526134700',146.77,-.66,29.9);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526100700',146.82,-.66,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526071000',146.87,-.65,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526084900',146.84,-.65,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526060600',146.91,-.65,30);
INSERT INTO platforms VALUES ('51671','DRIFTING BUOY','US','20050526042700',146.91,-.65,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526010000',149.66,-.89,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528221800',148.41,-.46,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528204300',148.41,-.46,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528190300',148.43,-.47,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528165600',148.6,-.55,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528151100',148.5,-.51,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528125400',148.52,-.51,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528112300',148.55,-.53,30);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528080000',148.61,-.54,30);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528072900',149.43,-.82,30);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528072900',148.71,-.59,30);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528055000',148.64,-.56,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528041000',148.67,-.57,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527061400',149.1,-.7,30.4);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527060100',149.1,-.7,30.4);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527040800',149.2,-.73,-999);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527003800',149.3,-.76,30.4);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528235600',148.37,-.43,30.4);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526230600',149.24,-.73,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526212600',149.29,-.75,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526195100',149.29,-.75,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526191300',149.37,-.79,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526153600',149.37,-.79,30);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526134700',149.39,-.8,29.9);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526115900',149.97,-.94,29.9);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526095700',149.48,-.84,29.8);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050528002400',148.71,-.59,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527210600',148.77,-.61,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527192800',148.81,-.62,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527185000',148.85,-.62,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527165700',148.89,-.63,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527152300',148.89,-.63,30.1);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527131700',149.43,-.82,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050527131700',149.1,-.7,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526085100',149.48,-.84,29.6);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526071300',149.5,-.85,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526060500',149.55,-.88,30.2);
INSERT INTO platforms VALUES ('51681','DRIFTING BUOY','US','20050526042700',149.55,-.88,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526024000',171.96,-4.22,30.4);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526052900',171.87,-4.22,30.4);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526042700',171.87,-4.22,30.4);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526065900',171.83,-4.21,30.4);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528235800',170.42,-4.15,30);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528221700',170.32,-4.17,29.9);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528220900',170.42,-4.15,29.9);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528203800',170.38,-4.16,29.9);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528190400',170.42,-4.15,29.9);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528182800',170.5,-4.16,29.9);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528165200',170.5,-4.16,29.8);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528151500',170.53,-4.13,29.9);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528093900',170.75,-4.07,29.7);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528093100',170.71,-4.1,29.7);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528080100',170.75,-4.07,29.6);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528062400',170.8,-4.07,29.8);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527152600',171.2,-4.08,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527134000',171.22,-4.07,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527061200',171.45,-4.13,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527050400',172.23,-4.08,30);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527040800',171.55,-4.16,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527022700',171.55,-4.16,30.5);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527004100',171.61,-4.18,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526230800',171.55,-4.16,30.1);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526212600',171.59,-4.16,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526195000',171.69,-4.19,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526180000',171.65,-4.19,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528112100',170.65,-4.11,29.8);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528040800',170.86,-4.06,30);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050528002400',170.94,-4.06,30.1);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527223300',171.07,-4.06,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527192600',171.07,-4.06,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527174700',171.12,-4.07,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527165900',171.2,-4.08,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527100300',171.45,-4.13,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050527063600',171.55,-4.16,30.2);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526173900',171.69,-4.19,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526153700',171.69,-4.19,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526134700',171.83,-4.21,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526115600',172.23,-4.08,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526095500',171.83,-4.21,30.3);
INSERT INTO platforms VALUES ('51735','DRIFTING BUOY','US','20050526081400',171.87,-4.22,30.3);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526004200',141.51,-2.6,27.4);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526010000',141.53,-2.61,28.2);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528235700',140.73,-2.52,27.1);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528125400',140.73,-2.52,26);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528111800',140.73,-2.52,26.2);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528093800',140.73,-2.52,26.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528080100',140.73,-2.52,29.6);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528073500',140.73,-2.52,29.3);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528054600',140.73,-2.52,28.5);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527165600',140.73,-2.52,24.4);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527131500',140.73,-2.52,25);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527061800',140.73,-2.52,31.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527055700',140.73,-2.52,31.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527041500',140.73,-2.52,-999);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527004700',140.73,-2.52,30.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526212900',140.73,-2.52,25.4);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526194900',140.73,-2.52,26.6);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526192500',140.73,-2.52,26.6);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528222500',140.73,-2.52,25.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528204000',140.74,-2.53,24.9);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528183600',140.73,-2.52,25.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528183400',140.73,-2.52,25.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528165400',140.73,-2.52,25.8);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050528002500',140.73,-2.52,28.4);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527210400',140.73,-2.52,24.7);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527203400',140.73,-2.52,24.4);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050527192500',140.73,-2.52,24.5);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526042700',141.51,-2.6,30.1);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526134600',140.73,-2.52,27);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526100400',141.27,-2.58,28.3);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526085100',141.48,-2.58,28.3);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526070800',141.48,-2.58,32.9);
INSERT INTO platforms VALUES ('51744','DRIFTING BUOY','US','20050526060600',141.5,-2.6,32.6);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526010000',150.05,-.68,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526042700',149.92,-.69,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528235800',149.08,-.55,30.2);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528222600',149.09,-.56,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528204300',149.13,-.56,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528190400',149.15,-.56,29.9);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528183700',149.15,-.56,29.9);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528165500',149.17,-.57,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528151000',149.24,-.58,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528125000',149.21,-.58,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528112100',149.26,-.58,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528093700',149.26,-.58,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528093100',149.26,-.58,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528080100',149.28,-.59,30.2);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528073600',149.27,-.6,30.3);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528055000',149.32,-.59,30.2);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528041000',149.33,-.6,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050528002600',149.37,-.6,30.4);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527205800',149.46,-.6,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527203600',149.46,-.6,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527192400',149.43,-.6,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527165500',149.48,-.6,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527152400',149.48,-.6,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527131700',149.6,-.59,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527080200',149.6,-.59,30.2);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527062400',149.68,-.61,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527055700',149.63,-.59,30.3);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527040800',149.68,-.61,30.4);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050527003900',149.74,-.62,30.1);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526230700',149.71,-.61,29.9);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526212900',149.74,-.62,29.9);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526195200',149.8,-.65,29.9);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526191400',149.8,-.65,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526174500',149.77,-.63,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526153400',149.8,-.65,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526134700',149.82,-.66,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526115800',150.23,-.69,30);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526095400',149.88,-.68,29.9);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526085100',149.88,-.68,29.8);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526071300',149.9,-.68,29.7);
INSERT INTO platforms VALUES ('51753','DRIFTING BUOY','US','20050526060500',149.92,-.69,-999);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526023900',167.82,-6.76,29.5);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526135500',167.77,-6.75,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528222600',167.09,-6.15,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528221200',167.17,-6.18,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528204600',167.14,-6.16,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528203800',167.23,-6.2,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528190500',167.17,-6.18,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528183700',167.19,-6.19,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528165300',167.23,-6.2,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528151400',167.27,-6.22,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528125400',167.32,-6.22,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528112200',167.34,-6.25,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528093600',167.44,-6.3,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528093000',167.44,-6.3,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528075000',167.44,-6.3,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528062300',167.46,-6.33,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528040400',167.51,-6.35,30.1);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527192900',167.62,-6.46,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527174700',167.65,-6.48,29.5);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527165600',167.67,-6.51,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527152700',167.67,-6.51,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527134100',167.73,-6.65,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527100300',167.73,-6.67,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527063600',167.73,-6.7,29.9);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527061900',167.73,-6.65,29.9);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527022700',167.73,-6.7,30.1);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527004500',167.73,-6.7,29.9);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526230800',167.73,-6.71,29.8);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526212300',167.72,-6.73,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526195000',167.72,-6.73,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526192000',167.73,-6.74,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526180000',167.73,-6.74,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526174700',167.73,-6.74,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526153800',167.74,-6.73,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050528002400',167.55,-6.41,29.6);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050527040700',167.73,-6.7,30.1);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526115800',167.73,-6.74,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526095400',167.76,-6.75,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526042600',167.76,-6.75,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526084400',167.76,-6.75,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526065900',167.76,-6.75,29.7);
INSERT INTO platforms VALUES ('51759','DRIFTING BUOY','US','20050526052700',167.76,-6.75,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526010000',156.4,2.68,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526042700',156.4,2.68,29.8);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528222600',156.92,2.18,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528221800',156.92,2.18,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528204200',156.92,2.18,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528204100',156.92,2.18,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528190400',156.91,2.19,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528183500',156.92,2.19,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528165200',156.91,2.21,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528125400',156.84,2.31,29.8);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528112400',156.88,2.28,29.8);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528112100',156.88,2.28,29.8);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528075900',156.84,2.31,29.9);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528073700',156.84,2.31,30);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528073600',156.84,2.3,30);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528062500',156.84,2.32,30);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528054800',156.84,2.32,30);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528041100',156.83,2.33,30.2);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528151200',156.89,2.23,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527192700',156.73,2.38,29.6);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527185000',156.71,2.41,29.5);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527165700',156.7,2.4,29.5);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527152400',156.7,2.4,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527062400',156.64,2.43,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527055700',156.56,2.45,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527040800',156.56,2.45,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527003600',156.56,2.48,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526230700',156.58,2.45,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526224000',156.52,2.54,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526212300',156.52,2.54,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526194900',156.52,2.54,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526191500',156.52,2.54,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526180800',156.54,2.5,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526174400',156.53,2.51,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526153600',156.52,2.54,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050528001100',156.79,2.35,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527222600',156.75,2.38,29.6);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050527205800',156.71,2.41,29.6);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526134400',156.48,2.6,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526115800',156.31,2.79,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526095400',156.48,2.6,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526085000',156.48,2.6,29.7);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526071400',156.48,2.62,29.8);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526060800',156.4,2.68,29.8);
INSERT INTO platforms VALUES ('51760','DRIFTING BUOY','US','20050526025100',156.43,2.67,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526010700',164.62,-5.54,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528222800',164.08,-5.54,30.1);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528222300',164.12,-5.53,-999);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528204600',164.12,-5.53,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528204200',164.12,-5.53,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528190500',164.11,-5.52,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528183600',164.13,-5.51,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528165400',164.14,-5.49,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528151500',164.17,-5.48,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528111800',164.21,-5.46,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528111000',164.24,-5.46,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528093000',164.24,-5.46,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528075000',164.24,-5.46,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528073100',164.41,-5.56,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528073100',164.3,-5.42,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528062300',164.26,-5.46,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528054200',164.27,-5.44,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528002600',164.3,-5.42,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528125300',164.19,-5.47,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527223300',164.31,-5.4,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527192900',164.31,-5.4,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527174700',164.3,-5.4,29.6);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527165600',164.29,-5.4,29.6);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527152700',164.29,-5.4,29.6);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527100100',164.28,-5.41,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527063700',164.28,-5.51,30);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527040800',164.28,-5.51,30.1);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050528040900',164.27,-5.44,30);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527022800',164.28,-5.51,30.1);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527003700',164.28,-5.51,30);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526230900',164.3,-5.52,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526194300',164.33,-5.55,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526192400',164.32,-5.54,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526180000',164.33,-5.55,30);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526174700',164.35,-5.56,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526153700',164.36,-5.57,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050527061900',164.28,-5.46,30);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526115700',164.41,-5.56,29.7);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526095400',164.46,-5.54,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526084700',164.46,-5.54,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526042800',164.62,-5.54,29.8);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526065800',164.5,-5.55,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526052600',164.52,-5.54,29.9);
INSERT INTO platforms VALUES ('51765','DRIFTING BUOY','US','20050526023800',164.54,-5.52,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526010000',155.57,-6.04,30);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528222800',156.39,-6.49,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528222000',156.37,-6.49,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528204400',156.37,-6.49,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528190500',156.34,-6.49,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528183800',156.33,-6.49,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528165500',156.31,-6.49,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528151500',156.28,-6.48,29.6);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528125200',156.19,-6.43,29.6);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528111800',156.23,-6.44,29.6);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528111000',156.23,-6.44,29.6);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528075900',156.2,-6.43,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528073500',156.19,-6.43,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528062000',156.19,-6.41,29.6);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528054500',156.18,-6.43,29.6);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528040700',156.16,-6.41,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050528002700',156.12,-6.37,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527210700',156.08,-6.35,29.4);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527192900',156.08,-6.36,29.4);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527165700',156.02,-6.32,29.4);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527152600',156.02,-6.32,29.4);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527131600',155.89,-6.25,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527131600',155.69,-6.13,29.5);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527040700',155.84,-6.21,29.8);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527003800',155.79,-6.14,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526230800',155.84,-6.2,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526195100',155.79,-6.14,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526192600',155.78,-6.13,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526181100',155.75,-6.14,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526174700',155.74,-6.13,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526153900',155.71,-6.11,29.8);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526134300',155.69,-6.09,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526115800',155.46,-5.97,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527062200',155.89,-6.25,29.8);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050527055800',155.84,-6.21,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526100600',155.71,-6.11,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526085000',155.69,-6.09,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526065800',155.64,-6.05,29.7);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526060600',155.57,-6.04,29.8);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526042600',155.57,-6.04,29.8);
INSERT INTO platforms VALUES ('51801','DRIFTING BUOY','US','20050526024600',155.57,-6.04,29.9);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526005900',156.68,1.29,30.3);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526071300',156.78,1.19,30.2);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528222400',157.68,.69,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528221900',157.67,.68,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528204200',157.64,.72,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528190300',157.63,.74,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528183500',157.62,.74,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528165400',157.59,.76,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528151300',157.55,.77,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528125300',157.42,.87,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528112400',157.48,.82,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528111800',157.48,.82,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528080000',157.43,.85,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528073600',157.42,.87,30.2);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528062400',157.41,.87,30.2);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528054700',157.37,.9,30.2);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528041000',157.37,.9,30.2);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527192700',157.23,.95,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527165400',157.17,.96,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527152200',157.17,.96,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527062400',156.92,1.05,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527040700',156.92,1.05,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527003700',156.87,1.08,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526230700',156.92,1.05,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526195100',156.84,1.08,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526191400',156.87,1.07,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526180800',156.86,1.07,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526174500',156.86,1.07,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526153600',156.84,1.08,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526115800',156.63,1.34,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050528001300',157.3,.94,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527210100',157.23,.95,30);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050527055800',156.92,1.05,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526095400',156.74,1.23,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526084800',156.74,1.23,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526064900',156.74,1.23,30.1);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526042800',156.74,1.23,30.2);
INSERT INTO platforms VALUES ('51826','DRIFTING BUOY','US','20050526024600',156.73,1.25,30.3);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526004000',144.91,-1.97,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526005900',144.92,-1.97,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526042700',144.85,-1.99,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528235500',143.92,-2.34,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528222700',143.93,-2.33,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528204500',143.95,-2.33,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528190300',143.97,-2.31,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528183800',143.97,-2.31,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528182500',144.05,-2.25,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528165500',143.98,-2.3,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528125300',144.08,-2.22,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528112200',144.06,-2.23,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528112100',144.05,-2.25,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528093300',144.06,-2.23,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528080100',144.09,-2.22,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528073800',144.08,-2.22,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528073700',144.08,-2.22,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527205600',144.23,-2.14,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527204000',144.23,-2.14,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527192700',144.25,-2.13,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527184400',144.26,-2.13,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527165600',144.3,-2.1,29.7);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527152200',144.3,-2.1,29.7);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527131600',144.4,-2.08,29.8);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527131600',144.74,-2.03,29.8);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527080000',144.4,-2.08,-999);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528054900',144.12,-2.2,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528041000',144.13,-2.18,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050528002400',144.17,-2.16,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527022500',144.52,-2.06,29.8);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527003800',144.52,-2.06,29.6);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526230500',144.59,-2.04,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526213000',144.59,-2.04,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526195200',144.61,-2.03,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526192500',144.65,-2.02,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526174500',144.65,-2.02,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526153400',144.68,-2.02,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526134800',144.71,-2.02,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526115900',145.06,-1.91,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526114800',144.78,-2.01,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526114800',145.06,-1.91,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526100700',144.77,-2.02,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526085100',144.78,-2.01,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526070800',144.81,-2.02,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050526060600',144.84,-1.99,29.5);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527062200',144.44,-2.07,30.2);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527060100',144.44,-2.07,30.2);
INSERT INTO platforms VALUES ('51844','DRIFTING BUOY','US','20050527042000',144.47,-2.07,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526010000',161.58,-2.72,30.2);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526071200',161.52,-2.78,30.2);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526085000',161.5,-2.77,30.2);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526023900',161.55,-2.76,30.2);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526180000',161.42,-2.82,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526230800',161.39,-2.83,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528062400',161.17,-2.84,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528054400',161.22,-2.84,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528040900',161.22,-2.84,30.2);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528001200',161.22,-2.84,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527223300',161.25,-2.82,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527205800',161.25,-2.82,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527192800',161.25,-2.84,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527174400',161.28,-2.84,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527165600',161.29,-2.84,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527152500',161.29,-2.84,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527131600',161.34,-2.83,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527131600',161.48,-2.79,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527100100',161.34,-2.83,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528222000',161.01,-2.87,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528204100',161.03,-2.86,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528190500',161.06,-2.86,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528165500',161.07,-2.86,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528151400',161.09,-2.85,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528125400',161.11,-2.86,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528112300',161.12,-2.86,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050528080000',161.16,-2.85,30);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527040700',161.37,-2.82,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050527003800',161.4,-2.82,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526195100',161.44,-2.81,30.1);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526153700',161.44,-2.81,29.9);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526115900',161.63,-2.67,30.2);
INSERT INTO platforms VALUES ('51851','DRIFTING BUOY','US','20050526042800',161.54,-2.77,30.2);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526023900',173.23,4.73,-999);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526071400',173.27,4.7,29.2);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528235700',173.52,4.76,29.2);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528222200',173.51,4.76,29.2);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528221000',173.49,4.75,29.2);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528203800',173.5,4.76,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528190100',173.49,4.75,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528182900',173.49,4.75,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528164400',173.46,4.71,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528151200',173.47,4.73,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528112400',173.46,4.71,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528094200',173.47,4.7,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528093100',173.47,4.7,-999);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528080000',173.44,4.69,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528062600',173.47,4.7,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528040900',173.47,4.7,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050528001900',173.44,4.69,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527223300',173.42,4.68,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527222500',173.42,4.68,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527192400',173.42,4.68,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527185000',173.4,4.65,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527174500',173.41,4.66,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527165600',173.4,4.65,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527152300',173.38,4.64,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527133900',173.4,4.65,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527100600',173.38,4.64,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527061800',173.39,4.63,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527050800',173.38,4.65,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527050800',173.34,4.63,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050527003700',173.33,4.65,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526230600',173.33,4.65,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526224000',173.31,4.68,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526212300',173.34,4.63,29.2);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526194600',173.33,4.65,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526175900',173.31,4.68,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526173800',173.33,4.66,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526155600',173.28,4.69,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526153500',173.31,4.68,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526134700',173.27,4.7,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526100500',173.28,4.69,29.1);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526042700',173.27,4.72,29.2);
INSERT INTO platforms VALUES ('51893','DRIFTING BUOY','US','20050526053200',173.27,4.72,29.2);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526005900',166.01,6.38,29.1);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526173500',165.77,6.31,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528235800',165.07,6.69,28.7);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528221400',165.06,6.7,28.7);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528221100',165.07,6.69,28.7);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528203800',165.07,6.69,28.7);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528182400',165.11,6.64,28.7);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528165100',165.11,6.64,28.7);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528151100',165.14,6.62,28.8);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528130100',165.17,6.61,28.8);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528112500',165.23,6.54,28.8);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528094200',165.23,6.54,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528080100',165.23,6.54,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528062600',165.25,6.53,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528041100',165.29,6.51,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528001000',165.33,6.5,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527223200',165.38,6.48,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527222400',165.38,6.48,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527192500',165.38,6.48,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527184900',165.41,6.46,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527174200',165.41,6.47,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527165600',165.4,6.46,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527152300',165.6,6.34,28.9);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527100600',165.61,6.32,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527061600',165.6,6.34,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527042300',165.61,6.32,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050527003700',165.7,6.3,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526230500',165.64,6.31,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526223700',165.7,6.3,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526194800',165.77,6.31,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526180000',165.77,6.31,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050528190100',165.09,6.67,28.7);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526153500',165.77,6.31,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526071500',165.9,6.33,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526115800',166.08,6.4,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526095900',165.9,6.33,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526025400',165.94,6.35,29.1);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526053100',165.92,6.34,29);
INSERT INTO platforms VALUES ('51901','DRIFTING BUOY','US','20050526042700',165.93,6.34,29);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526010700',163.74,-6.6,29.8);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528222100',164.12,-7.03,29.6);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528221100',164.13,-7.05,29.6);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528204000',164.11,-7.04,29.6);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528190600',164.13,-7.05,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528165500',164.11,-7.04,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528151400',164.11,-7.04,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528125300',164.11,-7.05,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528111000',164.09,-7.06,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528093100',164.1,-7.06,29.8);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528075100',164.01,-7.04,29.8);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528072800',164.01,-7.04,29.8);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528062300',164.08,-7.05,29.9);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528040700',164.04,-7.06,30);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528002600',164.01,-7.04,29.9);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527192900',163.96,-7.02,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527174700',163.94,-7.01,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527165700',163.9,-7,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527152700',163.9,-7,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527061100',163.75,-6.93,30);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050528183000',164.11,-7.04,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527040700',163.73,-6.89,30.1);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527003700',163.73,-6.89,30.1);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526231000',163.7,-6.88,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526195200',163.66,-6.8,29.6);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526191900',163.68,-6.82,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526181200',163.68,-6.82,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526174100',163.67,-6.81,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526153800',163.63,-6.73,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527131600',163.75,-6.93,29.8);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527100100',163.75,-6.93,29.6);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050527063600',163.73,-6.89,30);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526115700',163.78,-6.61,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526095400',163.67,-6.65,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526084500',163.67,-6.65,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526065800',163.67,-6.68,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526042800',163.67,-6.65,29.7);
INSERT INTO platforms VALUES ('51905','DRIFTING BUOY','US','20050526024000',163.74,-6.6,29.8);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526005900',161.45,6.87,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526025300',161.32,6.88,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050529000000',160.47,7.25,29);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528222300',160.44,7.24,29);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528221200',160.47,7.25,-999);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528204000',160.47,7.25,28.9);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528190100',160.47,7.25,28.9);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528183400',160.47,7.24,28.9);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528165100',160.49,7.24,28.8);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528151100',160.52,7.23,28.8);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528112500',160.56,7.19,28.8);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528112000',160.56,7.19,28.8);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528080000',160.64,7.07,28.7);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528073200',160.64,7.07,28.7);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527223300',160.71,7.05,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528203700',160.49,7.24,28.9);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527222500',160.71,7.05,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527205700',160.73,7.04,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527192500',160.71,7.05,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527184900',160.73,7.04,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527174000',160.73,7.04,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527165600',160.74,7.04,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527042100',160.92,6.97,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527003800',161.05,6.93,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528062600',160.61,7.12,28.8);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528041100',160.62,7.1,29);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050528001300',160.71,7.05,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526230600',161.01,6.94,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526224100',161.13,6.93,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526194800',161.13,6.93,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526191400',161.13,6.93,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526175900',161.08,6.93,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526174300',161.09,6.93,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526153300',161.13,6.93,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526115800',161.59,6.91,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527152200',160.74,7.04,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527100500',160.92,6.97,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050527062500',160.98,6.95,29.2);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526100600',161.3,6.88,-999);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526085000',161.3,6.88,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526071500',161.25,6.89,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526053000',161.3,6.88,29.1);
INSERT INTO platforms VALUES ('51921','DRIFTING BUOY','US','20050526042700',161.29,6.88,29.1);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526010900',155.63,-5.39,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526024600',155.63,-5.44,29.5);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526042700',155.63,-5.44,-999);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528222100',156.02,-6.09,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528204400',156.02,-6.09,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528190400',156,-6.07,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528183000',155.97,-6.04,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528165500',155.97,-6.04,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528151500',155.97,-6.03,29.5);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528125400',155.95,-6.03,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528111900',155.94,-6.02,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528093100',155.91,-5.97,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528075100',155.86,-5.89,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528062100',155.91,-5.95,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528054500',155.9,-5.95,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528040800',155.88,-5.92,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050528002700',155.86,-5.89,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527224500',155.83,-5.85,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527210400',155.83,-5.85,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527192900',155.83,-5.85,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527170600',155.81,-5.83,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527152700',155.78,-5.82,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527131500',155.74,-5.71,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527131500',155.65,-5.55,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527061400',155.74,-5.71,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527055800',155.72,-5.68,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527040600',155.72,-5.68,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050527003700',155.72,-5.68,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526230800',155.71,-5.66,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526195000',155.68,-5.6,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526181000',155.68,-5.6,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526173900',155.68,-5.6,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526153800',155.65,-5.52,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526134400',155.65,-5.52,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526115800',155.61,-5.27,29.7);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526095300',155.65,-5.52,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526084000',155.65,-5.52,29.6);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526071200',155.65,-5.5,29.5);
INSERT INTO platforms VALUES ('51923','DRIFTING BUOY','US','20050526060400',155.63,-5.44,29.4);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526004300',143.75,-10.3,26.4);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526100400',143.72,-10.26,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528235700',143.4,-9.91,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528223000',143.38,-9.92,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528204800',143.37,-9.93,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528190600',143.38,-9.93,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528184000',143.38,-9.93,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528111800',143.44,-9.98,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528093700',143.44,-9.98,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528091200',143.44,-9.99,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528075100',143.44,-9.99,26.7);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528073600',143.44,-9.99,26.7);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528054800',143.46,-10.01,26.8);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528040400',143.47,-10.02,27.1);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528002800',143.47,-10.05,26.7);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527211000',143.48,-10.08,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528125400',143.44,-9.99,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527204200',143.47,-10.07,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527192900',143.48,-10.08,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527184600',143.48,-10.09,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527171000',143.48,-10.09,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527152600',143.48,-10.09,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527131600',143.51,-10.08,26.7);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527062000',143.56,-10.14,26.8);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527022600',143.58,-10.15,26.8);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527005000',143.61,-10.2,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526230800',143.61,-10.19,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526213400',143.61,-10.2,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526195200',143.6,-10.2,26.4);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526192900',143.59,-10.2,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526174700',143.59,-10.2,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526153800',143.61,-10.22,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526134600',143.61,-10.22,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528183300',143.44,-9.98,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050528165800',143.43,-9.98,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527055800',143.56,-10.14,26.8);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050527040800',143.56,-10.15,26.8);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526115800',143.77,-10.38,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526102500',143.74,-10.26,26.7);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526084900',143.74,-10.26,26.6);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526060500',143.73,-10.28,26.4);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526070800',143.73,-10.26,26.5);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526011400',143.72,-10.3,26.4);
INSERT INTO platforms VALUES ('51925','DRIFTING BUOY','US','20050526042600',143.72,-10.28,26.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526023800',170.67,-15.53,28.6);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528222700',170.14,-15.49,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528222600',170.14,-15.49,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528205000',170.16,-15.49,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528190700',170.18,-15.49,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528183800',170.18,-15.49,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528125300',170.21,-15.52,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528110700',170.25,-15.51,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528093400',170.25,-15.51,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528093100',170.25,-15.51,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528074900',170.25,-15.51,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528062100',170.27,-15.51,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528040300',170.3,-15.51,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528002600',170.33,-15.53,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527210400',170.37,-15.52,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527192800',170.37,-15.52,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527175000',170.4,-15.52,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527152800',170.41,-15.54,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527100000',170.43,-15.56,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527063700',170.42,-15.54,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527061800',170.46,-15.53,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527040800',170.47,-15.53,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527022700',170.51,-15.52,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526231200',170.51,-15.52,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526212800',170.54,-15.5,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526195000',170.54,-15.5,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526193000',170.54,-15.5,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526181400',170.55,-15.49,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526174900',170.56,-15.49,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526154100',170.57,-15.5,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050527134600',170.42,-15.55,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526135800',170.57,-15.5,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526115800',170.6,-15.51,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526095200',170.65,-15.52,28.5);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526084300',170.65,-15.52,28.5);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526052500',170.65,-15.51,28.5);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526042500',170.67,-15.53,28.6);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526065700',170.65,-15.52,28.5);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050526081300',170.65,-15.52,28.5);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528165400',170.2,-15.5,28.4);
INSERT INTO platforms VALUES ('51956','DRIFTING BUOY','US','20050528151800',170.25,-15.51,28.4);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526023900',165.05,-7.75,29.5);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526042700',165.11,-7.91,29.4);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526095400',165.11,-7.91,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526153900',165.22,-8.12,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526180000',165.47,-8.42,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526231000',165.64,-8.59,29.4);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527040800',165.64,-8.59,29.6);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527063600',165.64,-8.59,29.5);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528073100',165.28,-8.2,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528062200',166.71,-9.06,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528040800',166.64,-9.06,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528002600',166.36,-8.98,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527193000',166.36,-8.98,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527174800',166.31,-8.96,29.4);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527170500',166.3,-8.94,29.4);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527152800',166.24,-8.92,29.4);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527134000',165.92,-8.8,29.4);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528222700',167.06,-9.12,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528221200',167.06,-9.12,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528204700',167.03,-9.1,29.2);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528190700',166.98,-9.09,29.2);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528183600',166.98,-9.08,29.2);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528165500',166.93,-9.07,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528151600',166.9,-9.07,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528125400',166.85,-9.07,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528111000',166.75,-9.07,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528093400',166.75,-9.07,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528093100',166.75,-9.07,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528075100',166.36,-8.98,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050528073100',166.36,-8.98,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527061700',165.92,-8.8,29.5);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050527004600',165.54,-8.48,29.5);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526195200',165.54,-8.48,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526174400',165.22,-8.12,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526115800',165.3,-8.19,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526084000',165.11,-7.91,29.3);
INSERT INTO platforms VALUES ('51959','DRIFTING BUOY','US','20050526065900',165.11,-7.91,29.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526004200',138.01,8.21,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528235800',137.37,8.22,29.4);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528222300',137.38,8.21,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528222000',137.37,8.22,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528204200',137.38,8.21,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528200500',137.38,8.2,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528183300',137.38,8.2,29.8);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528182600',137.38,8.2,29.8);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528165300',137.38,8.18,29.9);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528093800',137.41,8.11,-999);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528091500',137.41,8.11,30.2);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528080000',137.41,8.11,30.2);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528073300',137.52,8.11,30.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528055400',137.47,8.14,30.6);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528041200',137.49,8.14,30.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528001100',137.52,8.11,29.8);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050528001000',137.54,8.1,29.8);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527205700',137.57,8.1,29.6);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527203000',137.6,8.1,29.6);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527192200',137.6,8.1,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527184800',137.62,8.11,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527183500',137.73,8.18,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527165600',137.73,8.18,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527131500',137.73,8.18,29.8);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527131200',137.73,8.18,29.8);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527080600',137.73,8.18,30.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527062600',137.76,8.2,30.6);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527060300',137.73,8.18,30.5);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527042400',137.76,8.2,30.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527021500',137.76,8.2,30);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050527003400',137.82,8.19,29.7);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526211700',137.92,8.24,29.5);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526205500',137.92,8.24,29.5);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526194800',137.92,8.24,29.5);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526191300',137.82,8.19,29.5);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526185600',137.82,8.19,29.5);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526085100',137.92,8.24,30);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526071300',137.92,8.24,30.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526060500',137.93,8.26,30.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526042700',137.93,8.26,30.3);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526024700',137.97,8.25,30);
INSERT INTO platforms VALUES ('51964','DRIFTING BUOY','US','20050526005900',138.01,8.21,29.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526011200',153.85,-8.56,27.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526065900',153.88,-8.5,27.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527055800',153.96,-8.28,27.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527040700',153.91,-8.31,27.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527003700',153.91,-8.31,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526230900',153.89,-8.32,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526212900',153.79,-8.3,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526195200',153.79,-8.3,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526192700',153.87,-8.32,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526181100',153.87,-8.33,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526174700',153.87,-8.33,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528222900',154.63,-8.23,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528222000',154.64,-8.24,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528183800',154.55,-8.19,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528165600',154.41,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528151500',154.53,-8.19,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528125300',154.41,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528112100',154.47,-8.19,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528111800',154.47,-8.19,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528093800',154.41,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528093100',154.41,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528075200',154.41,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528073300',154.41,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528061800',154.38,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528054700',154.38,-8.2,27.4);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528040800',154.35,-8.21,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528204600',154.61,-8.21,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528204400',154.61,-8.21,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528190500',154.58,-8.21,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050528002700',154.27,-8.25,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527205800',154.2,-8.26,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527193100',154.18,-8.26,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527165600',154.09,-8.27,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527152700',154.09,-8.27,27.5);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527131600',153.87,-8.4,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527131600',153.97,-8.28,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050527062100',153.97,-8.28,27.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526153900',153.87,-8.37,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526134300',153.87,-8.37,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526115900',153.86,-8.74,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526095400',153.87,-8.44,27.6);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526084100',153.88,-8.5,27.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526060300',153.86,-8.52,27.7);
INSERT INTO platforms VALUES ('51966','DRIFTING BUOY','US','20050526042700',153.86,-8.52,27.7);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526023900',172.77,4.94,29.2);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528235600',173.01,4.98,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528222100',173,4.97,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528190000',172.97,4.96,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528183300',172.96,4.96,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528164800',172.95,4.94,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528151200',172.95,4.93,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528094400',172.9,4.88,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528075900',172.89,4.85,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528062600',172.91,4.89,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528040900',172.9,4.88,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527062300',172.84,4.82,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528221200',173,4.97,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050528204300',172.99,4.97,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527050800',172.82,4.84,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527050800',172.84,4.83,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527042000',172.84,4.83,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526230600',172.82,4.84,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526212200',172.82,4.84,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526194700',172.82,4.84,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526175900',172.81,4.88,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526174400',172.81,4.86,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527223200',172.88,4.86,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527192500',172.88,4.86,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527174500',172.88,4.84,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527152300',172.84,4.82,28.9);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527133800',172.86,4.83,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050527100700',172.84,4.83,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526071400',172.77,4.91,29.1);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526053200',172.76,4.93,29.2);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526134600',172.77,4.91,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526155700',172.79,4.89,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526153500',172.81,4.88,29);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526100700',172.79,4.89,29.1);
INSERT INTO platforms VALUES ('51969','DRIFTING BUOY','US','20050526042700',172.77,4.92,29.2);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526010000',149.49,1.16,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528222400',150.26,.83,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528204300',150.25,.84,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528190300',150.23,.85,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528183400',150.23,.85,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528182800',150.16,.91,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528165500',150.2,.86,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528151100',150.2,.88,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528125200',150.17,.89,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528112200',150.16,.91,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528112100',150.16,.91,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528094100',150.09,.95,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528080000',150.09,.95,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528073700',149.7,1.08,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528073700',150.09,.95,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528062200',150.06,.95,29.8);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528055000',150.06,.95,29.8);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528041000',150.05,.97,29.9);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050528002500',150,.97,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527210600',149.98,.98,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527192800',149.98,.99,29.5);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527170700',149.95,1,29.5);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527152300',149.94,.99,29.4);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527131400',149.89,1.03,-999);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527040800',149.87,1.05,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526194900',149.75,1.07,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526191300',149.79,1.07,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526174500',149.77,1.07,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526153600',149.75,1.07,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526134600',149.72,1.07,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526115900',149.39,1.18,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526114800',149.39,1.18,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526114800',149.66,1.09,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526100700',149.66,1.09,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527062200',149.89,1.03,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527060100',149.88,1.03,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050527003500',149.8,1.06,29.7);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526230600',149.81,1.06,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526223900',149.8,1.06,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526212900',149.8,1.06,29.6);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526085100',149.66,1.09,29.8);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526071100',149.65,1.1,29.9);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526060500',149.61,1.12,29.9);
INSERT INTO platforms VALUES ('51980','DRIFTING BUOY','US','20050526042700',149.61,1.12,29.9);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526023900',172.92,-13.99,28.7);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526042800',172.87,-13.97,28.7);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526051800',172.87,-13.97,28.7);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526065800',172.87,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528040500',172.42,-14.03,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528002500',172.43,-14.01,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527224800',172.48,-14.03,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527210500',172.51,-14.01,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527045900',172.8,-13.96,-999);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527040700',172.66,-13.97,28.7);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527022700',172.62,-13.98,28.7);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526231000',172.68,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526213000',172.71,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526195100',172.76,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526193200',172.76,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526181400',172.75,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526174900',172.75,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526154000',172.78,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528062200',172.4,-14.03,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527192900',172.48,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527191600',172.51,-14.01,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527175100',172.5,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527152800',172.51,-14.01,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527134500',172.52,-14.01,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527100100',172.56,-13.99,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527063600',172.44,-13.99,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050527061600',172.61,-13.99,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528222800',172.22,-14.07,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528222300',172.25,-14.05,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528204800',172.23,-14.07,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528190600',172.25,-14.05,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528183700',172.25,-14.05,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528172600',172.35,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528165300',172.35,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528151600',172.31,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528111900',172.35,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528093600',172.36,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528093100',172.36,-14.03,28.5);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050528075100',172.43,-14.01,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526134700',172.78,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526115800',172.8,-13.96,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526101400',172.87,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526095400',172.87,-13.97,28.6);
INSERT INTO platforms VALUES ('51983','DRIFTING BUOY','US','20050526081400',172.87,-13.97,28.6);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526005900',149.41,-.52,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526042500',149.3,-.53,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526115800',149.53,-.55,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528002400',149.02,-.34,29.9);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527210700',149.05,-.35,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527062300',149.14,-.42,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527060100',149.13,-.42,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527042100',149.16,-.43,30.5);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527003600',149.2,-.47,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526230500',149.18,-.47,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526212900',149.2,-.47,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526195100',149.2,-.49,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526191400',149.23,-.5,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526174500',149.22,-.5,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526153600',149.23,-.5,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526134800',149.23,-.5,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526060600',149.3,-.53,30.4);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526100800',149.28,-.51,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528222600',149.05,-.26,30);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528204400',149.05,-.26,30);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528112100',149.03,-.3,29.9);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528093800',149.04,-.31,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528080100',149.04,-.31,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528073900',149.03,-.31,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528073600',149.03,-.31,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528062000',149.03,-.32,30.4);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528054900',149.03,-.32,30.4);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528041000',149.02,-.33,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527203600',149.05,-.36,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528190300',149.05,-.27,29.9);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528183600',149.05,-.28,29.9);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528165500',149.02,-.29,29.9);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528151100',149.02,-.29,29.8);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050528125200',149.03,-.31,29.8);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527192600',149.05,-.36,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527184900',149.05,-.36,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527170700',149.05,-.36,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527152300',149.07,-.37,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527131500',149.26,-.51,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050527131500',149.14,-.42,30.1);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526085100',149.28,-.51,30.2);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526071200',149.3,-.52,30.3);
INSERT INTO platforms VALUES ('51994','DRIFTING BUOY','US','20050526064800',149.29,-.53,30.4);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050526040000',164.99,2,29.8);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050527120000',164.989,2.004,-999);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050526120000',164.984,2,-999);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050528020000',164.99,2.01,29.1);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050528120000',164.986,2.001,-999);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050528220000',164.99,2,29.4);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050528200000',164.99,2,29.3);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050528040000',164.99,2,29.2);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050527220000',164.99,2,29.1);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050527190000',164.99,2,29.2);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050526220000',164.97,2.01,29.6);
INSERT INTO platforms VALUES ('52001','MOORED BUOY','US','20050526190000',164.98,2,29.6);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050526010000',165.02,-2.01,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050528220000',165.01,-1.99,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050528200000',165.02,-1.99,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050528120000',165.015,-1.99,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050528030000',165.02,-1.99,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050527190000',165.01,-1.99,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050527120000',165.019,-1.998,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050527040000',164.96,-2.01,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050527020000',164.96,-2.01,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050526220000',164.96,-2.01,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050526190000',165.02,-2,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050526120000',165.016,-2.004,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050526040000',165.02,-2,-999);
INSERT INTO platforms VALUES ('52002','MOORED BUOY','US','20050526020000',165.02,-2,-999);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050526010000',165,5.03,29.4);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050526020000',165,5.04,29.4);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050526040000',165,5.03,29.4);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050527120000',165.002,5.036,-999);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050527220000',165,5.03,29.2);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050528120000',164.997,5.039,-999);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050528220000',165,5.04,29.2);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050528200000',165,5.03,29.2);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050528040000',165,5.04,29.1);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050527190000',165,5.03,29.2);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050526220000',165,5.03,29.3);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050526190000',165,5.03,29.3);
INSERT INTO platforms VALUES ('52003','MOORED BUOY','US','20050526120000',164.992,5.027,-999);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050526040000',165.19,-4.99,30);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050528200000',165.18,-5,30);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050528190000',165.18,-5,30);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050528120000',165.182,-5,-999);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050528040000',165.18,-5,30.3);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050528030000',165.18,-5,30.2);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050528020000',165.18,-5,30.1);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050527190000',165.19,-5,29.9);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050527120000',165.186,-5.002,-999);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050527040000',165.19,-5,30.1);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050528220000',165.19,-5,30.1);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050527020000',165.19,-5,30.2);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050526220000',165.19,-5,30);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050526190000',165.19,-5,30);
INSERT INTO platforms VALUES ('52004','MOORED BUOY','US','20050526120000',165.184,-5.001,-999);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050526010000',165.06,7.99,28.9);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050526020000',165.06,8,28.9);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050526120000',165.064,7.998,-999);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050527020000',165.06,8,28.8);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050528220000',165.07,8,28.7);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050528200000',165.07,8,28.7);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050528120000',165.058,8.002,-999);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050528040000',165.06,8,28.9);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050527220000',165.06,8,28.8);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050527190000',165.06,8,28.7);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050527120000',165.058,7.998,-999);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050526220000',165.06,8,28.8);
INSERT INTO platforms VALUES ('52006','MOORED BUOY','US','20050526190000',165.06,8,28.8);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050526010000',164.78,-8.03,29.2);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050528040000',164.79,-8.02,29.6);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050528220000',164.78,-8.02,29.4);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050528200000',164.78,-8.02,29.4);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050528190000',164.79,-8.02,29.4);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050528120000',164.785,-8.023,-999);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050526020000',164.78,-8.03,29.2);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050527190000',164.78,-8.02,29.4);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050527120000',164.785,-8.027,-999);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050527040000',164.79,-8.03,29.5);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050526190000',164.78,-8.02,29);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050526120000',164.784,-8.024,-999);
INSERT INTO platforms VALUES ('52007','MOORED BUOY','US','20050526040000',164.79,-8.02,29.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526000000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526120000',137.266,4.859,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526120000',137.253,4.866,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526090000',137.266,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526080000',137.27,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526080000',137.264,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526080000',137.27,4.86,30.4);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526080000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526080000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526060000',137.267,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526210000',137.27,4.86,29.7);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526210000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526200000',137.265,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526200000',137.27,4.86,29.6);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526190000',137.265,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526190000',137.27,4.86,29.6);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526180000',137.268,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526180000',137.27,4.86,29.6);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526180000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527090000',137.27,4.86,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527080000',137.265,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527080000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527070000',137.265,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527070000',137.27,4.86,30.2);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527060000',137.266,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527060000',137.27,4.86,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527060000',137.27,4.86,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527050000',137.264,4.853,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528000000',137.27,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527220000',137.267,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527210000',137.264,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527210000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527200000',137.264,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527200000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527190000',137.261,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527190000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527140000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050529000000',137.264,4.861,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050529000000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528230000',137.267,4.87,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528230000',137.27,4.87,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528210000',137.264,4.863,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528210000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528210000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528200000',137.264,4.864,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528200000',137.26,4.86,29.9);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528200000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528190000',137.264,4.864,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528190000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528180000',137.262,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528180000',137.26,4.86,29.9);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528170000',137.262,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528170000',137.26,4.86,29.9);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528170000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528160000',137.262,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528160000',137.26,4.86,29.9);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528150000',137.261,4.865,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528150000',137.26,4.86,29.9);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528130000',137.26,4.86,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528120000',137.26,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528120000',137.257,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528120000',137.26,4.86,30.2);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528120000',137.26,4.86,30.2);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528110000',137.265,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528110000',137.27,4.86,30.5);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528100000',137.267,4.861,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528100000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528090000',137.265,4.859,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528090000',137.267,4.861,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528090000',137.266,4.862,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528090000',137.27,4.86,30.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528090000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528070000',137.269,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528070000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528060000',137.266,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528060000',137.27,4.86,30.5);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528060000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528050000',137.266,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528050000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528040000',137.261,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528040000',137.269,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528040000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528040000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528030000',137.261,4.858,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528030000',137.26,4.86,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528030000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528010000',137.27,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528010000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528000000',137.27,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050528000000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527130000',137.261,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527130000',137.264,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527130000',137.258,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527130000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527130000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527120000',137.264,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527120000',137.258,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527120000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527180000',137.261,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527180000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527170000',137.261,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527170000',137.26,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527150000',137.261,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527150000',137.26,4.86,29.9);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527150000',137.26,4.86,29.9);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527140000',137.261,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527120000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527110000',137.258,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527110000',137.26,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527100000',137.267,4.855,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527100000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527090000',137.267,4.859,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527090000',137.268,4.859,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527090000',137.27,4.86,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527050000',137.27,4.86,30);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527050000',137.26,4.85,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527040000',137.264,4.853,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527040000',137.26,4.85,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527030000',137.264,4.853,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527030000',137.26,4.85,30.2);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527030000',137.26,4.85,30.2);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527020000',137.26,4.85,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527000000',137.268,4.854,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527000000',137.27,4.85,29.7);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050527000000',137.27,4.85,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526230000',137.268,4.854,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526230000',137.27,4.85,29.7);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526220000',137.27,4.86,29.8);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526210000',137.265,4.859,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526210000',137.266,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526170000',137.263,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526170000',137.26,4.86,29.7);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526160000',137.265,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526160000',137.27,4.86,29.7);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526150000',137.265,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526150000',137.27,4.86,29.7);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526130000',137.266,4.859,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526130000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526060000',137.27,4.86,30.6);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526060000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526050000',137.254,4.854,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526050000',137.25,4.85,30.5);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526040000',137.254,4.854,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526040000',137.25,4.85,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526030000',137.254,4.854,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526030000',137.25,4.85,30.4);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526120000',137.25,4.87,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526120000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526110000',137.253,4.866,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526110000',137.25,4.87,30.1);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526100000',137.266,4.857,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526100000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526090000',137.27,4.86,30.3);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526090000',137.27,4.86,30.3);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526030000',137.25,4.85,30.4);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526020000',137.271,4.856,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526020000',137.254,4.854,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526020000',137.27,4.86,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526020000',137.25,4.85,-999);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526000000',137.27,4.86,29.7);
INSERT INTO platforms VALUES ('52073','MOORED BUOY','JP','20050526000000',137.265,4.859,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526000000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528200000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528190000',147.032,1.989,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528190000',147.03,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528180000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528180000',147.025,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528180000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528180000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528160000',147.02,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528160000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528150000',147.02,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528150000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528150000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528120000',147.025,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528120000',147.02,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528120000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528110000',147.03,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528100000',147.021,1.997,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528100000',147.02,2,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528090000',147.023,1.986,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528090000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528090000',147.021,1.997,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528090000',147.02,2,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528090000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528070000',147.021,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528070000',147.023,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528070000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528060000',147.023,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528060000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528060000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528050000',147.023,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528050000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528050000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528030000',147.021,1.976,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528030000',147.02,1.98,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528030000',147.02,1.98,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528010000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528010000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528000000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528000000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527220000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527220000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527210000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527210000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527200000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527190000',147.025,1.979,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527190000',147.02,1.98,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527180000',147.011,1.994,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527180000',147.01,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527180000',147.01,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527160000',147.02,1.986,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527160000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527150000',147.02,1.986,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527150000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527150000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527120000',147.025,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527120000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527120000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527110000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527110000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527110000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527090000',147.017,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527090000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527090000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527080000',147.022,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527080000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527070000',147.021,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527070000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527060000',147.021,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527060000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527060000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527050000',147.022,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527050000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527050000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527040000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527040000',147.02,1.99,29.8);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527030000',147.017,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527030000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527030000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527020000',147.017,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527010000',147.017,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527000000',147.024,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527000000',147.017,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527000000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050529000000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050529000000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528230000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528230000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528220000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528220000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528220000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528210000',147.021,1.991,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528210000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528210000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050528200000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050527000000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526230000',147.024,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526230000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526220000',147.017,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526220000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526210000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526210000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526200000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526200000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526190000',147.018,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526190000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526190000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526180000',147.018,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526180000',147.026,2,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526180000',147.03,2,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526180000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526170000',147.025,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526170000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526150000',147.023,1.989,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526150000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526150000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526140000',147.023,1.989,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526140000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526120000',147.022,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526110000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526100000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526100000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526100000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526090000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526090000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526060000',147.019,1.986,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526060000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526050000',147.02,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526050000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526040000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526030000',147.02,1.993,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526030000',147.018,1.999,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526030000',147.02,2,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526030000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526030000',147.02,1.99,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526120000',147.02,1.99,29.6);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526110000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526090000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526080000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526080000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526060000',147.02,1.99,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526010000',147.02,2,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526020000',147.018,1.999,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526010000',147.018,1.999,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526010000',147.02,2,29.7);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526000000',147.022,1.992,-999);
INSERT INTO platforms VALUES ('52077','MOORED BUOY','JP','20050526000000',147.021,1.992,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526000000',147.03,4.97,30);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526000000',147.028,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526040000',147.034,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526040000',147.03,4.97,30.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526030000',147.034,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526030000',147.013,4.979,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526030000',147.01,4.98,30.6);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526030000',147.01,4.98,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526030000',147.03,4.97,30.6);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526030000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526010000',147.013,4.979,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526010000',147.01,4.98,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526000000',147.033,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526090000',147.03,4.97,30.2);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526090000',147.03,4.97,30.2);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526070000',147.028,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526070000',147.03,4.97,30.3);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526060000',147.032,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526060000',147.033,4.964,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526060000',147.03,4.97,30.4);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526060000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526060000',147.03,4.96,30.4);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526060000',147.03,4.96,30.4);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526050000',147.034,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528200000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528200000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528190000',147.03,4.96,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528180000',147.028,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528180000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528180000',147.028,4.968,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528180000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528180000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528160000',147.028,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528160000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528160000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528150000',147.028,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528150000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528150000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528130000',147.028,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528130000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528120000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528120000',147.029,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528120000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528120000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528110000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528110000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528100000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528100000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528090000',147.026,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528090000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528090000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528080000',147.026,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528080000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528080000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528070000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528070000',147.026,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528070000',147.03,4.97,30);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528060000',147.027,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528060000',147.03,4.97,30);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528060000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528050000',147.031,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528050000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528050000',147.03,4.96,30);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528030000',147.028,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528030000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528030000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528010000',147.028,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528010000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528000000',147.028,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528000000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527230000',147.028,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527230000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527220000',147.028,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527220000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527210000',147.028,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527210000',147.03,4.97,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527210000',147.03,4.97,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527190000',147.03,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527190000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527180000',147.035,4.952,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527180000',147.035,4.964,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527180000',147.03,4.97,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527180000',147.04,4.96,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527180000',147.04,4.96,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527180000',147.04,4.95,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527170000',147.035,4.964,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527170000',147.04,4.96,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527160000',147.035,4.964,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527160000',147.04,4.96,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527150000',147.035,4.964,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527150000',147.04,4.96,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527150000',147.04,4.96,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527140000',147.025,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527140000',147.02,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527130000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527120000',147.026,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527120000',147.026,4.96,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050529000000',147.029,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050529000000',147.03,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050529000000',147.03,4.97,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050529000000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528230000',147.033,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528230000',147.03,4.97,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528220000',147.029,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528220000',147.03,4.97,29.6);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528210000',147.033,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528210000',147.03,4.97,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528210000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050528200000',147.028,4.968,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527120000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527120000',147.03,4.96,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527120000',147.03,4.96,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527110000',147.028,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527110000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527110000',147.03,4.96,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527090000',147.03,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527090000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527090000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527080000',147.031,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527080000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527070000',147.031,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527070000',147.03,4.97,29.9);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527060000',147.03,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527060000',147.028,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527060000',147.03,4.97,30.1);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527050000',147.031,4.964,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527050000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527050000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527050000',147.03,4.96,30.2);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527040000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527040000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527030000',147.031,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527030000',147.026,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527030000',147.03,4.97,30.1);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527030000',147.03,4.97,30.1);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527000000',147.026,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527000000',147.031,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527000000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050527000000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526210000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526200000',147.03,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526200000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526190000',147.03,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526190000',147.029,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526190000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526180000',147.029,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526180000',147.031,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526180000',147.03,4.97,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526150000',147.028,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526220000',147.03,4.968,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526220000',147.03,4.97,29.7);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526220000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526210000',147.03,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526150000',147.03,4.962,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526150000',147.03,4.97,30);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526150000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526150000',147.03,4.96,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526130000',147.03,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526130000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526120000',147.03,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526110000',147.03,4.97,30);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526170000',147.029,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526170000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526160000',147.03,4.962,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526160000',147.03,4.96,29.8);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526160000',147.03,4.96,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526100000',147.033,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526100000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526090000',147.033,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526080000',147.03,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526080000',147.032,4.967,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526080000',147.03,4.97,30.3);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526080000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526070000',147.03,4.966,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526120000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526110000',147.03,4.965,-999);
INSERT INTO platforms VALUES ('52078','MOORED BUOY','JP','20050526050000',147.03,4.97,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526000000',147.01,.07,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526000000',147.008,.065,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526030000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526030000',147.01,.07,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526030000',147.008,.065,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526040000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526050000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050529000000',147.019,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050529000000',147.014,.065,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050529000000',147.01,.07,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050529000000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528230000',147.014,.065,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528230000',147.01,.07,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528220000',147.015,.061,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528220000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528210000',147.016,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528210000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528210000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528200000',147.018,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528200000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528180000',147.015,.058,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528180000',147.021,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528180000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528180000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528170000',147.021,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528170000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528160000',147.018,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528160000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528150000',147.021,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528150000',147.018,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528150000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528120000',147.019,.064,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528120000',147.018,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528120000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528120000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528110000',147.019,.064,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528110000',147.019,.066,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528110000',147.02,.07,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528110000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528090000',147.014,.058,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528090000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528090000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528070000',147.016,.059,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528070000',147.023,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528070000',147.02,.06,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528070000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528060000',147.014,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528060000',147.01,.06,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528060000',147.01,.06,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528050000',147,.042,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528050000',147,.04,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528030000',147.017,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528030000',147.02,.06,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528030000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528020000',147.017,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528020000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528000000',147.016,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528000000',147.02,.06,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050528000000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527220000',147.013,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527210000',147.016,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527210000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527200000',147.01,.09,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527190000',147.019,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527190000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527180000',147.011,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527180000',147.01,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527160000',147.021,.064,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527160000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527150000',147.021,.064,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527150000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527150000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527140000',147.015,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527140000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527140000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527130000',147.015,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527130000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527120000',147.015,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527120000',147.034,.061,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527120000',147.03,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527120000',147.03,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527120000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527110000',147.011,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527110000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527090000',147.01,.061,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527090000',147.01,.06,30.2);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527080000',147.009,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527080000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527070000',147.015,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527070000',147.02,.06,30.3);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527060000',147.017,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527060000',147.015,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527060000',147.02,.06,30.4);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527060000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527050000',147.004,.05,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527050000',147,.05,30.4);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527040000',147.009,.061,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527040000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527030000',147.031,.061,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527030000',147.004,.05,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527030000',147.03,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527030000',147,.05,30.2);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527000000',147.015,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527000000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050527000000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526210000',147.02,.06,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526210000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526190000',147.021,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526190000',147.016,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526190000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526180000',147.012,.064,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526180000',147.02,.06,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526180000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526150000',147.017,.07,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526230000',147.015,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526230000',147.02,.06,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526230000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526220000',147.021,.058,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526220000',147.02,.06,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526210000',147.016,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526210000',147.021,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526150000',147.017,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526150000',147.02,.07,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526150000',147.02,.06,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526150000',147.02,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526130000',147.02,.06,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526120000',147.021,.063,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526120000',147.034,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526090000',147.01,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526170000',147.012,.064,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526170000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526160000',147.017,.07,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526160000',147.02,.07,29.9);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526160000',147.02,.07,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526090000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526080000',146.994,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526080000',147.01,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526080000',146.99,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526060000',147.013,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526060000',147.01,.06,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526060000',147.01,.06,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526050000',147.007,.061,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526120000',147.03,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526120000',147.02,.06,30);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526110000',147.007,.057,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526110000',147.009,.057,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526110000',147.01,.06,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526090000',147.009,.057,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526040000',147.016,.058,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526040000',147.02,.062,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526040000',147.01,.06,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526030000',147.007,.061,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526030000',147.01,.07,30.1);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526010000',147.01,.07,-999);
INSERT INTO platforms VALUES ('52079','MOORED BUOY','JP','20050526010000',147.008,.065,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526000000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050529000000',138.06,2.07,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528220000',138.068,2.065,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528220000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528210000',138.068,2.069,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528210000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528210000',138.07,2.07,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528200000',138.065,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528200000',138.07,2.07,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528180000',138.066,2.074,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528180000',138.06,2.08,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528180000',138.07,2.07,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528170000',138.066,2.074,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528170000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528160000',138.066,2.074,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528160000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528150000',138.059,2.075,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528150000',138.06,2.08,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528150000',138.06,2.08,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528130000',138.062,2.073,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528130000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528120000',138.062,2.073,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528120000',138.067,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528120000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528120000',138.06,2.07,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528110000',138.067,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528110000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528100000',138.06,2.07,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528090000',138.063,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528090000',138.06,2.07,29.3);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528090000',138.06,2.07,29.3);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528080000',138.07,2.076,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528080000',138.07,2.08,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528080000',138.07,2.08,29.3);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528070000',138.063,2.073,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528070000',138.06,2.07,29.3);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528060000',138.063,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528060000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528060000',138.06,2.07,29.3);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528050000',138.063,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528050000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528030000',138.063,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528030000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528030000',138.06,2.07,29.2);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528000000',138.06,2.066,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050528000000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527230000',138.06,2.066,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527230000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527220000',138.058,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527220000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527210000',138.058,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527210000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527210000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527200000',138.058,2.073,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527200000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527190000',138.058,2.073,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527180000',138.059,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527180000',138.06,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527180000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527180000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527160000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527160000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527150000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527150000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527150000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527130000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527130000',138.061,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527130000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527120000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527120000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527110000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527090000',138.061,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527090000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527090000',138.06,2.07,29.6);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527080000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527070000',138.058,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527070000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527060000',138.058,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527060000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527060000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527050000',138.058,2.072,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527050000',138.06,2.07,29.5);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527040000',138.061,2.076,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527040000',138.06,2.08,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527030000',138.059,2.066,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527030000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527030000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527010000',138.063,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527010000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050527000000',138.06,2.07,29.3);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526230000',138.061,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526230000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526220000',138.057,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526220000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526210000',138.058,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526210000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526200000',138.06,2.07,29.3);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526190000',138.053,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526190000',138.05,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526180000',138.061,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526180000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526180000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526170000',138.061,2.071,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526170000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526170000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526150000',138.061,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526150000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526150000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526140000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526130000',138.07,2.05,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526120000',138.072,2.052,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526120000',138.07,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526120000',138.07,2.05,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526120000',138.07,2.05,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526110000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526100000',138.064,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526100000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526090000',138.064,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526090000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526090000',138.06,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526080000',138.065,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526080000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526080000',138.05,2.07,29.4);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526060000',138.059,2.073,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526060000',138.06,2.07,29.7);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526060000',138.06,2.07,29.7);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526040000',138.065,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526040000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526030000',138.065,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526030000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526030000',138.07,2.07,29.6);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526020000',138.065,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526000000',138.06,2.067,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526000000',138.06,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526010000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526020000',138.07,2.07,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526010000',138.065,2.068,-999);
INSERT INTO platforms VALUES ('52080','MOORED BUOY','JP','20050526010000',138.07,2.07,29.5);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526000000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526000000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526060000',156.022,2.039,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526060000',156.025,2.039,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526060000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526060000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526050000',156.025,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526050000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526040000',156.025,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526040000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526030000',156.025,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528110000',156.024,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528110000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528090000',156.02,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528090000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528090000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528080000',156.02,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528080000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528070000',156.024,2.033,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528070000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528070000',156.02,2.03,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528060000',156.017,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528060000',156.022,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528060000',156.02,2.04,29.9);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528060000',156.02,2.04,29.9);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528050000',156.017,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528050000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528030000',156.021,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528030000',156.022,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528030000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528030000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528020000',156.021,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528000000',156.021,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528000000',156.014,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528000000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528000000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528000000',156.01,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527220000',156.027,2.042,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527220000',156.03,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527210000',156.014,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527210000',156.01,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527200000',156.023,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527200000',156.014,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527200000',156.01,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527190000',156.023,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527190000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527180000',156.023,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527180000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527180000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527160000',156.023,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527160000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527150000',156.023,2.036,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527150000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527150000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527140000',156.02,2.039,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527130000',156.023,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527130000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527120000',156.022,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527120000',156.023,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527120000',156.028,2.039,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527120000',156.03,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527120000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527110000',156.022,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527110000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527100000',156.023,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527100000',156.024,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527100000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527090000',156.023,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527090000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527090000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527080000',156.023,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527080000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527060000',156.002,2.085,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527060000',156,2.09,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527060000',156,2.09,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527060000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527050000',156.019,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527050000',156.002,2.085,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527050000',156.021,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527050000',156,2.09,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527050000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527040000',156.021,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527040000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527030000',156.021,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050529000000',156.021,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050529000000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050529000000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528230000',156.025,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528230000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528220000',156.025,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528220000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528210000',156.025,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528210000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528210000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528190000',156.025,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528190000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528180000',156.024,2.035,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528180000',156.025,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528180000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528160000',156.024,2.035,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528160000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528160000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528150000',156.025,2.035,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528150000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528150000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528140000',156.021,2.035,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528140000',156.02,2.04,29.6);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528120000',156.02,2.035,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528120000',156.02,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528120000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050528120000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527030000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527030000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527000000',156.024,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527000000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050527000000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526230000',156.024,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526230000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526220000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526210000',156.026,2.031,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526210000',156.03,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526210000',156.03,2.03,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526190000',156.028,2.032,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526190000',156.026,2.031,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526190000',156.03,2.03,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526180000',156.025,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526180000',156.022,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526220000',156.024,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526180000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526180000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526170000',156.025,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526170000',156.023,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526170000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526160000',156.023,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526160000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526150000',156.023,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526150000',156.026,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526150000',156.03,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526150000',156.03,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526150000',156.02,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526140000',156.026,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526140000',156.03,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526120000',156.026,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526120000',156.03,2.04,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526110000',156.026,2.03,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526110000',156.022,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526110000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526110000',156.03,2.03,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526100000',156.022,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526100000',156.026,2.03,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526100000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526100000',156.03,2.03,29.7);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526090000',156.022,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526090000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526090000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526080000',156.022,2.037,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526080000',156.024,2.035,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526080000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526070000',156.022,2.039,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526070000',156.02,2.04,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526030000',156.02,2.06,29.8);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526030000',156.02,2.04,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526010000',156.021,2.038,-999);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526010000',156.02,2.04,29.9);
INSERT INTO platforms VALUES ('52082','MOORED BUOY','JP','20050526000000',156.022,2.038,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526000000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526000000',155.934,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526030000',155.93,8.02,29.3);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526080000',155.93,8.03,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526080000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526070000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526060000',155.931,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526060000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526060000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526050000',155.931,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526050000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526040000',155.931,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528160000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528160000',155.934,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528110000',155.933,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528110000',155.94,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528110000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528110000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528090000',155.933,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528090000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528090000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528070000',155.94,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528070000',155.94,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528070000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528060000',155.94,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528060000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528060000',155.94,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528060000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528050000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528050000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528040000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528030000',155.927,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528030000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528030000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528000000',155.927,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528000000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528000000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527220000',155.936,8.016,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527220000',155.94,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527210000',155.921,8.018,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527210000',155.92,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527190000',155.933,8.021,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527190000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527180000',155.931,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527180000',155.936,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527180000',155.94,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527180000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527160000',155.934,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527160000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527150000',155.934,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527150000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527150000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527140000',155.933,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527140000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527130000',155.932,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527130000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527120000',155.933,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527120000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527120000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527110000',155.933,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527110000',155.932,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527110000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527090000',155.932,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527090000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527090000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527080000',155.933,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527080000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527080000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527070000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527070000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527060000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527060000',155.937,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527060000',155.94,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527060000',155.94,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527060000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527050000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527050000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527040000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527040000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527030000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527030000',155.94,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527030000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527030000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527020000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527020000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527000000',155.935,8.021,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527000000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050527000000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526220000',155.934,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526220000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526210000',155.935,8.021,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526210000',155.934,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526210000',155.94,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050529000000',155.933,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050529000000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528230000',155.936,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528230000',155.94,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528220000',155.936,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528220000',155.94,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528210000',155.935,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528210000',155.94,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528210000',155.94,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528200000',155.935,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528200000',155.94,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528190000',155.933,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528190000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528190000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528180000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528180000',155.935,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528180000',155.94,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528180000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528180000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528160000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528150000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528150000',155.934,8.024,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528150000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528150000',155.93,8.02,29);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528130000',155.932,8.021,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528130000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528120000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528120000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050528110000',155.935,8.019,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526210000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526200000',155.932,8.021,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526200000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526190000',155.931,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526190000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526180000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526180000',155.935,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526180000',155.94,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526180000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526180000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526170000',155.932,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526170000',155.934,8.023,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526170000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526170000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526150000',155.931,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526150000',155.94,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526150000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526150000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526140000',155.931,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526120000',155.931,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526120000',155.93,8.02,29.1);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526110000',155.931,8.025,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526110000',155.93,8.03,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526110000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526100000',155.927,8.029,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526100000',155.93,8.03,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526090000',155.931,8.025,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526090000',155.927,8.029,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526090000',155.93,8.03,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526090000',155.93,8.02,29.2);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526090000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526080000',155.931,8.025,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526040000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526030000',155.934,8.022,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526030000',155.93,8.019,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526020000',155.93,8.019,-999);
INSERT INTO platforms VALUES ('52083','MOORED BUOY','JP','20050526020000',155.93,8.02,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526000000',156.03,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526030000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526030000',156.032,4.969,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526170000',156.035,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526170000',156.04,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526150000',156.035,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526150000',156.013,4.965,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526120000',156.013,4.965,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526120000',156.01,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526110000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526110000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526090000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526090000',156.03,4.98,29.8);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526080000',156.032,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526080000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526070000',156.032,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526140000',156.035,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526140000',156.04,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526070000',156.03,4.98,29.9);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526060000',156.037,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526060000',156.029,4.972,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526060000',156.04,4.97,29.9);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526060000',156.03,4.97,29.9);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526060000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526040000',156.036,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526040000',156.04,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526180000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526180000',156.03,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526180000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526150000',156.04,4.98,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526150000',156.01,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526150000',156.01,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526100000',156.032,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526100000',156.03,4.98,29.7);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526100000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050529000000',156.038,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050529000000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050529000000',156.04,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528230000',156.038,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528230000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528220000',156.038,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528220000',156.04,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528210000',156.031,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528210000',156.03,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528210000',156.03,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528200000',156.031,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528200000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528190000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528190000',156.03,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528180000',156.034,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528180000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528180000',156.03,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528160000',156.034,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528160000',156.03,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528150000',156.032,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528150000',156.036,4.976,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528150000',156.04,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528150000',156.04,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528150000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528140000',156.03,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528130000',156.03,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528130000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528120000',156.032,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528120000',156.03,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528120000',156.03,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528120000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528110000',156.033,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528110000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528100000',156.034,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528100000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528090000',156.032,4.976,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528090000',156.034,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528090000',156.03,4.98,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528090000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528070000',156.034,4.971,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528070000',156.04,4.98,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528070000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528060000',156.03,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528060000',156.03,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528060000',156.03,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528050000',156.03,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528050000',156.03,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528040000',156.032,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528040000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528030000',156.034,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528030000',156.03,4.97,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528030000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528020000',156.034,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528020000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528010000',156.034,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528010000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528000000',156.034,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528000000',156.03,4.97,29.4);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050528000000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527220000',156.029,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527220000',156.037,4.982,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527220000',156.04,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527220000',156.03,4.97,29.4);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527210000',156.027,4.969,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527210000',156.03,4.97,29.3);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527210000',156.03,4.97,29.3);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527190000',156.035,4.972,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527190000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527180000',156.032,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527180000',156.03,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527180000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527160000',156.035,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527160000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527160000',156.04,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527150000',156.033,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527150000',156.035,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527150000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527150000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527140000',156.027,4.978,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527140000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527130000',156.03,4.98,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527120000',156.032,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527120000',156.03,4.98,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527120000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527110000',156.03,4.98,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527100000',156.03,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527100000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527090000',156.032,4.976,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527090000',156.03,4.98,29.8);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527090000',156.03,4.98,29.8);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527080000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527080000',156.03,4.98,29.9);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527060000',156.033,4.972,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527060000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527060000',156.03,4.98,30.2);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527060000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527060000',156.03,4.97,30.2);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527060000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527040000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527040000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527030000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527030000',156.03,4.98,30);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527030000',156.03,4.98,30);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527010000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527010000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527000000',156.034,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527000000',156.033,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527000000',156.03,4.98,29.6);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050527000000',156.03,4.98,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526230000',156.037,4.972,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526230000',156.04,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526220000',156.035,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526220000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526220000',156.04,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526210000',156.037,4.972,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526210000',156.035,4.973,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526210000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526210000',156.04,4.97,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526200000',156.034,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526200000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526190000',156.034,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526190000',156.035,4.975,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526190000',156.04,4.98,29.5);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526190000',156.03,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526180000',156.034,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526180000',156.036,4.971,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526030000',156.037,4.974,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526030000',156.04,4.97,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526030000',156.04,4.97,29.9);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526030000',156.03,4.97,29.9);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526000000',156.034,4.972,-999);
INSERT INTO platforms VALUES ('52084','MOORED BUOY','JP','20050526000000',156.032,4.969,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526000000',156.06,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526000000',156.06,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526170000',156.053,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526170000',156.055,.013,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526170000',156.053,.013,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526170000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526150000',156.042,.009,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526120000',156.042,.009,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526120000',156.04,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526110000',156.042,.009,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526110000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526110000',156.04,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526100000',156.054,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526100000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526100000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526060000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526060000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526050000',156.052,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526050000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526040000',156.058,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526040000',156.052,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526040000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526040000',156.05,.01,30.1);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526030000',156.055,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526030000',156.06,.014,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528160000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528160000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528150000',156.056,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528150000',156.06,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528150000',156.06,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528150000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528130000',156.054,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528130000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528120000',156.057,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528120000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528120000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528110000',156.057,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528110000',156.06,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528100000',156.055,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528100000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528090000',156.055,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528090000',156.06,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528090000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528090000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528080000',156.055,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528070000',156.05,.02,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528060000',156.055,.009,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528060000',156.057,.006,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528060000',156.06,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528060000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528060000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528050000',156.052,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528050000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528040000',156.052,.017,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528040000',156.052,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528040000',156.059,.013,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528040000',156.05,.02,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528040000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528040000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528030000',156.052,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528030000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528030000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528000000',156.06,.009,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528000000',156.06,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528000000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528000000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527230000',156.052,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527230000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527220000',156.052,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527220000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527210000',156.052,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527210000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527210000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527200000',156.057,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527200000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527190000',156.051,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527190000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527180000',156.056,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527180000',156.051,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527180000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527180000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527180000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527160000',156.057,.015,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527160000',156.06,.02,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527150000',156.057,.015,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527150000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527150000',156.06,.02,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527150000',156.06,.02,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527150000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527140000',156.054,.008,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527140000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527130000',156.054,.008,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527130000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527120000',156.059,.014,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527120000',156.054,.008,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527120000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527120000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527120000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050529000000',156.052,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050529000000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528230000',156.057,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528220000',156.054,.014,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528220000',156.06,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528220000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528220000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528210000',156.054,.014,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528210000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528200000',156.049,.013,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528200000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528200000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528190000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528180000',156.056,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528180000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528180000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528170000',156.056,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528170000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528160000',156.056,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050528160000',156.054,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527110000',156.059,.014,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527110000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527090000',156.055,.013,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527090000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527090000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527080000',156.055,.013,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527080000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527060000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527060000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527060000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527050000',156.048,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527050000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527040000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527040000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527030000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527030000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527060000',156.056,.013,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527060000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527030000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527020000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527020000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527000000',156.053,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527000000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527000000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050527000000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526220000',156.056,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526220000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526220000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526210000',156.056,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526210000',156.054,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526210000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526210000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526210000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526190000',156.056,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526190000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526180000',156.053,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526180000',156.059,.009,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526180000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526180000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526180000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526180000',156.05,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526150000',156.05,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526200000',156.056,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526200000',156.06,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526200000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526150000',156.04,.01,29.8);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526150000',156.04,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526090000',156.054,.011,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526090000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526090000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526080000',156.05,.01,29.9);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526070000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526060000',156.054,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526030000',156.06,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526030000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526030000',156.05,.01,30);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526010000',156.058,.012,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526010000',156.06,.01,-999);
INSERT INTO platforms VALUES ('52085','MOORED BUOY','JP','20050526000000',156.058,.012,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526000000',156.02,-5.03,29.6);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526030000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526060000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526060000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526050000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526050000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526030000',156.024,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526030000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526030000',156.035,-5.041,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526030000',156.04,-5.04,29.5);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526030000',156.04,-5.04,29.5);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528000000',156.022,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528000000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528000000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527220000',156.022,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527210000',156.02,-5.031,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527210000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527210000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527190000',156.02,-5.036,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527190000',156.02,-5.04,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527180000',156.023,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527180000',156.02,-5.036,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527180000',156.02,-5.04,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527180000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527180000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527160000',156.026,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527160000',156.03,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527150000',156.022,-5.028,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527150000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527150000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527140000',156.022,-5.028,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527140000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527130000',156.022,-5.028,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527130000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527120000',156.026,-5.031,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527120000',156.024,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527120000',156.03,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527120000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527120000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527110000',156.026,-5.031,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527110000',156.024,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527110000',156.024,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527110000',156.023,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527110000',156.03,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527110000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527100000',156.024,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527100000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527090000',156.026,-5.031,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527090000',156.03,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527090000',156.03,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527080000',156.025,-5.034,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527080000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527060000',156.026,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527060000',156.028,-5.035,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527060000',156.03,-5.04,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527060000',156.03,-5.04,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527060000',156.03,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527050000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527050000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527040000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527040000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527030000',156.027,-5.031,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527030000',156.03,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527030000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527000000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527000000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050527000000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526230000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526230000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526230000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526220000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526220000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526210000',156.027,-5.034,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526210000',156.024,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526210000',156.03,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526210000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526210000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526190000',156.024,-5.031,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526190000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526190000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526180000',156.027,-5.035,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526180000',156.023,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526180000',156.024,-5.031,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526180000',156.03,-5.04,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050529000000',156.018,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050529000000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528230000',156.023,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528230000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528230000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528220000',156.018,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528220000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528210000',156.023,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528210000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528210000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528200000',156.023,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528200000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528200000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528180000',156.021,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528180000',156.023,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528180000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528180000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528170000',156.023,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528170000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528160000',156.025,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528160000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528150000',156.024,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528150000',156.025,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528150000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528150000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528140000',156.025,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528120000',156.025,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528120000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528110000',156.023,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528110000',156.025,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528110000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528090000',156.023,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528090000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528090000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528080000',156.023,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528080000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528070000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528070000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528060000',156.024,-5.028,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528060000',156.03,-5.027,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528060000',156.03,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528060000',156.03,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528060000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528050000',156.024,-5.028,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528050000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528030000',156.021,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528030000',156.026,-5.041,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528030000',156.03,-5.04,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528030000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528030000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528010000',156.021,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528010000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050528000000',156.021,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526180000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526170000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526170000',156.025,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526170000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526170000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526150000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526150000',156.036,-5.029,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526150000',156.025,-5.032,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526150000',156.04,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526150000',156.04,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526150000',156.02,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526120000',156.036,-5.029,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526120000',156.04,-5.03,29.8);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526110000',156.022,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526110000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526090000',156.022,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526090000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526090000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526080000',156.025,-5.034,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526080000',156.02,-5.03,29.7);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526080000',156.02,-5.03,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526060000',156.023,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526060000',156.025,-5.034,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526060000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526000000',156.025,-5.033,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526010000',156.02,-5.04,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526010000',156.023,-5.035,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526000000',156.021,-5.029,-999);
INSERT INTO platforms VALUES ('52086','MOORED BUOY','JP','20050526000000',156.02,-5.03,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526000000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526000000',136.721,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526000000',136.72,7.66,29.5);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526180000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526180000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526170000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526150000',136.699,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526050000',136.7,7.65,29.9);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526040000',136.702,7.661,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526040000',136.7,7.66,29.8);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526040000',136.7,7.65,29.8);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526030000',136.702,7.661,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526030000',136.7,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526030000',136.7,7.66,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526020000',136.721,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526020000',136.72,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526010000',136.721,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526010000',136.72,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526010000',136.72,7.66,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526000000',136.702,7.653,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526150000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526150000',136.7,7.65,29.5);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526140000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526130000',136.697,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526130000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526090000',136.703,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526090000',136.7,7.65,29.9);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526090000',136.7,7.65,29.9);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526080000',136.703,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526080000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526070000',136.702,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526070000',136.701,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526070000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526060000',136.702,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526200000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526190000',136.697,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526190000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526180000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526120000',136.697,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526120000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526120000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526110000',136.703,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526110000',136.7,7.65,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528140000',136.699,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528140000',136.7,7.65,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528130000',136.699,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528130000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528120000',136.694,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528120000',136.67,7.642,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528120000',136.69,7.65,29.8);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528120000',136.69,7.65,29.8);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528120000',136.67,7.64,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528110000',136.67,7.642,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528110000',136.67,7.64,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528090000',136.702,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528090000',136.704,7.648,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528090000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528090000',136.7,7.65,30);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528070000',136.702,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528070000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528070000',136.7,7.65,30.1);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528060000',136.7,7.652,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528060000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528060000',136.7,7.65,30.2);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528050000',136.705,7.658,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528050000',136.71,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528050000',136.7,7.65,30.1);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528030000',136.695,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528030000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528030000',136.7,7.65,29.8);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528020000',136.695,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528010000',136.701,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528010000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528000000',136.701,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528000000',136.704,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528000000',136.7,7.65,29.5);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528000000',136.7,7.65,29.5);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527230000',136.698,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527230000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527220000',136.698,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527220000',136.698,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527220000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527210000',136.698,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527210000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527210000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527200000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527190000',136.699,7.653,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527190000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527180000',136.699,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527180000',136.699,7.653,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527180000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527180000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527170000',136.699,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527170000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527170000',136.7,7.65,29.5);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527150000',136.693,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527150000',136.69,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527150000',136.69,7.65,29.5);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527130000',136.699,7.646,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527130000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527120000',136.699,7.646,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527120000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527120000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527110000',136.699,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527110000',136.708,7.654,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527110000',136.699,7.646,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527110000',136.71,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527110000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527100000',136.699,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527100000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527090000',136.699,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527090000',136.7,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527090000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527070000',136.7,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527070000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527070000',136.7,7.65,30.2);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050529000000',136.698,7.648,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050529000000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050529000000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528230000',136.705,7.653,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528230000',136.692,7.648,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528230000',136.71,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528230000',136.69,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528230000',136.69,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528220000',136.705,7.653,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528220000',136.71,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528210000',136.703,7.647,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528210000',136.7,7.65,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528210000',136.7,7.65,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528200000',136.698,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528200000',136.703,7.647,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528200000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528200000',136.7,7.65,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528190000',136.698,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528190000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528180000',136.699,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528180000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528180000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528160000',136.699,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528160000',136.7,7.65,29.6);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528150000',136.699,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528150000',136.7,7.65,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050528150000',136.7,7.65,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527060000',136.7,7.651,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527060000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527060000',136.7,7.65,30.1);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527050000',136.692,7.655,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527050000',136.69,7.66,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527040000',136.69,7.66,29.9);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527030000',136.692,7.655,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527030000',136.69,7.66,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527030000',136.69,7.66,29.7);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527020000',136.701,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527020000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527010000',136.7,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527000000',136.702,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527000000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050527000000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526230000',136.702,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526230000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526220000',136.696,7.649,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526220000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526220000',136.7,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526210000',136.694,7.647,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526210000',136.69,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526210000',136.69,7.65,29.4);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526200000',136.697,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526060000',136.7,7.65,-999);
INSERT INTO platforms VALUES ('52087','MOORED BUOY','JP','20050526060000',136.7,7.65,29.8);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526000000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526000000',156.005,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526020000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526030000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526030000',156.008,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526040000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526170000',156.005,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526170000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526150000',156.001,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526150000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526150000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526150000',156.006,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526150000',156.014,-1.974,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526150000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526150000',156,-1.97,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526140000',156.014,-1.974,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526140000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526120000',156.014,-1.974,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526090000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526080000',156.002,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526080000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526080000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526080000',156,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526080000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526070000',156.002,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526070000',156,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526060000',156.008,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526060000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526120000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526120000',156.01,-1.97,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526120000',156.01,-1.97,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526110000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526110000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526110000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526090000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526090000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526040000',156.008,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527040000',156.013,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527040000',156.01,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527030000',156.004,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527030000',156.013,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527030000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527030000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527030000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527010000',156.004,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527010000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527000000',156.003,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050529000000',156.012,-1.972,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050529000000',155.99,-1.966,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050529000000',156.01,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050529000000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050529000000',155.99,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528230000',155.99,-1.966,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528230000',155.99,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528220000',155.99,-1.966,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528220000',155.99,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528210000',156.007,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528210000',156.01,-1.97,29.8);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528210000',156.01,-1.97,29.8);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528200000',156.007,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528200000',156.01,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528180000',156.005,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528180000',156.006,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528180000',156.01,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528180000',156.01,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528170000',156.005,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528170000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528160000',156.009,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528160000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528150000',156.004,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528150000',156.009,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528150000',156.01,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528150000',156.01,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528150000',156,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528120000',156.003,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528120000',156.004,-1.967,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528120000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528120000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528110000',156.005,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528110000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528110000',156,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528090000',156.005,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528090000',156.01,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528090000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528090000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528070000',156.005,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528070000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528070000',156.005,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528070000',156.01,-1.97,30.3);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528060000',156.009,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528060000',156.01,-1.97,30.3);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528060000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528050000',156,-1.97,30.4);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528040000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528040000',156.003,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528040000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528040000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528030000',155.999,-1.967,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528030000',156,-1.97,30.5);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528030000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528000000',155.999,-1.967,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528000000',156.001,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050528000000',156,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527220000',156.001,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527220000',156.01,-1.96,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527210000',156.007,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527210000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527200000',156.007,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527190000',156.001,-1.973,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527190000',156,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527190000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527180000',156.007,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527180000',156.01,-1.97,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527170000',156.007,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527170000',156.01,-1.97,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527170000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527150000',156.004,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527150000',156.007,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527150000',156.01,-1.97,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527150000',156,-1.97,30.1);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527130000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527120000',156.001,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527120000',156.006,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527120000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527120000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527120000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527110000',156.003,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527110000',156.002,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527110000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527110000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527090000',156.001,-1.969,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527090000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527090000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527080000',156,-1.96,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527070000',156,-1.96,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527060000',156.007,-1.971,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527060000',156.013,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527060000',156.01,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527060000',156.01,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527000000',156.004,-1.968,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050527000000',156,-1.97,29.9);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526220000',156.003,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526220000',156,-1.97,29.8);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526210000',156.003,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526210000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526210000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526200000',156.001,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526200000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526190000',156,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526190000',156,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526180000',156.005,-1.97,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526180000',156.009,-1.966,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526180000',156.01,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526180000',156.01,-1.97,30);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526030000',156.009,-1.965,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526030000',156.01,-1.97,30.2);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526020000',156.009,-1.965,-999);
INSERT INTO platforms VALUES ('52088','MOORED BUOY','JP','20050526000000',156.01,-1.97,30.1);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050526020000',165.05,.03,29.7);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050527040000',165.05,.03,29.7);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050527190000',165.05,.03,29.4);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050528030000',165.06,.03,29.6);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050528120000',165.055,.033,-999);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050528220000',165.06,.05,29.6);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050528200000',165.06,.03,29.6);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050528040000',165.06,.03,29.5);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050528020000',165.06,.03,29.8);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050527120000',165.047,.027,-999);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050526220000',165.06,.03,29.4);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050526190000',165.05,.03,29.5);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050526120000',165.059,.031,-999);
INSERT INTO platforms VALUES ('52321','MOORED BUOY','US','20050526040000',165.06,.03,29.7);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526011300',153.05,-12.19,27.2);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527152800',152.96,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527131600',152.98,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527040800',153,-12.14,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527005000',153,-12.14,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526231000',153.01,-12.14,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526212800',153.02,-12.16,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526195100',153.02,-12.16,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526181200',153.02,-12.16,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526173900',153.02,-12.16,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526153900',153.02,-12.16,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526134200',153.02,-12.16,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528125200',152.98,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528040700',152.94,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528002800',152.96,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527224700',152.96,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527210600',152.96,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527193100',152.96,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527171000',152.95,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527063700',153,-12.14,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527061100',152.98,-12.14,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050527055700',152.98,-12.14,27.1);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528222200',152.9,-12.16,26.9);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528222000',152.9,-12.16,26.9);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528204700',152.9,-12.16,26.9);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528190800',152.91,-12.16,26.9);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528183200',152.91,-12.16,26.9);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528165700',152.93,-12.16,26.9);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528151600',152.91,-12.16,26.9);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528111000',152.92,-12.17,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528093800',152.93,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528092900',152.93,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528075100',152.96,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528072600',152.96,-12.16,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528072600',152.98,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528061600',152.93,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050528054500',152.93,-12.15,27);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526115800',153.06,-12.24,27.2);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526095400',153.04,-12.16,27.2);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526083900',153.04,-12.16,27.2);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526065900',153.04,-12.17,27.2);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526060400',153.03,-12.16,27.2);
INSERT INTO platforms VALUES ('52592','DRIFTING BUOY','US','20050526042700',153.05,-12.18,27.3);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526010000',152.92,4.61,29.9);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526115900',152.85,4.64,-999);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528151100',153.19,4.22,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528002400',153.15,4.26,29.3);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527222400',153.15,4.27,-999);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527205700',153.15,4.29,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527192600',153.15,4.27,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527184800',153.15,4.29,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527165600',153.09,4.32,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527152100',153.09,4.32,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527042300',153.1,4.34,30);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050529000000',153.21,4.22,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528221500',153.21,4.22,29.2);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528203900',153.21,4.22,28.7);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528190000',153.21,4.22,28.9);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528182600',153.2,4.22,29);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528165100',153.2,4.22,28.7);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527003800',153.09,4.42,30);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526230500',153.1,4.4,29.9);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526223600',153.09,4.42,29.8);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526212700',153.09,4.42,29.6);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526195000',153.08,4.48,29.6);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526191400',153.08,4.48,29.6);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526153500',153.08,4.48,29.7);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526134700',153.03,4.54,29.7);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528112400',153.17,4.21,29.5);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528080000',153.15,4.26,29.7);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528062400',153.17,4.24,29.8);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528054700',153.16,4.24,29.8);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050528041100',153.16,4.24,29.8);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527061500',153.09,4.32,29.7);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050527060000',153.09,4.32,29.7);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526095900',153.03,4.54,29.8);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526085100',153.03,4.54,29.8);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526071400',153.02,4.55,30);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526060600',152.96,4.59,30);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526042700',152.96,4.59,30.1);
INSERT INTO platforms VALUES ('52593','DRIFTING BUOY','US','20050526025000',152.96,4.59,30);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526023900',166.87,-7.87,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526042700',166.91,-7.89,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528222700',167.73,-7.4,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528221200',167.73,-7.44,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528204600',167.73,-7.42,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528190600',167.73,-7.44,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528183600',167.74,-7.45,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528165400',167.74,-7.48,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528151600',167.75,-7.5,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528111000',167.76,-7.63,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528093600',167.76,-7.63,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528093100',167.76,-7.63,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528075100',167.76,-7.63,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528072800',167.01,-7.96,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528072800',167.7,-7.76,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528062200',167.75,-7.66,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528040600',167.74,-7.69,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050528002500',167.7,-7.76,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527223300',167.63,-7.82,-999);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527192800',167.63,-7.82,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527174800',167.61,-7.85,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527165700',167.6,-7.85,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527152700',167.58,-7.88,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527134200',167.43,-7.96,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527100100',167.48,-7.94,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527062100',167.43,-7.96,30);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527040700',167.31,-8.01,30.1);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527022800',167.31,-8.01,30.1);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050527004600',167.31,-8.01,30);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526231000',167.28,-8.01,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526212500',167.18,-8,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526195200',166.98,-7.95,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526192200',167.15,-8,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526181300',167.15,-8,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526174800',167.15,-8,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526153900',166.98,-7.95,29.7);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526115700',166.73,-7.82,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526095400',166.98,-7.95,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526084500',166.91,-7.89,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526065800',166.91,-7.9,29.8);
INSERT INTO platforms VALUES ('52597','DRIFTING BUOY','US','20050526052700',166.91,-7.89,29.8);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526004700',137.6,-14.03,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526042300',137.6,-14.03,27.8);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526011500',137.6,-14.03,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526210800',137.6,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526195000',137.61,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526193000',137.61,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526185700',137.6,-14.04,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526172200',137.6,-14.04,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526153600',137.6,-14.02,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526133900',137.63,-14.01,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526131900',137.6,-14.02,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526115700',137.6,-14.02,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528223000',137.61,-14.03,27.2);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528222400',137.64,-14.03,27.2);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528184000',137.63,-14.02,27.2);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528183700',137.63,-14.02,27.2);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528170000',137.64,-14.02,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528143200',137.61,-14.01,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528125300',137.62,-14.03,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528125200',137.61,-14.01,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528111400',137.61,-14.02,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528093500',137.68,-14.02,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528090600',137.62,-14.03,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528204800',137.64,-14.03,27.2);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528202100',137.64,-14.03,27.2);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528190500',137.63,-14.02,27.2);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528075500',137.62,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528073400',137.62,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528072400',137.62,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528054100',137.62,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528035700',137.62,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528020400',137.62,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050528002900',137.62,-14.05,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527210800',137.63,-14.06,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527204300',137.62,-14.06,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527145400',137.61,-14.03,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527131500',137.62,-14.03,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527130900',137.61,-14.03,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527113300',137.62,-14.03,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527095800',137.6,-14.05,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527093500',137.6,-14.05,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527081900',137.6,-14.05,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527075300',137.6,-14.05,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527061100',137.6,-14.05,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527054500',137.61,-14.06,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527023000',137.61,-14.06,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527005100',137.61,-14.05,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527002900',137.61,-14.05,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526225400',137.62,-14.04,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526213500',137.6,-14.05,27.5);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527192500',137.61,-14.06,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527190400',137.61,-14.06,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527184800',137.61,-14.06,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050527171100',137.62,-14.04,27.4);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526113200',137.6,-14.02,27.7);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526084200',137.61,-14.02,27.8);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526081900',137.61,-14.03,27.8);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526063700',137.61,-14.03,27.8);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526060500',137.62,-14.03,27.8);
INSERT INTO platforms VALUES ('52627','DRIFTING BUOY','AU','20050526024800',137.6,-14.03,27.8);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526011000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526035000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526201000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526191000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526181000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526171000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526151000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526141000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526131000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526121000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526111000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526101000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526091000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526081000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526071000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528231000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528221000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528211000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528201000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528191000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528181000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528171000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528161000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528151000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528141000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528131000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528121000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528111000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528101000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528091000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528083000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528081000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528071000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528061000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528051000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528041000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528031000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528021000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528011000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050528001000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527231000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527221000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527211000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527201000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527161000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527151000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527141000',146.49,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527131000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527121000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527111000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527101000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527091000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527081000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527071000',146.48,-18.59,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527061000',146.48,-18.59,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527051000',146.48,-18.59,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527041000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527031000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527021000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527011000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527191000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527181000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527171000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050527001000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526231000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526221000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526211000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526161000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526061000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526051000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526041000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526021000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('55586','DRIFTING BUOY','NZ','20050526031000',146.5,-18.58,-999);
INSERT INTO platforms VALUES ('5900273','ARGO FLOAT','JP','20050527205900',143.313,5.121,-999);
INSERT INTO platforms VALUES ('5900282','ARGO FLOAT','JP','20050526210400',164.933,-.586,-999);
INSERT INTO platforms VALUES ('5900299','ARGO FLOAT','JP','20050526173500',153.294,10.963,-999);
INSERT INTO platforms VALUES ('5900300','ARGO FLOAT','JP','20050527082400',167.2,10.957,-999);
INSERT INTO platforms VALUES ('5900301','ARGO FLOAT','JP','20050527223700',163.132,3.32,-999);
INSERT INTO platforms VALUES ('5900302','ARGO FLOAT','JP','20050528125700',164.962,4.374,-999);
INSERT INTO platforms VALUES ('5900358','ARGO FLOAT','US','20050528185800',154.527,-3.148,-999);
INSERT INTO platforms VALUES ('5900364','ARGO FLOAT','US','20050527152100',172.108,-4.403,-999);
INSERT INTO platforms VALUES ('5900365','ARGO FLOAT','US','20050527210100',156.777,-3.15,-999);
INSERT INTO platforms VALUES ('5900482','ARGO FLOAT','JP','20050527004200',155.213,.868,-999);
INSERT INTO platforms VALUES ('5900496','ARGO FLOAT','JP','20050527003500',160.792,6.942,-999);
INSERT INTO platforms VALUES ('5900505','ARGO FLOAT','JP','20050526212500',146.328,-3.015,-999);
INSERT INTO platforms VALUES ('5900610','ARGO FLOAT','US','20050526095500',172.533,-14.787,-999);
INSERT INTO platforms VALUES ('5900669','ARGO FLOAT','US','20050528072800',165.34,-9.576,-999);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526000000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526080000',159.95,-9.43,29.6);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528120000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528110000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528100000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528090000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528080000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528070000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528060000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528050000',159.95,-9.43,29.5);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528040000',159.95,-9.43,29.5);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528030000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528020000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528010000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528000000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527230000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527220000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527170000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527160000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527150000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527140000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527130000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527120000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527110000',159.95,-9.43,29.1);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527100000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527050000',159.95,-9.43,29.9);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528180000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528170000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528160000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528150000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528140000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528130000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527210000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527200000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527180000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050529000000',159.95,-9.43,29.1);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528230000',159.95,-9.43,29.1);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528220000',159.95,-9.43,29.1);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528210000',159.95,-9.43,29.1);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050528200000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527040000',159.95,-9.43,29.9);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527030000',159.95,-9.43,29.6);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527020000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527010000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526210000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526200000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526180000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526170000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527090000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527080000',159.95,-9.43,29.5);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527070000',159.95,-9.43,29.6);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527060000',159.95,-9.43,29.8);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526160000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526150000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526140000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526130000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526120000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526110000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526100000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526090000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050527000000',159.95,-9.43,29.3);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526230000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526220000',159.95,-9.43,29.2);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526070000',159.95,-9.43,29.7);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526060000',159.95,-9.43,29.7);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526050000',159.95,-9.43,29.7);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526040000',159.95,-9.43,29.9);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526030000',159.95,-9.43,29.7);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526020000',159.95,-9.43,29.5);
INSERT INTO platforms VALUES ('91519','DRIFTING BUOY','','20050526010000',159.95,-9.43,29.4);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526000000',166.92,-.5,28.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050529000000',166.92,-.5,28.1);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528230000',166.92,-.5,28.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528220000',166.92,-.5,28.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528210000',166.92,-.5,28.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528200000',166.92,-.5,29);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528180000',166.92,-.5,28.7);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528170000',166.92,-.5,28.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528160000',166.92,-.5,28);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528150000',166.92,-.5,28.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528140000',166.92,-.5,28.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528130000',166.92,-.5,28.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528120000',166.92,-.5,28.3);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528110000',166.92,-.5,28);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528100000',166.92,-.5,28.3);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528090000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528080000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528070000',166.92,-.5,28.6);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528060000',166.92,-.5,28.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528050000',166.92,-.5,29.1);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528040000',166.92,-.5,28.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528030000',166.92,-.5,28.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528020000',166.92,-.5,28.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528010000',166.92,-.5,29);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050528000000',166.92,-.5,29.1);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527230000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527220000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527210000',166.92,-.5,29.3);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527200000',166.92,-.5,29.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527180000',166.92,-.5,29.4);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527170000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527160000',166.92,-.5,28.4);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527150000',166.92,-.5,28);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527140000',166.92,-.5,27.7);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527130000',166.92,-.5,27.7);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527120000',166.92,-.5,28);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527110000',166.92,-.5,28.3);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527100000',166.92,-.5,28.3);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527090000',166.92,-.5,28.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527080000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527070000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527060000',166.92,-.5,29);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527050000',166.92,-.5,28.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527040000',166.92,-.5,28.4);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527030000',166.92,-.5,28.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527020000',166.92,-.5,28.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527010000',166.92,-.5,27.6);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526160000',166.92,-.5,28.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526150000',166.92,-.5,27.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526140000',166.92,-.5,27.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526130000',166.92,-.5,27.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526120000',166.92,-.5,27.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526110000',166.92,-.5,27.6);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526100000',166.92,-.5,27.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526090000',166.92,-.5,28.7);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526080000',166.92,-.5,28.6);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050527000000',166.92,-.5,28.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526230000',166.92,-.5,28.9);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526220000',166.92,-.5,28.1);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526210000',166.92,-.5,28.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526200000',166.92,-.5,29.4);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526180000',166.92,-.5,29.4);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526170000',166.92,-.5,29.3);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526070000',166.92,-.5,28.8);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526060000',166.92,-.5,29);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526050000',166.92,-.5,28.6);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526040000',166.92,-.5,28.5);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526030000',166.92,-.5,29.2);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526020000',166.92,-.5,29.1);
INSERT INTO platforms VALUES ('91531','DRIFTING BUOY','','20050526010000',166.92,-.5,28.9);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526000000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050529000000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528230000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528220000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528210000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528200000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528180000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528170000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528160000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528150000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528140000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528130000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528120000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528110000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528100000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528090000',168.28,-17.77,27);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528080000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528070000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528060000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528050000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528040000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528030000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528020000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528010000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527210000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527200000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527180000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527170000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527160000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527030000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527020000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527010000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526160000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050528000000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527230000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527220000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526150000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526140000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526130000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526120000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526110000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526100000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526090000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526080000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527150000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527140000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527130000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527120000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527110000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527100000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527090000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527080000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527070000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527060000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527050000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527040000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050527000000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526230000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526220000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526210000',168.28,-17.77,27.1);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526200000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526180000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526170000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526020000',168.28,-17.77,27.3);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526030000',168.28,-17.77,27.3);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526050000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526070000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526060000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526040000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91559','DRIFTING BUOY','','20050526010000',168.28,-17.77,27.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526000000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050529000000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528230000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528220000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528210000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528200000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528190000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528180000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528170000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528160000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528150000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528140000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528130000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528120000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528110000',172.93,1.35,30.1);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528100000',172.93,1.35,30.1);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528090000',172.93,1.35,30.1);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528080000',172.93,1.35,30.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528070000',172.93,1.35,30.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528060000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528050000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528040000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528030000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528020000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528010000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050528000000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527230000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527220000',172.93,1.35,29.6);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527210000',172.93,1.35,29.6);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527200000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527190000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527180000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527170000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527160000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527150000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527140000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527130000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527060000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527050000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527030000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527020000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527010000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526180000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526170000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526160000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526150000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527120000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527110000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527100000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527090000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527080000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527070000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526140000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526130000',172.93,1.35,29.9);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526120000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526110000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526100000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526090000',172.93,1.35,30.1);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526080000',172.93,1.35,30.1);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526070000',172.93,1.35,30.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527040000',172.93,1.35,30);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050527000000',172.93,1.35,29.8);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526230000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526220000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526210000',172.93,1.35,29.6);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526200000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526190000',172.93,1.35,29.7);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526060000',172.93,1.35,30.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526050000',172.93,1.35,30.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526040000',172.93,1.35,30.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526030000',172.93,1.35,30.2);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526020000',172.93,1.35,30.1);
INSERT INTO platforms VALUES ('91611','DRIFTING BUOY','','20050526010000',172.93,1.35,30);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050526180000',152.6,-17,26.7);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050528000000',151.7,-1,28);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050528060000',151.2,-8.3,28);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050529000000',147.5,-5.6,29.7);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050528180000',148.7,-6.6,29.3);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050528120000',149.9,-7.5,28);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050527060000',152.3,-14.2,27.6);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050527120000',152.2,-12.7,27);
INSERT INTO platforms VALUES ('C6NR5','SHIP','','20050527180000',152.1,-11.2,27.7);
INSERT INTO platforms VALUES ('DEFA','SHIP','','20050526120000',152.6,-14.2,28);
INSERT INTO platforms VALUES ('DEFA','SHIP','','20050528120000',145.9,-3.8,31);
INSERT INTO platforms VALUES ('H9RS','SHIP','','20050527060000',151.7,3.7,-999);
INSERT INTO platforms VALUES ('H9RS','SHIP','','20050528000000',151,7.8,-999);
INSERT INTO platforms VALUES ('H9RS','SHIP','','20050528120000',150.1,10.3,-999);
INSERT INTO platforms VALUES ('H9RS','SHIP','','20050528060000',150.7,9.8,-999);
INSERT INTO platforms VALUES ('UHVV','SHIP','','20050526000000',143.5,-2.5,30);
INSERT INTO platforms VALUES ('V2ES','SHIP','','20050527180000',161.7,-18,25);
INSERT INTO platforms VALUES ('V2ES','SHIP','','20050528060000',160.2,-15.6,27);
INSERT INTO platforms VALUES ('V2ES','SHIP','','20050529000000',157.9,-12,28);
INSERT INTO platforms VALUES ('V2ES','SHIP','','20050528180000',158.6,-13.1,27);
INSERT INTO platforms VALUES ('V2ES','SHIP','','20050528120000',159.4,-14.4,27);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050526000000',140.3,4.2,26);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050526060000',141.2,2.6,30);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050526180000',143.1,-.6,26);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050527060000',145.4,-3.4,30.5);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050526120000',142.2,1,25);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050527000000',144.1,-1.9,25);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050527180000',147.8,-6.1,26);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050529000000',149.8,-7.8,25.5);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050528180000',148.1,-7.2,25);
INSERT INTO platforms VALUES ('V7CZ6','SHIP','','20050527120000',146.7,-4.7,25);
INSERT INTO platforms VALUES ('VJD2969','SHIP','','20050527050000',136.3,-15.6,-999);
INSERT INTO platforms VALUES ('VJRB','SHIP','','20050526000000',143.7,-12.9,23.8);
INSERT INTO platforms VALUES ('VJRY','SHIP','','20050526000000',141.5,-12,27.9);
INSERT INTO platforms VALUES ('VJRY','SHIP','','20050528120000',147,-18.8,25.9);
INSERT INTO platforms VALUES ('VJRY','SHIP','','20050527000000',143.4,-12.5,26.4);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050526090000',141.1,-12.6,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050526120000',140.5,-12.5,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050526150000',139.9,-12.5,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050528210000',139.4,-15.7,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050528180000',139.1,-15.2,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050528150000',138.8,-14.8,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050528120000',138.5,-14.4,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050528090000',138.3,-14,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050528060000',138,-13.7,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050528000000',137.6,-13,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050527210000',137.3,-12.7,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050527060000',137.1,-12.2,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050529000000',139.7,-16.1,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050527030000',137.7,-12.2,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050527000000',138.3,-12.3,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050526210000',138.9,-12.3,-999);
INSERT INTO platforms VALUES ('VNRL','SHIP','','20050526180000',139.4,-12.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526000000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526030000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526120000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526180000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528090000',172.5,2.6,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528060000',172.7,1.8,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528030000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528000000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527210000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527180000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527150000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527120000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527090000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527060000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527030000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050527000000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050529000000',171.5,6.7,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528210000',171.6,5.9,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528180000',171.8,5.1,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528150000',172.1,4.3,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050528120000',172.3,3.5,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526210000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526150000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526090000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VROB','SHIP','','20050526060000',172.9,1.4,-999);
INSERT INTO platforms VALUES ('VVKV','SHIP','','20050529000000',134.6,6.2,34);
INSERT INTO platforms VALUES ('WECB','SHIP','','20050526120000',173.5,-18.8,27.8);
INSERT INTO platforms VALUES ('WECB','SHIP','','20050526180000',173.5,-18.8,27.4);
INSERT INTO platforms VALUES ('WECB','SHIP','','20050529000000',173.9,-17,28.3);
INSERT INTO platforms VALUES ('WECB','SHIP','','20050528060000',173.9,-16.9,27);
INSERT INTO platforms VALUES ('WECB','SHIP','','20050528180000',173.9,-17,27.3);
INSERT INTO platforms VALUES ('WECB','SHIP','','20050528120000',173.9,-17,27.2);
INSERT INTO platforms VALUES ('WECB','SHIP','','20050527120000',173.7,-17.9,27.8);

