/* 
 * CCBrowser Copyright 2006, NOAA.
 * See the LICENSE.txt file in this file's directory.
 */
package gov.noaa.pfel.coastwatch;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * The Cencoos Currents Browser. See info for Browser.java.
 *
 * @author Bob Simons (bob.simons@noaa.gov) 2005-02-10
 */
public class CCBrowser extends Browser {

    /**
     * Constructor
     */
    public CCBrowser() throws Exception {
        super("gov.noaa.pfel.coastwatch.CCBrowser");
    }

    /** 
     * This gets the user (making one if needed) associated with a request.
     *
     * @param request
     * @return the User associated with the request (possibly a new user)
     */
    public User getUser(HttpServletRequest request) {
        
        HttpSession session = request.getSession();
        String sessionID = session.getId();
        synchronized (userHashtable) { 
            User user = (User)userHashtable.get(sessionID);
            if (user == null) {

                //make a User for this new session
                boolean doTally = getDoTally(request.getHeader("x-forwarded-for"));
                user = new CCUser(oneOf, shared, session, doTally); //customized for this class
                userHashtable.put(sessionID, user);
                if (doTally) nUsers++;
            }
            return user;
        }
    }


}
