/* 
 * TestAll Copyright 2005, NOAA.
 * See the LICENSE.txt file in this file's directory.
 */
package gov.noaa.pfel.coastwatch;

import com.cohort.array.*;
import com.cohort.ema.*;
import com.cohort.util.*;

import gov.noaa.pfel.coastwatch.*;
import gov.noaa.pfel.coastwatch.griddata.*;
import gov.noaa.pfel.coastwatch.hdf.*;
import gov.noaa.pfel.coastwatch.netcheck.*;
import gov.noaa.pfel.coastwatch.pointdata.*;
import gov.noaa.pfel.coastwatch.sgt.*;
import gov.noaa.pfel.coastwatch.util.*;
import gov.noaa.pfel.erddap.*;
import gov.noaa.pfel.erddap.dataset.*;
import gov.noaa.pfel.erddap.util.*;
import gov.noaa.pfel.erddap.variable.*;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

import org.apache.commons.logging.impl.*;
import org.json.JSONObject;

import ucar.nc2.dataset.*;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.*;
import ucar.nc2.dods.*;
import ucar.nc2.util.*;
import ucar.ma2.*;

/**
 * This is a very important class -- main() calls all of the unit tests relevant to CWBrowser.
 * Also, compiling this class forces compilation of all the classes that need to
 * be deployed, so this class is compiled and and main() is run prior to
 * calling makeCWExperimentalWar (and ultimately makeCoastWatchWar) and
 * deploying the .war file to Tomcat.
 *
 * @author Bob Simons (bob.simons@noaa.gov) 2005-10-06
 */
public class TestAll  {

    /**
     * This forces compilation of all the classes that need to
     * be deployed and calls all of the unit tests relevant to CWBrowser.
     *
     * @param args is ignored
     * @throws Throwable if trouble
     */
    public static void main(String args[]) throws Throwable {

        //always setup commons logging
        String2.setupCommonsLogging(-1);

        //unset EDStatic's logging to log.txt
        EDStatic.returnLoggingToSystemOut(); //also, this forces instantiation when run TestAll
        EDDGridFromDap.testVerboseOn();
        EDDTableFromSOS.testVerboseOn();

        String2.log("*** This must be run from a command line window because the SFTP and email tests ask for passwords.\n");
        //one time things
//        EDDTableFromDatabase.test();
//        EDDTableFromDapSequence.testBasic(false); //tests globecBottle
//        String2.log(EDDTableFromSOS.generateDatasetsXml("http://sdf.ndbc.noaa.gov/sos/server.php", "1.0.0", false));
//        EDDTableFromSOS.testNdbcSosCurrents();
//        EDDTableFromSOS.testNdbcSosSalinity();  
//        EDDTableFromSOS.testNdbcSosWLevel();  
//        EDDTableFromSOS.testNdbcSosWTemp();  
//        EDDTableFromSOS.testNdbcSosWaves();
//        EDDTableFromSOS.testNdbcSosWind();
//        EDD.testDasDds("ncdcOisst2Agg");
//          EDD.testDasDds("ncdcOisst2AmsrAgg");
//          ((EDDTable)EDD.oneFromDatasetXml("pmelTao")).getEmpiricalMinMax("2008-10-05", "2008-10-10", false, false);
//          String2.log(((EDDTable)EDD.oneFromDatasetXml("nwioosAdcp2003")).toString());
//        EDDTableFromDapSequence.testArgo();
//        EDDGridFromDap.testBasic();
//        EDDGridFromDap.testMetersPersourceUnit();
//        Projects.testHdf4();
//    NdbcMetStation.main(null); 
//        String2.log("ImageIO Readers: " + String2.toCSVString(ImageIO.getReaderFormatNames()) +
//            "\nImageIO Writers: " + String2.toCSVString(ImageIO.getWriterFormatNames()));
//        NcHelper.dump("TestAll",
//            "c:/observation/ndbcMet/46088.nc", true);
//        SgtMap.testRegionsMap(0, 360, -90, 90);
//        SgtMap.main(new String[]{"c:/temp/cwsamples/2008_112_34E.nc"});
//        Grid grid;
//        SgtMap.testCreateBathymetryGrid();
//        GridDataSetThredds.main(null);
//        String2.log(File2.hexDump("c:/content/bat/temp", 1000));
//        SSR.zipEach("c:/temp/codarsf/");
//        SSR.testPost();
//        Table.test4DNc(); 
//        NetCheck.verbose = true;
//        NetCheck nc = new NetCheck("c:/content/bat/NetCheck.xml", true); //testmode
//        String2.log(NcHelper.dumpString("c:\\temp\\lynn\\TAML1_thisworks.nc", false)); //false=don't print data
//        SaveOpendap.downloadMbariData();
//        Erddap.makeErddapContentZip("c:/programs/tomcat/samples/", "c:/backup/");
//        Test.ensureEqual("'", "'", "");
//        String2.log(
//          EDDGridFromDap.generateDatasetsXml("http://sdf.ndbc.noaa.gov:8080/thredds/dodsC/hfradar_usegc_6km"));
//        EDDGridFromDap.generateDatasetsXml("http://thredds1.pfeg.noaa.gov:8080/thredds/dodsC/satellite/cwtest/aqua/modis/chlora/D1"));
//        EDDGridFromDap.generateErdThreddsDatasetXml("Satellite/aggregsat", "satellite"));
//        EDDGridFromDap.generateErdThreddsDatasetXml("Hfradar/aggreghfradar", "satellite"));
//        EDDTableFromNc4DFiles.generateDatasetsXml("C:/observation/ndbcMet80407/NDBC_31201_met.nc", false)); 
  //        EDDTableFromDapSequence.generateDatasetsXml("http://dapper.pmel.noaa.gov/dapper/argo/argo_all.cdp", 
  //              "location", "profile", true));
//        SSR.displayInBrowser("file://" + tName);
//        String2.log(String2.readFromFile(tName)[1]);
//        Table.testSortColumnsByName(); 
//        SaveOpendap.test(); 
//        Projects.ssc();
//        Projects.soda("1.4.2", "F:/SODA_1.4.2/", "F:/SODA_1.4.2/");
//        Projects.soda("1.4.3", "F:/SODA_1.4.3/", "F:/SODA_1.4.3/");
//        Projects.soda("2.0.2", "F:/soda.2.0.2/", "F:/soda.2.0.2/");
//        Projects.soda("2.0.2", "F:/soda.2.0.3/", "F:/soda.2.0.3/"); //yes 2.0.2
//        Projects.soda("2.0.4", "\\\\Xserve\\pfel_share\\Dave2Roy\\", "\\\\Xserve\\pfel_share\\BobSimons\\soda204\\"); 
//        Projects.soda("2.0.4", "c:\\temp\\sodain\\", "c:\\temp\\sodain\\"); 

//        SgtMap.createBathymetryMatlabFile(-135, -114, 29, 50, 0.025, "c:/temp/luke/");
//        GridSaveAs.main(new String[]{"C:/u00/data/AG/1day/grd/.grd.zip", "C:/u00/data/AG/1day/nc/.nc"}); //one time set up for GenerateThreddsDataSetHtml
//        GridSaveAs.main(new String[]{"C:/temp/dave/PH2006001_2006008_ssta.grd", "C:/temp/dave/PH2006001_2006008_ssta.nc"}); 
//        System.out.println("abs(min_value)=" + (Math.abs(Integer.MIN_VALUE)));
//        GregorianCalendar tgc = Calendar2.parseISODateTimeZulu("0000-01-01");
//        String2.log("year 0 is leap year? " + tgc.isLeapYear(0) + " " + Calendar2.formatAsISODate(tgc));
//        tgc.set(Calendar.MONTH, 3);
//        String2.log("0000-03-01 day = " + tgc.get(Calendar.DAY_OF_YEAR));
//        tgc.set(Calendar2.YEAR, 2000);
//        String2.log("year 2000 is leap year? " + tgc.isLeapYear(0) + " " + Calendar2.formatAsISODate(tgc));
//        String2.log("" + (-1.25 % 1.0));  //answer is -.25

//        //String source = "C:/u00/satellite/MB/sstd/5day/MB2006301_2006305_sstd.nc"; //Xmx500 ok; 300 not ok
//       //String dest   = "C:/temp/MB2006301_2006305_sstd.nc";
//        //String source = "C:/u00/satellite/AT/ssta/1day/AT2006005_2006005_ssta.nc";
//        //String dest   = "C:/temp/AT2006005_2006005_ssta.nc";
//        String source = "C:/u00/satellite/CM/u25h/hday/CM2006171_230000h_u25h.nc";
//        String dest   = "C:/temp/CM2006171_230000h_u25h.nc";        
//        String2.log(NcHelper.dumpString(source, false));
//        Grid.davesSaveAs(new String[]{source, dest}, new FileNameUtility("gov.noaa.pfel.coastwatch.CWBrowser"));
//        String2.log(NcHelper.dumpString(dest, false));
//          Projects.testWobblyLonLat();
//          Projects.kushner();
//          String2.log(File2.hexDump("c:/temp/ndbc/NDBC_46023_met.asc", 300));
//          Projects.channelIslands();
//          Projects.kfmBiological();
//          Projects.kfm3();
//          Projects.kfmBiological200801();
//          Projects.kfmFishTransect200801();
//          Projects.kfmTemperature200801();
//          Projects.kfmSizeFrequency200801();
//            Projects.kfmSpeciesNameConversion200801();
//          Table table;
//double d = -1e32;
//float f = -1e32f;
//double a = Math.abs(d - f);
//String2.log("abs(d-f)=" + a);
//          TestNCDump.main(new String[]{"c:/temp/CM2006171_230000h_u25h.nc"});
//          //sec=13 min=12 hr=10 date=5 mon=2 yr=1
//          String2.log("sec=" + Calendar.SECOND + " min=" + Calendar.MINUTE + " hr=" + Calendar.HOUR + " date=" + Calendar.DATE +
//              " mon=" + Calendar.MONTH + " yr=" + Calendar.YEAR);
//          Touch.getPiscoUrls();
//String2.log(Calendar2.epochSecondsToIsoStringT(0));
//String2.log(Calendar2.epochSecondsToIsoStringT(1000* 86400L));
//String2.log(Calendar2.epochSecondsToIsoStringT(10000* 86400L));
//String2.log(Calendar2.epochSecondsToIsoStringT(100000* 86400L));
//String2.log(Calendar2.epochSecondsToIsoStringT(-10000* 86400L));
// post.TestJdbc.test();
/*try {
    try {
        throw new Exception("Hi, Bob");
    } catch (Exception e) {
        String2.log("#1=" + MustBe.throwableToString(e));
        throw e;
    }
} catch (Exception e) {
    String2.log("#2=" + MustBe.throwableToString(e));
    throw e;
}*/
//String2.log(String2.getKeysAndValuesString(System.getProperties()));
//Table.testXml();
//Table.testIobis();
//Table.testJson();
//Table taoTable = new Table();
//taoTable.readJson("tao", SSR.getUrlResponseString(
//    EDStatic.erddapUrl + "/tabledap/pmel_dapper/tao.json?longitude,latitude,altitude,time,station_id,sea_surface_temperature,sea_surface_temperature_quality,air_temperature,air_temperature_quality,relative_humidity,relative_humidity_quality,relative_humidity_source,wind_to_direction,wind_direction_quality,wind_direction_source,wind_speed,wind_speed_quality,wind_speed_source,eastward_wind,northward_wind&time>=2007-08-01&time<=2007-10-01"));
//Math2.gc(500); String2.log(" done " + Math2.memoryString());
//DigirHelper.test(); //tests all...
//DigirHelper.testGetMetadata();
//DigirHelper.testGetInventory();
//DigirHelper.testObis();
//DigirHelper.testOpendapStyleObis();
//new DigirObisTDSP();
//new DigirIobisTDSP();
//NdbcMetStation.main(null);
//Grid.testGrd(); //test first since others rely on it
//Grid.testReadGrdSubset();
//GridDataSetThredds.quickTest("GA", "ssta");
//TestListFiles.main(new String[]{"c:/"});
//EDD tedd = EDD.oneFromDatasetXml("erdCalcofiBio"); System.out.println(tedd.toString());
//Projects.testJanino();
//String2.log(File2.hexDump("c:/temp/temp.mat", 10000));
//MakeErdJavaZip.makeCwhdfToNcZip();
//dddd_ddd_dddd_add
//String regex="[0-9]{4}_[0-9]{3}_[0-9]{4}_[a-zA-Z][0-9]{2}";
//String2.log("match=" + ("1234_567_1234_k00".matches(regex))); 
//long tl = Calendar2.newGCalendarZulu(1858, 10, 17).getTimeInMillis();
//double td = tl;
//String2.log("tl=" + tl + " td=" + td); 
//String2.log(String2.toNewlineString(RegexFilenameFilter.fullNameList("c:/temp/incoming/", ".+hdf")));
//Projects.testGetNcGrids();
//Projects.erddapTunnelTest();
//EDDGridFromDap.testForEllyn();
//EDDGridFromDap.testPmelOscar();
//StringArray.diff("c:/temp/oldSlideSorter.java", "c:/temp/newSlideSorter.java");
//EDDGrid.suggestGraphMinMax();
//EDDGrid.verbose = true; 
//EDDGrid.reallyVerbose = true; 
//((EDDGrid)EDD.oneFromDatasetXml("ncdcOw6hrStrs")).makeNewFileForDapQuery(null, 
//    "taux[(2008-08-31T18:00:00Z)][(0.0)][(-89.75):(89.75)][(0.0):(359.75)]&.draw=surface" +
//    "&.vars=longitude|latitude|taux&.colorBar=BlueWhiteRed|C|Linear|-0.5|0.5|&.land=over", 
//    "c:/temp/griddap/", "testMvMap", ".png"); 
//EDD.oneFromDatasetXml("erdG1ssta1day");
//String2.log(String2.utf8ToString(EDD.oneFromDatasetXml("rMHchla8day").searchString()));

// :8081 led to out-of-date oceanwatch dataset!!  but now disabled
//Projects.testOpendapAvailability("http://oceanwatch.pfeg.noaa.gov/thredds/dodsC/satellite/CM/usfc/hday", 
//    "CMusfc", 5, 1, true); //nIter, maxSec
//Projects.testOpendapAvailability("http://coastwatch.pfeg.noaa.gov/erddap/griddap/erdCMsfc", 
//    "eastCurrent", 20, 5*60, false); //nIter, maxSec
//Projects.testOpendapAvailability("http://thredds1.pfeg.noaa.gov/thredds/dodsC/satellite/CM/usfc/hday", 
//    "CMusfc", 20, 5*60, true); //nIter, maxSec
//    EDDTableFromSOS.testNosSosATempStationList();
//      EDDGridFromDap.testKml();
//File2.deleteAllFiles("C:/temp/tmptmp", true, true);

//        String2.log(EDDTableFromNc4DFiles.generateDatasetsXml(
//            "/u00/data/points/KFM1mQuadrat/KFM1mQuadrat_SantaRosa_TrancionCanyon.nc", true));
//            "/u00/data/points/KFM5mQuadrat/KFM5mQuadrat_SantaRosa_TrancionCanyon.nc", true));
//            "/u00/data/points/KFMBandTransect/KFMBandTransect_SantaRosa_TrancionCanyon.nc", true));
//            "/u00/data/points/KFMFishTransect/KFMFishTransect_SantaRosa_TrancionCanyon.nc", true));
//            "/u00/data/points/KFMRandomPointContact/KFMRandomPointContact_SantaRosa_TrancionCanyon.nc", true));
//            "/u00/data/points/KFMTemperature/KFMTemperature_Anacapa_Admirals_Reef.nc", true));          

//      EDD.testDasDds("erdCinpKfm1Q");
//      EDD.testDasDds("erdCinpKfm5Q");
//      EDD.testDasDds("erdCinpKfmBT");
//      EDD.testDasDds("erdCinpKfmFT");
//      EDD.testDasDds("erdCinpKfmRPC");
//      EDD.testDasDds("erdCinpKfmT");
//      EDD.testDasDds("cwwcNDBCMet");
//      EDD.testDasDds("testTib");
//      EDDGridFromDap.testNoAxisVariable();

//        String2.log(EDDTableFromNc1DFiles.generateDatasetsXml(
//            "/u00/data/points/KFMSizeFrequencyNaturalHabitat/KFMSizeFrequencyNaturalHabitat_SantaRosa_TrancionCanyon.nc", true));
//      EDD.testDasDds("erdCinpKfmSFNH");

//        String2.log(EDDTableFromDapSequence.generateDatasetsXml(
//            "http://nwioos.coas.oregonstate.edu:8080/dods/drds/Observer%20Trawl%202002%202006", "OBSERVER_TRAWL_2002_2006", "", true));
//      EDD.testDasDds("nwioosObsTrawl2002");
//      String2.log(SSR.getUrlResponseString(
//          "http://coastwatch.pfeg.noaa.gov/erddap/tabledap/pmelTao.csv?&time>=2008-11-13T00:00:00Z"));
//          "http://127.0.0.1:8080/cwexperimental/index.html"));
//          "http://127.0.0.1:8080/cwexperimental/tabledap/rPmelTao.csv?&time>=2008-11-13T00:00:00Z"));
//      TestUtil.testFile2();
//      SSR.touchUrl("http://127.0.0.1:8080/cwexperimental/subscriptions/list.html?email=bob.simons@noaa.gov", 60000);
//      SSR.touchUrl("http://127.0.0.1:8080/cwexperimental/subscriptions/add.html?datasetID=erdMHchla8day" +
//        "&email=bob.simons@noaa.gov&emailIfAlreadyValid=false" +
//        "&action=\"http://127.0.0.1:8080/cwexperimental/setDatasetFlag.txt?datasetID=testID&flagKey=940513130\"", 60000);
//      EDDTableFromDapSequence.testPsdac();
//      TestUtil.testMustBe();
//  TestUtil.testMath2();
//  EDDGridFromDap.testSliderCsv();
//  TestUtil.testCalendar2();
//  EDDGridFromDap.testClimatologyTime();
//  EDDGridFromDap.testGenerateDatasetsXml();
//  EDDTableFromDapSequence.testBasic(false);
//  EDDTableFromDapSequence.testDapper(false);
//  EDDTableFromDapSequence.testGlobecBirds();
//  EDDTableFromOBIS.testRutgers();
//  EDDTableFromOBIS.testFishbase();
//  EDDTableFromNcFiles.makeTestFiles(); //one time
//  EDDTableFromNcFiles.testId();
//  EDDGridFromNcFiles.testCwHdf(true);
//  EDDGridSideBySide.testTransparentVector();
//  EDDTableFromErddap.testBasic(true);
//  EDDGridFromErddap.testGenerateDatasetsXml();
//  EDDTableFromErddap.testGenerateDatasetsXml();
//  NetcdfDataset in = NetcdfDataset.openDataset("http://dods.ndbc.noaa.gov/thredds/dodsC/data/stdmet/31201/31201h2005.nc");
//  TestSSR.testBobsLocalEmail();
//  EDDTableFromNcFiles.test24Hours();
//  GridSaveAs.main(new String[]{"C:/u00/data/MC/mday/grd/.grd", "C:/u00/data/MC/mday/nc/.nc"});
//  EDD.testDasDds("erdMCchlamday");
//  GridSaveAs.main(new String[]{"C:/u00/data/SC/mday/grd/.grd.zip", "C:/u00/data/SC/mday/nc/.nc"});
//  EDD.testDasDds("erdSCchlamday");
//  EDDTableFromDapSequence.testOneTime();
//  EDDTableFromSOS.testNosSosSalinity();
//  EDDTableFromSOS.testNosSosWind();
//  EDDTableFromSOS.testNosSosWTemp();
//  EDDTableFromDapSequence.testArgoTime();
//  String2.log(EDDTableFromDatabase.getPostTableInfo(null, null, "!!!LIST!!!", true));
//  String2.log(EDDTableFromDatabase.getPostTableInfo("", "detection", "detection", false));
//  String2.log(EDDTableFromDatabase.getPostTableInfo("", "surgery", "surgery", false));
//  EDDTableFromDatabase.testGenerateDatasetsXml();
//  EDDTableFromDatabase.testErdDetectionConstraints();
//  EDDTableFromDatabase.testTime();
//  String2.log(NcHelper.dumpString("c:/programs/seadas/MODIS.2007219.074906.gcoos.seadas_sst.hdf", false));
//  EDDGridFromDap.testAccessibleTo();
//  String2.log(SSR.getUrlResponseString("https://coastwatch.pfeg.noaa.gov:8443/erddap2/griddap/etopo180.htmlTable?altitude[(-90.0):1000:(90.0)][(-180.0):1000:(180.0)]"));
//  EDD.testDasDds("hiRomsFmtb");
//  StringArray.diff("c:/programs/tomcat/content/erddap/messages.xml", "c:/programs/tomcat/content/erddap/messages2.xml");
//  TestUtil.testString2();
//  String2.log("" + System.currentTimeMillis());
//  EDD.testDasDds("postErdBridge");
//  EDDTableFromNcFiles.testDistinct();
//  EDDTableFromNcFiles.testOrderBy();
//  EDDTableFromNcFiles.testOrderByMax();
//  EDStatic.test();
//  EDDTableCopy.testBasic();
//  EDDTableCopy.testCPostDet(false);  //testSourceDatasetUnavailable 
//  EDDTableCopy.testCPostDet(true);   //testSourceDatasetUnavailable (faster)
//  EDDGridReplicate.testBasic(false); //  testSourceDatasetUnavailable 
//  EDDGridFromNcFiles.testNc(false);
//  EDDGridFromNcFiles.testGrib2(true);
//  String2.log(EDDTableFromDapSequence.generateDatasetsXml(
//      "http://oceanwatch.pfeg.noaa.gov/opendap/GLOBEC/GLOBEC_MOC1", 
//      "MOC1", "", false)); 
//  EDDTableFromDapSequence.testErdlasNewportCtd();
//  EDDTableFromDapSequence.testDapErdlasNewportCtd();
//  EDDTableFromDapSequence.testErdlasCalCatch();
//EDDTableFromDapSequence.testTimeStamp();
//  EDDTableFromSOS.testNdbcTestServer();
//  EDDTableFromSOS.testNosTestServer();
//  EDDTableFromSOS.testNosSosSalinity("");

//  EDDTableReplicate.testReplicatePostDet(true);  //testSourceDatasetUnavailable (faster)
//  GenerateDatasetsXml.main(null);
//  DasDds.main(null);

//force compilation of all the classes that need to be deployed 
Attributes att;       
Browser browser;
ByteArray ba;
Calendar2 calendar2; 
CharArray chara;
CCBrowser ccBrowser;
CCUser ccUser;
CompoundColorMap ccm;
CompoundColorMapLayerChild ccmlc;
ContourScreen cons;
CurrentsScreen cs;
CWUser cwUser;
CWBrowser cwBrowser;
CWBrowserHAB cwBrowserHAB;
CWBrowserAK cwBrowserAK;
CWBrowserSA cwBrowserSA;
CWBrowserWW180 cwBrowserWW180;
CWBrowserWW360 cwBrowserWW360;
CWDataBrowser cwDataBrowser;
dods.dap.DConnect dConnect;
DataHelper dh;
DigirHelper dh2;
dods.dap.DSequence ds;
DoubleArray doublea;
EmaAttribute ea;
EmaClass ec;
EmaColor ecolor;
File2 f2;
FileNameUtility fnu;
FilledMarkerRenderer fmr;
FloatArray floata;
GDateTime gdt;
GenerateThreddsXml gtx;
GraphDataLayer gdl;
Grid grid;
GridDataSet gds;
GridDataSetAnomaly gdsa;
GridDataSetOpendap gdso;
GridDataSetThredds gdst;
GridScreen gs;
Image2 i2;
IntArray inta;
JSONObject jo;
LongArray la;
Math2 m2;
Matlab matlab;     
MustBe mb;
NcHelper ncHelper;
NetCheck netCheck;
OneOf oneOf;
OpendapHelper oh;  
ParseJSON parseJSON;
PasswordAuthenticator pAuth;
PointScreen ps;
PointVectorScreen pvs;
PrimitiveArray primitiveArray; 
Projects projects;
RegexFilenameFilter rff;
ResourceBundle2 rb2;
SdsReader sr;
SgtGraph sgtGraph; 
SgtMap sgtMap;     
SgtUtil sgtUtil;
Shared shared;
gov.noaa.pmel.util.SoTRange sotr;
ShortArray sha;
SimpleXMLReader sxr;
SSR ssr;
String2 s2;
StringArray sa;
Table table;
TableXmlHandler txh;
Test test;
TestSSR tssr;
TrajectoryScreen trajs;
XML xml;


//ERDDAP-related
AxisDataAccessor ada;
DasDds dd;
EDStatic es;
EDD edd;            
EDDGrid eddGrid;   
EDDGridFromDap eddgfd;  
EDDGridFromBinaryFile eddgfbf;  
EDDGridFromErddap eddgfed;  
EDDGridFromEtopo eddgfe;  
EDDGridFromFiles eddgff;  
EDDGridFromNcFiles eddgfncf;  
EDDGridAggregateExistingDimension eddaed;  
EDDGridCopy eddgc;
EDDGridSideBySide eddgsbs;  
EDDTable eddTable; 
EDDTableFromBMDE eddtfb; 
EDDTableFromDapSequence eddtfds; 
EDDTableFromDatabase eddtfdb; 
EDDTableFromErddap eddtfed;
EDDTableFromFiles eddtff; 
EDDTableFromHyraxFiles eddtfhf;
//EDDTableFromMWFS eddtfm; 
EDDTableFromNcFiles eddtfnf; 
EDDTableFromNOS eddtfn; 
EDDTableFromOBIS eddtfo; 
EDDTableFromSOS eddtfs;
EDDTableCopy eddtc;
//EDStatic above
EDV edv;
EDVAlt edva;
EDVAltGridAxis edvaga;
EDVGridAxis edvga;
EDVLat edvl;
EDVLatGridAxis edvlga;
EDVLon edvlon;
EDVLonGridAxis edvlonga;
EDVTime edvt;
EDVTimeGridAxis edvtga;
EDVTimeStamp edvts;
Erddap erddap;       
ErddapRedirect erddapRedirect;       
GenerateDatasetsXml gdx;
GridDataAccessor gda;
GridDataRandomAccessor gdra;
HtmlWidgets hw;
LoadDatasets ld;
MakeErdJavaZip mejz;
NoStackTraceException nste;
OutputStreamSource oss;
OutputStreamFromHttpResponse osfhr;
PersistentTable pt;
RunLoadDatasets rld;
Subscriptions sub;
TableWriterAll twa;
TableWriterAllWithMetadata twawm;
TableWriterDistinct twdis;
TableWriterDods twd;
TableWriterDodsAscii twda;
TableWriterGeoJson twgj;
TableWriterHtmlTable twht;
TableWriterJson twj;
TableWriterOrderBy twob;
TableWriterOrderByMax twobm;
TableWriterSeparatedValue twsv;
TaskThread tt;
WaitThenTryAgainException wttae;


/*        

        //convert isoDate to/from epoch seconds (a common utility I need)
        String2.log("Enter an ISO date/time or secondsSinceEpoch or YYYYDDD (or \"\" to stop)...");
        while (true) {
            String dateTime = String2.getStringFromSystemIn("? ");
            if (dateTime.length() == 0)
                break;
            int dashPo = dateTime.indexOf("-");
            int dashPo2 = dateTime.indexOf("-", Math.max(dashPo, 0));
            GregorianCalendar gc;
            try {
                if (dateTime.length() == 7)  gc = Calendar2.parseYYYYDDDZulu(dateTime);     //throws Exception if trouble
                else if (dashPo2 > 0)        gc = Calendar2.parseISODateTimeZulu(dateTime); //throws Exception if trouble
                else                         gc = Calendar2.newGCalendarZulu((long)(String2.parseDouble(dateTime)*1000));
                String2.log(
                    "iso=" + Calendar2.formatAsISODateTimeT(gc) +
                    "  seconds=" + String2.genEFormat6(Math2.floorDiv(gc.getTimeInMillis(), 1000)) + 
                    "  YYYYDDD=" + Calendar2.formatAsYYYYDDD(gc));            
            } catch (Exception e) {
                String2.log(e.toString());
            }
        }

        //low level utilities
        TestUtil.main(null);
        Image2.test();  
        XML.test();
        ByteArray.test();
        CharArray.test();
        ShortArray.test();
        IntArray.test();
        LongArray.test();
        FloatArray.test();
        DoubleArray.test();
        StringArray.test();
        PrimitiveArray.test();
        Attributes.test();
        ResourceBundle2.test();

        //test that requires running from a command line
        TestSSR.main(null);
        RegexFilenameFilter.main(null);  
        Tally.test();
        PersistentTable.test();

        //test that THREDDS is up  (use ip name here, not numeric ip)
        for (int i = 0; i < 3; i++) {
            try {
                OneOf.ensureDataServerIsUp( 
                    "http://oceanwatch.pfeg.noaa.gov/thredds/catalog.html",
                    String2.split("ERD THREDDS Data Server`Satellite Datasets`HF Radio-derived Currents Datasets`NOMADS Datasets",
                        '`'),
                    true);
                Opendap.doOceanWatchSpeedTests(false); //a test of THREDDS

            } catch (Exception e) {
                String2.getStringFromSystemIn(
                    MustBe.throwableToString(e) +
                    "\nPress ^C to stop or Enter to continue..."); 
            }
        }
        Math2.gc(2000);

        //data
        DataStream.main(null);
        SimpleXMLReader.main(null);
        TimePeriods.test();
        FileNameUtility.main(null);
        ParseJSON.test();

        //test validity of DataSet.properties
        ValidateDataSetProperties.main(null);

        //ensure all of the datasets used in each browser are in DataSet.properties validDataSets.
        if (true) {
            String propNames[] = {
                "CCBrowser", 
                "CWBrowser",
                "CWBrowserAK",
                "CWBrowserSA",
                "CWBrowserWW180",
                "CWBrowserWW360",
                "CWBrowserHAB"};
            StringArray validDataSets = null;
            for (int pni = 0; pni < propNames.length; pni++) {
                String2.log("\nTesting " + propNames[pni]);
                fnu = new FileNameUtility("gov.noaa.pfel.coastwatch." + propNames[pni]);
                String tDataSetList[] = String2.split(fnu.classRB2().getString("dataSetList", null), '`');
                int nDataSets = tDataSetList.length;
                if (validDataSets == null) {
                    String ts = fnu.dataSetRB2().getString("validDataSets", null);
                    String[] tsa = String2.split(ts, '`');
                    validDataSets = new StringArray(tsa);
                }
                for (int i = OneOf.N_DUMMY_GRID_DATASETS; i < nDataSets; i++) {  //"2" in order to skip 0=OneOf.NO_DATA and 1=BATHYMETRY
                    if (validDataSets.indexOf(tDataSetList[i], 0) == -1) {
                        Test.error("In " + propNames[pni] + ".properties, [" + i + "]=" + 
                            tDataSetList[i] + " not found in DataSet.properties validDataSets:\n" +
                            validDataSets);
                    }
                }
            }
        }
        
        Matlab.main(null);
        Table.testSaveAsMatlab();
        try {
            //this fails if opendap server is down
            Opendap.main(null); 
        } catch (Exception e) {
            String2.log(MustBe.throwableToString(e));
            String2.getStringFromSystemIn("\nRecover from opendap failure? Press 'Enter' to continue or ^C to stop...");
        }
        //need tests of data.Grid2DDataSet classes
        //hdf.SdsWriter.main(null); //needs work
        DataHelper.test();  
        NcHelper.test();  
        OpendapHelper.test();  //no tests. relies on testing in classes that use it.
        Grid.main(null); 
        //GridDataSetCWOpendap.test();  //the files are no longer available since we are moving to thredds
        GridDataSetThredds.test(); 
        GridDataSetThredds.testGetTimeSeries();
        GridDataSetOpendap.test();
        GridDataSetOpendap.testGetTimeSeries();
        SaveOpendap.test();
        TwoGrids.test();
        GridDataSetAnomaly.test();
        DoubleCenterGrids.test();

        //long test, not necessary to do every time; good for testing changes to shared and for memory tests.
        //and see method's comments for proper setup
        //Shared.test(); 

        Table.main(null);  
        //Table.testSql();
        DigirHelper.test();
        //PointSubsetScaled.main(null); //inactive: use PointIndex
        //PointSubsetFull.main(null);   //inactive: use PointIndex
        //Index.main(null);             //inactive: use PointIndex
        PointIndex.main(null); 
        StoredIndex.main(null); 
        //NdbcMetStation  //see tests in PointDataSetStationVariables
        //DrifterDummy.main(null);
        
        //CacheOpendapStation.testMbariOpendapReliability(); //don't run routinely; runs forever
        CacheOpendapStation.test(); 
        //PointDataSetFromStationVariables.remakeMbariCachesAndDataSets(); //run only when needed
        PointDataSetFromStationVariables.test(); //several tests
        TableDataSet4DNc.test();

        GenerateThreddsXml.testShortenBoldTitles();
        GenerateThreddsXml.test();

        //other
        GSHHS.test();
        Boundaries.test();
        Browser.test();
        DecimalDegreeFormatter.main(null);  
        DegreeMinuteFormatter.main(null);  
        CompoundColorMap.test();
        SgtMap.testCreateBathymetryGrid();
        SgtMap.testBathymetry(); 
        SgtMap.testRegionsMap(-180, 180, -90, 90);
        SgtMap.testRegionsMap(0, 360, -90, 90);
        SgtUtil.test();  //these need work
        SgtMap.test(true, true); 
        SgtMap.testMakeCleanMap();
        CartesianProjection.test();
        SgtGraph.test();  
        NDimensionalIndex.test();

        //ERDDAP
        HtmlWidgets.test();
        EDStatic.test();
        EDV.test();
        EDVTime.test();
        EDVTimeStamp.test();
        EDDTable.test();
        Table.testXml();
        Subscriptions.test(); 
        boolean doGraphicsTests = true;
        boolean doLongTest = false;
        EDDGridFromDap.test(false); //doGraphicsTests);
        //EDDGridFromDap.testGraphics(); //do just before releases    
        //EDDGridFromBinaryFile.test(); not finished
        EDDGridFromErddap.test(); 
        EDDGridFromEtopo.test(true);
        //EDDGridAggregateExistingDimension.test();  //don't usually run...very slow
        EDDGridFromNcFiles.test(true);
        EDDGridCopy.test();
        EDDGridSideBySide.test(true); //doGraphicsTests);  //the best grid graphics tests are here
        EDDTableFromDapSequence.test(false); //doGraphicsTests); //the best table graphics tests are always done
        //EDDTableFromDapSequence.testMemory(); //don't usually run...very slow
        EDDTableFromDatabase.test(); 
        EDDTableFromErddap.test(); 
        EDDTableFromHyraxFiles.test(false); //rarely: true=delete cached info
        EDDTableFromNcFiles.test(); 
        //EDDTableFromMWFS.test(false); //doLongTest); //as of 2009-01-14 no longer active
        EDDTableFromNOS.test(false); //doLongTest);
        EDDTableFromOBIS.test();
        EDDTableFromBMDE.test(); 
        EDDTableFromSOS.test();
        EDDTableCopy.test();
        Erddap.test(); 

        //NetCheckTests
        //NetCheck.unitTest(); which does 3 tests:
        HttpTest.unitTest();
        OpendapTest.unitTest(); 
        SftpTest.unitTest();        


        //a test of oceanwatch THREDDS
        try {
            for (int i = 0; i < 5; i++) {
                long time9 = System.currentTimeMillis();
                Opendap.doOceanWatchSpeedTests(false); 
                time9 = System.currentTimeMillis() - time9;
                if (i > 0 && time9 > 1000) 
                    String2.getStringFromSystemIn("OceanWatch Thredds too slow: " + time9 +
                        "\nPress ^C to stop or Enter to continue..."); 
            }
            //don't run often; run 20000 for better test
            Opendap.threddsTunnelTest(200, 
                "http://oceanwatch.pfeg.noaa.gov/thredds/dodsC/satellite/CM/usfc/hday",
                "CMusfc.CMusfc"); 
        } catch (Exception e) {
            String2.getStringFromSystemIn(MustBe.throwableToString(e) + 
                "\nUnexpected oceanwatch error: Press ^C to stop or Enter to continue..."); 
        }

        //a test of thredds1 THREDDS 8081
        try {
            for (int i = 0; i < 5; i++) {
                long time9 = System.currentTimeMillis();
                Opendap.doThredds1_8081SpeedTests(false); 
                time9 = System.currentTimeMillis() - time9;
                if (i > 0 && time9 > 1000) 
                    String2.getStringFromSystemIn("Thredds1 8081 Thredds too slow: " + time9 +
                        "\nPress ^C to stop or Enter to continue..."); 
            }
            //don't run often; run 20000 for better test
            Opendap.threddsTunnelTest(200, 
                "http://192.168.31.27:8081/thredds/dodsC/satellite/CM/usfc/hday",
                "CMusfc.CMusfc"); 
        } catch (Exception e) {
            String2.getStringFromSystemIn(MustBe.throwableToString(e) + 
                "\nUnexpected thredds1 8081 thredds error: Press ^C to stop or Enter to continue..."); 
        }
*/
        //a test of otter THREDDS 8081
        try {
            for (int i = 0; i < 5; i++) {
                long time8 = System.currentTimeMillis();
                Opendap.doOtterSpeedTests(false, 8081); 
                time8 = System.currentTimeMillis() - time8;
                if (i > 0 && time8 > 1000) 
                    String2.getStringFromSystemIn("Otter Thredds 8081 too slow: " + time8 +
                        "\nPress ^C to stop or Enter to continue..."); 
            }
            //don't run often; run 20000 for better test
            Opendap.threddsTunnelTest(200, 
                "http://161.55.17.243:8081/thredds/dodsC/satellite/CM/usfc/hday", //otter
                "CMusfc.CMusfc"); 
        } catch (Exception e) {
            String2.getStringFromSystemIn(MustBe.throwableToString(e) + 
                "\nUnexpected otter 8081 error: Press ^C to stop or Enter to continue..."); 
        }

        //a test of otter THREDDS 8087
        try {
            for (int i = 0; i < 5; i++) {
                long time8 = System.currentTimeMillis();
                Opendap.doOtterSpeedTests(false, 8087); 
                time8 = System.currentTimeMillis() - time8;
                if (i > 0 && time8 > 1000) 
                    String2.getStringFromSystemIn("Otter Thredds 8087 too slow: " + time8 +
                        "\nPress ^C to stop or Enter to continue..."); 
            }
            //don't run often; run 20000 for better test
            Opendap.threddsTunnelTest(2000, 
                "http://161.55.17.243:8087/thredds/dodsC/satellite/CM/usfc/hday", //otter
                "CMusfc.CMusfc"); 
        } catch (Exception e) {
            String2.getStringFromSystemIn(MustBe.throwableToString(e) + 
                "\nUnexpected otter 8087 error: Press ^C to stop or Enter to continue..."); 
        }

        //a test of erddap
        try {
            for (int i = 0; i < 5; i++) {
                long time9 = System.currentTimeMillis();
                Opendap.doErddapSpeedTests(false); 
                time9 = System.currentTimeMillis() - time9;
                if (i > 0 && time9 > 1000) 
                    String2.getStringFromSystemIn("Erddap too slow: " + time9 +
                        "\nPress ^C to stop or Enter to continue..."); 
            }
            //don't run often; run 20000 for better test
            Opendap.threddsTunnelTest(200, 
                "http://coastwatch.pfeg.noaa.gov/erddap/griddap/erdCMsfc",
                "eastCurrent"); 
        } catch (Exception e) {
            String2.getStringFromSystemIn(MustBe.throwableToString(e) + 
                "\nUnexpected oceanwatch error: Press ^C to stop or Enter to continue..."); 
        }

        //Touch.thredds();  //run as needed to tell thredds to cache PISCO datasets?   or usually runs really fast?

        //make ErdJava.zip  
        //for distribution of GridSaveAs, NetCheck, ConvertTable, and GenerateThreddsXml
        MakeErdJavaZip.main(null); //see C:\programs\tomcat\webapps\cwexperimental\ErdJava.zip
        //MakeErdJavaZip.makeConvertTableJar("C:/pmelsvn/WebContent/WEB-INF/lib/"); //only do when working on LAS stuff

        //make EMA.war
        MakeEmaWar.main(null);

        String2.log(
            "\n" +
            "*** Before a release, spell check (copy to EditPlus, then spellcheck)\n" +
            "and validate HTML the main web pages!\n");

// */
        //AFTER deploying browsers: test the experimental browser
        //TestBrowsers.testAll();

        //TestBrowsers.doGraphicalGetTests(TestBrowsers.experimentalBaseUrl + "CWBrowser.jsp"); //part of testAll
 
        String2.log("\n*** TestAll finished successfully.  Press ^C to exit.");
    }
   
    
}

