package org.gwtopenmaps.openlayers.client.control;

import org.gwtopenmaps.openlayers.client.util.JSObject;

/**
 * Pan and Zoom control.
 *
 * This control is added to OpenLayers maps by default.
 * Remove this control from the map when using the PanZoomBar.
 *
 * Other controls that are added by default are the {@link Attribution},
 * {@link Navigation} and {@link ArgParser}.
 *
 * @author Edwin Commandeur
 * @since GWT-OL 0.4
 */
public class ZoomPanel extends Control {

	protected ZoomPanel(JSObject element) {
		super(element);
	}

	public ZoomPanel() {
		this(ZoomPanelImpl.create());
	}

	public ZoomPanel(ZoomPanelOptions options) {
		this(ZoomPanelImpl.create(options.getJSObject()));
	}

}
