; rrdgt_t0.pro
;
;       this version time based on t0 and calculated x ppi or 200ppi
;       only works for flat, non-curved, graphs
;
!PATH = '~jnewman/Data/Tg_digitizing/Scan_dgt:' + !PATH
$date
$pwd
print,'run - rrdgt.pro'
;
.run ps
.run opal
.run dgt_arrayget
.run dgt_arrayread
.run dgt_ppl
.run dgt_arrayinfo
.run dgt_plt
.run dgt_cntrpt
.run dgt_tbyroa
.run dgt_findcenter
.run dgt_tmhours
.run dgt_gtms
.run dgt_intrp
.run spline
.run dgt_oplt
.run dgt_rplt
.run overlay.pro
.run dgt_axl.pro
.run dgt_wneg
;
;********************************* inputs
; @Runs/hh600523_ab00_13.pro
@Runs/hh600523_cd12_00.pro
; @Runs/hh600523_ef15_04.pro
; @Runs/hh600523_gh04_17.pro
; @Runs/hh600523_ij16_05.pro
; @Runs/hh600523_kl04_18.pro
;****
; @setec
!color=1
; @setx
; !color=255
; 1 = postscript files otherwise writes to screen
yps = 1
;********************************* inputs
; flat graph = 1,  default = curved graph = 0
grphtyp = 1
; time[hour]/graph tick  ie 0.5 = ticks every half hour
if(n_elements(xscl) eq 0) then xscl = double(1.)
; sea level cm/graph tick  ie 0.5 = ticks every half ft or cm
if(n_elements(yscl) eq 0) then yscl = double(1.)
if(n_elements(units) eq 0) then units = 'cm'
if(n_elements(dtime) eq 0) then dtime = double(15.)
print,' input sea level units = ',units
print,' x scale:',float(xscl),' hours/tick,  y scale:',float(yscl),' ',units,' sea level/tick'
if(units eq 'cm') then untscl = 1. else untscl = 30.48
; if ppl = 0 in station file then will calculate ppl from graph rather than 
;            using the default based on scanning dpi = 200.
if(n_elements(pp0) eq 0) then pp0 = 200.
print,' default ppl based on scanning',pp0,' dpi'
if(n_elements(xppl) eq 0) then xppl = pp0
if(n_elements(yppl) eq 0) then yppl = 0
; if not calculating yppl use xppl*xyscl -> xyscl is any needed unit correction
if(n_elements(xyscl) eq 0) then xyscl = 1.
; cvalue is value in graph units of center point that data was referenced to
; if not 0 that value should be added to y values
if n_elements(cvalue) eq 0 then cvalue = 0 else cvalue = cvalue*untscl
if(n_elements(yps) eq 0) then yps = 0
;help,/rout
print
rttl = rttl+' - x scale calculated and y scale 200ppi'
print,rttl
print,'     ',stime,' = time of 1st time mark in hours'
print,'     ',cvalue,'cm = reference line'
print
print,'DGT_ARRAYGET'
dgt_arrayget,infil,a
print
print,'DGT_ARRAYINFO'
dgt_arrayinfo,a,tm,clin,infil,units,yppl,ppl=xppl,slope=slp,xscl=xscl,yscl=yscl
; if yppl not calculated use xppl*xyscl -> xyscl is any needed unit correction
if(yppl eq 0) then yppl = xppl*xyscl
print,'DGT_FINDCENTER  time is not scaled in this version'
; data line are values = 7, shouldn't change use default cutoff=-7
dgt_findcenter,a,line,xlen,ylen,wgd,wbad,nw,arrng $
              ,cntrpt=clin,dpl=xppl,yppl=yppl,slope=slp
; xppl = pixels/hour and yppl = pixels/units(feet or cm)
print,'X range in pixels:',arrng(0:1,0)
print,'Y range in pixels, reference line removed:',arrng(0:1,1)
; x or y len in pixels, line in hours and units at this point
; stime = time of 1st time mark, rest at xscl intervals in hours
; xtm = tm
; print,' time at time marks in pixels, xtm:'
; print,xtm
; ytm = stime+(dindgen(n_elements(tm))*xscl)
; print,'time at time marks in hours, ytm:'
; print,float(ytm)
; ytm in hours
; sea level height in cm = (graph height*cm/graph height)+ height of center line
if(nw gt 0) then yheight = (line(wgd,1)*untscl)+cvalue $
            else yheight = (line(*,1)*untscl)+cvalue
dgt_tmhours,stime,tm,xlen,t0,ppl=xppl,xscl=xscl
; print,'SPLINE interpolate between each time mark to get times'
; xtime = spline(xtm,ytm,xlen)
xtime = line(*,0)+t0
print,' time range:',xtime(0),' to',xtime(n_elements(xtime)-1)
asz = fltarr(2,2)
asz(*,0) = [xtime(0),xtime(n_elements(xtime)-1)]
asz(*,1) = arrng(*,1)/yppl*untscl+cvalue  ; array size in cm of sea level
print,'x range:   time(hours):',asz(*,0)
print,'y range: sea level(cm):',asz(*,1)
; if miss data get times:
if(nw gt 0) then dgt_gtms,xtime,wbad,nw,badbetween
if(nw gt 0) then xtime = xtime(wgd)
wgd = 0
print,'DGT_INTRP interpolate to even time'
dgt_intrp,xtime,yheight,intrp_xt,intrp_yh,yesneg,dt=dtime
print,'DGT_OPLT graph unit time scaled from pixels by',xppl
if(yps eq 1) then pson,ls=1,'Runs/'+stn+'_o3'
dgt_oplt,asz,rttl,line(*,0),line(*,1),xtime,yheight,intrp_xt,intrp_yh $
        ,units,cvalue
if(yps eq 1) then psoff
print,'DGT_RPLT graph unit time scaled from pixels by',xppl
if(yps eq 1) then pson,'Runs/'+stn+'_3'
dgt_rplt,1,3,asz,rttl,line(*,0),line(*,1),xtime,yheight,intrp_xt,intrp_yh $
        ,units,cvalue
if(yps eq 1) then psoff
outfil = outfil+'.sav'
print
print,'save,',outfil,',intrp_xt,intrp_yh,rttl,badbetween,asz'
help,intrp_xt,intrp_yh,rttl,badbetween,asz
save,filename=outfil,intrp_xt,intrp_yh,rttl,badbetween,asz
sz = size(a)
if(sz(1) gt sz(2)) then ls = 1 else ls = 0
print,'ls =',ls
dgt_axl,infil,stn,ls,plus,rttl,intrp_xt,intrp_yh,asz,pp0=pp0
if(plus ne '') then dgt_axl,infil,stn,ls,plus,rttl,intrp_xt,intrp_yh,asz,pp0=pp0
if yesneg then dgt_wneg,line,xtime,yheight,a,rttl,nox=1
print,' end - rrdgt_flat_graph.pro'
exit
